

(*
 * filedirs - library to get list of GT-HOST file directories
 *
 *)

var
   filelevel:    array[1..100] of char;
   filedir:      array[1..100] of string[64];
   filedirs:     integer;


procedure get_filedir_list;
   {build list of available file directories}
var
   fd:       text;
   gtdir:    anystring;
   line:     anystring;
   i:        integer;

begin
   filedirs := 0;

   gtdir := locate_file_env('gtdir.bbs','GTPATH=');
   if exists(gtdir) = false then
   begin
      writeln;
      writeln(whoami,':  Can''t locate file directory, ',gtdir);
      writeln('Check setting of GTPATH environment variable.');
      exit;
   end;

   assign(fd,gtdir);
   reset(fd);

   while not eof(fd) do
   begin
      readln(fd,line);
      line := line + ' ';

      if (line[1] <> ' ') then
      begin
         INCR(filedirs);
         if line[1] in ['0','A'..'Z'] then
            i := 1
         else
            i := 2;

         filelevel[filedirs] := line[i];

         i := pos(' ',line);
         while (i < LEN(line)) and (line[i] = ' ') do
            INCR(i);

         delete(line,1,i-1);
         i := pos(' ',line);

         line := copy(line,1,i-1);
         if line[LEN(line)] <> '\' then
            line := line + '\';
         filedir[filedirs] := line;
      end;
   end;

   close(fd);
end;

