
const getfiles_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE File list processing library 2.1'#0;
#log File list processing library (simplified version) 2.1

(*
 * getfile2 - file list processing library (simplified version)
 *
 * This module will change a wildcard list of files into a
 * sorted file name list.
 *
 *)

const
   maxnumfiles =  200;
   null =         #0;

type
   filestring =   string [64];
   filearray =    array [1.. maxnumfiles] of filestring;


var
   filetable:     filearray;
   filecount:     integer;

(*
 *
 * expand a wildcard into a list of full pathnames.
 *
 *)

procedure getfiles (pattern:       filestring;
                    var fdir:      filearray;
                    var num:       integer);
var
   i:             integer;
   cf:            byte;
   onedir:        filestring;
   curdir:        filestring;
   reg:           regpack;
   dta:           string[255];
   c:             char;

begin
   for i := 1 to LEN(pattern) do
      pattern[i] := upcase(pattern[i]);

   num := 0;
   curdir := pattern;

   while (LEN(curdir) > 0) and
         (curdir [LEN(curdir)] <> '\') and
         (curdir [LEN(curdir)] <> ':') do
            DECR(curdir[0]);

   pattern := pattern + null;
   reg.ax := $1a00;
   reg.ds := seg (dta [1]);
   reg.dx := ofs (dta [1]);
   msdos(reg);              {set dta address}

   reg.ax := $4e00;
   reg.cx := $21;  {match archive and read-only attributes}
   reg.ds := seg (pattern [1]);
   reg.dx := ofs (pattern [1]);
   msdos(reg);              {find first matching file}

   cf := reg.flags and 1;

#ifdef DEBUGGING
   if (cf <> 0) then
      writeln(con,'warning:  no files matched  ',pattern);
#endif

   while ((cf <> 1) and (num < maxnumfiles)) do
   begin
      onedir := '';
      i := 0;

      repeat
         c := dta [31 + i];

         if c <> null then
            onedir := onedir + c;

         i := i + 1;
      until c = null;          {throw out the . and .. entries}


      if onedir [1]<> '.' then
      begin
         num := num + 1;
         fdir[num] := curdir + onedir;
      end;

      reg.ax := $4f00;
      reg.ds := seg (dta [1]);
      reg.dx := ofs (dta [1]);
      msdos(reg);              {keep searching for next file}

      cf := reg.flags and 1;
   end;

   if num >= maxnumfiles then
      writeln(con,'warning:  files in excess of ', maxnumfiles, ' ignored');

end;                     {getfiles}


