
(*
 * getuser.inc - get current user information under GT-host
 *
 * For use with GT PowerComm 12.xx HOST-MODE.
 *
 * S.H.Smith, 6-apr-87 (rev. 26-apr-87)
 *
 * This program is provided courtesy of:
 *         The Tool Shop
 *         Phoenix, Az
 *         (602) 279-2673
 *
 * This program uses many of the building-blocks in the Tool Shop Library,
 * which is available for download from the Tool Shop.   Compile using
 * TSHELL 1.1, also avaliable from the Tool Shop.
 *
 *)

(* layout of the user control file records for gt12.10 *)

type
   user_record = record
      dead:          boolean;
      name:          string[30];
      lastread:      integer;
      date:          string[10];
      time:          string[10];
      total_calls:   integer;
      banned:        boolean;
      xpert:         boolean;
      nonstp:        boolean;
      city:          string[30];
      passwd:        string[20];
      phone:         string[10];
      level:         char;
      calls:         integer;
      m3:            byte;
   end;

var
   user:  user_record;



procedure get_user_info;
   {lookup information for currently logged user; sets 'user' fields
    according to the best information available.
    call get_maildir_list first}
var
   user_name:  anystring;
   fname:      anystring;
   fd:         text;
   ctlfd:      file of user_record;

begin
   writeln(con,'Loading user information');

   user.name := 'Unknown';
   user.level := 'Z';

   fname := locate_file_env('gtuser.bbs','GTPATH=');
   if exists(fname)=false then
   begin
      writeln(con,whoami,': Missing file: ',fname);
      writeln(con,'Check setting of GTPATH environment.');
      exit;
   end;

   assign(fd,fname);
   reset(fd);
   readln(fd,user_name);
   close(fd);

   writeln('Welcome, ',user_name);
   flush(output);

   fname := maildir[1]+'\gtmail.ctl';
   if exists(fname)=false then
   begin
      writeln(con,whoami,': Missing file: ',fname);
      writeln(con,'Check setting of GTPATH environment.');
      exit;
   end;

   assign(ctlfd,fname);
   reset(ctlfd);
   read(ctlfd,user);

   while not eof(ctlfd) do
   begin
       read(ctlfd,user);

       if user.name = user_name then
       begin
          close(ctlfd);
          exit;
       end;
   end;

   close(ctlfd);
   writeln(con,whoami,': Can''t find "',user_name,'" in control file ',fname);
end;

