{**************************************************************************}
{                                                                          }
{ TPCHAR.PAS                                                               }
{ for Turbo Pascal 6.0 +,Version 1.00                                      }
{                                                                          }
{ (c) 1992, RAVIART Philippe, All rights reserved.                         }
{ CIS: 100135,503                                                          }
{**************************************************************************}
{$A+,S-}
{$DEFINE DEBUG}

{$IFDEF DEBUG}
   {$D+,L+}
{$ELSE
   {$D-,L-}
{$ENDIF}

unit
  TpChar;interface

{**************************************************************************}
{                                                                          }
{ This Unit contains 17 procs for treating characters.                     }
{ Please Refer to "TPCHAR.DOC" for details.                                }
{                                                                          }
{**************************************************************************}

Function    IsAscii (C: Char):Boolean;
Function    IsCntrl (C: Char):Boolean;
Function    IsGraph (C: Char):Boolean;
Function    IsPrint (C: Char):Boolean;
Function    IsSigned(C: Char):Boolean;
Function    IsSpace (C: Char):Boolean;
Function    IsAlnum (C: Char):Boolean;
Function    IsAlpha (C: Char):Boolean;
Function    IsDigit (C: Char):Boolean;
Function    IsDos   (C: Char):Boolean;
Function    IsFile  (C: Char):Boolean;
Function    IsLower (C: Char):Boolean;
Function    IsPunct (C: Char):Boolean;
Function    IsReal  (C: Char):Boolean;
Function    IsUpper (C: Char):Boolean;
Function    IsHex   (C: Char):Boolean;
Function    IsPath  (C: Char):Boolean;

implementation

Const
   ChrClass  : Array[0..127] of byte =
               ($00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
                $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
                $00,$48,$08,$48,$48,$48,$48,$48,$48,$48,$88,$28,$08,$68,$68,$08,
                $44,$44,$44,$44,$44,$44,$44,$44,$44,$44,$88,$08,$08,$08,$08,$88,
                $48,$52,$52,$52,$52,$72,$52,$42,$42,$42,$42,$42,$42,$42,$42,$42,
                $42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$08,$88,$08,$48,$48,
                $48,$51,$51,$51,$51,$71,$51,$41,$41,$41,$41,$41,$41,$41,$41,$41,
                $41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$48,$08,$48,$48,$00);


Function    IsAscii(C: Char): Boolean;Assembler;
Asm
  mov   bl,C
  xor   ax,ax
  shl   bl,1
  sbb   al,-1
End;

Function    IsCntrl(C: Char):Boolean;Assembler;
Asm
  mov  bl,C
  mov  al,True
  cmp  bl,127
  je   @@01
  cmp  bl,' '
  adc  al,-1
@@01:
end;

Function    IsGraph(C: Char): Boolean;Assembler;
Asm
   mov   bl,C
   xor   ax,ax
   cmp   bl,33
   jb    @@01
   cmp   bl,127
   adc   al,al
@@01:
end;

Function    IsPrint(C: Char):Boolean;Assembler;
Asm
   mov   bl,C
   xor   ax,ax
   cmp   bl,32
   jb    @@01
   cmp   bl,127
   adc   al,al
@@01:
end;

Function    IsSigned(C: Char):Boolean;assembler;
Asm
   xor   ax,ax
   mov   cl,C
   cmp   cl,'9'
   jnbe  @@02
   cmp   cl,'0'
   jnb   @@01
   cmp   cl,'-'
   je    @@01
   cmp   cl,'+'
   jne   @@02
@@01:
   inc   ax
@@02:
end;

Function    IsSpace(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   cl,C
   cmp   cl,' '
   je    @@01
   cmp   cl,$0d
   jnbe  @@02
   cmp   cl,$09
   jb    @@02
@@01:
   inc   ax
@@02:
end;

Function    IsAlnum(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$07
   jz    @@01
   inc   ax
@@01:
end;

Function    IsAlpha(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$03
   jz    @@01
   inc   ax
@@01:
end;

Function    IsDigit(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$04
   jz    @@01
   inc   ax
@@01:
end;

Function    IsDos(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$c0
   jz    @@01
   inc   ax
@@01:
end;

Function    IsFile(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$40
   jz    @@01
   inc   ax
@@01:
end;

Function    IsLower(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$01
   jz    @@01
   inc   ax
@@01:
end;

Function    IsPunct(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$08
   jz    @@01
   inc   ax
@@01:
end;

Function    IsReal(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$24
   jz    @@01
   inc   ax
@@01:
end;

Function    IsUpper(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$02
   jz    @@01
   inc   ax
@@01:
end;

Function    IsHex(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$14
   jz    @@01
   inc   ax
@@01:
end;

Function    IsPath(C: Char):Boolean;Assembler;
Asm
   xor   ax,ax
   mov   bx,Offset ChrClass
   add   bl,C
   test  byte([bx]),$40
   jz    @@02
@@01:
   inc   ax
   jmp   @@03
@@02:
   mov   bl,C
   cmp   bl,'\'
   je    @@01
   cmp   bl,':'
   je    @@01
@@03:
end;

end.
