Program Exam19;

{**************************************************************************}
{                                                                          }
{ Ce programme dmontre les possibilits de StrCmp?? et StrnCmp??.         }
{                                                                          }
{**************************************************************************}

Uses
  TpStr;

Var
  S1  ,
  S2  : String;
  Cmp : ShortInt;
{  ---------------------------------------------------------------         }
{  Function   StrCmp(Str1,Str2: String):ShortInt;                          }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Compare <Str1>  <Str2> et retourne un rsultat:            }
{              infrieur  0 si <Str1> est infrieur  <Str2>              }
{                   egal  0 si <Str1> est gal  <Str2>                   }
{              suprieur  0 si <Str1> est suprieur  <Str2>              }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test1;
Begin
  S1  := 'abcdefghijklm';
  S2  := 'nopqrstuvwxyz';
  Cmp := StrCmp(S1,S2);
  Cmp := StrCmp(S2,s1);
  S1  := S2;
  Cmp := StrCmp(S1,S2);
end;

{  ---------------------------------------------------------------         }
{  Function   StrCmpE(Str1,Str2: String;Exact: Boolean):ShortInt;          }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Idem, mais la valeur de Exact determine si la comparaison   }
{              entre les deux chanes pourra ou non retourner la mme      }
{              valeur que StrCmp si les longueurs sont diffrentes.        }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test2;
Begin
  S1  := 'abc';
  S2  := 'abc ';
  Cmp := StrCmpE(S1,S2,True);
  Cmp := StrCmpE(S1,S2,False);
  S1  := ' abc';
  S2  := 'abc ';
  Cmp := StrCmpE(S1,S2,True);
  Cmp := StrCmpE(S1,S2,False);
  Cmp := StrCmpE('abc','abcde',False);
  Cmp := StrCmpE('abcde','abc',False);
end;

{  ---------------------------------------------------------------         }
{  Function   StrCmpEI(Str1,Str2: String;Exact: Boolean):ShortInt;         }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Idem, sans tenir compte des majuscules/minuscules.          }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test3;
Begin
  S1  := 'abc';
  S2  := 'ABC ';
  Cmp := StrCmpEI(S1,S2,True);
  Cmp := StrCmpEI(S1,S2,False);
  S1  := ' abc';
  S2  := 'ABC ';
  Cmp := StrCmpEI(S1,S2,True);
  Cmp := StrCmpEI(S1,S2,False);
  Cmp := StrCmpEI('abc','aBCde',False);
  Cmp := StrCmpEI('abcde','ABC',False);
end;

{  ---------------------------------------------------------------         }
{  Function   StrCmpI(Str1,Str2: String):ShortInt;                         }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Identique  StrCmp, sans tenir compte des majuscules/       }
{              minuscules.                                                 }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test4;
Begin
  S1  := 'abcdefghijklm';
  S2  := 'nopqrstuvwxyz';
  Cmp := StrCmpI(S1,S2);
  Cmp := StrCmpI(S2,s1);
  S1  := StrUpr(S2);
  Cmp := StrCmpI(S1,S2);
end;

{  ---------------------------------------------------------------         }
{  Function   StrnCmp(Str1,Str2: String;Count: Integer):ShortInt;          }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Identique  StrCmp, mais compare sur <Count> caractres.    }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test5;
Begin
  S1  := 'abcdefghijklm';
  S2  := 'nopqrstuvwxyz';
  Cmp := StrnCmp(S1,S2,5);
  Cmp := StrnCmp(S2,s1,5);
  S1  := S2;
  Cmp := StrnCmp(S1,S2,12);
end;

{  ---------------------------------------------------------------         }
{  Function   StrnCmpE(Str1,Str2: String;Exact: Boolean;Count: Integer):ShortInt;}
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Combinaison de StrnCmp et de StrCmpE.                       }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test6;
Begin
  S1  := 'abc';
  S2  := 'abc ';
  Cmp := StrnCmpE(S1,S2,True,5);
  Cmp := StrnCmpE(S1,S2,False,2);
  S1  := ' abc';
  S2  := 'abc ';
  Cmp := StrnCmpE(S1,S2,True,4);
  Cmp := StrnCmpE(S1,S2,False,4);
  Cmp := StrnCmpE('abc','abcde',False,3);
  Cmp := StrnCmpE('abcde','abc',False,4);
end;

{  ---------------------------------------------------------------         }
{  Function   StrnCmpEI(Str1,Str2: String;Exact: Boolean;Count: Integer):ShortInt;}
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : Idem sans tenir compter des majuscules/minuscules.          }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test7;
Begin
  S1  := 'abc';
  S2  := 'ABC ';
  Cmp := StrnCmpEI(S1,S2,True,5);
  Cmp := StrnCmpEI(S1,S2,False,2);
  S1  := ' abc';
  S2  := 'ABC ';
  Cmp := StrnCmpEI(S1,S2,True,4);
  Cmp := StrnCmpEI(S1,S2,False,4);
  Cmp := StrnCmpEI('abc','ABCDE',False,3);
  Cmp := StrnCmpEI('aBCde','abc',False,4);
end;

{  ---------------------------------------------------------------         }
{  Function   StrnCmpI(Str1,Str2: String;Count: Integer):ShortInt;         }
{  ---------------------------------------------------------------         }
{                                                                          }
{  Effet     : combinaison de StrnCmp et de StrCmpI.                       }
{                                                                          }
{  Usage     : Chane pascal.                                              }
{                                                                          }
{  Vitesse   : 7800/s                                                      }
{                                                                          }
{ -------------------------------------------------------------------------}

Procedure Test8;
Begin
  S1  := 'abc';
  S2  := 'ABC ';
  Cmp := StrnCmpI(S1,S2,3);
  Cmp := StrnCmpI(S1,S2,4);
  S1  := ' abc';
  S2  := 'ABC ';
  Cmp := StrnCmpI(S1,S2,4);
  Cmp := StrnCmpI('abc','ABCDE',3);
  Cmp := StrnCmpI('aBCde','abc',4);
end;

Begin
  Test1;
  Test2;
  Test3;
  Test4;
  Test5;
  Test6;
  Test7;
  Test8;
End.

{ -------------------------------------------------------------------------}
