{**************************************************************************}
{                                                                          }
{ TPSTR.PAS                                                                }
{ for Turbo Pascal 6.00 + ,Version 2.00                                    }
{                                                                          }
{ (c) 1993, RAVIART Philippe, All rights reserved.                         }
{ CIS: 100135,503
{**************************************************************************}
{$A+,S-}
{$DEFINE DEBUG}

{$IFDEF DEBUG}
   {$D+,L+}
{$ELSE
   {$D-,L-}
{$ENDIF}
unit TpStr;interface

{**************************************************************************}
{                                                                          }
{ This Unit contains 143 procs for treating characters or strings.         }
{ Please Refer to "TPSTR.DOC" for details.                                 }
{                                                                          }
{**************************************************************************}

{$IFNDEF VER70}
Type
  pChar = ^Char;
{$ENDIF}

Procedure   FormatStr
            (Var Result: String;Format: String;Var Params);
Function    StrL
            (L: Longint)                                         :String;
Function    StrLF
            (L: Longint;Field: Integer)                          :String;
Function    StrLFCR
            (L: Longint;Field: Integer)                          :String;
Function    StrLFCL
            (L: Longint;Field: Integer)                          :String;
Function    StrR
            (R: Real)                                            :String;
Function    StrRF
            (R: Real;Field: Integer)                             :String;
Function    StrRFD
            (R: Real;Field,Decimals: Integer)                    :String;
{$IFOPT N+}
Function    StrC
            (C: Comp)                                            :String;
Function    StrCF
            (C: Comp;Field: Integer)                             :String;
Function    StrCFD
            (C: Comp;Field,Decimals: Integer)                    :String;
Function    StrD
            (D: Double)                                          :String;
Function    StrDF
            (D: Double;Field: Integer)                           :String;
Function    StrDFD
            (D: Double;Field,Decimals: Integer)                  :String;
Function    StrE
            (E: Extended)                                        :String;
Function    StrEF
            (E: Extended;Field: Integer)                         :String;
Function    StrEFD
            (E: Extended;Field,Decimals: Integer)                :String;
Function    StrS
            (S: Single)                                          :String;
Function    StrSF
            (S: Single;Field: Integer)                           :String;
Function    StrSFD
            (E: Single;Field,Decimals: Integer)                  :String;
{$ENDIF}
Procedure   ChrDel
            (Var Str: String;Match: Char);
Function    ChrDel_
            (    Str: String;Match: Char)                        :String;
Procedure   ChrnDel
            (Var Str: String;Match: Char;Count: Integer);
Function    ChrnDel_
            (    Str: String;Match: Char;Count: Integer)         :String;
Procedure   ChrDelI
            (Var Str: String;Match: Char;Index: Integer);
Function    ChrDelI_
            (    Str: String;Match: Char;Index: Integer)         :String;
Procedure   ChrDelL
            (Var Str: String;Match: Char);
Function    ChrDelL_
            (    Str: String;Match: Char)                        :String;
Procedure   ChrnDelL
            (Var Str: String;Match: Char;Count: Integer);
Function    ChrnDelL_
            (    Str: String;Match: Char;Count: Integer)         :String;
Procedure   ChrnDelLI
            (Var Str: String;Match: Char;Count,Index: Integer);
Function    ChrnDelLI_
            (    Str: String;Match: Char;Count,Index: Integer)   :String;
Procedure   ChrDelR
            (Var Str: String;Match: Char);
Function    ChrDelR_
            (    Str: String;Match: Char)                        :String;
Procedure   ChrnDelR
            (Var Str: String;Match: Char;Count: Integer);
Function    ChrnDelR_
            (    Str: String;Match: Char;Count: Integer)         :String;

Procedure   ChrFill
            (Var Str: String;Fill: Char;MaxLen: Integer);
Function    ChrFill_
            (                Fill: Char;MaxLen: Integer)         :String;

Procedure   ChrPadC
            (Var Str: String;Fill: Char;MaxLen: Integer);
Function    ChrPadC_
            (    Str: String;Fill: Char;MaxLen: Integer)         :String;
Procedure   ChrPadL
            (Var Str: String;Fill: Char;MaxLen: Integer);
Function    ChrPadL_
            (    Str: String;Fill: Char;MaxLen: Integer)         :String;
Procedure   ChrPadR
            (Var Str: String;Fill: Char;MaxLen: Integer);
Function    ChrPadR_
            (    Str: String;Fill: Char;MaxLen: Integer)         :String;

Function    ChrPosL
            (Str: String;Match: Char)                            :Integer;
Function    ChrPosLN
            (Str: String;Match: Char;Occur: Byte)                :Integer;
Function    ChrPosLI
            (Str: String;Match: Char)                            :Integer;
Function    ChrPosLIN
            (Str: String;Match: Char;Occur: Byte)                :Integer;
Function    ChrPosR
            (Str: String;Match: Char)                            :Integer;
Function    ChrPosRN
            (Str: String;Match: Char;Occur: Byte)                :Integer;
Function    ChrPosRI
            (Str: String;Match: Char)                            :Integer;
Function    ChrPosRIN
            (Str: String;Match: Char;Occur: Byte)                :Integer;

Function    ChrQty
            (Str: String;Match: Char)                            :Integer;
Function    ChrQtyI
            (Str: String;Match: Char)                            :Integer;

Procedure   ChrRepl
            (Var Str:String;Chr1,Chr2 : Char);
Function    ChrRepl_
            (    Str:String;Chr1,Chr2 : Char)                    :String;
Procedure   ChrReplI
            (Var Str:String;Chr1,Chr2 : Char);
Function    ChrReplI_
            (    Str:String;Chr1,Chr2 : Char)                    :String;

{$IFNDEF VER70}
Function    StrPCopy
            (Var Dest: pChar;Str: String)                        :pChar;
Function    StrPas
            (Str: pChar)                                         :String;
{$ENDIF}

Procedure   StrCat
            (Var Str1: String;Str2: String);
Function    StrCat_
            (    Str1: String;Str2: String)                      :String;
Procedure   StrnCat
            (Var Str1: String;Str2: String;Maxlen: Integer);
Function    StrnCat_
            (    Str1: String;Str2: String;Maxlen: Integer)      :String;

Function    StrCmp
            (Str1,Str2: String)                                  :ShortInt;
Function    StrCmpE
            (Str1,Str2: String;Exact: Boolean)                   :ShortInt;
Function    StrCmpEI
            (Str1,Str2: String;Exact: Boolean)                   :ShortInt;
Function    StrCmpI
            (Str1,Str2: String)                                  :ShortInt;
Function    StrnCmp
            (Str1,Str2: String;Count: Integer)                   :ShortInt;
Function    StrnCmpE
            (Str1,Str2: String;Exact: Boolean;Count: Integer)    :ShortInt;
Function    StrnCmpEI
            (Str1,Str2: String;Exact: Boolean;Count: Integer)    :ShortInt;
Function    StrnCmpI
            (Str1,Str2: String;Count: Integer)                   :ShortInt;

Procedure   StrCopy
            (Var Str1: String;Str2: String);
Procedure   StrnCopy
            (Var Str1: String;Str2: String;Maxlen: Integer);
Procedure   StrnCpyI
            (Var Str1: String;Str2: String;Index,Count: Integer);

Function    StrCSpn
            (Str1,Str2: String)                                  :Integer;
Function    StrPBrk
            (Str1,Str2: String)                                  :Integer;
Procedure   StrMemb
            (Var Str1: String;Str2: String);

Procedure   StrCut
            (Var Str1: String;MaxLen: Integer);
Function    StrCut_
            (    Str1: String;MaxLen: Integer)                   :String;

Procedure   StrDeTab
            (Var Str1: String;Str2: String;TabSize: Byte);
Function    StrDeTab_
            (    Str1: String;TabSize: Byte)                     :String;
Procedure   StrReTab
            (Var Str1: String;Str2: String;TabSize: Byte);
Function    StrReTab_
            (    Str1: String;TabSize: Byte)                     :String;

Procedure   StrENum
            (Var Str1: String;First,Last: Char);
Function    StrENum_
            (                 First,Last: Char)                  :String;

Procedure   StrFill
            (Var Str1: String;Str2: String;Count,MaxLen: Integer);
Function    StrFill_
            (                 Str1: String;Count,MaxLen: Integer):String;

Procedure   StrJC
            (Var Str1: String;MaxLen: Integer);
Function    StrJC_
            (    Str1: String;MaxLen: Integer)                   :String;
Procedure   StrJL
            (Var Str1: String;MaxLen: Integer);
Function    StrJL_
            (    Str1: String;MaxLen: Integer)                   :String;
Procedure   StrJR
            (Var Str1: String;MaxLen: Integer);
Function    StrJR_
            (    Str1: String;MaxLen: Integer)                   :String;

Procedure   StrLwr
            (Var Str1: String);
Function    StrLwr_
            (    Str1: String)                                   :String;
Procedure   StrUpr
            (Var Str1: String);
Function    StrUpr_
            (    Str1: String)                                   :String;

Procedure   StrMove
            (Var Str1: String;Str2: String);
Procedure   StrOvr
            (Var Str1: String;Str2: String;Index: Integer);
Function    StrOvr_
            (    Str1: String;Str2: String;Index: Integer)       :String;
Procedure   StrnOvr
            (Var Str1: String;Str2: String;Index,Count: Integer);
Function    StrnOvr_
            (    Str1: String;Str2: String;Index,Count: Integer) :String;

Procedure   StrPeek
            (Var Str1: String;Var Source;MaxLen: Byte);
Procedure   StrPoke
            (Var Dest;Str2: String);

Procedure   StrRev
            (Var Str1: String);
Function    StrRev_
            (    Str1: String)                                   :String;
Procedure   StrRoll
            (Var Str1: String;Count: Integer);
Function    StrRoll_
            (    Str1: String;Count: Integer)                    :String;

Procedure   ATrim
            (Var Str1: String);
Function    ATrim_
            (    Str1: String)                                   :String;
Procedure   LTrim
            (Var Str1: String);
Function    LTrim_
            (    Str1: String)                                   :String;
Procedure   RTrim
            (Var Str1: String);
Function    RTrim_
            (    Str1: String)                                   :String;

Function    Copy
            (    Str1: String;Index,Count: Integer)              :String;
Function    Left
            (    Str1: String;Count: Integer)                    :String;
Function    Right
            (    Str1: String;Count: Integer)                    :String;

Procedure   Delete
            (Var Str : String;Index,Count: Integer);
Function    Pos
            (Find,Str: String)                                   :Integer;

Function    LoCase
            (C: Char)                                            :Char;
Function    UpCase
            (C: Char)                                            :Char;

Function    Replicate
            (Fill: Char;MaxLen:Integer)                          :String;

Function    Soundex
            (Str1: String)                                       :String;

Function    WrdQty
            (Str1: String)                                       :Byte;

Function    HtoL      (Str: String)                              :Longint;
Function    LtoA      (L: LongInt)                               :String;
Function    LtoB      (L: LongInt)                               :String;
Function    LtoO      (L: LongInt)                               :String;
Function    WtoH      (W: Word)                                  :String;
Function    WtoB      (W: Word)                                  :String;
Function    WtoO      (W: Word)                                  :String;
Function    BtoH      (B: Byte)                                  :String;
Function    BtoB      (B: Byte)                                  :String;
Function    BtoO      (B: Byte)                                  :String;
Function    PtoH      (P: Pointer)                               :String;
Function    AtoR      (Str: String)                              :Real;
Function    AtoL      (Str: String)                              :Longint;
Function    AtoH      (Str: String)                              :Integer;
Function    AtoLh     (Str: String)                              :LongInt;
Function    ValidInt  (Str: String)                              :Boolean;
Function    ValidHInt (Str: String)                              :Boolean;
Function    ValidReal (Str: String)                              :Boolean;

implementation

Const
   UpCaseMap : String[38] = 'AAEEEIIIOOUUYAIOUAO';
   LoCaseMap : String[38] = '';

   Digits    : array[0..$F] of Char = '0123456789ABCDEF';

   ChrClass  : Array[0..127] of byte =
               ($00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
                $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
                $00,$48,$08,$48,$48,$48,$48,$48,$48,$48,$88,$28,$08,$68,$68,$08,
                $44,$44,$44,$44,$44,$44,$44,$44,$44,$44,$88,$08,$08,$08,$08,$88,
                $48,$52,$52,$52,$52,$72,$52,$42,$42,$42,$42,$42,$42,$42,$42,$42,
                $42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$42,$08,$88,$08,$48,$48,
                $48,$51,$51,$51,$51,$71,$51,$41,$41,$41,$41,$41,$41,$41,$41,$41,
                $41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$41,$48,$08,$48,$48,$00);

   SoudexTbl : Array[0..255] of Char =
                (#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,'1','2','3',#0,'1','2',#0,#0,'2','2','4',
                 '5','5',#0,'1','2','6','2','3',#0,'1',#0,'2',#0,
                 '2',#0,#0,#0,#0,#0,#0,#0,'1','2','3',#0,'1','2',
                 #0,#0,'2','2','4','5','5',#0,'1','2','6','2','3',
                 #0,'1',#0,'2',#0,'2',#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,
                 #0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0,#0);

{$F+}
Procedure   FormatStr(Var Result: String;Format: String;Var Params);Assembler;
Asm
   push  Word(Params)
   sub   sp,$0c
   push  ds
   lds   si,dword ptr Format
   les   di,dword ptr Result
   inc   di
   cld
   lodsb
   xor   ah,ah
   xchg  cx,ax
@@01:
   jcxz  @@07
   lodsb
   dec   cx
   cmp   al,'%'
   je    @@03
@@02:
   stosb
   jmp   @@01
@@03:
   jcxz  @@07
   lodsb
   dec   cx
   cmp   al,'%'
   je    @@02
   mov   bx,$20
   mov   dx,0
   cmp   al,'0'
   jne   @@04
   mov   bl,al
@@04:
   cmp   al,'-'
   jne   @@05
   inc   bh
   jcxz  @@07
   lodsb
   dec   cx
@@05:
   cmp   al,'0'
   jb    @@06
   cmp   al,'9'
   ja    @@06
   sub   al,'0'
   xchg  dx,ax
   mov   ah,$0a
   mul   ah
   add   al,dl
   xchg  dx,ax
   jcxz  @@07
   lodsb
   dec   cx
   jmp   @@05
@@06:
   cmp   al,'#'
   jne   @@08
   shl   dx,1
   shl   dx,1
   add   dx,[bp-02]
   mov   Word([bp+06]),dx
   jmp   @@01
@@07:
   xchg  di,ax
   les   di,dword ptr Result
   sub   ax,di
   dec   ax
   stosb
   jmp   @@22
@@08:
   push  ds
   push  di
   push  cx
   push  dx
   push  bx
   call  @@12
   pop   bx
   pop   dx
   or    dx,dx
   je    @@12
   sub   dx,cx
   jnb   @@10
   or    bh,bh
   jnz   @@09
   sub   si,dx
@@09:
   add   cx,dx
   xor   dx,dx
@@10:
   or    bh,bh
   je    @@11
   rep   movsb
@@11:
   xchg  dx,cx
   mov   al,bl
   rep   stosb
   xchg  dx,cx
   rep   movsb
   pop   cx
   pop   si
   pop   ds
   jmp   @@01
@@12:
   xchg  dx,ax
   lds   si,dword ptr Params
   lodsw
   xchg  bx,ax
   lodsw
   xchg  bx,ax
   mov   Word(Params),si
   xor   cx,cx
   lea   si,[bp-02]
   push  ss
   pop   ds
   and   dl,$df
   cmp   dl,'C'
   je    @@17
   cmp   dl,'S'
   je    @@13
   cmp   dl,'D'
   je    @@16
   cmp   dl,'X'
   je    @@15
   db    $c3
@@13:
   mov   dx,ax
   or    dx,bx
   je    @@14
   mov   si,ax
   mov   ds,bx
   lodsb
   mov  cl,al
@@14:
   db    $c3
@@15:
   mov   cl,$10
   jmp   @@20
@@16:
   mov   cl,$0a
   or    bx,bx
   jns   @@18
   neg   bx
   neg   ax
   sbb   bx,0
   call  @@18
   mov   al,'-'
@@17:
   inc   cx
   dec   si
   mov   Byte([si]),al
   db    $c3
@@18:
   push  si
@@19:
   xor   dx,dx
   xchg  bx,ax
   div   cx
   xchg  bx,ax
   div   cx
   add   dl,'0'
   cmp   dl,':'
@@20:
   jb    @@21
   add   dl,7
@@21:
   dec   si
   mov   Byte([si]),dl
   mov   dx,ax
   or    dx,bx
   jne   @@19
   pop   cx
   sub   cx,si
   db    $c3
@@22:
   pop   ds
   mov   sp,bp
End;

Procedure   FastMove;Assembler;
Asm
   cmp   si,di
   jb    @@01
   cld
   shr   cx,1
   jnb   @@03
   movsb
   jmp   @@03
@@01:
   std
   add   si,cx
   dec   si
   add   di,cx
   dec   di
   shr   cx,1
   jnb   @@02
   movsb
@@02:
   dec   si
   dec   di
@@03:
   repne movsw
end;
{$F-}

Function    StrL;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ah]
  end;
  str(L, RStr^);
end;

Function    StrLF;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ch]
  end;
  str(L:Field, RStr^);
end;

Function    StrLFCR;
Var
  Format ,
  Result : String;
Begin
  Format := '%' + StrL(Field) + 'D';
  FormatStr(Result,Format,L);
  StrLFCR := Result;
End;

Function    StrLFCL;
Var
  Format ,
  Result : String;
Begin
  Format := '%-' + StrL(Field) + 'D';
  FormatStr(Result,Format,L);
  StrLFCL := Result;
End;

Function    StrR;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ch]
  end;
  str(R, RStr^);
end;

Function    StrRF;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0eh]
  end;
  str(R:Field, RStr^);
end;

Function    StrRFD;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+10h]
  end;
  str(R:Field:Decimals, RStr^);
end;

{$IFOPT N+}
Function    StrC  (C: Comp)                             :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0eh]
  end;
  str(C, RStr^);
end;

Function    StrCF (C: Comp;Field: Integer)              :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+10h]
  end;
  str(C:Field, RStr^);
end;

Function    StrCFD(C: Comp;Field,Decimals: Integer)     :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+12h]
  end;
  str(C:Field:Decimals, RStr^);
end;

Function    StrD  (D: Double)                           :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0eh]
  end;
  str(D, RStr^);
end;

Function    StrDF (D: Double;Field: Integer)            :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+10h]
  end;
  str(D:Field, RStr^);
end;

Function    StrDFD(D: Double;Field,Decimals: Integer)   :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+12h]
  end;
  str(D:Field:Decimals, RStr^);
end;

Function    StrE  (E: Extended)                         :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+10h]
  end;
  str(E, RStr^);
end;

Function    StrEF (E: Extended;Field: Integer)          :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+12h]
  end;
  str(E:Field, RStr^);
end;

Function    StrEFD(E: Extended;Field,Decimals: Integer) :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+14h]
  end;
  str(E:Field:Decimals, RStr^);
end;

Function    StrS  (S: Single)                           :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ah]
  end;
  str(S, RStr^);
end;

Function    StrSF (S: Single;Field: Integer)            :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ch]
  end;
  str(S:Field, RStr^);
end;

Function    StrSFD(E: Single;Field,Decimals: Integer)   :String;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0eh]
  end;
  str(E:Field:Decimals, RStr^);
end;
{$ENDIF}

Procedure   ChrDel(Var Str: String;Match: Char);Assembler;
Asm
   mov    dx,ds
   lds    si,Str
   cld
   xor    bx,bx
   mov    ax,bx
   lodsb
   mov    cx,ax
   jcxz   @@03
   mov    di,ds
   mov    es,di
   mov    di,si
   mov    al,Match
   repne  scasb
   jne    @@04
   dec    di
   mov    si,di
   inc    si
@@01:
   cmp    al,[si]
   jne    @@02
   inc    si
   loop   @@01
   jmp    @@03
@@02:
   movsb
   inc    bx
   loop   @@01
@@03:
   mov    ax,di
   les    di,Str
   sub    ax,di
   dec    ax
   stosb
@@04:
   mov    ds,dx
end;

Function    ChrDel_(Str: String;Match: Char):String;Assembler;
asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   push  ax
   push  cs
   call  near ptr ChrDel
   pop   ds
end;

Procedure   ChrnDel (Var Str: String;Match: Char;Count: Integer);Assembler;
Asm
   push   ds
   cld
   les    di,Str
   inc    di
   lds    si,Str
   mov    ah,Match
   mov    bx,0
   mov    dx,Count
   or     dx,dx
   je     @@05
   lodsb
   mov    cl,al
   mov    ch,0
   jcxz   @@05
   push   di
@@01:
   lodsb
   cmp    al,ah
   je     @@02
   stosb
   inc    bl
   loop   @@01
   jmp    @@03
@@02:
   dec    dx
   jz     @@03
   loop   @@01
   jmp    @@04
@@03:
   add    bl,cl
   rep    movsb
@@04:
   pop    di
   dec    di
   mov    al,bl
   dec    al
   stosb
@@05:
   pop    ds
End;

Function    ChrnDel_(Str: String;Match: Char;Count: Integer):String;Assembler;
asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   mov   ah,0
   push  Count
   push  cs
   call  near ptr ChrnDel
   pop   ds
End;

Procedure   ChrDelI(Var Str: String;Match: Char;Index: Integer);Assembler;
Asm
   push   ds
   lds    si,Str
   cld
   lodsb
   xor    ah,ah
   mov    cx,ax
   jcxz   @@03
   mov    bx,Index
   xor    dx,dx
   push   ds
   pop    es
   mov    di,si
   push   di
   mov    ah,Match
   cmp    bx,cx
   ja     @@03
   cmp    bx,1
   jle    @@01
   push   cx
   mov    cx,bx
   dec    cx
   mov    dx,cx
   rep    movsb
   pop    cx
   sub    cx,bx
   inc    cx
@@01:
   lodsb
   cmp    al,ah
   je     @@02
   stosb
   inc    dl
@@02:
   loop   @@01
   pop    di
   mov    al,dl
   dec    di
   stosb
@@03:
   pop   ds
end;

Function    ChrDelI_(Str: String;Match: Char;Index: Integer):String;Assembler;
asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   mov   ah,0
   push  Index
   push  cs
   call  near ptr ChrDelI
   pop   ds
end;

Procedure   ChrDelL(Var Str: String;Match: Char);Assembler;
Asm
   push   ds
   les    di,Str
   lds    si,Str
   mov    al,Match
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@02
   mov    bx,cx
   inc    di
   cld
   repe   scasb
   jz     @@02
   mov    dx,di
   dec    dx
   sub    dx,si
   dec    dx
   mov    cx,bx
   sub    cx,dx
   mov    [si],cl
   inc    si
   xchg   di,si
   dec    si
   shr    cx,1
   jnb    @@01
   movsb
@@01:
   rep   movsw
@@02:
   pop  ds
End;

Function    ChrDelL_(Str: String;Match: Char):String;Assembler;
asm
   push  ds
   lds   si, Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   push  ax
   push  cs
   call  near ptr ChrDelL
   pop   ds
End;

Procedure   ChrnDelL (Var Str: String;Match: Char;Count: Integer);Assembler;
Asm
   push   ds
   les    di,Str
   lds    si,Str
   mov    al,Match
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@02
   mov    bx,cx
   mov    cx,Count
   cmp    cx,0
   jle    @@02
   inc    di
   cld
   repe   scasb
   jnz    @@02
   mov    dx,di
   sub    dx,si
   dec    dx
   mov    cx,bx
   sub    cx,dx
   mov    [si],cl
   inc    si
   xchg   di,si
   shr    cx,1
   jnb    @@01
   movsb
@@01:
   rep   movsw
@@02:
   pop  ds
End;

Function    ChrnDelL_(Str: String;Match: Char;Count: Integer):String;Assembler;
Asm
   push  ds
   lds   si, Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   push  ax
   push  Count
   push  cs
   call  near ptr ChrnDelL
   pop   ds
End;

Procedure   ChrnDelLI (Var Str: String;Match: Char;Count,Index: Integer);Assembler;
Asm
   push   ds
   les    di,Str
   lds    si,Str
   mov    ah,Match
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@05
   cmp    cx,Index
   jl     @@05
   mov    bx,cx
   add    si,Index
   add    di,Index
   mov    dx,Count
   cld
@@01:
   lodsb
   cmp    al,ah
   jne    @@02
   or     dx,dx
   je     @@02
   dec    dx
   loop   @@01
   jmp    @@03
@@02:
   stosb
   cmp    dx,Count
   jne    @@04
   loop   @@01
@@03:
   sub    bx,Count
   add    bx,dx
   mov    ax,bx
   les    di,Str
   stosb
   jmp    @@05
@@04:
   push   cs
   call   near ptr fastmove
   jmp    @@03
@@05:
   pop  ds
End;

Function    ChrnDelLI_(Str: String;Match: Char;Count,Index: Integer):String;Assembler;
Asm
   push  ds
   lds   si, Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   push  ax
   push  Count
   push  Index
   push  cs
   call  near ptr ChrnDelLI
   pop   ds
End;

Procedure   ChrDelR(Var Str: String;Match: Char);Assembler;
Asm
   les    di,Str
   mov    si,di
   mov    al,Match
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@03
   add    di,cx
@@01:
   cmp    es:[di],al
   jne    @@02
   dec    di
   loop   @@01
   jmp    @@03
@@02:
   mov    es:[si],cl
@@03:
end;

Function    ChrDelR_(Str: String;Match: Char):String;Assembler;
asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   mov   ah,0
   push  ax
   push  cs
   call  near ptr ChrDelR
   pop   ds
end;

Procedure   ChrnDelR (Var Str: String;Match: Char;Count: Integer);Assembler;
Asm
   les    di,Str
   mov    si,di
   mov    al,Match
   mov    dx,Count
   xor    cx,cx
   mov    cl,es:[di]
   jcxz   @@03
   cmp    dx,0
   jle    @@03
   add    di,cx
@@01:
   cmp    es:[di],al
   jne    @@02
   dec    di
   dec    dx
   js     @@02
   loop   @@01
   jmp    @@03
@@02:
   mov    es:[si],cl
@@03:
End;

Function    ChrnDelR_(Str: String;Match: Char;Count: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Match
   mov   ah,0
   push  ax
   push  Count
   push  cs
   call  near ptr ChrnDelR
   pop   ds
End;

Procedure   ChrFill(Var Str: String;Fill: Char;MaxLen: Integer);Assembler;
Asm
   cld
   les   di,Str
   mov   ax,MaxLen
   stosb
   mov   cx,ax
   mov   al,Fill
   mov   ah,al
   shr   cx,1
   jnc   @@01
   stosb
@@01:
   rep   stosw
@@02:
end;

Function    ChrFill_(Fill: Char;MaxLen: Integer):String;Assembler;
Asm
   les   di,@Result
   push  es
   push  di
   mov   al,Fill
   push  ax
   push  Maxlen
   push  cs
   call  near ptr ChrFill
End;

Procedure   ChrPadC(Var Str: String;Fill: Char;MaxLen: Integer);Assembler;
Asm
   les   di,Str
   mov   si,di
   mov   dx,MaxLen
   or    dx,dx
   jz    @@08
   sub   cx,cx
   mov   cl,es:[di]
   cmp   cx,dx
   jae   @@08
   mov   es:[di],dl
   push  di
   sub   dx,cx
   mov   bx,dx
   shr   bx,1
   sub   dx,bx
   add   di,cx
   add   si,dx
   add   si,cx
   or    cx,cx
   jnz   @@01
   mov   bx,MaxLen
   jmp   @@03
@@01:
   push  si
@@02:
   mov   al,es:[di]
   mov   es:[si],al
   dec   di
   dec   si
   loop  @@02
   pop   si
@@03:
   mov   al,Fill
   mov   cx,bx
   jcxz  @@05
@@04:
   inc   si
   mov   es:[si],al
   loop  @@04
@@05:
   pop   di
   mov   cx,dx
   jcxz  @@08
   inc   di
@@06:
   cld
   shr   cx,1
   jnb   @@07
   stosb
@@07:
   mov   ah,al
   rep   stosw
@@08:
end;

Function    ChrPadC_  (Str: String;Fill: Char;MaxLen: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Fill
   push  ax
   push  Maxlen
   push  cs
   call  near ptr ChrPadC
   pop   ds
end;

Procedure   ChrPadL(Var Str: String;Fill: Char;MaxLen: Integer);Assembler;
Asm
   push  ds
   les   di,Str
   push  es
   pop   ds
   xor   ch,ch
   mov   cl,es:[di]
   mov   bx,MaxLen
   cmp   cl,bl
   jae   @@04
   mov   es:[di],bl
   mov   si,di
   add   si,cx
   add   di,bx
   sub   bx,cx
   std
   inc  cx
   shr   cx,1
   jnb   @@01
   movsb
@@01:
   rep   movsw
   mov   cx,bx
   mov   al,Fill
   mov   ah,al
   les   di,Str
   inc   di
   cld
   shr   cx,1
   jnb   @@03
   stosb
@@03:
   rep   stosw
@@04:
   pop   ds
End;

Function    ChrPadL_  (Str: String;Fill: Char;MaxLen: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Fill
   push  ax
   push  Maxlen
   push  cs
   call  near ptr ChrPadL
   pop   ds
end;

Procedure   ChrPadR(Var Str: String;Fill: Char;MaxLen: Integer);Assembler;
Asm
   les   di,Str
   xor   cx,cx
   mov   cl,es:[di]
   mov   bx,MaxLen
   cmp   cl,bl
   jae   @@03
   mov   es:[di],bl
   add   di,cx
   sub   bx,cx
   mov   cx,bx
   mov   al,Fill
   mov   ah,al
   cld
   inc  di
@@01:
   shr   cx,1
   jnb   @@02
   stosb
@@02:
   rep   stosw
@@03:
End;

Function    ChrPadR_(Str: String;Fill: Char;MaxLen: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   mov   al,Fill
   push  ax
   push  Maxlen
   push  cs
   call  near ptr ChrPadR
   pop   ds
end;

Function    ChrPosL (Str: String;Match: Char): Integer;Assembler;
Asm
  les   di,Str
  mov   ch,0
  mov   cl,es:[di]
  inc   di
  jcxz  @@01
  mov   al,Match
  mov   bx,cx
  cld
  repne scasb
  jne   @@01
  sub   bx,cx
  xchg  bx,cx
@@01:
  mov   ax,cx
End;

Function    ChrPosLN(Str: String;Match: Char;Occur: Byte): Integer;Assembler;
Asm
  les   di,Str
  mov   ch,0
  mov   cl,es:[di]
  inc   di
  jcxz  @@02
  mov   al,Match
  mov   dl,Occur
  mov   bx,cx
  cld
@@01:
  repne scasb
  jne   @@02
  dec   dl
  jnz   @@01
  sub   bx,cx
  xchg  bx,cx
@@02:
  mov   ax,cx
End;

Function    ChrPosR (Str: String;Match: Char): Integer;Assembler;
Asm
  les   di,Str
  mov   ch,0
  mov   cl,es:[di]
  jcxz  @@02
  add   di,cx
  mov   al,Match
@@01:
  std
  repne scasb
  jne   @@02
  inc   cx
@@02:
  mov   ax,cx
End;

Function    ChrPosRI(Str: String;Match: Char): Integer;Assembler;
Asm
  push  ds
  lds   si,Str
  mov   ch,0
  mov   cl,Byte([si])
  jcxz  @@03
  add   si,cx
  mov   dx,cx
  mov   al,Match
  push  ax
  push  cs
  call  near ptr upcase
  mov   ah,al
  std
@@01:
  lodsb
  push  ax
  push  cs
  call  near ptr upcase
  cmp   al,ah
  je    @@02
  dec   dx
  loop  @@01
@@02:
  mov   cx,dx
@@03:
  mov   ax,cx
  pop   ds
End;

Function    ChrPosRIN(Str: String;Match: Char;Occur: Byte): Integer;Assembler;
Asm
  push  ds
  lds   si,Str
  mov   ch,0
  mov   cl,Byte([si])
  jcxz  @@03
  add   si,cx
  mov   al,Match
  push  ax
  push  cs
  call  near ptr upcase
  mov   ah,al
  mov   dl,Occur
  std
@@01:
  lodsb
  push  ax
  push  cs
  call  near ptr upcase
  cmp   al,ah
  je    @@02
  loop  @@01
  jmp   @@03
@@02:
  dec   dl
  jz    @@03
  loop  @@01
@@03:
  mov   ax,cx
  pop   ds
End;

Function    ChrPosRN(Str: String;Match: Char;Occur: Byte): Integer;Assembler;
Asm
  les   di,Str
  mov   ch,0
  mov   cl,es:[di]
  jcxz  @@02
  add   di,cx
  mov   al,Match
  mov   dl,Occur
  std
@@01:
  repne scasb
  jne   @@02
  dec   dl
  jnz   @@01
  inc   cx
@@02:
  mov   ax,cx
End;

Function    ChrPosLI (Str: String;Match: Char): Integer;Assembler;
Asm
  mov   dx,ds
  lds   si,Str
  cld
  lodsb
  mov   ch,0
  mov   cl,al
  jcxz  @@03
  mov   al,Match
  push  ax
  push  cs
  call  near ptr upcase
  mov   ah,al
  mov   bx,1
@@01:
  lodsb
  push  ax
  push  cs
  call  near ptr upcase
  cmp   al,ah
  je    @@02
  inc   bx
  loop  @@01
  jmp   @@03
@@02:
  mov   cx,bx
@@03:
  mov   ax,cx
  mov   ds,dx
End;

Function    ChrPosLIN(Str: String;Match: Char;Occur: Byte): Integer;Assembler;
Asm
  push  ds
  lds   si,Str
  cld
  lodsb
  mov   ch,0
  mov   cl,al
  jcxz  @@04
  mov   al,Match
  push  ax
  push  cs
  call  near ptr upcase
  mov   ah,al
  mov   bx,1
  mov   dl,Occur
@@01:
  lodsb
  push  ax
  push  cs
  call  near ptr upcase
  cmp   al,ah
  je    @@02
  inc   bx
  loop  @@01
  jmp   @@04
@@02:
  dec   dl
  jz    @@03
  inc   bx
  loop  @@01
@@03:
  mov   cx,bx
@@04:
  mov   ax,cx
  pop   ds
End;

Function    ChrQty   (Str: String;Match: Char): Integer;Assembler;
Asm
  les   di,Str
  cld
  mov   ch,0
  mov   cl,Byte(es:[di])
  inc   di
  mov   dx,0
  jcxz  @@02
  mov   al,Match
  mov   dx,0
@@01:
  repne scasb
  jne   @@02
  inc   dl
  jcxz  @@02
  jmp   @@01
@@02:
  mov   ax,dx
End;

Function    ChrQtyI  (Str: String;Match: Char): Integer;Assembler;
Asm
  push  ds
  lds   si,Str
  cld
  lodsb
  mov   ch,0
  mov   cl,al
  mov   dx,0
  jcxz  @@03
  mov   al,Match
  push  ax
  push  cs
  call  near ptr upcase
  mov   ah,al
@@01:
  lodsb
  push  ax
  push  cs
  call  near ptr upcase
  cmp   al,ah
  jne   @@02
  inc   dl
@@02:
  loop  @@01
@@03:
  mov   ax,dx
  pop   ds
End;

Procedure   ChrRepl(Var Str: String;Chr1,Chr2 : Char);Assembler;
Asm
   push  ds
   lds   si,Str
   lodsb
   mov   cl,al
   xor   ch,ch
   jcxz  @@03
   mov   ah,Chr1
@@01:
   cmp   byte([si]),ah
   jne   @@02
   mov   al,Chr2
   mov   byte([si]),al
@@02:
   inc   si
   loop  @@01
@@03:
   pop   ds
end;

Function    ChrRepl_(Str:String;Chr1,Chr2 : Char):String;Assembler;
Asm
   cld
   push  ds
   lds   si,Str
   les   di,@Result
   lodsb
   stosb
   mov   cl,al
   xor   ch,ch
   jcxz  @@04
   mov   ah,Chr1
@@01:
   lodsb
   cmp   al,ah
   jne   @@02
   mov   al,Chr2
@@02:
   stosb
   loop  @@01
@@04:
   pop   ds
End;

Procedure   ChrReplI(Var Str:String;Chr1,Chr2 : Char);Assembler;
Asm
   push  ds
   xor   ax,ax
   lds   si,Str
   lodsb
   mov   cl,al
   xor   ch,ch
   jcxz  @@03
   mov   al,Chr1
   push  ax
   push  cs
   call  near ptr Upcase
   mov   ah,al
@@01:
   mov   al,[si]
   push  ax
   push  cs
   call  near ptr Upcase
   cmp   al,ah
   jne   @@02
   mov   al,Chr2
   mov   byte([si]),al
   mov   al,Chr1
   push  ax
   push  cs
   call  near ptr Upcase
   mov   ah,al
@@02:
   inc   si
   loop  @@01
@@03:
   pop   ds
end;

Function    ChrReplI_(Str:String;Chr1,Chr2 : Char):String;Assembler;
Asm
   cld
   push  ds
   lds   si,Str
   les   di,@Result
   lodsb
   stosb
   mov   cl,al
   xor   ch,ch
   jcxz  @@03
   mov   al,Chr1
   push  ax
   push  cs
   call  near ptr upcase
   mov   ah,al
@@01:
   lodsb
   push  ax
   push  ax
   push  cs
   call  near ptr upcase
   cmp   al,ah
   pop   ax
   jne   @@02
   mov   al,Chr2
@@02:
   stosb
   loop  @@01
@@03:
   pop   ds
End;

{$IFNDEF VER70}
Function    StrPCopy(Var Dest: pChar;Source: String): pChar;
Asm
   push   ds
   cld
   xor    ax,ax
   lds    si,dword ptr Source
   les    di,Dest
   push   es
   push   di
   lodsb
   cwd
   mov    cx,ax
   push   cx
   call   FastMove
   pop    bx
   pop    di
   pop    es
   mov    Byte(es:[di][bx]),0
   pop    ds
   mov    ax,di
   mov    dx,es
end;

Function    StrPas  (Str: pChar)                         :String;
Asm
   push  ds
   cld
   mov   cx,-1
   mov   al,0
   les   di,Str
   repnz scasb
   mov   ax,cx
   not   ax
   dec   ax
   les   di,@Result
   stosb
   lds   si,Str
   mov   cx,ax
   push  cs
   call  near ptr fastmove
   pop   ds
end;
{$ENDIF}

Procedure   StrCat(Var Str1: String;Str2: String);Assembler;
Asm
   push  ds
   xor   ax,ax
   mov   bx,ax
   cld
   lds   si,Str2
   les   di,Str1
   lodsb
   mov   cx,ax
   jcxz  @@03
   mov   bl,es:[di]
   inc   di
   add   di,bx
   add   bx,cx
@@01:
   cmp   bx,$0100
   jl    @@02
   dec   bx
   loop  @@01
@@02:
   jcxz  @@03
   push  cs
   call  near ptr FastMove
   les   di,Str1
   mov   Byte(es:[di]),bl
@@03:
   pop   ds
end;

Function    StrCat_(Str1: String;Str2: String):String;Assembler;
Asm
   push  ds
   lds   si,Str1
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   les   di,Str2
   push  es
   push  di
   push  cs
   call  near ptr StrCat
   pop   ds
end;

Procedure   StrnCat(Var Str1: String;Str2: String;Maxlen: Integer);Assembler;
Asm
   push  ds
   xor   ax,ax
   mov   bx,ax
   cld
   lds   si,Str2
   les   di,Str1
   lodsb
   mov   cx,ax
   jcxz  @@04
   mov   bl,es:[di]
   inc   di
   add   di,bx
   add   bx,cx
@@01:
   cmp   bx,$0100
   jl    @@02
   dec   bx
   loop  @@01
   jcxz  @@04
@@02:
   cmp   bx,Maxlen
   jle   @@03
   dec   bx
   loop  @@02
@@03:
   jcxz  @@04
   push  cs
   call  near ptr FastMove
   les   di,Str1
   mov   Byte(es:[di]),bl
@@04:
   pop   ds
end;

Function    StrnCat_(Str1: String;Str2: String;Maxlen: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str1
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   les   di,Str2
   push  es
   push  di
   push  Maxlen
   push  cs
   call  near ptr StrnCat
   pop   ds
End;

Function    StrCmp(Str1,Str2: String):ShortInt;Assembler;
Asm
   mov   dx,ds
   cld
   les   di,Str2
   lds   si,Str1
   mov   ah,es:[di]
   inc   di
   lodsb
   xor  bx,bx
   xor  cx,cx
   mov  cl,al
   cmp  al,ah
   je   @@01
   jb   @@02
   inc  bx
   mov  cl,ah
   jcxz @@03
@@01:
   xor   bx,bx
   jcxz  @@03
@@02:
   mov   bx,-1
   jcxz  @@03
   repe  cmpsb
   pushf
   xor   bl,bl
   popf
   je    @@03
   mov   bl,1
   ja    @@03
   mov   bx,-1
@@03:
   mov   ax,bx
   mov   ds,dx
end;

Function    StrCmpE(Str1,Str2: String;Exact: Boolean):ShortInt;Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   les   di,Str2
   lodsb
   mov   ah,es:[di]
   inc   di
   mov   cl,al
   cmp   cl,ah
   jbe   @@02
@@01:
   mov   cl,ah
   jmp   @@03
@@02:
   mov   bl,Exact
   or    bl,bl
   je    @@01
@@03:
   xor   ch,ch
   rep   cmpsb
   je    @@04
   mov   al,[si-1]
   mov   ah,es:[di-1]
   sub   al,ah
   cbw
   jmp   @@05
@@04:
   xor   ax,ax
@@05:
   pop   ds
End;

Function    StrCmpEI(Str1,Str2: String;Exact: Boolean):ShortInt;Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   les   di,Str2
   lodsb
   mov   ah,es:[di]
   inc   di
   mov   cl,al
   cmp   cl,ah
   jbe   @@02
@@01:
   mov   cl,ah
   jmp   @@03
@@02:
   mov   bl,Exact
   or    bl,bl
   je    @@01
@@03:
   xor   ch,ch
@@04:
   jcxz  @@06
   mov   al,[si]
   inc   si
   push  ax
   push  cs
   call  near ptr Upcase
   push  ax
   mov   al,es:[di]
   inc   di
   push  ax
   push  cs
   call  near ptr Upcase
   pop   bx
   cmp   ax,bx
   jne   @@05
   loop  @@04
   jmp   @@06
@@05:
   sub   ax,bx
   jmp   @@07
@@06:
   xor   ax,ax
@@07:
   pop   ds
End;

Function    StrCmpI(Str1,Str2: String):ShortInt;Assembler;
Asm
   push  ds
   cld
   les   di,Str2
   lds   si,Str1
   mov   ah,es:[di]
   inc   di
   lodsb
   xor   bx,bx
   mov   cx,bx
   mov   cl,al
   cmp   al,ah
   je    @@01
   jb    @@02
   inc   bx
   mov   cl,ah
   jcxz  @@04
@@01:
   xor   bx,bx
   jcxz  @@04
@@02:
   mov   bx,-1
   jcxz  @@04
@@03:
   lodsb
   push  ax
   push  cs
   call  near ptr Upcase
   mov   ah,es:[di]
   inc   di
   xchg  al,ah
   push  ax
   push  cs
   call  near ptr Upcase
   cmp   ah,al
   loope @@03
   pushf
   xor   bl,bl
   popf
   je    @@04
   mov   bl,1
   ja    @@04
   mov   bx,-1
@@04:
   mov   ax,bx
   pop   ds
end;

Function    StrnCmp(Str1,Str2: String;Count: Integer):ShortInt;Assembler;
Asm
   mov   dx,ds
   cld
   les   di,Str2
   lds   si,Str1
   mov   ah,es:[di]
   inc   di
   lodsb
   xor  bx,bx
   xor  cx,cx
   mov  cl,al
   cmp  al,ah
   je   @@01
   jb   @@02
   inc  bx
   mov  cl,ah
   jcxz @@04
@@01:
   xor   bx,bx
   jcxz  @@04
@@02:
   mov   bx,-1
   jcxz  @@04
   cmp   cx,Count
   jna   @@03
   mov   cx,Count
@@03:
   repe  cmpsb
   pushf
   xor   bl,bl
   popf
   je    @@04
   mov   bl,1
   ja    @@04
   mov   bx,-1
@@04:
   mov   ax,bx
   mov   ds,dx
end;

Function    StrnCmpE(Str1,Str2: String;Exact: Boolean;Count: Integer):ShortInt;Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   les   di,Str2
   lodsb
   mov   ah,es:[di]
   inc   di
   mov   cl,al
   cmp   cl,ah
   jbe   @@02
@@01:
   mov   cl,ah
   jmp   @@03
@@02:
   mov   bl,Exact
   or    bl,bl
   je    @@01
@@03:
   xor   ch,ch
   cmp   cx,Count
   jna   @@04
   mov   cx,Count
@@04:
   rep   cmpsb
   je    @@05
   mov   al,[si-1]
   mov   ah,es:[di-1]
   sub   al,ah
   cbw
   jmp   @@06
@@05:
   xor   ax,ax
@@06:
   pop   ds
End;

Function    StrnCmpEI(Str1,Str2: String;Exact: Boolean;Count: Integer):ShortInt;Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   les   di,Str2
   lodsb
   mov   ah,es:[di]
   inc   di
   mov   cl,al
   cmp   cl,ah
   jbe   @@02
@@01:
   mov   cl,ah
   jmp   @@03
@@02:
   mov   bl,Exact
   or    bl,bl
   je    @@01
@@03:
   xor   ch,ch
   cmp   cx,Count
   jna   @@04
   mov   cx,Count
@@04:
   jcxz  @@06
   mov   al,[si]
   inc   si
   push  ax
   push  cs
   call  near ptr Upcase
   push  ax
   mov   al,es:[di]
   inc   di
   push  ax
   push  cs
   call  near ptr Upcase
   pop   bx
   cmp   ax,bx
   jne   @@05
   loop  @@04
   jmp   @@06
@@05:
   sub   ax,bx
   jmp   @@07
@@06:
   xor   ax,ax
@@07:
   pop   ds
End;

Function    StrnCmpI(Str1,Str2: String;Count: Integer):ShortInt;Assembler;
Asm
   push  ds
   cld
   les   di,Str2
   lds   si,Str1
   mov   ah,es:[di]
   inc   di
   lodsb
   xor   bx,bx
   mov   cx,bx
   mov   cl,al
   cmp   al,ah
   je    @@01
   jb    @@02
   inc   bx
   mov   cl,ah
   jcxz  @@04
@@01:
   xor   bx,bx
   jcxz  @@04
@@02:
   mov   bx,-1
   jcxz  @@04
   cmp   cx,Count
   jna   @@03
   mov   cx,Count
@@03:
   lodsb
   push  ax
   push  cs
   call  near ptr Upcase
   mov   ah,es:[di]
   inc   di
   xchg  al,ah
   push  ax
   push  cs
   call  near ptr Upcase
   cmp   ah,al
   loope @@03
   pushf
   xor   bl,bl
   popf
   je    @@04
   mov   bl,1
   ja    @@04
   mov   bx,-1
@@04:
   mov   ax,bx
   pop   ds
end;

Procedure   StrCopy(Var Str1: String;Str2: String);Assembler;
Asm
   push  ds
   les   di,Str1
   lds   si,Str2
   xor   ch,ch
   mov   cl,[si]
   inc   cx
   push  cs
   call  near ptr Fastmove
   pop   ds
end;

Procedure   StrnCopy(Var Str1: String;Str2: String;MaxLen: Integer);Assembler;
Asm
   push  ds
   les   di,Str1
   lds   si,Str2
   xor   ch,ch
   mov   cl,[si]
   cmp   cx,Maxlen
   jna   @@01
   mov   cx,Maxlen
   mov   Byte(es:[di]),cl
   inc   si
   inc   di
   dec   cx
@@01:
   inc   cx
   push  cs
   call  near ptr Fastmove
   pop   ds
end;

Procedure   StrnCpyI(Var Str1: String;Str2: String;Index,Count: Integer);Assembler;
Asm
   push  ds
   les   di,Str1
   lds   si,Str2
   mov   ax,Index
   mov   bx,Count
   push  es
   push  di
   push  ds
   push  si
   push  ax
   push  bx
   push  cs
   call  near ptr Copy
   add   sp,4
   pop   ds
end;

Function    StrCSpn(Str1,Str2: String): Integer;Assembler;
Var
  aSet: Array[1..32] of Byte;
Asm
   push   ds
   cld
   lds    si,Str2
   mov    ax,ss
   mov    es,ax
   mov    cx,16
   xor    ax,ax
   lea    di,aSet
   rep    stosw
   lodsb
   or     al,al
   jz     @@02
   mov    cx,ax
@@01:
   lodsb
   push   cx
   mov    di,ax
   mov    cx,ax
   mov    al,1
   and    cl,7
   shl    al,cl
   mov    cl,3
   shr    di,cl
   or     byte([aSet+di]),al
   pop    cx
   loop   @@01
@@02:
   lds    si,Str1
   mov    bx,-1
   lodsb
   mov    ah,0
   mov    cx,ax
   jcxz   @@05
@@03:
   inc    bx
   lodsb
   push   cx
   mov    di,ax
   mov    cx,ax
   mov    al,1
   and    cl,7
   shl    al,cl
   mov    cl,3
   shr    di,cl
   pop    cx
   and    al,Byte([aSet+di])
   jnz    @@04
   loop   @@03
   inc    bx
@@04:
   xchg   ax,bx
@@05:
   pop    ds
end;

Function    StrPBrk(Str1,Str2: String):Integer;Assembler;
Var
  aSet: Array[1..32] of Byte;
Asm
  push   ds
  cld
  lds    si,Str2
  mov    ax,ss
  mov    es,ax
  mov    cx,16
  xor    ax,ax
  lea    di,aSet
  rep    stosw
  lodsb
  or     al,al
  jz     @@02
  mov    cx,ax
@@01:
  lodsb
  push   cx
  mov    di,ax
  mov    cx,ax
  mov    al,1
  and    cl,7
  shl    al,cl
  mov    cl,3
  shr    di,cl
  or     byte([aSet+di]),al
  pop    cx
  loop   @@01
@@02:
  lds    si,Str1
  mov    bx,0
  lodsb
  mov    cl,al
  jcxz   @@04
@@03:
  inc    bx
  lodsb
  push   cx
  mov    di,ax
  mov    cx,ax
  mov    al,1
  and    cl,7
  shl    al,cl
  mov    cl,3
  shr    di,cl
  pop    cx
  and    al,Byte([aSet+di])
  jnz    @@04
  loop   @@03
  mov    bx,0
@@04:
  xchg   ax,bx
  pop    ds
end;

Procedure   StrMemb(Var Str1: String;Str2: String);Assembler;
Var
  aSet: Array[1..32] of Byte;
Asm
  push   ds
  cld
  lds    si,Str2
  mov    ax,ss
  mov    es,ax
  mov    cx,16
  xor    ax,ax
  lea    di,aSet
  rep    stosw
  lodsb
  or     al,al
  jz     @@02
  mov    cx,ax
@@01:
  lodsb
  push   cx
  mov    di,ax
  mov    cx,ax
  mov    al,1
  and    cl,7
  shl    al,cl
  mov    cl,3
  shr    di,cl
  or     byte([aSet+di]),al
  pop    cx
  loop   @@01
@@02:
  mov    bx,0
  mov    al,0
  les    di,Str1
  inc    di
  mov    cx,255
@@03:
  inc    al
  push   di
  push   ax
  push   cx
  mov    di,ax
  mov    cx,ax
  mov    al,1
  and    cl,7
  shl    al,cl
  mov    cl,3
  shr    di,cl
  pop    cx
  and    al,Byte([aSet+di])
  pop    ax
  pop    di
  jz     @@04
  stosb
  inc    bx
@@04:
  loop   @@03
  les    di,Str1
  mov    ax,bx
  stosb
@@05:
  pop    ds
End;

Procedure   StrCut(Var Str1: String;MaxLen: Integer);Assembler;
Asm
   push  ds
   lds   si,Str1
   xor   ax,ax
   cld
   lodsb
   cmp   ax,Maxlen
   jnae  @@01
   mov   ax,Maxlen
   mov   [si-1],al
@@01:
   pop   ds
end;

Function    StrCut_(    Str1: String;MaxLen: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str1
   les   di,@Result
   xor   ax,ax
   cld
   lodsb
   cmp   ax,Maxlen
   jnae  @@01
   mov   ax,Maxlen
@@01:
   mov   cx,ax
   stosb
   push  cs
   call  near ptr Fastmove
   pop   ds
end;

Procedure   StrDeTab(Var Str1: String;Str2: String;TabSize: Byte);Assembler;
Asm
   push   ds
   cld
   xor    cx,cx
   mov    dx,cx
   mov    dh,TabSize
   lds    si,Str2
   les    di,Str1
   lodsb
   or     dh,dh
   jnz    @@01
   xor    al,al
@@01:
   mov    cl,al
   stosb
   jcxz   @@06
   mov    ah,$09
   mov    bl,255
@@02:
   lodsb
   cmp    al,ah
   je     @@03
   stosb
   inc    dl
   cmp    dl,bl
   loopne @@02
   jmp    @@05
@@03:
   push   cx
   mov    cl,dh
   mov    al,' '
@@04:
   stosb
   inc    dl
   cmp    dl,bl
   loopne @@04
   pop    cx
   loop   @@02
@@05:
   les    di,Str1
   mov    es:[di],dl
@@06:
   pop    ds
end;

Function    StrDeTab_(Str1: String;TabSize: Byte):String;Assembler;
Asm
   push   ds
   cld
   xor    cx,cx
   mov    dx,cx
   mov    dh,TabSize
   lds    si,Str1
   les    di,@Result
   lodsb
   or     dh,dh
   jnz    @@01
   xor    al,al
@@01:
   mov    cl,al
   stosb
   jcxz   @@06
   mov    ah,$09
   mov    bl,255
@@02:
   lodsb
   cmp    al,ah
   je     @@03
   stosb
   inc    dl
   cmp    dl,bl
   loopne @@02
   jmp    @@05
@@03:
   push   cx
   mov    cl,dh
   mov    al,' '
@@04:
   stosb
   inc    dl
   cmp    dl,bl
   loopne @@04
   pop    cx
   loop   @@02
@@05:
   les    di,@Result
   mov    es:[di],dl
@@06:
   pop    ds
end;

Procedure   StrReTab(Var Str1: String;Str2: String;TabSize: Byte);Assembler;
Asm
   push   ds
   cld
   xor    bx,bx
   mov    cx,bx
   mov    dx,cx
   mov    dh,TabSize
   lds    si,Str2
   les    di,Str1
   lodsb
   stosb
@@01:
   mov    cl,al
   jcxz   @@08
@@02:
   lodsb
   cmp    al,' '
   je     @@04
   or     dl,dl
   jne    @@05
@@03:
   stosb
   inc    bl
   loop   @@02
   jmp    @@07
@@04:
   inc    dl
   cmp    dl,dh
   je     @@06
   loop   @@02
   or     dl,dl
   jz     @@07
@@05:
   push   cx
   push   ax
   mov    cl,dl
   mov    al,' '
   add    bl,cl
   rep    stosb
   pop    ax
   pop    cx
   xor    dl,dl
   jcxz   @@07
   jmp    @@03
@@06:
   mov    al,9
   stosb
   inc    bl
   xor    dl,dl
   loop   @@02
@@07:
   les   di,Str1
   mov   es:[di],bl
@@08:
   pop   ds
end;

Function    StrReTab_(    Str1: String;TabSize: Byte):String;Assembler;
Asm
   push   ds
   cld
   xor    bx,bx
   mov    cx,bx
   mov    dx,cx
   mov    dh,TabSize
   lds    si,Str1
   les    di,@Result
   lodsb
   stosb
@@01:
   mov    cl,al
   jcxz   @@08
@@02:
   lodsb
   cmp    al,' '
   je     @@04
   or     dl,dl
   jne    @@05
@@03:
   stosb
   inc    bl
   loop   @@02
   jmp    @@07
@@04:
   inc    dl
   cmp    dl,dh
   je     @@06
   loop   @@02
   or     dl,dl
   jz     @@07
@@05:
   push   cx
   push   ax
   mov    cl,dl
   mov    al,' '
   add    bl,cl
   rep    stosb
   pop    ax
   pop    cx
   xor    dl,dl
   jcxz   @@07
   jmp    @@03
@@06:
   mov    al,9
   stosb
   inc    bl
   xor    dl,dl
   loop   @@02
@@07:
   les   di,@Result
   mov   es:[di],bl
@@08:
   pop   ds
end;

Procedure   StrENum(Var Str1: String;First,Last: Char);Assembler;
Asm
  mov   cx,0
  mov   bx,1
  mov   cl,Last
  sub   cl,First
  cmp   cl,0
  jnl   @@01
  dec   cl
  not   cl
  mov   bx,-1
@@01:
  inc   cl
  les   di,Str1
  mov   al,cl
  cld
  stosb
  mov   al,First
@@02:
  stosb
  add   al,bl
  loop  @@02
End;

Function    StrENum_ (First,Last: Char):String;Assembler;
Asm
  mov   cx,0
  mov   bx,1
  mov   cl,Last
  sub   cl,First
  cmp   cl,0
  jnl   @@01
  dec   cl
  not   cl
  mov   bx,-1
@@01:
  inc   cl
  les   di,@Result
  mov   al,cl
  cld
  stosb
  mov   al,First
@@02:
  stosb
  add   al,bl
  loop  @@02
End;

Procedure   StrFill(Var Str1: String;Str2: String;Count, MaxLen: Integer);Assembler;
Asm
   push  ds
   les   di,Str1
   lds   si,Str2
   mov   Byte(es:[di]),0
   mov   cx,MaxLen
   jcxz  @@04
   mov   dl,[si]
   mov   dh,dl
   or    dl,dl
   jz    @@04
   push  dx
   xor   ah,ah
   mov   al,[si]
   mov   bx,Count
   mul   bx
   cmp   al,cl
   jae   @@01
   mov   es:[di],al
   jmp   @@02
@@01:
   mov   es:[di],cl
@@02:
   pop   dx
   mov   bx,si
   mov   ax,Count
   push  cx
   mov   cl,8
   shl   ax,cl
   pop   cx
@@03:
   inc   di
   inc   si
   push  ax
   mov   al,[si]
   mov   es:[di],al
   pop   ax
   dec   cx
   jz    @@04
   dec   dl
   jnz   @@03
   dec   ax
   je    @@04
   mov   dl,dh
   mov   si,bx
   jmp   @@03
@@04:
   pop   ds
end;

Function    StrFill_(Str1: String;Count,MaxLen: Integer):String;Assembler;
Asm
   push  ds
   les   di,@Result
   lds   si,Str1
   mov   Byte(es:[di]),0
   mov   cx,MaxLen
   jcxz  @@04
   mov   dl,[si]
   mov   dh,dl
   or    dl,dl
   jz    @@04
   push  dx
   xor   ah,ah
   mov   al,[si]
   mov   bx,Count
   mul   bx
   cmp   al,cl
   jae   @@01
   mov   es:[di],al
   jmp   @@02
@@01:
   mov   es:[di],cl
@@02:
   pop   dx
   mov   bx,si
   mov   ax,Count
   push  cx
   mov   cl,8
   shl   ax,cl
   pop   cx
@@03:
   inc   di
   inc   si
   push  ax
   mov   al,[si]
   mov   es:[di],al
   pop   ax
   dec   cx
   jz    @@04
   dec   dl
   jnz   @@03
   dec   ax
   je    @@04
   mov   dl,dh
   mov   si,bx
   jmp   @@03
@@04:
   pop   ds
end;

Procedure   StrJC(Var Str1: String;MaxLen: Integer);
Begin
  ChrPadC(Str1,' ',MaxLen);
end;

Function    StrJC_(Str1: String;MaxLen: Integer):String;
Begin
  StrJC_ := ChrPadC_(Str1,' ',Maxlen);
End;

Procedure   StrJL(Var Str1: String;MaxLen: Integer);
Begin
  ChrPadR(Str1,' ',MaxLen);
End;

Function    StrJL_(Str1: String;MaxLen: Integer):String;
Begin
  StrJL_ := ChrPadR_(Str1,' ',Maxlen);
End;

Procedure   StrJR(Var Str1: String;MaxLen: Integer);
Begin
  ChrPadL(Str1,' ',MaxLen);
End;

Function    StrJR_(Str1: String;MaxLen: Integer):String;
Begin
  StrJR_ := ChrPadL_(Str1,' ',Maxlen);
End;

Procedure   StrLwr(Var Str1: String);Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   mov   ax,ds
   mov   es,ax
   mov   di,si
   lodsb
   inc   di
   xor   ch,ch
   mov   cl,al
   jcxz  @@02
@@01:
   lodsb
   push  ax
   push  cs
   call  near ptr LoCase
   stosb
   loop  @@01
@@02:
   pop   ds
End;

Function    StrLwr_(Str1: String):String;Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   les   di,@Result
   lodsb
   stosb
   xor   ch,ch
   mov   cl,al
   jcxz  @@02
@@01:
   lodsb
   push  ax
   push  cs
   call  near ptr LoCase
   stosb
   loop  @@01
@@02:
   pop   ds
End;

Procedure   StrUpr(Var Str1: String);Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   mov   ax,ds
   mov   es,ax
   mov   di,si
   lodsb
   inc   di
   xor   ch,ch
   mov   cl,al
   jcxz  @@02
@@01:
   lodsb
   push  ax
   push  cs
   call  near ptr UpCase
   stosb
   loop  @@01
@@02:
   pop   ds
End;


Function    StrUpr_(Str1: String): String;Assembler;
Asm
   push  ds
   cld
   lds   si,Str1
   les   di,@Result
   lodsb
   stosb
   xor   ch,ch
   mov   cl,al
   jcxz  @@02
@@01:
   lodsb
   push  ax
   push  cs
   call  near ptr UpCase
   stosb
   loop  @@01
@@02:
   pop   ds
End;

Procedure   StrMove(Var Str1: String;Str2: String);Assembler;
Asm
  push  ds
  xor   cx,cx
  lds   si,Str2
  mov   cl,[si]
  inc   cl
  les   di,Str1
  push  cs
  call  near ptr Fastmove
  pop   ds
End;

Procedure   StrOvr(Var Str1: String;Str2: String;Index: Integer);Assembler;
Asm
   push  ds
   les   di,Str1
   mov   bx,di
   mov   cx,Index
   jcxz  @@02
   cmp   cl,es:[di]
   ja    @@02
   mov   dx,cx
   add   di,cx
   lds   si,Str2
   mov   cl,[si]
   jcxz  @@02
   add   dx,cx
   sub   dl,es:[bx]
   cmp   dl,1
   jg    @@02
@@01:
   inc   si
   mov   dl,[si]
   mov   es:[di],dl
   inc   di
   loop  @@01
@@02:
   pop   ds
end;

Procedure   StrnOvr(Var Str1: String;Str2: String;Index,Count: Integer);Assembler;
Asm
   push  ds
   les   di,Str1
   mov   bx,di
   mov   cx,Index
   jcxz  @@02
   cmp   cl,es:[di]
   ja    @@02
   mov   dx,cx
   add   di,cx
   lds   si,Str2
   mov   cl,[si]
   jcxz  @@02
   add   dx,cx
   sub   dl,es:[bx]
   cmp   dl,1
   jg    @@02
   mov   bx,Count
   or    bx,bx
   jz    @@02
@@01:
   inc   si
   mov   dl,[si]
   mov   es:[di],dl
   inc   di
   dec   bl
   jz    @@02
   loop  @@01
@@02:
   pop   ds
end;

Function    StrOvr_(Str1: String;Str2: String;Index: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str1
   les   di,@Result
   mov   cl,[si]
   sub   ch,ch
   inc   cx
   push  cs
   call  near ptr Fastmove
   les   di,@Result
   mov   bx,di
   mov   cx,Index
   jcxz  @@02
   cmp   cl,es:[di]
   ja    @@02
   mov   dx,cx
   add   di,cx
   lds   si,Str2
   mov   cl,[si]
   jcxz  @@02
   add   dx,cx
   sub   dl,es:[bx]
   cmp   dl,1
   jg    @@02
@@01:
   inc   si
   mov   dl,[si]
   mov   es:[di],dl
   inc   di
   loop  @@01
@@02:
   pop   ds
End;

Function    StrnOvr_(Str1: String;Str2: String;Index,Count: Integer):String;Assembler;
Asm
   push  ds
   lds   si,Str1
   les   di,@Result
   mov   cl,[si]
   sub   ch,ch
   inc   cx
   push  cs
   call  near ptr Fastmove
   les   di,@Result
   mov   bx,di
   mov   cx,Index
   jcxz  @@02
   cmp   cl,es:[di]
   ja    @@02
   mov   dx,cx
   add   di,cx
   lds   si,Str2
   mov   cl,[si]
   jcxz  @@02
   add   dx,cx
   sub   dl,es:[bx]
   cmp   dl,1
   jg    @@02
   mov   bx,Count
   or    bx,bx
   jz    @@02
@@01:
   inc   si
   mov   dl,[si]
   mov   es:[di],dl
   inc   di
   dec   bl
   jz    @@02
   loop  @@01
@@02:
   pop   ds
End;

Procedure   StrPeek(Var Str1: String;Var Source;MaxLen: Byte);Assembler;
Asm
   push  ds
   lds   si,Source
   les   di,Str1
   xor   ch,ch
   mov   cl,MaxLen
   mov   Byte(es:[di]),cl
   inc   di
   push  cs
   call  near ptr FastMove
   pop   ds
end;

Procedure   StrPoke(Var Dest;Str2: String);Assembler;
Asm
   push  ds
   lds   si,Str2
   mov   cl,[si]
   inc   si
   les   di,Dest
   xor   ch,ch
   push  cs
   call  near ptr FastMove
   pop   ds
End;

Procedure   StrRev(Var Str1: String);Assembler;
Asm
   push  ds
   lds   si,Str1
   mov   di,si
   cld
   lodsb
   xor   ah,ah
   mov   cx,ax
   cmp   cx,1
   jle   @@02
   add   di,cx
   shr   cx,1
@@01:
   lodsb
   xchg  al,[di]
   mov   [si-1],al
   dec   di
   loop  @@01
@@02:
   pop   ds
end;

Function    StrRev_  (    Str1: String):String;Assembler;
Asm
   push  ds
   lds   si,Str1
   les   di,@Result
   cld
   lodsb
   stosb
   xor   ah,ah
   mov   cx,ax
   jcxz  @@02
   add   di,cx
   dec   di
@@01:
   lodsb
   mov   es:[di],al
   dec   di
   loop  @@01
@@02:
   pop   ds
end;

Procedure   StrRoll(Var Str1: String;Count: Integer);
Var
  Temp : String;
  I    : Integer;
Begin
  I := 0;
  if (Count > 0) Then
    I := Count
  Else
    if (Count < 0) Then
      I := Length(Str1) + Count;
  If (I <> 0) Then
    Begin
      Temp := Copy(Str1,Succ(I),Length(Str1) - I) + Copy(Str1,1,I);
      StrMove(Str1,Temp);
    End;
End;

Function    StrRoll_ (    Str1: String;Count: Integer):String;
Var
  Temp : String;
  I    : Integer;
Begin
  I := 0;
  if (Count > 0) Then
    I := Count
  Else
    if (Count < 0) Then
      I := Length(Str1) + Count;
  If (I <> 0) Then
    StrRoll_ := Copy(Str1,Succ(I),Length(Str1) - I) + Copy(Str1,1,I)
  Else
    StrRoll_ := Str1;
End;

Procedure   ATrim(Var Str1: String);Assembler;
asm
   les   di,Str1
   push  es
   push  di
   {$IFOPT G+}
     push   $20
   {$ELSE}
     mov   ax,$20
     push  ax
   {$ENDIF}
   push  cs
   call  near ptr ChrDel
end;

Function    ATrim_(Str1: String): String;Assembler;
asm
   push  ds
   lds   si,Str1
   mov   cl,[si]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   {$IFOPT G+}
     push   $20
   {$ELSE}
     mov   ax,$20
     push  ax
   {$ENDIF}
   push  cs
   call  near ptr ChrDel
   pop   ds
end;

Procedure   LTrim(Var Str1: String);Assembler;
asm
   les   di,Str1
   push  es
   push  di
   {$IFOPT G+}
     push   $20
   {$ELSE}
     mov   ax,$20
     push  ax
   {$ENDIF}
   push  cs
   call  near ptr ChrDelL
end;

Function    LTrim_(Str1: String): String;Assembler;
asm
   push  ds
   lds   si,Str1
   mov   cl,es:[di]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   {$IFOPT G+}
     push   $20
   {$ELSE}
     mov   ax,$20
     push  ax
   {$ENDIF}
   push  cs
   call  near ptr ChrDelL
   pop   ds
end;

Procedure   RTrim(Var Str1: String);Assembler;
asm
   les   di,Str1
   push  es
   push  di
   {$IFOPT G+}
     push   $20
   {$ELSE}
     mov   ax,$20
     push  ax
   {$ENDIF}
   push  cs
   call  near ptr ChrDelR
end;

Function    RTrim_(Str1: String): String;Assembler;
asm
   push  ds
   lds   si,Str1
   mov   cl,es:[di]
   xor   ch,ch
   inc   cx
   les   di,@Result
   push  cs
   call  near ptr FastMove
   les   di,@Result
   push  es
   push  di
   {$IFOPT G+}
     push   $20
   {$ELSE}
     mov   ax,$20
     push  ax
   {$ENDIF}
   push  cs
   call  near ptr ChrDelR
   pop   ds
end;

Function    Pos(Find,Str: String):integer;Assembler;
Asm
   cld
   push  ds
   xor   ax,ax
   les   di,Str
   lds   si,Find
   mov   al,es:[di]                    { Pos := Length(S)                  }
   inc   di
   mov   cx,ax
   jcxz  @@06                          { Length(S)    = 0                  }
   lodsb
   mov   dx,ax
   dec   dx
   js    @@02                          { Length(Find) = 0                  }
   lodsb
   jz    @@03
   sub   cx,dx                         { Length(S) < Length(Find)          }
   jbe   @@04
   mov   ah,cl
@@01:
   repne scasb
   jne   @@04
   mov   bx,cx
   mov   cx,dx
   rep   cmpsb
   xchg  bx,cx
   je    @@05
   jcxz  @@04
   sub   bx,dx
   add   si,bx
   add   di,bx
   jmp   @@01
@@02:
   inc   ax                            { Pos := 1                          }
   jmp   @@06
@@03:
   mov   ah,cl
   repne scasb
   je    @@05
@@04:
   mov   ah,cl
@@05:
   mov   al,ah
   sub   al,cl
   mov   ah,dh
@@06:
   pop   ds
end;

Procedure   Delete(Var Str: String;Index,Count: Integer);Assembler;
Asm
   push  ds
   lds   si,Str
   xor   ax,ax
   cwd
   cld
   lodsb
   mov   cx,ax
   mov   di,si
   mov   ax,Index
   dec   ax
   jns   @@01
   xchg  ax,dx
@@01:
   sub   cx,ax
   jle   @@03
   add   di,ax
   mov   bx,ax
   mov   ax,Count
   add   ax,dx
   jle   @@03
   sub   cx,ax
   jnle  @@02
   xor   cx,cx
@@02:
   add   bx,cx
   mov   byte([si-1]),bl
   jcxz  @@03
   mov   bx,ds
   mov   es,bx
   mov   si,di
   add   si,ax
   push  cs
   call  near ptr FastMove
@@03:
   pop   ds
end;

Function    Copy(Str1: String;Index,Count: Integer):string;Assembler;
Asm
   mov   dx,ds
   lds   si,Str1
   les   di,@Result
   cld
   lodsb
   xor   ah,ah
   mov   cx,ax
   mov   ax,Index
   dec   ax
   jnle  @@01
   xor   ax,ax
@@01:
   sub   cx,ax
   jle   @@03
   add   si,ax
   mov   ax,Count
   test  ax,ax
   jle   @@03
   cmp   ax,cx
   jnle  @@02
   xchg  ax,cx
@@02:
   mov   ax,cx
   stosb
   push  dx
   push  cs
   call  near ptr fastmove
   pop   dx
   jmp   @@04
@@03:
   xor   ax,ax
   stosb
@@04:
   mov   ds,dx
end;

Function    Left(Str1: String;Count: Integer): String;
Begin
  Left := Copy(Str1,1,Count);
End;

Function    Right(Str1: String;Count: Integer): String;Assembler;
Asm
   push  ds
   les   di,@Result
   lds   si,Str1
   cld
   lodsb
   mov   ah,0
   mov   cx,ax
   jcxz  @@02
   mov   bx,Count
   mov   ax,0
   or    bx,bx
   jle   @@02
   cmp   bx,cx
   jna   @@01
   mov   bx,cx
@@01:
   add   si,cx
   sub   si,bx
   mov   ax,bx
@@02:
   stosb
   mov   cx,ax
   push  cs
   call  near ptr fastmove
   pop   ds
End;

Function    Soundex(Str1: String): String;Assembler;
Asm
   push  ds
   cld
   les   di,@Result
   mov   al,4
   stosb
   mov   bx,di
   mov   ax,'00'
   mov   cx,2
   rep   stosw
   mov   di,bx
   lds   si,Str1
   lodsb
   mov   cl,al
   jcxz  @@03
   lodsb
   push  ax
   push  cs
   call  near ptr Upcase
   stosb
   dec   cx
   jcxz  @@03
   mov   ah,al
   mov   dx,$0401
   xor   bh,bh
@@01:
   lodsb
   mov   bl,al
   pop   ds
   mov   al,Byte([bx+SoudexTbl])
   push  ds
   or    al,al
   jz    @@02
   cmp   ah,al
   je    @@02
   stosb
   inc   dl
   cmp   dl,dh
   jae   @@03
   mov   ah,al
@@02:
   loop  @@01
@@03:
   pop   ds
end;

Function    Replicate(Fill: Char;MaxLen:Integer):string;
Var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ah]
  end;
  ChrFill(RStr^,Fill,MaxLen);
end;

Function    UpCase(C: Char):Char;Assembler;
Asm
    mov   al,C
    cmp   al,'a'
    jb    @@02
    cmp   al,''
    ja    @@02
    cmp   al,'z'
    ja    @@01
    sub   al,' '
    jmp   @@02
@@01:
    cmp   al,''
    jb    @@02
    sub   al,''
    mov   bx,offset UpCaseMap
    inc   bx
    xlat
@@02:
End;

Function    LoCase(C: Char):Char;Assembler;
Asm
    mov   al,C
    cmp   al,'A'
    jb    @@02
    cmp   al,''
    ja    @@02
    cmp   al,'Z'
    ja    @@01
    add   al,' '
    jmp   @@02
@@01:
    cmp   al,''
    jb    @@02
    sub   al,''
    mov   bx,offset LoCaseMap
    inc   bx
    xlat
@@02:
End;

Function    BtoH(B: Byte): String;Assembler;
Asm
    push   ds
    cld
    les    di,@Result
    mov    al,2
    stosb
    mov    si,offset Digits
    push   si
    mov    al,B
    xor    ah,ah
    push   ax
    mov    cl,4
    shr    al,cl
    add    si,ax
    movsb
    pop    ax
    pop    si
    and    ax,$0f
    add    si,ax
    movsb
    pop    ds
end;

Function    WtoH(W: Word): String;Assembler;
Asm
    push   ds
    cld
    les    di,@Result
    mov    al,4
    stosb
    mov    ax,W
    push   ax
    mov    si,offset Digits
    push   si
    xor    al,al
    push   ax
    mov    cl,4
    xchg   al,ah
    shr    al,cl
    add    si,ax
    movsb
    pop    ax
    pop    si
    push   si
    and    ah,$0f
    xchg   ah,al
    xor    ah,ah
    add    si,ax
    movsb
    pop    si
    pop    ax
    xor    ah,ah
    push   ax
    push   si
    mov    cl,4
    shr    al,cl
    add    si,ax
    movsb
    pop    si
    pop    ax
    and    al,$0f
    add    si,ax
    movsb
    pop    ds
end;

Function    LtoA(L: LongInt) : string;Assembler;
Asm
    push   ds
    cld
    les    di,@Result
    mov    al,8
    stosb
    mov    ax,Word(L+2)
    mov    dx,Word(L)
    mov    cx,2
@@01:
    push   cx
    push   ax
    mov    si,offset Digits
    push   si
    xor    al,al
    push   ax
    mov    cl,4
    xchg   al,ah
    shr    al,cl
    add    si,ax
    movsb
    pop    ax
    pop    si
    push   si
    and    ah,$0f
    xchg   ah,al
    xor    ah,ah
    add    si,ax
    movsb
    pop    si
    pop    ax
    xor    ah,ah
    push   ax
    push   si
    mov    cl,4
    shr    al,cl
    add    si,ax
    movsb
    pop    si
    pop    ax
    and    al,$0f
    add    si,ax
    movsb
    mov    ax,dx
    pop    cx
    loop   @@01
    pop    ds
end;

Function    PtoH(P : Pointer) : string;Assembler;
Asm
    les    di,@Result
    push   es
    push   di
    les    di,P
    push   es
    call   WtoH
    pop    di
    add    di,5
    push   di
    les    di,P
    push   di
    call   WtoH
    pop    es
    pop    di
    les    di,@Result
    mov    al,9
    stosb
    add    di,4
    mov    al,':'
    stosb
end;

Function    BtoB(B: Byte): String;Assembler;
Asm
    push   ds
    cld
    les    di,@Result
    mov    al,8
    stosb
    mov    bx,$0100
    mov    cx,8
    mov    dl,B
    xor    dh,dh
@@01:
    shr    bx,1
    test   dx,bx
    jz     @@02
    mov    al,'1'
    stosb
    loop   @@01
    jmp    @@03
@@02:
    mov    al,'0'
    stosb
    loop   @@01
@@03:
    pop    ds
end;

Function    WtoB(W: Word): string;Assembler;
Asm
    push   ds
    cld
    les    di,@Result
    mov    al,16
    stosb
    mov    bx,$8000
    mov    cx,16
    mov    dx,W
@@01:
    test   dx,bx
    pushf
    shr    bx,1
    popf
    jz     @@02
    mov    al,'1'
    stosb
    loop   @@01
    jmp    @@03
@@02:
    mov    al,'0'
    stosb
    loop   @@01
@@03:
    pop    ds
end;

Function    LtoB(L : LongInt) : string;
var
  I : LongInt;
  N : Byte;
begin
  N := 1;
  LtoB[0] := #32;
  for I := 31 downto 0 do
    begin
      LtoB[N] := Digits[Ord(L and LongInt(1 shl I) <> 0)];
      Inc(N);
    end;
end;

Function    BtoO(B: Byte): String;Assembler;
Asm
    std
    les    di,@Result
    mov    al,3
    stosb
    mov    si,offset Digits
    mov    cx,3
    mov    al,B
    xor    ah,ah
    add    di,cx
    inc    di
@@01:
    push   si
    push   ax
    and    al,7
    add    si,ax
    movsb
    pop    ax
    pop    si
    shr    ax,1
    shr    ax,1
    shr    ax,1
    loop   @@01
End;

Function    WtoO(W: Word): string;Assembler;
Asm
    std
    les    di,@Result
    mov    al,6
    stosb
    mov    si,offset Digits
    mov    cx,6
    mov    ax,W
    add    di,cx
    inc    di
@@01:
    push   si
    push   ax
    and    ax,7
    add    si,ax
    movsb
    pop    ax
    pop    si
    shr    ax,1
    shr    ax,1
    shr    ax,1
    loop   @@01
end;

Function    LtoO(L : LongInt) : string;Assembler;
Asm
    std
    les    di,@Result
    mov    al,12
    stosb
    mov    si,offset Digits
    mov    cx,12
    mov    ax,word(L)
    mov    dx,word(L+02)
    add    di,cx
    inc    di
@@01:
    push   si
    push   ax
    and    ax,7
    add    si,ax
    movsb
    pop    ax
    pop    si
    shr    dx,1
    rcr    ax,1
    shr    dx,1
    rcr    ax,1
    shr    dx,1
    rcr    ax,1
    loop   @@01
end;

Function    ValidInt(Str:string):boolean;
var
  Temp : longint;
  Code : integer;

  Function NoLetters:boolean;
  var 
    I   : integer;
    Bad : boolean;
  begin
    NoLetters := true;
    for I := 1 to Length(Str) do
      begin
{        if Not(IsDigit(Str[I])) then
          NoLetters := false;}
      end;
  end;

begin
  if length(Str) = 0 then
     ValidInt := true
  else
    begin
      val(Str,temp,code);
      ValidInt := (Code = 0) and Noletters;
    end;
end;

Function    ValidHInt(Str:string):boolean;
var
  Temp : longint;
  Code : integer;
begin
  if length(Str) = 0 then
    ValidHInt := true
  else
    begin
      val(Str,temp,code);
      ValidHInt := (Code = 0);
    end;
end;

Function    ValidReal(Str:string):boolean;
var
  Code : integer;
  Temp : Real;
begin
  if length(Str) = 0 then
    ValidReal := true
  else
    begin
      if Copy(Str,1,1)='.' Then
        Str:='0'+Str;
      if (Copy(Str,1,1)='-') and (Copy(Str,2,1)='.') Then
        Insert('0',Str,2);
      if Str[length(Str)] = '.' then
        Delete(Str,length(Str),1);
      val(Str,temp,code);
      ValidReal := (Code = 0);
    end;
end;

Function    AtoR(Str:string):Real;
var
  code : integer;
  Temp : Real;
begin
  if length(Str) = 0 then
    AtoR := 0
  else
    begin
      if Copy(Str,1,1)='.' Then
        Str:='0'+Str;
      if (Copy(Str,1,1)='-') and (Copy(Str,2,1)='.') Then
        Insert('0',Str,2);
      if Str[length(Str)] = '.' then
        Delete(Str,length(Str),1);
      val(Str,temp,code);
      if code = 0 then
        AtoR := temp
      else
        AtoR := 0;
    end;
end;

Function    AtoL(Str: string): Longint;
var
  code : integer;
  Temp : longint;
begin
  if length(Str) = 0 then
    AtoL := 0
  else
    begin
      val(Str,temp,code);
      if code = 0 then
        AtoL := temp
      else
        AtoL := 0;
    end;
end;

Function    HtoL(Str: string):longint;
begin
  if Str = '' then
    HtoL := 0
  else
    begin
      if Str[1] <> '$' then
        Str := '$'+Str;
      HtoL := AtoL(Str);
    end;
end;

Function    WrdQty(Str1: String): Byte;Assembler;
Asm
   xor   cx,cx
   mov   dx,cx
   les   di,Str1
   mov   cl,es:[di]
   jcxz  @@02
   mov   al,' '
   inc   di
   cld
@@01:
   rep   scasb
   je    @@02
   inc   dx
   repne scasb
   je    @@01
@@02:
   mov   ax,dx
end;

Function    AtoH(Str: String): Integer;Assembler;
Asm
  mov   dx,ds
  xor   bx,bx
  mov   ax,bx
  mov   cx,ax
  cld
  lds   si,Str
  lodsb
  or    al,al
  je    @@05
  cmp   al,5
  ja    @@05
  mov   cl,al
@@01:
  lodsb
  cmp   al,'$'
  je    @@01
  cmp   al,'a'
  jb    @@02
  and   al,$5f
@@02:
  xor   al,'0'
  cmp   al,10
  jb    @@03
  add   al,$89
  cmp   al,$fa
  jb    @@05
  and   al,$0f
@@03:
  shl   bx,1
  jc    @@04
  shl   bx,1
  jc    @@04
  shl   bx,1
  jc    @@04
  shl   bx,1
  jc    @@04
  or    bl,al
  loop  @@01
  jmp   @@05
@@04:
  xor   bx,bx
@@05:
  mov   ax,bx
  mov   ds,dx
end;

Function    AtoLh(Str: String): LongInt;Assembler;
Asm
  push  ds
  xor   bx,bx
  mov   dx,bx
  mov   cx,dx
  cld
  lds   si,Str
  lodsb
  or    al,al
  je    @@05
  cmp   al,9
  ja    @@05
  mov   cl,al
@@01:
  lodsb
  cmp   al,'$'
  je    @@01
  cmp   al,'a'
  jb    @@02
  and   al,$5f
@@02:
  xor   al,'0'
  cmp   al,10
  jb    @@03
  add   al,$89
  cmp   al,$fa
  jb    @@05
  and   al,$0f
@@03:
  shl   bx,1
  rcl   dx,1
  jc    @@04
  shl   bx,1
  rcl   dx,1
  jc    @@04
  shl   bx,1
  rcl   dx,1
  jc    @@04
  shl   bx,1
  rcl   dx,1
  jc    @@04
  or    bl,al
  loop  @@01
  jmp   @@05
@@04:
  xor   bx,bx
  mov   dx,bx
@@05:
  mov   ax,bx
  pop   ds
end;

end.
