{$S-,R-,V-,I-,B-,F-}
{$M 4096,4096,100000}

{$IFDEF Debug}
  {$D+}
{$ENDIF}

{$I TPDEFINE.INC}

{*********************************************************}
{*                   MAKEPMNU.PAS 5.05                   *}
{*                Pull-down Menu compiler                *}
{*            An example program for TPPDMENU            *}
{*           Copyright (c) Ken Henderson, 1989.          *}
{*                                                       *}
{*                                                       *}
{*                 All rights reserved.                  *}
{*********************************************************}

program MAKEPMNU;
  {-Compiles .MSC files to .MNU pull-down menu files for TPPDMENU}

uses
  Dos,                       {standard DOS/BIOS routines}
  TpCrt,                     {Turbo Professional TpCrt unit}
  TpString;                  {Turbo Professional string handling routines}

var
 menusource:text;
 outstr,src,obj,inname,outname,menuline:string;
 menuobject:file;
 closing,ch : char;
 chbyte : byte absolute ch;
 outbuff : array[1..maxint] of byte;
 outstring : array[1..255] of byte;
 outstringoffset,p,numbers,res,counter,outoffset,byteswritten,outnum : integer;
 lensrc : byte absolute menuline;    {Length of the line as it's read in}
 FirstOfLine : boolean;

const
  {screen messages}
  ProgName : string[45] = 'MAKEPMNU: Menu compiler for TPPDMENU';
  Copyright : string[41] = 'Copyright (c) 1989 by Ken Henderson';
  SrcExt : string[3] = 'MSC';
  MenExt : string[3] = 'MNU';

label
  nextline;

procedure Halterror(msg:string);
begin
  writeln('Error - ',msg);
  Close(menuobject);
  Close(menusource);
  halt(1);
end;

procedure HelpExit(exitcode:integer);
begin
  Writeln('   menusrc        menu source file to compile   ');
  Writeln('   /Smenusrc      menu source file to compile   ');
  Writeln('   /?             this message                  ');
  Halt(exitcode);
end;

begin
  Writeln(ProgName);
  Writeln(Copyright);
  if paramcount=0 then HelpExit(1);
  Src:=StUpcase(paramstr(1));
  if Src[2]='?' then HelpExit(0);
  if Src[1]='/' then Src:=copy(Src,3,length(Src)-2);
  Src:=DefaultExtension(Src,SrcExt);
  Obj :=ForceExtension(Src,MenExt);

  Assign(menusource,Src);
  if ioresult<>0 then HaltError('No available file handles');
  Reset(menusource);
  if ioresult<>0 then HaltError('Could not open menu source file');
  Assign(menuobject,obj);
  if ioresult<>0 then HaltError('No available file handles');
  Rewrite(menuobject,1);
  if ioresult<>0 then HaltError('Could not open menu object file');

  outoffset := 1;
  while not eof(menusource) do
  begin
    readln(menusource,menuline);
    FirstofLine:=true;       {We are reading a command number, most likely}
    menuline:=trim(menuline);
    if (menuline='') or (menuline[1]='*') then goto nextline;
    counter:=1;
    while counter<=lensrc do
    begin
      ch:=menuline[counter];
      case ch of
      '0'..'9' : begin
                   outstr:='';
                   while (ch in ['0'..'9']) and (counter<=lensrc) do  {get all digits}
                   begin
                     if (length(outstr)=3) then HaltError('Numbers cannot have more than three digits');
                     outstr:=outstr+ch;
                     inc(counter);
                     ch:=menuline[counter];
                   end;
                   Val(outstr,outnum,res);  {move to an integer}
                   if (FirstOfLine) and (menuline[length(menuline)] in [#34,#39]) then    {command order word}
                   begin
                     outbuff[outoffset]:=hi(outnum);
                     inc(outoffset);
                     outbuff[outoffset]:=Lo(outnum);
                     FirstOfLine:=false;
                   end else outbuff[outoffset]:=byte(outnum);
                   inc(outoffset);
                  end;
       #34, #39 : begin
                    closing:=ch;
                    inc(counter);
                    ch:=menuline[counter];
                    outstringoffset:=1;
                    while (ch<>closing) and (counter<=lensrc)  do
                    begin
                      outstring[outstringoffset]:=chbyte;
                      inc(outstringoffset);
                      inc(counter);
                      ch:=menuline[counter];
                    end;
                    if ch<>closing then HaltError('Unterminated string');
                    Dec(outstringoffset);
                    outbuff[outoffset]:=byte(outstringoffset);
                    Inc(outoffset);
                    Move(outstring[1],outbuff[outoffset],outstringoffset);
                    Inc(outoffset,outstringoffset);
                    inc(counter);       {get passed closing}
                  end;
      end;
      inc(counter);
    end;
    nextline:
  end;

  if outbuff[pred(outoffset)]<>byte(#255) then HaltError('Menu source files must end with byte 255');
  blockwrite(menuobject,outbuff,pred(outoffset),byteswritten);
  if (ioresult<>0) or (byteswritten<>pred(outoffset)) then HaltError('Could not write menu object file');
  Close(menuobject);
  Close(menusource);
end.






