program TpLdir;
  {-Program to emulate a TpDir that selects several filenames }

uses
  TpCrt,                          {Crt interface, standard unit}
  Dos,                            {Dos interface, standard unit}
  TpPick;                         {Turbo Professional pick list manager}

type
  Filepath                 = String[12]; {Type of returned filenames}
  String13                 = String[13]; {Type of selected filenames (allows for #17)}

const
  PMonoAttr                : PickColorArray = {Monochrome pick colors}
  (
    $07,
    $0F,
    $0F,
    $70,
    $0F,
    $07
    );

  PColorAttr               : PickColorArray = {Color pick colors}
  (
    $70,
    $78,
    $78,
    $0F,
    $71,
    $1F
    );
  MaxFiles                 = 250; {Max file names}

var
  FileStr                  : Filepath; {Entered filemask}
  FileArr, ChosenArr       : array[1..MaxFiles] of Filepath; {File and select array}
  PickColorArr             : PickColorArray; {Pick colors}
  FileInfo                 : SearchRec; {For Find First/Next}
  FileIndex,
  SelectedFile,
  ChosenFileIndex,                {Index variables}
  ChosenIndex              : Word;

  {$F+}
  function SendFileName(FileIndex : Word) : String13; {Return selected files}
  begin
    for ChosenIndex := 1 to MaxFiles do
      if (FileArr[FileIndex] = ChosenArr[ChosenIndex]) then
      begin
        AltPickAttr := True;
        SendFileName := FileArr[FileIndex]+#17;
        Exit;
      end;
    SendFileName := FileArr[FileIndex];
  end;
  {$F-}

  procedure HaltError(msg : String); {Get out with an error}
  begin
    WriteLn(msg);
    Halt(1);
  end;

begin
  TpWindow.Explode := False;      {No explode 'um}

  if WhichHerc = HercInColor then PickColorArr := PColorAttr
  else
    case CurrentMode of
      2, 7 : PickColorArr := PMonoAttr;
    else
     PickColorArr := PColorAttr;
    end;

  for ChosenIndex := 1 to MaxFiles do
    ChosenArr[ChosenIndex][0] := #0;

  FileStr[0] := #0;
  WriteLn('Enter a filemask to select from '); ReadLn(FileStr);
  if Pos('*', FileStr)+Pos('?', FileStr) <> 0 then
  begin
    FileIndex := 0;
    FindFirst(FileStr, Archive, FileInfo);
    while DosError = 0 do
    begin
      Inc(FileIndex);
      FileArr[FileIndex] := FileInfo.name;
      FindNext(FileInfo);
    end;
    if FileIndex > 0 then
    begin
      SelectedFile := 1;
      ChosenFileIndex := 0;
      PickMatrix := 5;
      if not AddPickCommand(PKSUser0, 1, 32, 0) then
        HaltError('Error setting up command table');
      repeat
        if not PickWindow(@SendFileName, FileIndex, 1, 1, 78, 24,
                          True, PickColorArr, FileStr, SelectedFile) then
          HaltError('Error initializing pick list');
        if PickCmdNum = PKSUser0 then
        begin
          Inc(ChosenFileIndex);
          ChosenArr[ChosenFileIndex] := FileArr[SelectedFile];
        end;
      until (PickCmdNum = PKSExit) or (PickCmdNum = PKSSelect);
      WriteLn('The files you chose were:');
      for ChosenIndex := 1 to ChosenFileIndex do WriteLn(ChosenArr[ChosenIndex]);
    end;
  end;
end.
