Program WatchDem;
Uses WatchMgr;

CONST RecName: RECORD
        Component1: STRING[20];
        Component2: LongInt;
      END  =  (
        Component1: 'hello world';
        Component2: 12345678
      );

VAR n:WORD;

BEGIN

 {- Use ClrWatch to reset after a partial program trace -}
  ClrWatch;

 {- Set some watches -}
  AddWatch('WatchDem.RecName.Component1');  {- fully qualified -}
  AddWatch('RecName.Component2');
  Inc(RecName.Component2);

 {- Established watches may be inspected under program control -}
  FOR n:=1 TO WatchCount do Writeln(n:3,' [',WatchStr(n),']');

 {- DelWatch requires a precise watch string specification -}
 {- The following will not delete WatchDem.RecName.Component1 -}
  DelWatch('RecName.Component1');

 {- However case and leading/trailing spaces are not significant -}
 {- The following WILL delete WatchDem.RecName.Component1 -}
  DelWatch('   wATCHdEM.recname.COMPONENT1    ');

 {- Clear all watches -}
  ClrWatch;

 {- you can use AddWatch to display messages under program control -}
  AddWatch(WatchMgr.Copyright);
  ClrWatch;

 {- Display the number of command line parameters -}
  n := ParamCount;
  AddWatch('      n      ');

 {- Like "Break/Add watch", leading and trailing spaces are ignored -}
 {- There are presently no command line parameters -}

 {- Watch an area of memory in the Program Segment Prefix -}
  AddWatch('Mem[PrefixSeg:$80],27sm');

 {- Watch as a command line is patched in -}
  String(Ptr(PrefixSeg,$80)^) := 'Watch Manager Version 1.0'#13;
  Dec(Mem[PrefixSeg:$80]);  {- length should exclude trailing #13 -}


 {- Recheck the number of command line parameters -}
  n := ParamCount;
  WRITELN('Patched Command Line Parameter: ',ParamStr(1));


 {- The watch routines may be nested in a natural fashion -}
 {- The following will delete the most recently defined watch -}
  DelWatch(WatchStr(WatchCount));

END.
