unit textseek;

{Text Seek provides some of the advantages of a file-of-characters for}
{text files.  By Tom Cantlon.}

{This is revision 2 of textseek. It fixes a bug related to how Eof works.}
{The change is one line at line 103 in this file. 85 previous down loads.}


interface

uses dos;

procedure tseek(var f:text; n:longint);

{The equivelant of seek}


procedure backupln(var f:text; n:word);

{Backs up the pointer in a text file n lines.  Backup 1 would cause the line}
{last read to be read again.  It is not an error to back up to many times.  }
{The pointer will simply remain at the beginning of the file.}


function bof(var f:text):boolean;

{The equivelant of eof but tests for the beginning of a file.  Usefull when}
{in a loop using backupln.}


function tfilepos(var f:text):longint;

{The equivelant of filepos.}


implementation

var reg:registers;
    c:char;
    temp:word;
    bofile:boolean;
    fileposition:longint;
    loop:byte;
    templong:longint;

type wordrec = record low,high:word; end;

const CR = #$0D;


function actualfilepos(var f:text):longint;
begin
with reg do begin
  ah := $42;
  al := 1;
  bx := textrec(f).handle;
  cx := 0;
  dx := 0;
  msdos(reg);
  wordrec(templong).high := dx;
  wordrec(templong).low := ax;
  end;  {with}
actualfilepos := templong;
end; {proc}


procedure backupln;
begin
bofile := false;
if eof(f) then loop := 1 else loop := 0;
with textrec(f) do begin
  repeat  {n times}
    repeat  {find CR twice}
      inc(loop);
      repeat  {find CR}
        if bufpos > 0 then dec(bufpos)
        else begin
          bofile := bof(f);
          if not bofile then begin
            fileposition := actualfilepos(f);
            if fileposition >= bufsize + bufend
                               then tseek(f,fileposition - (bufsize + bufend))
            else begin
              temp := fileposition - bufend;
              tseek(f,0);
              bufend := temp;
              with reg do begin
                ah := $42;
                al := 0;
                bx := handle;
                cx := 0;
                dx := bufend;
                msdos(reg);
                end;  {with}
              end;  {else}
            bufpos := bufend - 1;
            end;  {if not bof}
          end;  {else}
        until (buffer[bufpos] = CR) or bofile;
      if not bofile and (loop = 2) then begin
        readln(f);                             {step past CR/LF}
        if eof(f) then loop := 0;              {take care of eof quirk}
        end;
      until (loop = 2) or bofile;
    dec(n);
    loop := 0;
    until (n = 0) or bofile;
  end;  {with}
end;  {proc}


procedure tseek;
begin
with reg do begin
  ah := $42;
  al := 0;
  bx := textrec(f).handle;
  cx := wordrec(n).high;
  dx := wordrec(n).low;
  msdos(reg);
  end;  {with}
textrec(f).bufpos := textrec(f).bufend;
read(f,c);
textrec(f).bufpos := 0;
end; {proc}


function bof;
begin
with reg do begin
  ah := $42;
  al := 1;
  bx := textrec(f).handle;
  cx := 0;
  dx := 0;
  msdos(reg);
  bof := ((ax <= textrec(f).bufsize) and (dx = 0)) and (textrec(f).bufpos = 0);
  end;  {with}
end;  {proc}


function tfilepos;
begin
tfilepos := actualfilepos(f) - textrec(f).bufsize + textrec(f).bufpos;
end;
end.  {unit}