   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

   EditorDialog

   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
   {===================================================================

   SEARCH - created with DLGDSN

   ===================================================================}
function CreateFindDialog : PDialog ;
{$IFDEF code} {$I find.src } {$ENDIF}
begin
{$IFDEF code}
   CreateFindDialog          := MakeDialog ;
{$ELSE}
   CreateFindDialog          := PDIALOG ( RezFile^.Get ( 'DIALOG_FIND' ) ) ;
{$ENDIF}
end ;
   {===================================================================

   REPLACE - created with DLGDSN

   ===================================================================}
function CreateReplaceDialog : PDialog ;
{$IFDEF code} {$I replace.src } {$ENDIF}
begin
{$IFDEF code}
   CreateReplaceDialog       := MakeDialog ;
{$ELSE}
   CreateReplaceDialog       := PDIALOG ( RezFile^.Get ( 'DIALOG_REPLACE' ) ) ;
{$ENDIF}
end ;
   {===================================================================

   Add SEARCH & REPLACE

   ===================================================================}
   {===================================================================

   EXECUTE

   ===================================================================}
function EditorDialog ( Dialog : Integer ;
                        Info : Pointer ) : word ;
var
   R                         : TRect ;
   T                         : TPoint ;
begin
   case Dialog of
   edOutOfMemory :
      EditorDialog           := MessageBox ( ^C'Not enough memory for this operation.' ,
                                             NIL ,
                                             mfError + mfOkButton ) ;
   edReadError :
      EditorDialog           := MessageBox ( ^C'Error reading file %s.' ,
                                             @Info ,
                                             mfError + mfOkButton ) ;
   edWriteError :
      EditorDialog           := MessageBox ( ^C'Error writing file %s.' ,
                                             @Info ,
                                             mfError + mfOkButton ) ;
   edCreateError :
      EditorDialog           := MessageBox ( ^C'Error creating file %s.' ,
                                             @Info ,
                                             mfError + mfOkButton ) ;
   edSaveModify :
      EditorDialog           := MessageBox ( ^C'%s has been modified. Save?' ,
                                             @Info ,
                                             mfInformation + mfYesNoCancel ) ;
   edSaveUntitled :
      EditorDialog           := MessageBox ( ^C'Save untitled file?' ,
                                             NIL ,
                                             mfInformation + mfYesNoCancel ) ;
   edSaveAs :
      EditorDialog           := ExecDialog ( New ( PFileDialog , Init ( '*.*' ,
                                             'Save file as' ,
                                             '~N~ame' ,
                                             fdOkButton ,
                                             101 ) ) , Info ) ;
   edFind :
      EditorDialog           := ExecDialog ( CreateFindDialog , Info ) ;
   edSearchFailed:
      EditorDialog           := MessageBox ( ^C'Search string not found.' ,
                                             NIL ,
                                             mfError + mfOkButton ) ;
   edReplace :
      EditorDialog           := ExecDialog ( CreateReplaceDialog , Info ) ;
   edReplacePrompt :
      begin
   {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   Avoid placing the dialog on the same line as the cursor
   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}
         R.Assign ( 0 , 1 , 40 , 8 ) ;
         R.Move ( ( Desktop^.Size.X - R.B.X ) div 2 , 0 ) ;
         Desktop^.MakeGlobal ( R.B , T ) ;
         Inc ( T.Y ) ;
         if TPoint(Info).Y <= T.Y then
            R.Move ( 0 , Desktop^.Size.Y - R.B.Y - 2 ) ;
         EditorDialog        := MessageBoxRect ( R ,
                                                 ^C'Replace this occurence?' ,
                                                 NIL ,
                                                 mfYesNoCancel
                                                 + mfInformation ) ;
      end ;
   else
      MessageBox ( ^C'Unknown DIALOG requested!' ,
                   NIL ,
                   mfError + mfOkButton ) ;
   end ;
end ;
