(*****************************************************************************)
(*  SysTimer.PAS                                                             *)
(*  08/06/94                                                                 *)
(*  Brad Stowers                                                             *)
(*       CIS:      72733,3374                                                *)
(*       Internet: brad.stowers@delta.com                                    *)
(*  This code is released to the public domain.  Use at your own risk!       *)
(*  No support or guarantees are made or implied.  If you have problems      *)
(*  feel free to contact me at one of the above addresses and I will help    *)
(*  all I can.  If you make improvements, PLEASE share them on BPASCAL.      *)
(*  This code was inspired by an article on the same topic in the            *)
(*  Windows/DOS Developers Journal, Novemeber 1993, by Mark Szamrej.  It is  *)
(*  not as "all-encompassing" as what is provided in that article, simply    *)
(*  because I didn't need all that.                                          *)
(*****************************************************************************)
(*  Provides an object that allows for easy manipulation of high resolution  *)
(*  timers that are available through MMSYSTEM.  By themselves, they are not *)
(*  so easy to use because of the need for a Callback function in a DLL.     *)
(*  This unit, along with the included DLL, wraps everything up in a tidy    *)
(*  object.  If you find that the application's message queue is being       *)
(*  over-run with WM_SYSTEMTIMER messages, you will want to consider using   *)
(*  just the callback function for all your processing.  I try to keep the   *)
(*  actually processing that occurs to an absolute minimum, and much prefer  *)
(*  the messaging method.  See the MMTIMER.PAS file for further info.        *)
(*****************************************************************************)
unit SysTimer;

interface

uses MMSystem, OWindows, WinTypes, WinProcs, Objects;

const
  wm_SystemTimer = wm_User + 384;

type
  PTimeCallBack = ^TTimeCallBack;  { Declared in MMSYSTEM.  We need a pointer flavor }

  pSystemTimer = ^tSystemTimer;
  tSystemTimer = object(tObject)
    ID       : Integer;

    constructor Init(AWnd: HWnd; ADelay, AResolution: word; OnlyOnce: boolean);
    destructor  Done; virtual;
    procedure   Reset(AWnd: HWnd; ADelay, AResolution: word; OnlyOnce: boolean);
    procedure   Kill;
  private
    ParentWnd : hWnd;
    function    MakeTimer(ADelay, AResolution: word; OneShot: boolean): word;
  end;

implementation

uses mmTimer;


constructor tSystemTimer.Init(AWnd: HWnd; ADelay, AResolution: word; OnlyOnce: boolean);
begin
  inherited Init;
  ID := 0;
  ParentWnd := AWnd;
  ID := MakeTimer(ADelay, AResolution, OnlyOnce);
  { Timer will not be created if ADelay or AResolution is to small (or to great). }
  { It can be checked with timeGetDevCaps in MMSYSTEM.  I generally don't care    }
  { why it failed, only that it failed, so this is enough for me.                 }
  if ID = 0 then fail;
end;

destructor tSystemTimer.Done;
begin
  Kill;
  inherited Done;
end;

procedure tSystemTimer.Reset(AWnd: HWnd; ADelay, AResolution: word; OnlyOnce: boolean);
begin
  Kill;
  ParentWnd := AWnd;
  ID := MakeTimer(ADelay, AResolution, OnlyOnce);
end;

procedure tSystemTimer.Kill;
begin
  if ID <> 0 then
    timeKillEvent(ID);
  ID := 0;
end;

function tSystemTimer.MakeTimer(ADelay, AResolution: word; OneShot: boolean): word;
begin
  MakeTimer := SystemTimerMake(ParentWnd, ADelay, AResolution, OneShot);
end;

end.
