(*****************************************************************************)
(*  mmTimer.PAS                                                              *)
(*  08/06/94                                                                 *)
(*  Brad Stowers                                                             *)
(*       CIS:      72733,3374                                                *)
(*       Internet: brad.stowers@delta.com                                    *)
(*  This code is released to the public domain.  Use at your own risk!       *)
(*  No support or guarantees are made or implied.  If you have problems      *)
(*  feel free to contact me at one of the above addresses and I will help    *)
(*  all I can.  If you make improvements, PLEASE share them on BPASCAL.      *)
(*****************************************************************************)
(*  Provides a function that creates high resolution timers provided in      *)
(*  MMSYSTEM.  These timers require a callback function that is in a FIXED   *)
(*  memory location (see the $C directive below).  This file contains both   *)
(*  the library code for the DLL and the import unit.  Compile this file     *)
(*  twice, first with the MAKEDLL defined and again without it.  This will   *)
(*  create both the MMTIMER.DLL and MMTIMER.TPW file.                        *)
(*****************************************************************************)

{$DEFINE MAKEDLL}

{$IFDEF MAKEDLL} { Compile the DLL library code }

{$C FIXED DEMANDLOAD DISCARDABLE}
library mmTimer;
{$D Provides High Resolution Timer Services. }

uses WinTypes, WinProcs, MMSystem;

const
  wm_SystemTimer = wm_User + 384;

{ You may want to do all processing here rather than posting a message.  If you do, and   }
{ you will be accessing data other than the parameters passed to the procedure, that data }
{ MUST be in a fixed data segment.  Also, because this is called during interrupts, it is }
{ very limited (and is why it must be FIXED).  There are only a few API calls that are    }
{ allowed, so read the "timeSetEvent" section of the MMSYSTEM.HLP file before adding your }
{ own code here.                                                                          }
procedure SystemTimerCallBack(uTimerID, uMessage: Word; dwUser, dw1, dw2: Longint); export;
begin
  PostMessage(LoWord(dwUser), wm_SystemTimer, uTimerID, LongInt(@SystemTimerCallBack));
end;

function SystemTimerMake(ParentWnd: hWnd; ADelay, AResolution: word; OneShot: boolean): word; export;
begin
  if OneShot then
    SystemTimerMake := timeSetEvent(ADelay, AResolution, SystemTimerCallBack,
                                    MakeLong(ParentWnd, word(OneShot)), TIME_ONESHOT)
  else
    SystemTimerMake := timeSetEvent(ADelay, AResolution, SystemTimerCallBack,
                                    MakeLong(ParentWnd, word(OneShot)), TIME_PERIODIC);
end;

exports
  SystemTimerMake     index 1;


{$ELSE} { Compile the import unit code. }
unit mmTimer;

interface

uses WinTypes;

function SystemTimerMake(ParentWnd: hWnd; ADelay, AResolution: word; OneShot: boolean): word;

implementation

function SystemTimerMake; external 'MMTIMER' index 1;

{$ENDIF}

begin
end.
