/* ķ */
/*  SOUND WIZARDS MODULE PLAYER V1.3 BY LORD EXCESS  */
/* Ľ */

#include <stdlib.h>

#define Detection         0
#define SoundBlaster      1
#define SoundBlaster_Pro  2
#define Gravis_UltraSound 3

unsigned int Soundcard, Channels;
void *Mod_Driver;
unsigned char Peak[8];

extern void far Detect_Hardware(void);
extern void far Driver_SB(void);
extern void far Driver_SBP(void);
extern void far Driver_GUS(void);

void Mod_Close(void)
{
 asm {
  mov     bx,1
  call    DWORD PTR [Mod_Driver]
 }
}

void Mod_Init(unsigned int Driver, unsigned int Port, unsigned char IRQ, unsigned char DMA)
{
 asm {
  mov     ax,[Driver]
  or      ax,ax
  jz      l_1
  cmp     ax,Gravis_UltraSound
  ja      l_Error
  mov     cl,BYTE PTR [IRQ]
  mov     ch,BYTE PTR [DMA]
  mov     dx,[Port]
  jmp     l_2
 }
l_1:
  Detect_Hardware();
 asm {
  or      ax,ax
  jz      l_Error
  cmp     ax,Gravis_UltraSound
  ja      l_Error
 }
l_2:
 asm {
  mov     [Soundcard],ax
  mov     WORD PTR [Mod_Driver],0
  cmp     ax,SoundBlaster
  jnz     l_3
  mov     WORD PTR [Mod_Driver+2],SEG Driver_SB
  jmp     l_Test
 }
l_3:
 asm {
  cmp     ax,SoundBlaster_Pro
  jnz     l_4
  mov     WORD PTR [Mod_Driver+2],SEG Driver_SBP
  jmp     l_Test
 }
l_4:
 asm {
  mov     WORD PTR [Mod_Driver+2],SEG Driver_GUS
 }
l_Test:
 asm {
  xor     bx,bx
  call    DWORD PTR [Mod_Driver]
  or      ax,ax
  jz      l_Error
 }
 if (atexit(Mod_Close)) {
  Mod_Close();
l_Error:
  asm {
   mov     [Soundcard],0
  }
 }
}

void Mod_Load(char *File_Name)
{
 if (Soundcard) asm {
  mov     bx,2
  mov     dx,[File_Name]
  call    DWORD PTR [Mod_Driver]
  mov     [Channels],ax
 }
 else Channels=0;
}

void Mod_Play(unsigned int Looping)
{
 if (Soundcard) asm {
  mov     bx,3
  mov     ax,[Looping]
  call    DWORD PTR [Mod_Driver]
 }
}

void Mod_Stop(void)
{
 if (Soundcard) asm {
  mov     bx,4
  call    DWORD PTR [Mod_Driver]
 }
}

void Mod_Volume(unsigned char Volume)
{
 if (Soundcard) asm {
  mov     bx,5
  mov     al,[Volume]
  call    DWORD PTR [Mod_Driver]
 }
}

unsigned int Mod_Status(void)
{
 if (Soundcard) {
  asm {
   mov     bx,6
   call    DWORD PTR [Mod_Driver]
  }
  return(_AX);
 }
 else return(0);
}

unsigned int Mod_Position(void)
{
 if (Soundcard) {
  asm {
   mov     bx,7
   xor     al,al
   call    DWORD PTR [Mod_Driver]
  }
  return(_AX);
 }
 else return(0);
}

void Mod_Rewind(void)
{
 if (Soundcard) asm {
  mov     bx,7
  mov     al,-1
  call    DWORD PTR [Mod_Driver]
 }
}

void Mod_Forward(void)
{
 if (Soundcard) asm {
  mov     bx,7
  mov     al,1
  call    DWORD PTR [Mod_Driver]
 }
}

void Mod_Peak(void)
{
 asm {
  push    es
  mov     ax,ds
  mov     es,ax
  mov     di,OFFSET Peak
 }
 if (Soundcard) asm {
  mov     bx,8
  call    DWORD PTR [Mod_Driver]
 }
 else asm {
  cld
  mov     cx,4
  xor     ax,ax
  rep     stosw
 }
  asm pop    es;
}
