{**************************************************************************}
{*                    SoftWeyr LAN library. Version 1.3                   *}
{*                               PrStop.PAS                               *}
{*                    Demo program for SoftWeyr LANLIB                    *}
{*                   for Turbo Pascal (tm) 6.0 or higher                  *}
{*                     Copyright (c) by SoftWeyr,1994                     *}
{**************************************************************************}
uses Dos,NetCall;
var I,Typ:Integer;
    Machine,Name,Path,Server:String;
    Valid:Boolean;
    QEntry:TQueueEntry;
    HaveQPriv:Boolean;
    Const Port:String='LPT1';
Procedure Help;
begin
Writeln(
'This program halts printind on network printer, assigned to LPT1, or to port'#13#10,
'specified in command line'#13#10,
'If you have  SuperQueue (Q) privelege, even "Cancelled" message wouldn''t'#13#10,
'be printed');
 halt(124);
end;

begin
 {Restore standard dos critical error handler}
 SetIntVec($24,SaveInt24);
 {Check command line }
 if ParamCount<>0 then
  begin
   Name:=ParamStr(1);
   for i:=1 to length(Name) do Name[i]:=Upcase(Name[i]);
   if (Name='/?') or (Name[1]='H')  or (Name[1]='?') or
    (copy(Name,1,2)='/H') then Help;
   if Name='AUX' then Port:='COM1' else
    if (Copy(Name,1,3)='LPT')or(Copy(Name,1,3)='COM') then Port:=Name
    else
     if Name<>'PRN' then
     begin
      Writeln('Invalid printer port');
      Help
     end;
   end;
  {Search for remote device name }
  i:=0;
  Repeat
   GetDevice(I,Name,Path,Typ,Valid);
   inc(i);
   if Name='PRN' then Name:='LPT1' else
    if Name='AUX' then Name:='COM1';
  Until (DosError<>0)or(Name=Port);
  {handle possible errors}
  if DosError<>0 then
   begin
    if DosError=18 then Writeln('Port ',PORT,' is not redirected')
    else
    Writeln(GetError(DosError));
    Halt(DosError);
   end;
  if not Valid then
   begin
    Writeln('Port ',Port,' redirection is invalid');
    Halt(127);
   end;
  {Show information- (really we call  GetDeviceDescr to obtain access rights,
  but why keep something, which we know}
  Writeln('Port ',Port,' is redirected to ',GetDeviceDescr(Path));
  Writeln('Network path:',Path);
  {extract server's name }
  i:=3;
  While Path[i]<>'\' do inc(i);
  Server:=Copy(Path,1,i-1);
  Name:=Copy(Path,i+1,255);
  Machine:=GetMachineName;
 if GetPrivilege(Server) and priv_SuperQueue<>0 then
  begin
   Writeln('You have  SuperQueue privilege on server ',Server);
  { halt printing}
 ControlQueue(Server,0,CQ_Halt);
 HaveQPriv:=True;
 end
 else HaveQPriv:=False;
  {search current job}
  i:=0;
  Repeat
   GetQueueEntry(I,Server,QEntry);
  until (DosError<>0)or(QEntry.Machine=Machine)and(QEntry.Destignation=Name);
  if DosError=18 then
    Writeln('You have no jobs on this printer')
   else
  if DosError<>0 then
    Writeln(GetError(DosError)) else
    begin
     ControlQueue(Server,QEntry.Sequence,CQ_cancel);
     Writeln('Job No ',QEntry.Sequence,' is interruptted');
    end;

  if HaveQPriv then
   begin
   {If we have halted printer }
   {restore despooling}
   ControlQueue(Server,0,CQ_start);
   end;
end.
