program DirectoryListExample;  {EXDIR.PAS} {Modified}

{ demonstrate how modify existing programs to add status line facility}

uses
  Dos, StatLine, OpString, OpCrt, OpRoot, OpCmd,
  OpMouse, OpFrame, OpWindow, OpPick, OpDir,OpKey;

var
  Dir : DirList;
  Finished : Boolean;
  SL : StatusLine;

const
  FA : FlexAttrs = ($02,$0a,$1e,$70);

{$F+}
  function SampleReadKey    : Word;
  var
    Count : Word;
    LastX,
    LastY : byte;
  begin
    While not KeyOrButtonPressed do;
    if MouseButtonPressed(LeftButton,Count,LastX,LastY) then
      SampleReadKey := SL.GetKey(LastY,LastX,ReadkeyOrButton)
    else
      SampleReadKey := ReadKeyOrButton;
  end; {SampleReadKey}
  {$F-}

begin
  if not MouseInstalled then exit;
  clrscr;
  if not Dir.InitCustom(25, 5, 55, 20,                 {Window coordinates}
                        DefaultColorSet,               {ColorSet}
                        DefWindowOptions or wBordered, {Window options}
                        MaxAvail,                      {Heap space for files}
                        PickVertical,                  {Pick orientation}
                        SingleFile)                    {Command handler}
  then begin
    WriteLn('Failed to Init DirList,  Status = ', InitStatus);
    Halt;
  end;
  if not SL.Init(1,1,FA) then exit;
  if SL.AddTopic('ENTER ',Enter) and
     SL.AddTopic('ESC ', ESC) and
     SL.AddTopic('Home ',Home) and
     SL.AddTopic('End ',EndKey) and
     SL.AddTopic('PgDn ',PgDn) and
     SL.AddTopic('PgUp ',PgUp) and
     SL.AddTopic(^A'F5'^A'-Zoom ',F5) then
    SL.Draw;


  {Set desired DirList features}
  ShowMouse;
  EnableEventHandling;
  with PickCommands do begin
    cpOptionsOn(cpEnableMouse);
    SetGetKeyProc(SampleReadKey);
    AddCommand(ccUser0,1,F5,0);
  end;
  Dir.SetPosLimits(3, 3, ScreenWidth-5, ScreenHeight-2);
  Dir.SetSizeLimits(3, 3, ScreenWidth-5, ScreenHeight-2);
  Dir.SetPadSize(1, 1);
  Dir.diOptionsOn(diOptimizeSize);
  Dir.AddMaskHeader(True, 1, 30, heTC);
  Dir.SetSortOrder(SortName);
  Dir.SetNameSizeTimeFormat('<dir>', 'Mm/dd/yy', 'Hh:mmt');
  Dir.SetMask('*.*', AnyFile);
  {Pick a file}
  Finished := False;
  repeat
    Dir.Process;
    case Dir.GetLastCommand of
      ccSelect :
        FastWrite(Pad('Selected: '+Dir.GetSelectedPath, ScreenWidth),
                  ScreenHeight, 1, TextAttr);
      ccError  :
        begin               {!!.01}
          FastWrite('Error '+Long2Str(Dir.GetLastError),
                    ScreenHeight, 1, TextAttr);
          Finished := True; {!!.01}
        end;                {!!.01}
      ccUser0:
         if Dir.IsZoomed then
           Dir.UnZoom
         else
           Dir.Zoom;
      ccQuit   :
        Finished := True;
      {Process other exit commands}
    end;
  until Finished;
  Dir.Done;
  HideMouse;
  SL.DOne;
end.
