program mul_reg_demo;

uses
   crt,stat;
const
     num12 = 12;                       { number of data points }
var
   y,x,z,a : single_array_pointer;     { point to dynamic arrays }
   j       : word;
   r,se    : single;
   mean,
   small,y_est,
   large,diff,
   sd      : single;
   a1,b1   : single;
begin
{ create dynamic arrays}
     create_single_array(num12,x);     { create x dynamic array }
     create_single_array(num12,y);     { create y dynamic array }
     create_single_array(num12,z);     { create z dynamic array }
     create_single_array(3,a);         { create regression coef. array }

{ put data into the arrays}
     y^[1] := 110.0; x^[1] := 60.0; z^[1] := 40.0;
     y^[2] := 135.0; x^[2] := 60.0; z^[2] := 20.0;
     y^[3] := 120.0; x^[3] := 60.0; z^[3] := 30.0;
     y^[4] := 120.0; x^[4] := 62.0; z^[4] := 20.0;
     y^[5] := 140.0; x^[5] := 62.0; z^[5] := 30.0;
     y^[6] := 130.0; x^[6] := 62.0; z^[6] := 40.0;
     y^[7] := 135.0; x^[7] := 62.0; z^[7] := 20.0;
     y^[8] := 150.0; x^[8] := 64.0; z^[8] := 30.0;
     y^[9] := 145.0; x^[9] := 64.0; z^[9] := 30.0;
     y^[10] := 170.0; x^[10] := 70.0; z^[10] := 20.0;
     y^[11] := 185.0; x^[11] := 70.0; z^[11] := 30.0;
     y^[12] := 160.0; x^[12] := 70.0; z^[12] := 40.0;

{ clear screen and print header}
     clrscr;
     writeln('                       MULREG EXAMPLE');
     writeln('            mean        sd     small    large');
     writeln('           ------     ------   ------   ------');
{ get stats on each variable }
     elem_stat(num12,x,small,large,mean,sd);
     writeln('x data',mean:10:2,sd:10:2,small:10:2,large:10:2);
     elem_stat(num12,z,small,large,mean,sd);
     writeln('z data',mean:10:2,sd:10:2,small:10:2,large:10:2);
     elem_stat(num12,y,small,large,mean,sd);
     writeln('y data',mean:10:2,sd:10:2,small:10:2,large:10:2);
     writeln;
{ run mulreg}
     mulreg(num12,y,x,z,a,r,se);

{ print out regression coefficients }
         writeln('y estimated = ',a^[1]:10:5,' + ',a^[2]:10:5,' * X'
                                            ,' + ',a^[3]:10:5,' * Z');

{ print out correlation coefficient and standard error}
     writeln('R = ',r:10:3,' standard error = ',se:20:10,' units');
{ print out estimations }
     writeln('   actual   estimated   difference');
     for j := 1 to num12 do
     begin
          y_est := a^[1] + (a^[2] * x^[j]) + (a^[3] * z^[j]);
          diff  := y^[j] - y_est;
          z^[j] := diff;
          x^[j] := j;
          writeln(y^[j]:10:3,y_est:10:3,diff:10:3);
     end;
{ see if residuals are correlated }
     linfit(num12,x,z,z,0,a1,b1,r);
     writeln('intercept of residuls',a1:10:3,' slope =', b1:10:3,'  R= ',r:10:3,' Nope');

end.