program random_generator_test;

uses
    stat;
const
     zero = 0.0;
var
   r       : single_array_pointer;
   quarter : quartype;
   j,k     : word;
   small,
   large,
   stand,
   temp    : single;
   mean,
   sd,dummy      : single;
   dummyl,dummyh : single;
   number,d,d1   : word;
   skew,qur      : single;
   se_mean       : single;

begin  { begin main program }
     for j := 1 to 5 do
        randomize;
     repeat
           write('Enter in number of elements in array-->');
           readln(number);
     until number > 1;
     create_single_array(number,r);

     write('Enter mean of values-->');
     readln(mean);
     write('Enter standard deviation of values-->');
     readln(sd);

     for j := 1 to number do
         r^[j] := rndnorm1(mean,sd);

     elem_stat(number,r,small,large,temp,stand);
                       moments(number,r,temp,stand,skew,qur);
     quart(number,r,quarter);
     se_mean := standard_error(number,stand,1);

     small := quarter[1];
     large := quarter[5];
     dummyl := mean - se_mean;
     dummyh := mean + se_mean;
     writeln('                                                     Standard error 1*SD');
     writeln('                         Theory   Observed  Difference   Low       High');
     writeln('                        --------- --------- ---------- -------- ----------');
     writeln('Mean                  ',mean:10:3,temp:10:3,(temp-mean):10:3,dummyl:10:3,dummyh:10:3);
     dummy := standard_error(number,stand,4);;
     dummyl := sd - dummy;
     dummyh := sd + dummy;
     writeln('Standard Deviation    ',sd:10:3,stand:10:3,(stand-sd):10:3,dummyl:10:3,dummyh:10:3);

     writeln(' Skewness             ',zero:10:3,skew:10:3,(zero-skew):10:3);
     writeln(' Qurtosis             ',zero:10:3,(qur-3.0):10:3,(zero-qur+3.0):10:3);
     dummy := mean + 4.0*sd;
     writeln('Largest value  4*SD   ',dummy:10:3,large:10:3,(large - dummy):10:3);
     dummy := mean - 4.0*sd;
     writeln('Smallest value 4*SD   ',dummy:10:3,small:10:3,(small - dummy):10:3);
     dummyh := temp + stand;
     dummyl := temp - stand;
     sd     := temp + 2.0*stand;
     mean   := temp - 2.0*stand;
     d := 0;
     d1 := 0;
     for j := 1 to number do
     begin
         if (r^[j] >= dummyl) and (r^[j] <= dummyh) then
            inc(d);
         if (r^[j] >= mean) and (r^[j] <= sd) then
            inc(d1);
     end;

     writeln('Percent between +- 1*SD   68.3 %',(100.0*d/number):8:1,' %');
     writeln('Percent between +- 2*SD   95.5 %',(100.0*d1/number):8:1,' %');
     writeln;
     writeln('Number of values = ',number:10);
     for j := 1 to 5 do
         write(quarter[j]:10:3);

end.

