{****	Stamper 1.0 Copyright 1994 Hemal Popat ********}
program Stamper;
{$R Stamper.RES}
uses WinTypes,WinProcs,Objects,OWindows,ODialogs,Strings,WinDos,CommDlg,Win31;
const
	ST_Name	 = 'Stamper';
	id_About	= 501;
	id_CMGetFiles	= 601;
	id_CMALTER	= 602;
	id_CMExit	= 610;
	id_edit		= 603;
	tctrl=699;
{**********************	TYPES	******************************}
type
	TSTApp = object(TApplication)
	procedure InitMainWindow; virtual;
end;

PSTWindow = ^TSTWindow;
TSTWindow = object(TWindow)
	About,Select,Alter,BtExit:PButton;
	Text:PStatic;
	EditBox:PEdit;
	FilesBuf:PChar;
	CurTime:LongInt;
	constructor Init(ATitle: PChar);
	destructor Done; virtual;
	procedure SetupWindow;virtual;
	procedure IDAbout (Var Msg:TMessage);virtual id_first+id_about;
	procedure IDCMALTER(Var Msg:TMessage);virtual id_First+id_CMALTER;
	procedure IDCMExit(Var Msg:TMessage);virtual id_First+id_CMExit;
	procedure IDCMGetFiles(Var Msg:TMessage);virtual id_First+id_CMGetFiles;
end;
{*********************	Functions	*******************************}
function StrTok(P:PChar;C:Char):PChar;
const
	Next:Pchar = nil;
begin
	if P = NIL then P := Next;
	if P <> NIL then begin
		Next := StrScan(P,C);
		If Next <> NIL then begin
			Next^ := #0;
			Next := Next+1;
			end;
		end;
	StrTok := P;
end;
{**********************	METHODS	******************************}
procedure TSTApp.InitMainWindow;
begin
	MainWindow := New(PSTWindow, Init(ST_Name));
end;
{**********************	TSTWindow	*******************************}
constructor TSTWindow.Init(ATitle: PChar);
var
	Indx:Integer;
begin
	TWindow.Init(nil, ATitle);
with Attr do
	begin
		X := 50; Y := 50; W := 285; H := 220;
		Attr.Style := ws_Overlapped or ws_SysMenu or ws_MinimizeBox;
		end;
	About:=New(PButton,Init(@Self,id_about,'&About',150,150,120,40,false));
	Alter:=New(PButton,Init(@Self,id_CMAlter,'Al&ter',15,150,120,40,false));
	BtExit:=New(PButton,Init(@Self,id_CMExit,'E&xit',150,100,120,40,false));
	Select:=New(PButton,Init(@Self,id_CMGetFiles,'&Select',15,100,120,40,true));
	EditBox:=New(PEdit,Init(@Self,id_edit,'950101000000',80,59,120,28,13,false));
	Text:=New(PStatic,Init(@Self,071,' Enter Date/Time in format:',30,5,215,20,30));
	Text:=New(PStatic,Init(@Self,071,' yymmddhhmmss',70,32,140,20,30));
	GetMem(FilesBuf,4096);
	StrCopy(FilesBuf,'');
end;

destructor TSTWindow.Done;
begin
	FreeMem(FilesBuf,4096);
	TWindow.Done;
end;

procedure TSTWindow.SetupWindow;
var
	SysMenu:HMenu;
begin
	TWindow.SetupWindow;
	SetClassWord(HWindow,GCW_HIcon,LoadIcon(HInstance,'ST_Icon'));
	SetClassWord(HWindow,GCW_HBrBackground,GetStockObject(ltGray_Brush));
	end;

procedure TSTWindow.IDCMGetFiles(var Msg:TMessage);
const
	szFilter:Array[0..8] of Char ='*.*'#0'*.*'#0#0;
var
	Path,Name,Ext,OldDir:Array[0..fsPathName] of Char;
	szDirName:Array[0..256] of Char;
	szFile,szFileTitle:Array[0..512] of Char;
	OFN:TOpenFileName;
	P:PChar;
begin
	StrCopy(FilesBuf,'');
	OFN.lStructSize := sizeof(TOpenFileName);
	OFN.hWndOwner := HWindow;
	OFN.lpStrFilter := @szFilter;
	OFN.lpStrCustomFilter := nil;
	OFN.nMaxCustFilter := 0;
	OFN.nFilterIndex := LongInt(1);
	OFN.lpStrFile := FilesBuf;
	OFN.nMaxFile := 4096;
	OFN.lpstrfileTitle := szFileTitle;
	OFN.nMaxFileTitle := sizeof(szFileTitle);
	OFN.lpstrInitialDir := NIL;
	OFN.lpStrTitle := 'Select Files';
	OFN.flags := OFN_ALLOWMULTISELECT;
	OFN.nFileOffset := 0;
	OFN.nFileExtension := 0;
	OFN.lpstrDefext := nil;
	GetOpenFileName(OFN)
end;

procedure TSTWindow.IDCMALTER(var Msg:TMessage);
var
	Path,PathName:Array[0..69] of Char;
	FName:Array[0..18] of Char;
	pResult:PChar;
	Files:PStrCollection;
	Indx:Integer;
	Instring:array[0..12] of Char;
	inputpas:string;
	code:integer;
	error:boolean;
	DT:TDateTime;
	time:longint;
	F:File;
begin
	if StrLen(FilesBuf) = 0 then	{0 files selected - error message}
		begin
		MessageBeep(mb_IconExclamation);
		MessageBox(HWindow,'Please select files first','Stamper',mb_IconExclamation);
		Exit;
		end;
	EditBox^.GetText(Instring,13);
	inputpas:=StrPas(instring);
	error:=false;
	with DT do begin
		val(copy(inputpas,1,2),year,code);
		if code<>0 then error:=true;
		val(copy(inputpas,3,2),month,code);
		if code<>0 then error:=true;
		val(copy(inputpas,5,2),day,code);
		if code<>0 then error:=true;
		val(copy(inputpas,7,2),hour,code);
		if code<>0 then error:=true;
		val(copy(inputpas,9,2),min,code);
		if code<>0 then error:=true;
		val(copy(inputpas,11,2),sec,code);
		if code<>0 then error:=true;
	end;
	if error=true then
		begin
		MessageBeep(mb_IconExclamation);
		MessageBox (HWindow,'Please enter date/time correctly','Stamper',mb_iconexclamation);
		Exit;
		end;
	DT.year:=DT.year+1900;
	PackTime(DT,Time);
	Files := New(PStrCollection,Init(10,10));
	pResult := StrScan(FilesBuf,' ');
	if pResult = NIL then	{1 file only}
		Files^.Insert(StrNew(FilesBuf))
		else begin	{2 or more}
		pResult := StrTok(FilesBuf,' ');	{get the path}
		StrCopy(Path,pResult);
		SetCurDir(Path);		{chdir there}
		pResult := StrTok(NIL,' ');	{get the 1st filename}
		while pResult <> NIL do begin
			FileExpand(PathName,pResult);	{expand file name}
			Files^.Insert(StrNew(PathName));	{store it in collection}
			pResult := StrTok(NIL,' ');	{get next file name}
			end;
		end;
	for Indx := 0 to (Files^.Count -1) do begin	{process the selected files}
		pResult := Files^.At(Indx);
		Assign(F,PResult);
		Reset(F);
		SetFTime(F,Time);
		Close(F);
		end;
	Dispose(Files,Done);	{clean up collection}
	sendmessage(hwnd_broadcast,wm_user+$0206,0,0); {update file manager window}
end;

procedure TSTWindow.IDCMExit(var Msg:TMessage);
begin
	CloseWindow;
end;

procedure TSTWindow.IDAbout(var Msg:TMessage);
begin
	case Msg.Wparam of
		id_About:
			application^.ExecDialog(New(PDialog,Init(@Self,'ST_About')));
	else
		DefWndProc(Msg);
	end;
end;

{**********************	MainLine	*******************************}
var
	STApp: TSTApp;
begin
	STApp.Init(ST_Name);
	STApp.Run;
	STApp.Done;
end.
