unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Sssprite, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Packman: TSprite;

implementation

var
  MoveX: Integer;
  MoveY: Integer;
  BitmapDir: string;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var

  I: integer;
begin
  BitmapDir := 'c:\sssprite\';
  Form1.Show;
  InitializeScreen(form1.Canvas, form1.Width, form1.Height,
    'c:\delphi\images\splash\16color\EARTH.BMP');
  Packman.CreateSprite(Packman, BitmapDir + 'pack00.bmp',
    BitmapDir + 'pack00m.bmp');
  Packman.TurnOnOffSprite(Packman, True);
  Packman.SetPosition(Packman, form1.width div 2 - 16, form1.height div 2 - 16);

  Packman.AddAnimation(Packman, BitmapDir + 'pack01.bmp',
    BitmapDir + 'pack01m.bmp',0);
  Packman.AddAnimation(Packman, BitmapDir + 'pack10.bmp',
    BitmapDir + 'pack10m.bmp',1);
  Packman.AddAnimation(Packman, BitmapDir + 'pack11.bmp',
    BitmapDir + 'pack11m.bmp',1);
  Packman.AddAnimation(Packman, BitmapDir + 'pack20.bmp',
    BitmapDir + 'pack20m.bmp',2);
  Packman.AddAnimation(Packman, BitmapDir + 'pack21.bmp',
    BitmapDir + 'pack21m.bmp',2);
  Packman.AddAnimation(Packman, BitmapDir + 'pack30.bmp',
    BitmapDir + 'pack30m.bmp',3);
  Packman.AddAnimation(Packman, BitmapDir + 'pack31.bmp',
    BitmapDir + 'pack31m.bmp',3);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
    Packman.MoveSprite(Packman, MoveX, MoveY);

    Packman.AnimateForwardSprite(Packman, True);
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_up then
  begin
    Packman.SetSegment(Packman, 2);
    MoveX := 0;
    MoveY := -8;
  end
  else if Key = VK_down then
  begin
    Packman.SetSegment(Packman, 3);
    MoveX := 0;
    MoveY := 8;
  end
  else if Key = VK_right then
  begin
    Packman.SetSegment(Packman, 1);
    MoveX := 8;
    MoveY := 0;
  end
  else if Key =VK_left then
  begin
    Packman.SetSegment(Packman, 0);
    MoveX := -8;
    MoveY := 0;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Packman.DeleteSprite(Packman);
    TerminateScreen;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  RefreshScreen;
end;

end.
