unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    RbtnMD5: TRadioButton;
    RbtnSHA: TRadioButton;
    procedure FormCreate(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  MD5, SHA;

const
  FileBufSize = 16384;


{ For the sake of clarity, two almost identical functions to demonstrate the use }
{ of the MD5 and SHA units.                                                      }

function  CalcMD5Digest(AFileName: TFileName): string;
var
  MD5Digest: TMD5Digest;
  MD5Context: TMD5Context;
  i: Integer;
  Bytes: Word;
  Buf: Pointer;
  F: File;
begin
  Result := '';

  try
    AssignFile(F, AFileName);
    FileMode := 0; { Just Read-access, we don't want to be fooled by read-only files... }
    Reset(F, 1);
    GetMem(Buf, FileBufSize);
    MD5Init(MD5Context);
    repeat
      BlockRead(F, Buf^, FileBufSize, Bytes);
      if Bytes > 0 then
        MD5Update(MD5Context, Buf^, Bytes);
    until Bytes < FileBufSize;
    MD5Digest := MD5Final(MD5Context);

    for i := 0 to 15 do
      Result := Result + IntToHex(Byte(MD5Digest[i]),2)
  finally
    FreeMem(Buf, FileBufSize);
    CloseFile(F)
  end
end;

function  CalcSHADigest(AFileName: TFileName): string;
var
  SHADigest: TSHADigest;
  SHAContext: TSHAContext;
  i: Integer;
  Bytes: Word;
  Buf: Pointer;
  F: File;
begin
  Result := '';

  try
    AssignFile(F, AFileName);
    FileMode := 0; { Just Read-access, we don't want to be fooled by read-only files... }
    Reset(F, 1);
    GetMem(Buf, FileBufSize);
    SHAInit(SHAContext);
    repeat
      BlockRead(F, Buf^, FileBufSize, Bytes);
      if Bytes > 0 then
        SHAUpdate(SHAContext, Buf^, Bytes);
    until Bytes < FileBufSize;
    SHADigest := SHAFinal(SHAContext);

    for i := 0 to 19 do
      Result := Result + IntToHex(Byte(SHADigest[i]),2)
  finally
    FreeMem(Buf, FileBufSize);
    CloseFile(F)
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  { The application handles critical errors.  }
  { File errors are caught by the Delphi RTL  }
  SetErrorMode(SEM_FAILCRITICALERRORS);
  Panel1.Caption := 'Double-click a file to calculate the message-digest'
end;

procedure TForm1.FileListBox1DblClick(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  Panel1.Caption := 'calculating...';
  Update;

  if RbtnMD5.Checked then
    Panel1.Caption := CalcMD5Digest(FileListBox1.FileName)
  else
    Panel1.Caption := CalcSHADigest(FileListBox1.FileName);

  Screen.Cursor := crDefault
end;

end.
