/* sbsample.c */

#define TRUE  1
#define FALSE 0

unsigned int resetport = 0x226;
unsigned int readport  = 0x22A;
unsigned int writeport = 0x22C;
unsigned int pollport  = 0x22E;

void out(unsigned int port, unsigned char value)
  {
    asm {
      mov    dx, port
      mov    al, value
      out    dx, al
     }
  }

void writedsp(unsigned char value)
  {
     wait:
      asm {
      mov    dx, writeport
      in     al, dx
      and    al, 0x80
      jnz    wait
      mov    al, [value]
      out    dx, al
     }
  }

unsigned char readdsp(void)
  {
     wait:
    asm {
      mov    dx, pollport
      in     al, dx
      and    al, 0x80
      jz     wait
      mov    dx, readport
      in     al, dx
     }
  }

char resetdsp(void)
  {
    char i;

    out(resetport, 1);
    out(resetport, 0);
    i = 100;
    while (!i && (readdsp() != 0xAA)) i++;
    if (!i)
      return FALSE;
      else return TRUE;
  }

void turnspeakeron()
  {
    writedsp(0xD1);
  }

void turnspeakeroff()
  {
    writedsp(0xD3);
  }

unsigned char getsample(void)
  {
    writedsp(0x20);
    return readdsp();
  }

void outputsample(unsigned char sample)
  {
    writedsp(0x10);
    writedsp(sample);
  }
