{============================================================================}
FUNCTION UnpackText(RLELength   : WORD;
                VAR TheArray; {an untyped parameter}
                    Destination : STRING) : BYTE;

{Created by Rob Rosenberger
            CompuServe 74017,1344

Version 1.00 released to the public domain on 30 Nov 88.

   This function will unpack the given run-length-encoded text to a specified
destination.  If the destination is 'CON' (all caps), UnpackText will use the
ASSIGNCRT statement instead of ASSIGN.}

VAR
   RLEarray : ARRAY [1..65520] OF CHAR ABSOLUTE TheArray;

   OutputDevice : TEXT;
   ArrayIndex   : WORD;
   RepeatValue  : BYTE;
   RepeatIndex  : BYTE;
   RepeatString : STRING;

BEGIN {UnpackText}
{$IFOPT I+}
    {$I-}
    {$DEFINE IACTIVE} {memorize that we shifted into $I-!}
{$ENDIF}
IF (Destination = 'CON')
  THEN ASSIGNCRT(OutputDevice)
  ELSE ASSIGN(OutputDevice,Destination);
REWRITE(OutputDevice);
ArrayIndex := 0;
REPEAT
  INC(ArrayIndex);
  CASE RLEarray[ArrayIndex] OF
    #0 : {a repetition char is coming}
      BEGIN
      INC(ArrayIndex); {move to the repeat #}
      RepeatString[0] := RLEarray[ArrayIndex];
      INC(ArrayIndex); {move to the rep char}
      FOR RepeatIndex := 1 TO ORD(RepeatString[0])
       DO IF (RLEarray[ArrayIndex] = CHR(255))
           THEN {this is the code for a CR/LF}
              WRITELN(OutputDevice)
           ELSE {it's any other character}
              RepeatString[RepeatIndex] := RLEarray[ArrayIndex];
      IF (RLEarray[ArrayIndex] <> CHR(255))
       THEN WRITE(OutputDevice,RepeatString)
      END;
    #255 : {the code for a CR/LF}
      WRITELN(OutputDevice);
    ELSE {a non-RLE char}
      WRITE(OutputDevice,RLEarray[ArrayIndex])
   END {CASE}
 UNTIL (ArrayIndex = RLELength);

CLOSE(OutputDevice);
{$IFDEF IACTIVE} {did we shift into $I- on purpose?}
    {$I+}
    {$UNDEF RJR} {forget that we shifted into $I-!}
{$ENDIF}
{Tell calling routine how the I/O went.}
UnpackText := IORESULT
END; {UnpackText}
{============================================================================}

