Unit GetField;

Interface

uses Crt,screenio;

procedure Field_Str(Xpos, Ypos, Len : Byte;
                    Prompt      : String;
                    Var UserStr : String;
                    Picture     : string);

procedure SetUp_Field(PromptColor,ActiveFColor,InactiveFColor,ShadowC : Byte;
                      ClearChar : Char;
                      EscKey,Clean,Confirm,Bell,UpDn,Wndw : Boolean);

procedure GetString(Ypos,Xpos,Attr,Len : Byte;
                    Var Str255 : String;
                    Picture : string;
                    Var Keyval : Integer);

procedure GetStr(Ypos,Xpos : Byte;
                 Var Str255 : String;
                 Picture : string);

procedure Disp_Fields;

procedure Do_Fields(Var KeyVal : Integer);

function  Get_Key : Integer;

procedure NumStr(Var Fstr : string;
                 Len,Dec : byte);

procedure Release_Fields;

var
  Field_Id : byte;
  ESC_KEY  : BOOLEAN;

implementation

const
  _A = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  _L = 'TF';
  _N = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
  _Y = 'NY';
  _9 = '1234567890-.';
  _D = '1234567890- ';
  _P = '@ALNXY9#!$*';

Type
  Field_IO = Record
               Xpos,Ypos,Len,Exit,Opts : Byte;
               UserStr : ^String;
               Picture : String;
               Decimal : integer;
               CharType: Char;
               Prompt  : String;
             end;
Var
  Field_Array     : Array[1..256] of ^Field_IO;
  Max_Field       : Byte;
  Active_Fcolor   : Byte;
  _Shadow         : byte;
  Inactive_Fcolor : Byte;
  Prompt_Color    : byte;
  Up_X,Up_Y,
  Lo_X,Lo_Y       : byte;
  Clear_Char      : Char;
  UpDn_Enable     : Boolean;
  Esc_Exit,_Bell,
  _Confirm,_INS,
  Clean_Str       : Boolean;
  Disp_Win        : Boolean;
  Decimal         : byte;
  CharType        : Char;
  _LEGAL          : char;

procedure TrimStr(VAR InputStr : string;
                      CChar    : Char);
  var
    count  : byte;
  begin
    count := Length(InputStr);
    while (InputStr[count] = CChar) and (count > 0) do
      begin
        Delete(InputStr,count,1);
        dec(count);
      end;
    while (InputStr[1] = CChar) and (Length(InputStr) > 0) do
      Delete(InputStr,1,1);
  end;

procedure NumStr(Var Fstr : string;
                 Len,Dec : byte);
  var
    RealInt : Real;
    code : integer;
  begin
    while Pos(Clear_Char,Fstr) > 0 do
      delete(Fstr,Pos(Clear_Char,Fstr),1);
    Val(Fstr,RealInt,code);
    Str(RealInt:Len:Dec,Fstr);
  end;

function NumToStr(num : integer;len : byte) : string;
  var
    str1 : string;
    count : byte;
  begin
    Str(num:len,str1);
    for count := 1 to length(str1) do
      if str1[count] = ' ' then str1[count] := '0';
    NumToStr := Str1;
  end;

function ValidDate(var datestr : string) : boolean;
  var
    month,day,year : byte;
    code           : integer;
    tempstr        : string;
  begin
    tempstr := copy(datestr,1,2);
    TrimStr(TempStr,' ');
    Val(TempStr,month,code);
    tempstr := copy(datestr,4,2);
    TrimStr(TempStr,' ');
    Val(TempStr,day,code);
    tempstr := copy(datestr,7,2);
    TrimStr(TempStr,' ');
    Val(TempStr,year,code);
    if (month > 0) and (month < 13) and (day > 0) and (day < 32) then
        begin
          datestr := NumToStr(month,2)+datestr[3]+NumToStr(day,2)+datestr[6]+NumToStr(year,2);
          ValidDate := True
        end else ValidDate := False;
  end;

procedure Field_Str;
  var
    count : byte;
    code  : integer;
    fchar : char;
  begin
    inc(Max_Field,1);
    New(Field_Array[Max_Field]);
    Field_Array[Max_Field]^.Decimal := 0;
    Field_Array[Max_Field]^.CharType:= 'C';
    fchar := 'X';
    if length(picture) > 1 then
      if picture[1] = '@' then
        begin
          fchar   := picture[2];
          if fchar = '9' then
            begin
              if (length(picture) > 3) and (picture[3] = ':') then
                Val(picture[4],Field_Array[Max_Field]^.Decimal,code);
              Field_Array[Max_Field]^.CharType:= 'N';
            end;
          if fchar = 'D' then
            begin
              picture := '99/99/99';
              len := 8;
              Field_Array[Max_Field]^.CharType:= 'D';
            end else picture := fchar;
        end;
    if Length(UserStr) > Len then Delete(UserStr,Len,Length(UserStr)-Len);
    for count := 1 to (Len-Length(UserStr)) do
      UserStr := UserStr + Clear_Char;
    for count := Length(Picture)to Len do
      Picture := Picture + fchar;
    for count := 1 to Length(Picture) do
      begin
        if pos(picture[count],_P) = 0 then UserStr[count] := Picture[count];
        if Picture[count] = '!' then UserStr[count] := UpCase(UserStr[count]);
      end;
    if Field_Array[Max_Field]^.Decimal > 0 then
      begin
        delete(Picture,Len-Field_Array[Max_Field]^.Decimal,1);
        Insert('.',Picture,Len-Field_Array[Max_Field]^.Decimal);
        NumStr(UserStr,Len,Field_Array[Max_Field]^.Decimal);
      end;
    Field_Array[Max_Field]^.Prompt  := Prompt;
    Field_Array[Max_Field]^.Xpos    := Xpos+Length(Prompt);
    Field_Array[Max_Field]^.Ypos    := Ypos;
    Field_Array[Max_Field]^.Len     := Len;
    Field_Array[Max_Field]^.UserStr := @UserStr;
    Field_Array[Max_Field]^.Picture := Picture;
    if Up_X > Xpos then Up_X := Xpos;
    if Up_Y > Ypos then Up_Y := Ypos;
    if Lo_X < (Xpos+Length(prompt)+Len-1) then Lo_X := (Xpos+Length(prompt)+Len-1);
    if Lo_Y < Ypos then Lo_Y := Ypos;
  end;

procedure SetUp_Field;
  begin
    Prompt_Color    := PromptColor;
    Active_FColor   := ActiveFColor;
    Inactive_Fcolor := InactiveFColor;
    _Shadow         := ShadowC;
    Clear_Char      := ClearChar;
    Disp_Win        := Wndw;
    Esc_Exit        := EscKey;
    if Max_Field = 0 then
      begin
        Up_X            := 80;
        Up_Y            := 25;
        Lo_X            := 0;
        Lo_Y            := 0;
        Field_Id        := 1;
      end;
    Clean_Str       := Clean;
    _Confirm        := Confirm;
    _Bell           := Bell;
    UpDn_Enable     := UpDn;
    ESC_KEY         := FALSE;
  end;

procedure Release_Fields;
  Var
    Field_Num,count : Byte;
  begin
    textattr := Inactive_Fcolor;
    for Field_Num := 1 to Max_Field do
      with Field_Array[Field_Num]^ do
        begin
          gotoxy(Xpos,Ypos);
          Write(UserStr^);
          if Clean_Str then TrimStr(UserStr^,Clear_Char);
        end;
    For Field_Num := 1 to Max_Field do
      Dispose(Field_Array[Field_Num]);
    Max_Field := 0;
  end;

function Get_Key : Integer;
  Var CH : Char;
      Int : Integer;
  begin
    CH := ReadKey;
    If CH = #0 then
      begin
        CH := ReadKey;
        int := Ord(CH);
        inc(int,256);
      end else Int := Ord(CH);
    Get_Key := Int;
  end;

procedure GetString;

Var
  Position,
  count    : Byte;
  Exit     : Boolean;

  function validpos : boolean;
    begin
      if pos(picture[position],_P) > 0 then validpos := True
        else validpos := false;
    end;

  procedure WriteString;
    Var X : Byte;
    begin
      GotoXY(Xpos,Ypos);
      Write(Str255);
    end;

  procedure BackSpaceChar;
    var
      temppos : byte;
    Begin
      temppos := Position;
      while (Pos(picture[temppos-1],_P) = 0) and (temppos > 0) do
        dec(temppos);
      if TempPos > 1 then
        begin
          delete(Str255,temppos-1,1);
          position := TempPos;
          dec(Position);
          temppos := Position;
          while (Pos(picture[temppos+1],_P) > 0) and (temppos < Len+ 1) do
            inc(temppos);
          insert(Clear_Char,Str255,temppos);
          WriteString;
        end;
    end;

  procedure DeleteChar;
    Begin
      inc(Position);
      BackSpaceChar;
    end;

  function FixNum : boolean;
    begin
      FixNum := True;
      if Char(Keyval) = '.' then
        if decimal > 0 then
          begin
            if Position < Pos('.',Str255) then
              while Position < Pos('.',Str255) do
                begin
                  Str255[position] := ' ';
                  inc(Position);
                end else Position := Pos('.',Str255);
            inc(Position);
            NumStr(Str255,Len,Decimal);
            WriteString;
            GotoXY(Xpos+Position-1,Ypos);
            FixNum := False;
          end;
    end;

  procedure WriteChar;
    Var
      DoWrite : Boolean;
      temppos : Byte;
    Begin
      If Position <= Len then
        begin
          DoWrite := True;
          case Picture[Position] of
            '!' : Char(KeyVal) := UpCase(Chr(KeyVal));
            'X' : ;
            'A' : If Pos(upcase(Char(KeyVal)),_A) = 0 then
                    begin
                      DoWrite := False;
                      InValidInput('Letters Only');;
                      write(Chr(07));
                    end;
            'N' : If Pos(Char(KeyVal),_N) = 0 then
                    begin
                      DoWrite := False;
                      InValidInput('Letters and Numbers Only');
                      write(Chr(07));
                    end;
            'L' : If Pos(upcase(Char(KeyVal)),_L) = 0 then
                    begin
                      DoWrite := False;
                      InValidInput('T or F Only Allowed');;
                      write(Chr(07));
                    end else Char(KeyVal) := UpCase(Chr(KeyVal));
            'Y' : If Pos(upcase(Char(KeyVal)),_Y) = 0 then
                    begin
                      DoWrite := False;
                      InValidInput('Y or N Only Allowed');;
                      write(Chr(07));
                    end else Char(KeyVal) := UpCase(Chr(KeyVal));
            '#' : If Pos(Char(KeyVal),_D) = 0 then
                    begin
                      DoWrite := False;
                      InValidInput('Numbers Only');;
                      write(Chr(07));
                    end;
            '9' : If Pos(Char(KeyVal),_9) = 0 then
                    begin
                      DoWrite := False;
                      InValidInput('Numeric Values Only');;
                      write(Chr(07));
                    end else DoWrite := FixNum;
            else DoWrite := False;
          end;
          If DoWrite then
          begin
            If _INS then begin
              Insert(Char(Keyval),Str255,Position);
              temppos := Position;
              while (Pos(picture[temppos],_P) > 0) and (temppos < Len+1) do
                inc(temppos);
              delete(Str255,TempPos,1);
            end else Str255[Position] := Char(KeyVal);
            WriteString;
            repeat
              Inc(Position);
            until validpos or (position > len);
            GotoXY(Xpos+Position-1,Ypos);
          end;
        end;
        if (Not _Confirm) and (Position > len) then
          begin
            Exit := true;
            if _BELL then soundbell;
          end;

    End;

  procedure EditString;
    Begin
      KeyVal := Get_Key;
      If ErrPrompt then ClearInvalid;
      Case KeyVal of
{Back}    8 : If Position > 1 then BackSpaceChar
                else if Not _Confirm then begin
                                            Exit := True;
                                            KeyVal := 331;
                                          end;
{Esc}    27 : Exit := True;
{Return} 13 : Exit := True;
{Home}  327 : Position := 1;
{Up}    328 : Exit := True;
{PgUp}  329 : Exit := True;
{Left}  331 : If Position > 1 then
                repeat
                  dec(Position);
                until validpos or (position = 1)
              else if Not _Confirm then Exit := True;
{Right} 333 : If Position < Len then
                repeat
                  inc(Position);
                until validpos or (position > len)
              else if Not _Confirm then Exit := True;
{End}   335 : begin
                position := Length(Str255)+1;
                while (position > 0) and (Str255[Position-1] = Clear_Char) do
                  dec(Position);
              end;
{Down}  336 : Exit := True;
{PgDn}  337 : Exit := True;
{Ins}   338 : If _INS then _INS := False else _INS := True;
{Del}   339 : DeleteChar;
      end;
      If (KeyVal < 256) and (Keyval > 27) then
        WriteChar
      else begin
             while (Pos(picture[position],_P) = 0) and (position < Len+1) do
               inc(Position);
             GotoXY(Xpos+Position-1,Ypos);
           end;
    end;

begin
  Exit      := false;
  _INS      := False;
  TextAttr  := Attr;
  Position  := 1;
  _LEGAL    := 'U';
  WriteString;
  while Length(Picture) < Len do
    picture := picture + 'X';
  while (Pos(picture[position],_P) = 0) and (position < Len+1) do
    inc(Position);
  if (Not _Confirm) and (Keyval = 331) then Position := Len;
  GotoXY(Xpos+Position-1,Ypos);
  repeat
    EditString;
    if Exit then
      if chartype = 'D' then
        if (KeyVal <> 27) and (ValidDate(Str255) = FALSE) and (str255 <> '  /  /  ') then
          begin
            Exit := False;
            InValidInput('Invalid Date');
            SoundBell;
          end;
    If Not Esc_Exit then
      If KeyVal = 27 then
        Exit := False;
  until Exit;
  if chartype = 'N' then
    NumStr(Str255,Len,Decimal);
  GotoXY(Xpos,Ypos);
  write(Str255);
  if KeyVal = 27 then ESC_KEY := TRUE
    else ESC_KEY := FALSE;
end;

procedure GetStr(Ypos,Xpos : Byte;
                 Var Str255 : String;
                 Picture : string);
  var
    ReturnVal : Integer;
    oldattr : byte;
  begin
    Oldattr := textattr;
    GetString(Ypos,Xpos,Active_Fcolor,Length(Str255),Str255,Picture,ReturnVal);
    textattr := OldAttr;
    if ReturnVal = 27 then ESC_KEY := TRUE
      else ESC_KEY := FALSE;
  end;

procedure Disp_Windw;
  begin
    DrawBox('',Single,Up_X-2,Up_Y-1,Lo_X+2,Lo_Y+1,_Shadow,Prompt_Color,Prompt_Color);
  end;

procedure Disp_Fields;
  var
    Field_Num : byte;
    Old_Attr : byte;
  begin
    old_attr := textattr;
    if Disp_Win then Disp_Windw;
    for Field_Num := 1 to Max_Field do
      with Field_Array[Field_Num]^ do
        begin
          gotoxy(Xpos-Length(Prompt),Ypos);
          textattr := Prompt_color;
          write(prompt);
          textattr := Active_Fcolor;
          write(UserStr^);
        end;
    textattr := Old_Attr;
  end;

procedure Do_Fields;
  Var
    Exit : Boolean;
    count : byte;
    old_Attr : Byte;
  begin
    if Max_Field > 0 then
    begin
    old_attr := textattr;
    Disp_Fields;
    Repeat
      Decimal  := Field_Array[Field_Id]^.Decimal;
      CharType := Field_Array[Field_Id]^.CharType;
      With Field_Array[Field_Id]^ do
        GetString(Ypos,Xpos,Active_Fcolor,Len,UserStr^,Picture,KeyVal);
      If (Field_Id = Max_Field) and (KeyVal = 13) or
        (KeyVal = 337) or (KeyVal = 27) then
          Exit := True else Exit := False;
      if (UpDn_Enable = FALSE) and ((KeyVal = 328) or (KeyVal = 336)) then Exit := True
        else Case KeyVal of
               13,336,333 : If Field_Id = Max_Field then
                              Field_Id := 1 else inc(Field_Id);
               328,331    : If Field_Id = 1 then
                              Field_Id := Max_Field
                            else dec(Field_Id,1);
             else If Field_Id = Max_Field then
                     Field_Id := 1 else inc(Field_Id);
             end;
    Until Exit;
    release_fields;
    Textattr := Old_Attr;
    end;
  end;

begin
  Max_Field := 0;
  SetUp_Field($07,$70,$07,$00,' ',True,false,true,true,true,true);
end.
