{$F+}
Unit Spooler;

{ This is an enhanced version of a unit created by               }
{ Brian Ebarb Power Software Company - Houston, TX (713)781-9784 }
{ The modifications allow the user access to the spooler Q list. }
{ The changes were made by John Gatewood Ham. (J.HAM3 on GEnie)  }

InterFace

Uses Dos,Search;

Type
      Qentry   = array[1..64] of byte;
      Qtype    = array[1..32] of Qentry;
      Qpointer = ^Qtype;
      slistptr    = ^slist;
      slist       = record
                      next : slistptr;
                      fname: string;
                    end;
var
   numsfilesinlist:integer;
   sfilelist,
   endofsfilelist:slistptr;
   some_in_q:boolean;

function print_installed:boolean;
function queue_empty:boolean;
function fileinqueue(searchname:string):boolean;
function filesetinqueue(searchname:string):boolean;
function spool_a_file(Filestring:string):boolean;
function unspool_a_file(Filestring:string):boolean;
function unspool_all_files:boolean;
procedure deletesfilelist;
procedure getspoolfilelist(fileset:string);

Implementation

var print_not_installed:boolean;   {this variable is local to this unit}

function queue_empty:boolean;
var
   tq:^byte;
   regs:registers;

begin      { Hold queue, Get Status,             }
           { Get pointer to names, Release queue }
  Regs.AH:=$1;
  Regs.AL:=$4;
  Intr($2F, Regs);
{ if error we'll say queu not empty }
  if Regs.Flags AND FCarry = FCarry then
    {error is in Regs.AX }
    queue_empty:=false
  else
    begin
      { mov seg(TheQ),ds; }
      { mov ofs(TheQ),si; }
      { put the contents of DS:SI into TQ}
      TQ:=ptr(regs.ds,regs.si);

      if tq^ = $00 then
        queue_empty := true
      else
        queue_empty := false;
    end;

  { restart the queue }
    Regs.AH := $1;
    Regs.AL := $5;
    Intr($2F, Regs);
end;

{Is a file in print queue?}
function fileinqueue(searchname:string):boolean;
var testname:pathstr;
    i,k:integer;
    foundit:boolean;
    regs:registers;
    tq:qpointer;

begin

  Regs.AH:=$1;
  Regs.AL:=$4;
  Intr($2F, Regs);
  TQ:=ptr(regs.ds,regs.si);
  Regs.AH := $1;
  Regs.AL := $5;
  Intr($2F, Regs);

  i:=1;
  foundit:=false;
  while (tq^[i,1] <> $00) and
        (i < 33) and
        (not foundit) do
    begin
      k:=1;
      testname:='';
      while tq^[i,k] <> $00 do
        begin
          testname:=testname+chr(tq^[i,k]);
          k:=k+1;
        end;
      if testname = searchname then
         foundit:=true;
      i:=i+1;
    end;

  fileinqueue:=foundit;
end;

function print_installed:boolean;
var 
    v1,v2:integer;
    version:word;
    regs:registers;
begin
  version:=dosversion;
  v1:=lo(version);
  v2:=hi(version);
  if v1 < 3 then
     begin
       writeln('You have DOS ',v1,'.',v2,' and it has no PRINT.COM capability.');
       print_installed:=false;
       exit;
     end;
  Regs.AH := $1;
  Regs.AL := $0;
  Intr($2F, Regs);
  if Regs.AL <> 255 then
     print_installed:=false
  else
     print_installed:=true;
end;

function valid_file_name(fname:string):boolean;
var testfile:file;
    holdresult:integer;
begin
   {make sure file really exists.... This dos function takes anything
    and who knows what it will do with junk?}
  assign(testfile,fname);
  {$I-}
  reset(testfile,1);
  {$I+}
  holdresult:=ioresult;
  case holdresult of
       0 : close(testfile); {don't forget to release that file handle!}
                            {took me 3 hours to find this bug........ }
       2 : writeln('File not found ---> ',fname);
       3 : writeln('Path not found ---> ',fname);
{      5 : writeln('Access denied  ---> ',fname);  that's ok - it's out there}
{ so we'll just let the program say no error on reset                        }
       5 : holdresult := 0;
       6 : writeln('Invalid handle ---> ',fname);
       8 : writeln('Not enough ram ---> ',fname);
      11 : writeln('Invalid format ---> ',fname);
  else
      writeln('Unknown error #',holdresult:3,' on open of ',fname);
  end;
  if holdresult = 0 then
    valid_file_name := true
  else
    valid_file_name := false;
end;

function spool_a_file(Filestring:string):boolean;
var
   Regs : Registers;
   Fname : array[1..64] of byte;
   TheFile : record
                   Byt  : Byte;
                   Loc  : array[1..2] of Word;
             end;
   i:integer;
begin;
  FileString := FileString+#0;
  FillChar(Fname, 64, #0);
  for i := 1 to Length(FileString) do
    Fname[i] := ord(FileString[i]);
  TheFile.Byt := 0;
  TheFile.Loc[2] := Seg(Fname);
  TheFile.Loc[1] := Ofs(Fname);

  if (not valid_file_name(filestring)) then
    begin
      spool_a_file:=false;
      exit;
    end;

  with Regs do
        begin
           AH:=$1;
           AL:=$1;
           DS:=Seg(TheFile);
           DX:=Ofs(TheFile);
        end;
  Intr($2F, Regs);
  if Regs.Flags AND FCarry = FCarry then
     spool_a_file := false
  else
     spool_a_file := true;
end;

function unspool_a_file(Filestring:string):boolean;
var
   Regs : Registers;
   Fname : array[1..64] of byte;
   i:integer;
begin
   FileString := FileString+#0;
   FillChar(Fname, 64, #0);
   for i:= 1 to Length(FileString) do
       Fname[i] := ord(FileString[i]);

   if not valid_file_name(filestring) then
      begin
        unspool_a_file:=false;
        exit;
      end;
   if queue_empty then
      begin
        unspool_a_file:=false;
        exit;
      end;
   if not fileinqueue(copy(filestring,1,length(filestring)-1)) then
      begin
        unspool_a_file:=false;
        exit;
      end;

   with Regs do
       begin
         AH:=$1;
         AL:=$2;
         DS:=seg(fname);
         DX:=ofs(fname);
       end;
   Intr($2F, Regs);
   if Regs.Flags AND FCarry = FCarry then
      unspool_a_file := false
   else
      unspool_a_file := true;
end;

function unspool_all_files:boolean;
var
  Regs : Registers;
begin
  Regs.AH := $1;
  Regs.AL := $3;
  Intr($2F, Regs);
  if Regs.Flags AND FCarry = FCarry then
     unspool_all_files := false
  else
     unspool_all_files := true;
end;

{delete the filelist}
procedure deletesfilelist;
var tnode:slistptr;
    tnode2:slistptr;
begin
  tnode:=sfilelist;
  while tnode <> nil do
    begin
      tnode2:=tnode;
      tnode:=tnode^.next;
      dispose(tnode2);
    end;
  sfilelist:=nil;
  endofsfilelist:=nil;
  numsfilesinlist:=0;
end;

{create a list of files on spooler from a fileset with wildcards}
procedure getspoolfilelist(fileset:string);
var
  tnode:slistptr;
  i,k:integer;
  filename:string;
  regs:registers;
  queue:qpointer;
begin
  numsfilesinlist:=0;
  sfilelist:=nil;                {start with no files}
  endofsfilelist:=nil;

  {freeze queue and get pointer to queue}
  Regs.AH:=$1;
  Regs.AL:=$4;
  Intr($2F, Regs);
  if Regs.Flags AND FCarry = FCarry then
     exit
  else
     queue:=ptr(regs.ds,regs.si);

  {put files from queue into qarray}
  i:=1;
  while (queue^[i,1] <> $00) and (i < 33) do   {load queue}
    begin
      k:=1;
      filename:='';
      while queue^[i,k] <> $00 do
        begin
          filename:=filename+chr(queue^[i,k]);
          k:=k+1;
        end;
      new(tnode);
      endofsfilelist^.next:=tnode;
      with tnode^ do
        begin
          next:=nil;
          fname:=filename;
        end;
      if sfilelist = nil then   {if start of list point filelist to it}
         sfilelist:=tnode;
      endofsfilelist:=tnode;
      numsfilesinlist:=numsfilesinlist+1;
      i:=i+1;
    end;

  {unfreeze queue}
  Regs.AH := $1;
  Regs.AL := $5;
  Intr($2F, Regs);
{
  if Regs.Flags AND FCarry = FCarry then
     exit;
}
end;

function look4file(fname:string):byte;
var res:boolean;
begin
  res:=fileinqueue(fexpand(fname));
  if res then
     begin
       some_in_q:=true;
       look4file:=$69;  {force error condition so search will end}
     end
  else
     look4file:=0;
end;

function filesetinqueue(searchname:string):boolean;
var dummy:byte;

begin
   some_in_q:=false;
   searchname:=fexpand(searchname);
   searchdirectory(searchname,
                   look4file,
                   anyfile-directory,
                   false,
                   false,
                   dummy);
   filesetinqueue:=some_in_q;
end;

begin
   print_not_installed:=(not print_installed);
end.
