{******************************************************************************
Unit:  POST                               Language:  Turbo Pascal
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:  Provides POST graphics device driver mode values, auto
					detection routine, and installation procedures.
Calling Sequence:  uses POST;
Where Located:  POST UNIT
******************************************************************************}
unit Post;

interface
uses
	Graph;

{$F+}
function PostDetect:integer;
function PostInstall:integer;
procedure PostSetFont(font,size:integer);
procedure PostSwap;
{$F-}

const

	ModeCRT		= $80;					{ CRT output						}
	ModeCOM		= $40;					{ serial output					}
	ModePRN		=	0;						{ parallel output				}
	ModeLAND	= $20;					{ landscape, full page	}
	ModePORT	=	0; 						{ portrait, full page		}
	ModePRO   = $1C;    			{ PRO 64000 x 35000     }
	ModeVGA		= $10;					{ VGA 640 x 480 				}
	ModeEGA		= $08;					{ EGA 640 x 350 				}
	ModeCGA		= $04;					{ CGA 640 x 200 				}
	Mode72P   = 0;        		{ 72 POINT 612 x 792    }
	ModeTOP		= $02;					{ upper half page				}
	ModeBOT		= $01;					{ lower half page				}
	ModeCEN   = 0;						{ center                }

	Courier							= 1;	{ Courier Font Number		}
	CourierBold					= 2;	{ Courier Bold					}
	CourierOblique			= 3;	{ Courier Italic				}
	CourierBoldOblique	= 4;	{ Courier Bold Italic		}
	Times								= 5;	{ Times Font Number			}
	Helvetica						= 9;	{ Helvetica	Font Number	}
	Symbol							=	13;	{	Symbol Font Number		}

var
	PostFontNumber:integer;		{ current font					}
	PostFontSize:integer;			{ current font size			}
	PostInstalled:boolean;		{ installed flag				}
	PostMode:integer;					{ current mode					}
	PostPath:string;					{ current path					}

implementation

{******************************************************************************
Function:  PostDetect                     Language:  Turbo Pascal
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Driver auto detection routine returns default mode.
					Default mode can be set prior to installation by changing
					PostMode variable contents.
Calling Sequence:	mode := PostDetect;
Where Located:  POST UNIT
Input:	none
Output:	none
Returns:	default graphics mode
******************************************************************************}
function PostDetect:integer;
begin
	PostDetect := PostMode;		{return mode}
end;

{******************************************************************************
Function:  PostInstall                    Language:  Turbo Pascal
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Installs POST graphics driver using current defaults:
					PostMode and PostPath.  This routine currently halts on
					error detection.
Calling Sequence:		PostMode := current mode;
										PostPath := current path;
										status := PostInstall;
Where Located:  POST UNIT
Input:	none
Output:	none
Returns:	installation status
******************************************************************************}
function PostInstall:integer;
var
	GraphDriver:integer;				{graphics type}
	GraphMode:integer;					{graphics mode}
	GraphStatus:integer;				{graphics status}
begin
	GraphDriver := InstallUserDriver('POST',@PostDetect);	{install}
	GraphStatus := GraphResult;										{get status}
	if (GraphStatus <> 0)													{failed ?}
	then begin																		{yes}
		writeln(GraphErrorMsg(GraphStatus));				{report}
		end
	else begin																		{passed}
		GraphDriver := DETECT;											{auto detection}
		InitGraph(GraphDriver,GraphMode,PostPath);	{initialize}
		GraphStatus := GraphResult;									{get status}
		if (GraphStatus <> 0)												{failed ?}
		then begin																	{yes}
			writeln(GraphErrorMsg(GraphStatus));			{report}
		end;
	end;
	PostInstalled := TRUE;												{enabled}
	PostInstall := GraphStatus;										{okay}
end;

{******************************************************************************
Function:  PostSetFont                    Language:  Turbo Pascal
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Select new font and size.

					NOTE:  	This procedure only works when current font is the
									system DefaultFont (see SetTextStyle).

Calling Sequence:		PostSetFont(font,size:integer);
Where Located:  POST UNIT
Input:	font:integer - font number
				size:integer - font size
Output:	none
Returns:	none
******************************************************************************}
procedure PostSetFont(font,size:integer);
begin
	SetUserCharSize(font,size,size,0);		{setup font and point size}
	PostFontNumber := font;								{save font number}
	PostFontSize := size;									{save font size}
end;

{******************************************************************************
Function:  PostSwap                       Language:  Turbo Pascal
Revision:  1.0 JJN 07-26-90 ORIGINAL GENERATION
Responsible Engineer:  John J. Novak

	Copyright1 = 'Copyright (c) 1990 - Heuristic Solutions, Inc.';
	Copyright2 = '720 E. Main St. CS-1007, Moorestown, NJ  08057';

Date Started:	07-26-90
Date Tested:	07-26-90
Purpose:	Swap pages between ModeTOP and ModeBOT.
Calling Sequence:	PostSwap;
Where Located:  POST UNIT
Input:	none
Output:	none
Returns:	none
******************************************************************************}
procedure PostSwap;
begin
	if (PostMode AND (ModeBOT OR ModeTOP)) <> 0
	then ClearDevice;						{swap two page mode}
end;

{$F-}
begin
	PostFontNumber := 0;									{zero font number}
	PostFontSize := 0;										{zero font size}
	PostMode := 0;												{default mode}
	PostPath := '';												{default path}
	PostInstalled := FALSE;								{disable}
end.
