unit ipx;
{
continued by: joejared@webworldinc.com (Joe Jared)

v1.01:	Corrected procedure for ipxinit.  Now you check to see if you
have a socket BEFORE you try to use it.

Thanks to Ralf Brown and Christoph Weller for better documentation and DPMI
interfacing.


Due to the requirement of properly installing VIPX drivers in windows, I haven't
even tried to interface it, but half of the work is done.
}

interface

uses
	dos,

{$ifdef DPMI}
	Winapi,
{$endif}
	dpmiunit;


type



	netAddr  = array[1..4] of byte;    { The address of a network }

	nodeAddr = array[1..6] of byte;    { The address of a node in a network }

	address  = array[0..1] of word;    { A pointer to the data 0=offset 1=seg }

	netAddress = record
		Net    : netAddr;   { network address }
		Node   : nodeAddr;  { node address }
		Socket : word;      { Big endian socket number}
		end;

	localAddrT = record
		Net    : netAddr;   { my network address }
		Node   : nodeAddr;  { my node address }
		end;

	ECBType = record
		link      : address;    { Pointer to next ECB? }
		ESR       : address;    { Event Service Routine 00000000h if none }
		inUse     : byte;       { In use flag }
		complete  : byte;       { Completeing flag }
		socket    : word;       { Big endian socket number }
		IPXwork   : array[1..4] of byte;  { IPX work space }
		Dwork     : array[1..12] of byte; { Driver work space }
		immedAddr : nodeAddr;   { Immediate local node address }
		fragCount : word;       { Fragment count }
		fragData  : address;    { Pointer to data fragment }
		fragSize  : word;       { Size of data fragment }
		end;

	IPXheader = record
		check  : word;                { big endian checksum }
		length : word;                { big endian length in bytes }
		tc     : byte;                { transport control }
		pType  : byte;                { packet type }
		dest   : netAddress;          { destination network address }
		src    : netAddress;          { source network address }
		end;


const

	MYSOCKET  : word = $2104; { Default socket number for communications}


	BROADCAST : nodeAddr = ($ff,$ff,$ff,$ff,$ff,$ff);  { Address for broadcast }

var
	localAddr    : ^localAddrT;
	{Required for DPMI compatibility.  Mr. IPX doesn't like to talk to memory
	above 1 MEG.}

function  IPXopenSocket(longevity : byte; var socketNumber : word):byte;
{#F}
{--------N-7A----BX0000-----------------------


longevity
	00h open until close or terminate
	FFh open until close


SocketNumber
	0000h dynamic allocation
	else  socket to open

Function returns one of the following:

	00h Successful
	FEh socket table full
	FFh socket already open

}
{#F}

{

TSRs which need to use sockets should set AL to FFh, non-resident
programs should normally use AL=00h IPX can be configured to support up
to 150 open sockets on a workstation, and defaults to 20 this function
is supported by Advanced NetWare 1.02+

Refer to Ralf Browns list for used socket numbers.

SeeAlso: INT 7A/BX=0023h


}
{#X IPXcloseSocket IPXlistenForPacket}

procedure IPXcloseSocket(socketNumber : word);
{#F}
{--------N-7A----BX0001-----------------------}
{#F}
{
socketnumber is the requested ipx socket to close.


DX = socket number (high byte in DL) (see #2936)

also cancels events set by any Event Control Blocks for the socket
the program must close all open sockets before terminating
this function is supported by Advanced NetWare 1.02+

}

{#X IPXopenSocket}

procedure IPXsendPacket(var E : ECBtype);
{--------N-7A----BX0003-----------------------}

{
Returns immediately; IPX attempts to send the packet in the background
this function is supported by Advanced NetWare 1.02+ this function is
nearly identical to BX=000Fh, except that it always copies the source
address into the IPX header assumed to be at the beginning of the first
fragment
}
{#X IPXlistenForPacket}


function  IPXlistenForPacket(var E : ECBtype):byte;
{#F}

{--------N-7A----BX0004-----------------------

E Event Control Block

Returns:
00h successful
FFh no listening socket for packet

}
{#F}

{
This function provides IPX with an ECB for receiving an IPX packet, but
does not wait for a packet to arrive

The application must open a socket and initialize the ECB's ESR address,
socket number, fragment count, and fragment descriptor fields before
invoking this function there is no limit on the number of ECBs which may
simultaneously be listening on a socket this function is supported by
Advanced NetWare 1.02+

}

{#X IPXopenSocket IPXsendPacket}

procedure GetLocalAddress;

{#F}
{--------N-7A----BX0009-----------------------}
{#F}

{

Gets the local machine address and stores it in localAddr

See Also: BX=0002h,BX=000Bh

}
{#F}
{
Format of IPX internetwork address:
Offset  Size    Description (Table 2950)
 00h  4 BYTEs   (big-endian) network number
 04h  6 BYTEs   (big-endian) node number within network

}
{#F}

{#X localAddr}

procedure ImIdle;
{#F}
{--------N-7A----BX000A-----------------------

IPX Driver - RELINQUISH CONTROL
}

{#F}
{
This call indicates that the application is idle and permits the IPX
driver to do some work.   This function is supported by Advanced NetWare 1.02+


SeeAlso: INT 15/AX=1000h,INT 21/AH=89h,INT 2F/AX=1680h
}

{#F}
procedure InitSendPacket(var ecb : ecbType; var ipx : ipxHeader; size,sock : word);
{Constructs and preinitializes Transmission packet.  Required before usage.}
procedure InitReceivePacket(var ecb : ecbType; var ipx : ipxHeader; size,sock : word);
{Constructs and preinitializes reception packet.  Required before usage.}
function IPXinstalled:boolean;
{
This should be run prior to all other routines.  Don't try to walk through doors
without first seeing if it is one.
}

{
Test to make sure it's there _before_ we try to use it.
}
procedure done;

{

Just your usual cleanup....

Destroys localaddr pointer


}
{#X localaddr}
procedure init;
{
Initializes localaddr pointer

}
{#X localaddr}


implementation

function IPXopenSocket(longevity : byte; var socketNumber : word):byte;
var
	regs : registers;

begin
	regs.bx:=$0000;
	regs.al:=longevity;
	regs.dx:=swap(socketNumber);

	Callintr($7A,regs);
	if socketNumber=$0000 then socketNumber:=swap(regs.dx);

	IPXopenSocket:=regs.al;
end;

{ Close a socket
  PARMS:  socketNumber = a socket to close }

procedure IPXcloseSocket(socketNumber : word);
var
  regs : registers;

begin
  regs.bx:=$0001;
  regs.dx:=swap(socketNumber);

  callintr($7A,regs);
end;

procedure GetLocalAddress;
var
  regs : registers;

begin
	regs.bx:=$0009;

	regs.es:=seg(localAddr^);

	regs.si:=ofs(localAddr^);

	callintr($7A,regs);

end;


procedure IPXsendPacket(var E : ECBtype);
var
  regs : registers;

begin

	regs.bx:=$0003;
	regs.es:=seg(E);
	regs.SI:=ofs(E);
	callintr($7A,regs);


end;





function IPXlistenForPacket(var E : ECBtype):byte;
var
  regs : registers;

begin
	regs.bx:=$0004;
	regs.es:=seg(E);
	regs.SI:=ofs(E);
	callintr($7A,regs);
	IPXlistenForPacket:=regs.al;
end;

{ Tell the IPX driver that we aren't doing anything at the moment }
procedure ImIdle;
var
  regs : registers;

begin
  regs.bx:=$000A;
  callintr($7A,regs);

end;

{ Set up the fields in a send IPX record }
procedure InitSendPacket(var ecb : ecbType; var ipx : ipxHeader; size,sock : word);
begin
	fillChar(ecb,sizeOf(ecb),#0);
	fillChar(ipx,sizeOf(ipx),#0);
	with ecb do begin
		socket:=swap(sock);               { Big endian socket number }
		fragCount:=1;                     { Fragment count }
		fragData[0]:=ofs(IPX);            { Pointer to data fragment }
{$ifdef DPMI}
		fragData[1]:=(getselectorbase (seg(IPX)) shr 4);
{$else}
		fragData[1]:=seg(IPX);
{$endif}
		fragSize:=sizeof(IPX)+size;       { Size of data fragment }
		immedAddr:=BROADCAST;             { Needs to be BROADCAST?? }
		end;


	with ipx do begin
		check:=$ffff;                     { NO CHECKSUM }
		ptype:=0;                         { Packet exchange packet }
		dest.net:=localAddr^.net;          { Send to this network }
		dest.node:=BROADCAST;             { Send to everybody! }
		dest.socket:=swap(sock);          { Send to my socket }
		src.net:=localAddr^.net;           { From this net }
		src.node:=localAddr^.node;         { From ME }
		src.socket:=swap(sock);           { From my socket }
		end;
end;

{ Set up the fields in a recieve IPX record }
procedure InitReceivePacket(var ecb : ecbType; var ipx : ipxHeader; size,sock : word);
begin
  fillChar(ecb,sizeOf(ecb),#0);
  fillChar(ipx,sizeOf(ipx),#0);
  with ecb do begin
	inUse:=$1d;                               { ???? }
	socket:=swap(sock);                       { Big endian socket number }
	fragCount:=1;                             { Fragment count }
	fragData[0]:=ofs(IPX);                    { Pointer to data fragment }

{$ifdef DPMI}
	fragData[1]:=(getselectorbase (seg(IPX))shr 4);

{$ELSE}
	  fragData[1]:=seg(IPX);

{$ENDIF}

	fragSize:=sizeof(IPX)+size;               { Size of data fragment }
	end;

	if IPXlistenForPacket(ecb)<>0 then ;          { Tell IPX to listen }
end;

{ Set up IPX and get the local address }
{define test}


function IPXinstalled:boolean;
var
	i    : integer;
	regs : registers;
	ipinstalled	: boolean;
	s: string;


begin
	regs.ax:=$7A00;
	callintr($2f,regs);
	if regs.al<>255 then ipinstalled := false
	else begin
		ipinstalled := true;
		getLocalAddress;
		end;
	ipxinstalled := ipinstalled;

end;

procedure init;

begin
{$ifdef DPMI}
	localaddr := ptr(globaldosalloc(sizeof(localaddr^)),0);
{$ELSE}
	 getmem(localAddr,sizeof(localAddr^));
{$ENDIF}

end;

procedure done;
begin
{$ifdef DPMI}
	globaldosfree(seg(localaddr^));
{$ELSE}
	freemem(localAddr,sizeof(localAddr^));
{$ENDIF}

end;

end.
