unit DPMIunit;

interface

uses

{$IFDEF DPMI}
	WINAPI,
{$ENDIF}
	dos;

type

  DPMIRegisters = record
	  DI,SI,BP,
	  Reserved,
	  BX,DX,CX,AX  : LongInt;
	  Flags,
	  ES,DS,FS,GS,
	  IP,CS,SP,SS  : Word;
	end;
  { DPMI-Registers }



{$IFDEF DPMI}

function SimulateRealIntr(Interrupt : Byte;var Regs : DPMIRegisters):boolean;

{$ENDIF}

function CallIntr(intnum: byte;var Regs : Registers):boolean;

implementation

{$IFDEF DPMI}

function SimulateRealIntr(Interrupt : Byte;var Regs : DPMIRegisters):boolean;

var
  RealCall : Registers;

begin
	{ Clear the Registers }
	FillChar(RealCall, SizeOf(RealCall), 0);
	with RealCall do begin
		AX := $0300;      { Interrupt                     }
		BX := Interrupt;  { Interrupt to call             }
		CX := 0;          { 0 Byte Stack to copy          }
		ES := Seg(Regs);  { ES:DI points to the Registers }
		DI := Ofs(Regs);
		end;
	Intr($31, RealCall); { Call Interrupt                }
	SimulateRealIntr := true; {!!! stupid !!!}
end;




{$ENDIF}

function CallIntr(intnum: byte;var Regs : Registers):boolean;

var
{$IFDEF DPMI}
  DPMIRegister  : DPMIRegisters;  { DPMIRegisters  }
{$ELSE}
  {$IFDEF WINDOWS}
  NovRegs       : TRegisters;     { Windows TRegisters }
  {$ELSE}
  NovRegs       : Registers;      { DOS-Registers }
  {$ENDIF}
{$ENDIF}

begin
{$IFDEF DPMI}
{ Protected Mode Interrrupt Call }
	CallIntr := false;
	FillChar(DPMIRegister, SizeOf(DPMIRegister), 0); { Clear the Registers }

	with DPMIRegister do begin
		AX := Regs.AX;  { Copy Registers }
		BX := Regs.BX;
		CX := Regs.CX;
		DX := Regs.DX;
		if regs.es <>0 then es := (GetSelectorBase(regs.es) shr 4);

		si 	:= regs.si;
		di 	:= regs.di;
		end;

	if SimulateRealIntr(intnum, DPMIRegister) then begin
		{ Call Real Mode Interrupt }

		CallIntr := true;
		with Regs do begin
			AX := DPMIRegister.AX; { Copy Registers back }
			BX := DPMIRegister.BX;
			CX := DPMIRegister.CX;
			DX := DPMIRegister.DX;
			ES := DPMIRegister.ES;
			DS := DPMIRegister.DS;
			SI := LoWord(DPMIRegister.SI);
			end;
		end
	else begin
		FillChar(Regs, SizeOf(Regs), 0); { If error fill Registers with Zero }
	end;

{$ELSE} { Real Mode/Windows Call }
	Move(Regs, NovRegs, SizeOf(Regs));      { Copy Registers down }
	Intr(intnum, NovRegs);
	Move(NovRegs, Regs, SizeOf(NovRegs));   { Copy Registers back }
	{$ENDIF}
end;





end.
