program CHAT;

{$M 8192,0,50000}
uses
	CRT,
{$ifdef DPMI}
	winapi,
	{dpmiunit,}
{$endif}

	IPX;

type
	Packet = record
		ecb  : ECBType;
		IPX  : IPXheader;
		data : string;
		end;


{$ifdef DPMI}
{$D DOS, and protected mode IPX chat}
{$ENDIF}


var
  GDsend,GDreceive	: longint;
  Send,Receive: ^Packet;	  {Protected mode pointers}

procedure Main;

var

  line   : string;
  y      : integer;
  done   : boolean;
  k      : char;
  i      : integer;
  handle : string;

begin
	ClrScr;

	writeln('IPX chat');
	if paramcount<1 then begin
		writeln;
		write('Enter your Name:');
		readln(handle);
		end
	else handle := paramstr(1);

	window(1,1,80,23);
	textBackground(Blue);
	textColor(Yellow);

	clrScr;
	window(1,24,80,25);
	textBackground(Red);
	textColor(Yellow);

	clrScr;
	y:=1;
	line:='';
	done:=FALSE;

	send^.data:=handle+ ' has joined chat';
	with send^.ecb do for i:=1 to 6 do ImmedAddr[i]:=$ff;
	repeat until send^.ecb.inuse=0;
	IPXsendPacket(send^.ecb);

	repeat
		repeat until KeyPressed or (receive^.ecb.inuse=0);

		if receive^.ecb.inuse=0 then begin

			window(1,1,80,23);
			gotoXY(1,y);
			textBackground(Blue);
			textColor(Yellow);
			writeln(receive^.data);

			y:=WhereY;
			if IPXlistenForPacket(receive^.ecb)<>0 then begin
				writeln(#7,'ERROR TRYING TO receive A PACKET!');
				halt(2);
				end;

			window(1,24,80,25);
			GotoXY(1,length(line)+1);

		end;

		if KeyPressed then begin
			k:=ReadKey;
			case k of
				#13 : if line<>'' then begin
					send^.data:=handle+' '+line;
						with send^.ecb do for i:=1 to 6 do ImmedAddr[i]:=$ff;

					repeat until send^.ecb.inuse=0;

					IPXsendPacket(send^.ecb);
					line:='';
					end;

		  #8  : if length(line)>0 then dec(line[0]);

		  #0  : k:=ReadKey;

		  #27 : begin
				send^.data:=handle+' has left chat.';
				with send^.ecb do for i:=1 to 6 do ImmedAddr[i]:=$ff;
				repeat until send^.ecb.inuse=0;
				IPXsendPacket(send^.ecb);

				done:=TRUE;
				end;
		else
		  if length(line)<79 then
			line:=line+k
		  else
			begin
			  sound(1000);
			  delay(100);
			  noSound;

			end;
		end;

		window(1,24,80,25);
		textBackground(white);
		textColor(black);
		GotoXY(1,1); clreol; write(line);

	  end;
  until done;


end;

begin
	ipx.init;

	if ipxinstalled then begin
		if IPXopenSocket(0,MYSOCKET)=0 then begin

{$ifdef DPMI}
			{Make sure the buffers are in stupid dos memory!}
			GDsend := globaldosalloc(sizeof(send^));
			send := ptr(loword(GDsend),0);

			GDreceive := globaldosalloc(sizeof(receive^));
			receive := ptr(loword(GDreceive),0);
{$ELSE}
			getmem(Send,sizeof(send^));
			getmem(receive,sizeof(receive^));
{$endif}

			with send^ do InitSendPacket(ecb,ipx,sizeof(String),MYSOCKET);
			with receive^ do InitReceivePacket(ecb,ipx,sizeof(String),MYSOCKET);


			Main;

			IPXcloseSocket(MYSOCKET);
			TextColor(LightGray);
			TextBackground(Black);
			window(1,1,80,25);
			clrScr;


{$ifdef DPMI}
			globaldosfree(loword(GDsend));
			globaldosfree(loword(GDreceive));
{$ELSE}
			freemem(send,sizeof(send^));
			freemem(receive,sizeof(receive^));
{$endif}

			end;



		end
	else Writeln ('No IPX driver detected');

	ipx.done;



end.

