unit Smartdrv;
{#M}
{
Purpose: To allow the cache buffers to be flushed if Smart drive is loaded.
Real/DPMI version.
}

{#M}

interface

function chksmartdrv:boolean;{$ifdef DPMI} export;  {$ENDIF}
procedure flushcache; {$ifdef DPMI} export;  {$ENDIF}

implementation


uses
	crt,
	dos,
	dpmiunit;



var

	sdinstalled	: boolean;
	{Quick and dirty Smartdrive detection}



function chksmartdrv:boolean;
var
	treg	: registers;
begin
	with treg do begin
		ax := $4a10;
		bx := 0;
		end;

	callintr($2f,treg);

	if treg.ax = $babe then sdinstalled := true else sdinstalled := false;

	chksmartdrv := sdinstalled;

end;

procedure flushcache;
var
	tregs : registers;

begin
	if sdinstalled then with tregs do begin
		ax := $4a10;
		bx := 1;
		callintr ($2f,tregs);
		end;
end;


begin
	if chksmartdrv then begin
		writeln ('DPMI Cache flusher installed');
		end;


end.

