Program PlayAudioCD;

{

  Description: Turbo Pascal for Windows program to play an audio CD ROM disc on a CD ROM READER.
               The program as it stands now is a bare-bones program to get a TPW 1.5 program to
               talk to a CD ROM player to play a music disk using the multimedia features of Win31.
               I had to spend a little time digging and converting the reference manual
               examples (manual mentioned below) from C to Turbo Pascal. I had looked for this
               starting point in the Compuserve forum for TPW, but didn't find anything. So, I 
               thought maybe someone else might appreciate this... Any feedback would be welcome.

               In each routine, a running dialog of what is going on is being written via WRITELN.
               They are not pretty, but are there strictly for debugging purposes...

  Date.......: September 7, 1992

  Author.....: Mark C. Paxton

  Environment: CompuAdd 433 (486 33mHz) 8MB RAM with a NEC CDR-37 CD ROM Reader (developed here)
               also tested on an IBM PS-2 Utimedia M57SLC 8MB RAM (internal CD ROM Reader)
               Windows 3.1 TPW 1.5

  Reference..: Microsoft Windows MultiMedia Programmer's Workbook

}

Uses
  WinCrt,      { Well, I did say it was bare bones...}
  Strings,
  WinProcs,
  WinTypes,
  MMSystem;    { Multimedia stuff located here... }

Var
  FileName                   : Array[0..65] of Char;
  wDeviceId                  : Word;
  StartTrack,                
  EndTrack                   : Byte;
  ReturnValCode              : Integer;
  numberOfTracks             : LongInt;

{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
function GetErrorMessage(RC:LongInt):String;

Const
 ErrorMessageLength          = 128;
Var
  lpstrBuffer                : Array[0..ErrorMessageLength] of Char;
  ErrorString                : String;
  I                          : Integer;

begin

 For I := 0 to ErrorMessageLength do lpstrBuffer[I]:= ' ';
 GetErrorMessage:='No Message was found.';

 If mciGetErrorString( RC,PChar(@lpstrBuffer),ErrorMessageLength ) then
    begin
      ErrorString:=StrPas(lpstrBuffer);
      GetErrorMessage:=ErrorString;
    end;

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure OpenCD;

{  MCI_OPEN_PARMS = record
    dwCallback: Longint;
    wDeviceID: Word;
    wReserved0: Word;
    lpstrDeviceType: PChar;
    lpstrElementName: PChar;
    lpstrAlias: PChar;
  end; }

Var
  MCI_OPEN_PARMS             : TMCI_Open_Parms;
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_OPEN_PARMS.dwCallback := 0;
  MCI_OPEN_PARMS.wReserved0 := 0;
  MCI_OPEN_PARMS.lpstrDeviceType := nil;
  MCI_OPEN_PARMS.lpstrAlias      := nil;
  MCI_OPEN_PARMS.wDeviceId:=0;
  MCI_OPEN_PARMS.lpstrElementName:=NIL;
  MCI_OPEN_PARMS.lpstrDeviceType:=PChar(MCI_DEVTYPE_CD_AUDIO);

  RC:=mciSendCommand( 0,
                      MCI_OPEN,
                      MCI_OPEN_TYPE or MCI_OPEN_TYPE_ID,
                      Longint(@MCI_OPEN_PARMS));

  wDeviceId:=MCI_OPEN_PARMS.wDeviceId;
  Writeln('CD assigned as device (wDeviceId) = ',wDeviceId);

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to open CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    HALT(0);
  end;

  WriteLn('CD Opened Successfully');

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure CloseCD;
Var
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  RC:=mciSendCommand( wDeviceId,
                      MCI_CLOSE,
                      0,
                      0);
  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to close CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    HALT(0);
  end;

  WriteLn('CD Closed Successfully');

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
Procedure SetMSFasFormat;
{
 TMCI_Set_Parms = record
    dwCallback: Longint;
    dwTimeFormat: Longint;
    dwAudio: Longint;
  end;
}

Var
  MCI_SET_PARMS              : TMCI_Set_Parms;
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_SET_PARMS.dwCallback := 0;
  MCI_SET_PARMS.dwTimeFormat := MCI_FORMAT_MSF;
  MCI_SET_PARMS.dwAudio := 0;

  RC:=mciSendCommand( wDeviceId,
                      MCI_SET,
                      MCI_SET_TIME_FORMAT,
                      Longint(@MCI_SET_PARMS));

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to set MSF Format on the CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    CloseCD;
    HALT(0);
  end;

  WriteLn('CD Set MCI FORMAT MSF Successful');

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
Procedure SetTMSFasFormat;
{
 TMCI_Set_Parms = record
    dwCallback: Longint;
    dwTimeFormat: Longint;
    dwAudio: Longint;
  end;
}

Var
  MCI_SET_PARMS              : TMCI_Set_Parms;
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_SET_PARMS.dwCallback := 0;
  MCI_SET_PARMS.dwTimeFormat := MCI_FORMAT_TMSF;
  MCI_SET_PARMS.dwAudio := 0;

  RC:=mciSendCommand( wDeviceId,
                      MCI_SET,
                      MCI_SET_TIME_FORMAT,
                      Longint(@MCI_SET_PARMS));

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to set TMSF Format on the CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    CloseCD;
    HALT(0);
  end;

  WriteLn('CD Set MCI FORMAT TMSF Successful');

end;
{---------------------------------------------------------------------------------------------}


{---------------------------------------------------------------------------------------------}
procedure PlayCD(StartTrack,EndTrack:Byte);

{ TMCI_Play_Parms = record
    dwCallback: Longint;
    dwFrom: Longint;
    dwTo: Longint;
  end; 
}

Var
  MCI_SET_PARMS              : TMCI_Set_Parms;
  MCI_PLAY_PARMS             : TMCI_Play_Parms;
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_PLAY_PARMS.dwFrom := 0;
  MCI_PLAY_PARMS.dwTo   := 0;
  MCI_PLAY_PARMS.dwFrom := MCI_MAKE_TMSF(StartTrack,0,0,0);
  MCI_PLAY_PARMS.dwTo   := MCI_MAKE_TMSF(EndTrack,  0,0,0);

  RC:=mciSendCommand( wDeviceId,
                      MCI_PLAY,
                      MCI_FROM OR MCI_TO ,
                      Longint(@MCI_PLAY_PARMS));

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to play the CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    CloseCD;
    HALT(0);
  end;

  WriteLn('CD Set MCI FORMAT TMSF Successful');


end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure GetNumberTracks;
{
  TMCI_Status_Parms = record
    dwCallback: Longint;
    dwReturn: Longint;
    dwItem: Longint;
    dwTrack: Longint;
  end;
}
Var
  MCI_STATUS_PARMS           : TMCI_Status_Parms;
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_STATUS_PARMS.dwCallback := 0;
  MCI_STATUS_PARMS.dwReturn   := 0;
  MCI_STATUS_PARMS.dwItem     := MCI_STATUS_NUMBER_OF_TRACKS;
  MCI_STATUS_PARMS.dwTrack    := 0;

  RC:=mciSendCommand( wDeviceId,
                      MCI_STATUS,
                      MCI_STATUS_ITEM,
                      Longint(@MCI_STATUS_PARMS));

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to Retrieve Number of Tracks from CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    CloseCD;
    HALT(0);
  end;

  numberOfTracks:=MCI_STATUS_PARMS.dwReturn;
  WriteLn('The number of tracks found = ',numberOfTracks);

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure GetTrackInfo;
{- Track information is stated in minutes and seconds relative to the beginning of the disc. The
   durations of each song can be constructed by subtracting the begin time of a song from the
   begin time of the previous song. }
{
  TMCI_Status_Parms = record
    dwCallback: Longint;
    dwReturn: Longint;
    dwItem: Longint;
    dwTrack: Longint;
  end;
}
Var
  MCI_STATUS_PARMS           : TMCI_Status_Parms;
  RC                         : LongInt;
  I                          : Integer;
  MSF                        : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  For I:=1 to numberOfTracks do begin

    MCI_STATUS_PARMS.dwTrack    := I;
    MCI_STATUS_PARMS.dwCallback := 0;
    MCI_STATUS_PARMS.dwReturn   := 0;
    MCI_STATUS_PARMS.dwItem     := MCI_STATUS_POSITION;

    RC:=mciSendCommand( wDeviceId,
                        MCI_STATUS,
                        MCI_STATUS_ITEM or MCI_TRACK,
                        Longint(@MCI_STATUS_PARMS));

    If RC<>0 then begin
      Str(RC:5,aString);
      aString:='Return Code: '+aString;
      aString:=aString+'. Failure to get track information from the CD. Error Message: '+GetErrorMessage(RC);
      StrPCopy(MessageText, aString);
      MessageBox(0, MessageText, 'General Information', mb_OK);
      CloseCD;
      HALT(0);
    end;

    MSF:=MCI_STATUS_PARMS.dwReturn;
    WriteLn('Track ',I,' starting position -',
             ' Minutes: ',MCI_MSF_MINUTE(MSF),
             ' Seconds: ',MCI_MSF_SECOND(MSF),
             ' Frame:   ',MCI_MSF_FRAME(MSF));
  end;

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure GetLengthOfEachTrack;
{
  TMCI_Status_Parms = record
    dwCallback: Longint;
    dwReturn: Longint;
    dwItem: Longint;
    dwTrack: Longint;
  end;
}
Var
  MCI_STATUS_PARMS           : TMCI_Status_Parms;
  RC                         : LongInt;
  I                          : Integer;
  MSF                        : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  For I:=1 to numberOfTracks do begin

    MCI_STATUS_PARMS.dwTrack    := I;
    MCI_STATUS_PARMS.dwCallback := 0;
    MCI_STATUS_PARMS.dwReturn   := 0;
    MCI_STATUS_PARMS.dwItem     := MCI_STATUS_LENGTH;

    RC:=mciSendCommand( wDeviceId,
                        MCI_STATUS,
                        MCI_STATUS_ITEM or MCI_TRACK,
                        Longint(@MCI_STATUS_PARMS));

    If RC<>0 then begin
      Str(RC:5,aString);
      aString:='Return Code: '+aString;
      aString:=aString+'. Failure to get track length information from the CD. Error Message: '+GetErrorMessage(RC);
      StrPCopy(MessageText, aString);
      MessageBox(0, MessageText, 'General Information', mb_OK);
      CloseCD;
      HALT(0);
    end;

    MSF:=MCI_STATUS_PARMS.dwReturn;
    WriteLn('Track ',I,' starting position -',
             ' Minutes: ',MCI_MSF_MINUTE(MSF),
             ' Seconds: ',MCI_MSF_SECOND(MSF),
             ' Frame:   ',MCI_MSF_FRAME(MSF));
  end;

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure GetCurrentTrack;
{
  TMCI_Status_Parms = record
    dwCallback: Longint;
    dwReturn: Longint;
    dwItem: Longint;
    dwTrack: Longint;
  end;
}
Var
  MCI_STATUS_PARMS           : TMCI_Status_Parms;
  RC                         : LongInt;
  currentTrack               : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_STATUS_PARMS.dwCallback := 0;
  MCI_STATUS_PARMS.dwReturn   := 0;
  MCI_STATUS_PARMS.dwItem     := MCI_STATUS_CURRENT_TRACK;
  MCI_STATUS_PARMS.dwTrack    := 0;

  RC:=mciSendCommand( wDeviceId,
                      MCI_STATUS,
                      MCI_STATUS_ITEM,
                      Longint(@MCI_STATUS_PARMS));

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to get current track number from the CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    CloseCD;
    HALT(0);
  end;

  currentTrack:=MCI_STATUS_PARMS.dwReturn;
  WriteLn('The current track number is = ',currentTrack);

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
procedure EjectCD;
{
 TMCI_Set_Parms = record
    dwCallback: Longint;
    dwTimeFormat: Longint;
    dwAudio: Longint;
  end;
}

Var
  MCI_SET_PARMS              : TMCI_Set_Parms;
  RC                         : LongInt;
  aString                    : String;
  MessageText                : Array[0..128] of Char;

begin

  MCI_SET_PARMS.dwCallback := 0;
  MCI_SET_PARMS.dwTimeFormat := 0;
  MCI_SET_PARMS.dwAudio := 0;

  RC:=mciSendCommand( wDeviceId,
                      MCI_SET,
                      mci_Set_Door_Open,
                      Longint(@MCI_SET_PARMS));

  If RC<>0 then begin
    Str(RC:5,aString);
    aString:='Return Code: '+aString;
    aString:=aString+'. Failure to Set Door Open (EJECT) for the CD. Error Message: '+GetErrorMessage(RC);
    StrPCopy(MessageText, aString);
    MessageBox(0, MessageText, 'General Information', mb_OK);
    CloseCD;
    HALT(0);
  end;

  WriteLn('CD Set Door Open (EJECT) Successful');

end;
{---------------------------------------------------------------------------------------------}

{---------------------------------------------------------------------------------------------}
begin

  If ParamCount=1 then begin
    If (ParamStr(1)='EJECT') or (ParamStr(1)='eject') then begin
      OpenCD;
      EjectCD;
      CloseCD;
      MessageBox(0, 'CD Ejected.', 'NOTICE', mb_OK);	
      Halt(0);
    end;
  end;

  If ParamCount<>2 then begin
    MessageBox(0, 'Program expects 2 parameters: StartTrack, EndTrack. Program terminated.', 'E R R O R', mb_OK);	
    Halt(0);
  end;

  Val(ParamStr(1),StartTrack,ReturnValCode);
  If ReturnValCode<>0 then begin
    MessageBox(0, 'StartTrack parameter is invalid. Program terminated.', 'E R R O R', mb_OK);	
    Halt(0);
  end;

  Val(ParamStr(2),EndTrack,  ReturnValCode);
  If ReturnValCode<>0 then begin
    MessageBox(0, 'EndTrack parameter is invalid. Program terminated.', 'E R R O R', mb_OK);	
    Halt(0);
  end;

  If StartTrack = EndTrack then EndTrack:=EndTrack + 1;
  If StartTrack > EndTrack then begin
    MessageBox(0, 'Start and End tracks values are invalid. Program terminated.', 'E R R O R', mb_OK);	
    CloseCD;
    HALT(1);
  end;

  WriteLn('Starting Play at ',StartTrack,' and ending at ',EndTrack);

  OpenCD;

  SetMSFasFormat;
  GetNumberTracks;
  GetTrackInfo;
  GetLengthOfEachTrack;

  SetTMSFasFormat; 

{ Specify the start track and the end track. Does not play the end track.
  Therefore, specify one more than what you want to hear. }

  PlayCD(StartTrack,EndTrack);

  GetCurrentTrack;

  CloseCD;

end.
{---------------------------------------------------------------------------------------------}
