;
          XOR    AX,AX                 ;Clear AX to zero
          MOV    ES,AX                 ;Allow low-memory access
;
          MOV    WORD [>OutCount],0    ;Clear outer loop counter
;
          CLI                          ;No interrupts while reading
      ES: MOV    CX,[>$46E]            ;Hi part of CPU timer value
      ES: MOV    DX,[>$46C]            ;Lo part of CPU timer value
          STI                          ;Interrupts back on
;
          MOV    [>Hi_Timer],CX        ;Save hi part of timer
          MOV    [>Lo_Timer],DX        ;Save low part of timer
;
Loop1:    CLI                          ;No interrupts while reading
;
      ES: MOV    CX,[>$46E]            ;Hi part of CPU timer value
      ES: MOV    DX,[>$46C]            ;Lo part of CPU timer value
;
          STI                          ;Interrupts back on
;
          MOV    AX,CX                 ;Save CX and DX for later
          MOV    BX,DX
;
          SUB    AX,[>Hi_Timer]        ;Subtract low order part
          SBB    BX,[>Lo_Timer]        ;Subtract high order part
;
          JE     Loop1                 ;Continue until non-0 tick difference
;
          MOV    [>Hi_Timer],CX        ;Save hi part
          MOV    [>Lo_Timer],DX        ;Save low part
;
Loop2:    MOV    CX,110                ;Run short delay loop.
Delay:    LOOP   Delay
;
          CLI                          ;No interrupts while reading
;
      ES: MOV    CX,[>$46E]            ;Hi part of CPU timer value
      ES: MOV    DX,[>$46C]            ;Lo part of CPU timer value
;
          STI                          ;Interrupts back on
;
          INC    WORD [>OutCount]      ;Increment outer loop count
;
          SUB    CX,[>Hi_Timer]        ;Subtract low order part
          SBB    DX,[>Lo_Timer]        ;Subtract high order part
;
          JE     Loop2                 ;Keep going if next tick not found
;
          MOV    AX,[>OutCount]        ;Pick up outer loop counter
          SHL    AX,1                  ;* 2 = ticks for 1 ms delay
;
          LES    DI,[BP+>One_MS_Delay] ;Get address of result
      ES: MOV    [DI],AX               ;Store result
