program PcntApp;

{---------------------------------------------------------------------
Example application for the custom control PercentBar (PBar.DLL) of
the SMWCC 2.0 Custom Control Pack

Copyright (C) by Sebastian Modersohn

Note: This code file isn't documented into detail. If you have
      questions to *THIS* code file or want to know some details
      please contact me via CompuServe, ID 100340,1474.
---------------------------------------------------------------------}

{$IFNDEF AUTOLOAD}

  You HAVE to compile this program with the global defined symbol "AUTOLOAD" !
  This demonstrates the autoloading feature of the import unit Micro!
{$ENDIF}

{$R PcntApp}

uses WinTypes, WinProcs, OWindows, ODialogs, BWCC,
     {the interface unit for the pbar and its constant unit}
     PCnt, PcntCo;

{some Id's}
const id_ABar        =201;
      id_Inc         =301;
      id_Dec         =302;

type
  PPBarWindow = ^TPBarWindow;
  TPBarWindow = object(TDlgWindow)
    ABar: PBar;
    constructor Init(AParent: PWindowsObject; AName: PChar);

    procedure Increase(var Msg: TMessage);
      virtual id_First + id_Inc;
    procedure Decrease(var Msg: TMessage);
      virtual id_First + id_Dec;

    procedure Help(var Msg: TMessage);
      virtual id_First + 998;
  end;

{App that initializes the main window}
  PPBarApp = ^TPBarApp;
  TPBarApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{ TPBarWindow }

constructor TPBarWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
  inherited Init(AParent, AName);
  {Inits the pbar, it is disposed by the parent automatically}
  ABar:=New(PBar, InitResource(@Self, id_ABar));
end;

procedure TPBarWindow.Increase(var Msg: TMessage);
begin
  {one way to increase the percent of the bar}
  ABar^.AddPercent(1);
end;

procedure TPBarWindow.Decrease(var Msg: TMessage);
begin
  {one way to decrease the percent of the bar}
  ABar^.AddPercent(-1);
end;

procedure TPBarWindow.Help(var Msg: TMessage);
begin
  WinHelp(HWindow, HelpFile, Help_Context, 100);
end;

{ TPBarApp }

procedure TPBarApp.InitMainWindow;
begin
  MainWindow := New(PPBarWindow, Init(nil, MakeIntResource(100)));
end;

var
  App: TPBarApp;

begin
  App.Init('PBar Demo');
  App.Run;
  App.Done;
end.
