program PowerFunction;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ Program to illustrate the use of a function, in this case to evaluate  }
{ a number raised to a power ( x ^ y ). The number is referred to as the }
{ base value and the power is the exponent. Negative base values with    }
{ fractional exponents are excluded in this simple program as they would }
{ require the use of complex numbers. A unit POWERU.TPU is available to  }
{ handle complex solutions.                                              }
{                                                                        }
{ FUNC.PAS  -> FUNC.EXE       R Shaw            13.1.93                  }
{________________________________________________________________________}

uses Crt;       {The Crt unit contains the procedure to clear the screen}

var
  x,y   : real;
  sign  : integer;
  reply : char;

function Power(Base, Exponent : real) : real;
begin
  if Base > 0.0 then
    Power := exp(Exponent * ln(Base))
  else if Base = 0.0 then
    Power := 0.0
  else if ((Base < 0.0) and (round(Exponent) = Exponent)) then
    begin
      if abs(round(Exponent) mod 2) = 1 then sign := -1 else sign := +1;
      Power := sign * exp(Exponent * ln(Abs(Base)));
    end
  else if ((Base < 0.0) and (round(Exponent) <> Exponent)) then exit
end;

begin
   ClrScr;
   writeln('      FUNCTION FOR EVALUATING POWERS OF NUMBERS.');
   writeln;
   writeln('Please enter the base and exponent for x^y when requested. ');
   writeln('In each case press the ENTER key after typing the values.');
   writeln;
   writeln('High values for x and particularly y may cause floating point overflow.');
   writeln('Please restart program if this happens.');
   Repeat
     writeln;
     writeln;
     write('Base value x: ');
     readln(x);
     write('Exponent y  : ');
     readln(y);
     writeln;
     If ((x < 0.0) and (round(y) <> y)) then
        begin
          writeln('   Result not possible without use of complex numbers');
          writeln('   A unit POWERU.TPU is available for this purpose.');
        end
     else writeln('   ',x:6:3,' ^ ',y:6:3,' = ',Power(x,y):6:3);
     writeln;
     write('Press C to continue or Q to quit ');
     Reply := readkey;
   Until UpCase(Reply) = 'Q';
end.
