program parabola_print;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ This program illustrates the graphics capabilities of Turbo Pascal, by }
{ using the Line procedure with a suitable algorithm to draw a parabola. }
{ Apart from using the Graph unit of Turbo Pascal, a GraphPRN unit is    }
{ employed to allow hardcopy to an Epson printer. This latter unit is    }
{ listed by Ohlsen and Stoker in 'Turbo Pascal Advanced Techniques'      }
{ published by the Que Corporation.                                      }
{                                                                        }
{ GRAPHICS.PAS  ->  .EXE    R Shaw             12.1.90                   }
{________________________________________________________________________}

uses  Crt,Graph,GraphPRN;

var
   GraphDriver,GraphMode      : integer;
   MaxX,MaxY,CopyPRN,OX       : integer;
   PixelX1,PixelY1,PixelY2    : longint;
   x,dx                       : real;

{ Main program }

begin
     TextMode(2);
     Write('If hardcopy is required enter 1 else 0:  ');
     Readln(CopyPRN);
     GraphDriver:=Detect;
     InitGraph(GraphDriver,GraphMode,'');
     MaxX:=GetMaxX;
     MaxY:=GetMaxY;
     SetViewPort(0,0,MaxX,MaxY,ClipOff);

     OX := round(MaxX/2);

     Line(70,MaxY-40,MaxX-70,MaxY-40);
     Line(OX,40,OX,MaxY-40);

     x := -5;
     dx := 10/(maxX-140);

     repeat
        pixelX1 := round(MaxX/2 + ((MaxX-140)/10) * x);
        pixelY1 := round(MaxY-40 - ((MaxY-80)/30) * ((x * x) + 5));
        pixelY2 := round(MaxY-40 -((MaxY-80)/30)*((x + dx)*(x + dx) +5));

        Line(pixelX1,pixelY1,pixelX1 + 1,pixelY2);

        x := x + dx;

     until x > 5;

     SetTextJustify(CenterText, CenterText);
     OutTextXY(OX,10,'Graph of y = x^2 + 5');
     OutTextXY(OX,MaxY-10,'Press any key to continue');
     If CopyPRN = 1 Then HardCopy(4);

     repeat until keypressed;

     CloseGraph;
     TextMode(3);
end.