{$R-,S-,I-,V-,B-,F+,O+,A-}
{$I OPDEFINE.INC}

unit OpDirX;

{ OPDIR extension to allow directory sorts based on extension, name }

interface

uses opdir;

  procedure SortExt(DirPtr : DirListPtr);
    {-Sort alphabetically by extension, then by name}
  procedure SortDirExt(DirPtr : DirListPtr);
    {-Sort directories first, then alphabetically by extension and name}

implementation

uses Dos,
     OpInline,
     OpString;

  function LessExt(var X, Y : DirRec) : Boolean;
    {-Sort ordering -- alphabetically by extension then name}
  var
    Xdrive : Boolean;
    Ydrive : Boolean;
  begin
    Xdrive := (X.Attr = diDriveAttr);
    Ydrive := (Y.Attr = diDriveAttr);
    if Xdrive = Ydrive then
      if ByteFlagIsSet(X.Attr, Directory) then
        LessExt := (X.Name < Y.Name)
      else
        LessExt := (JustExtension(X.Name)+X.Name <
          JustExtension(Y.Name)+Y.Name)
    else
      LessExt := Xdrive;
  end;

  procedure SortExt(DirPtr : DirListPtr);
    {-Sort alphabetically by name, then by extension}
  begin
    with DirPtr^ do begin
      diLess := LessExt;
      diQuickSort(1, pkItems);
    end;
  end;

  function LessDirExt(var X, Y : DirRec) : Boolean;
    {-Sort directories first, then alphabetically by extension and name}
  var
    Xdir : Boolean;
    Ydir : Boolean;
    Xdrive : Boolean;
    Ydrive : Boolean;
  begin
    Xdrive := (X.Attr = diDriveAttr);
    Ydrive := (Y.Attr = diDriveAttr);
    if Xdrive = Ydrive then begin
      Xdir := ByteFlagIsSet(X.Attr, Directory);
      Ydir := ByteFlagIsSet(Y.Attr, Directory);
      if Xdir = YDir then
        LessDirExt := LessExt(X, Y)
      else
        LessDirExt := Xdir;
    end else
      LessDirExt := Xdrive;
  end;

  procedure SortDirExt(DirPtr : DirListPtr);
    {-Sort directories first, then alphabetically by extension and name}
  begin
    with DirPtr^ do begin
      diLess := LessDirExt;
      diQuickSort(1, pkItems);
    end;
  end;

{$IFDEF InitAllUnits}
begin
{$ENDIF}
end.