(***************************************************************************************)
(*  ODTEST.PAS   - Everything you ever wanted to know about owner-drawn list boxes,    *)
(*                 but were afraid to ask because the answer was so nasty.             *)
(*  Brad Stowers - Internet:   bstowers@cybernetics.net                                *)
(*                 CompuServe: 72733, 3374                                             *)
(*  Version 0.91 - Not everything is finished quite yet.                               *)
(*  Last updated - 12/12/94, Brad Stowers, Second release.                             *)
(***************************************************************************************)
(*  This work is in no way copyrighted, protected, or even claimed by the author.      *)
(*  You may use this in any way you see fit, for whatever purposes you want, and will  *)
(*  NOT hold the author responsible for ANYTHING when it blows up in your face.        *)
(*  Most of the bitmap work was gleaned from Peter Gruhn and various magazines.  A lot *)
(*  of the general form and structure was learned from other O/D Listboxes in BPascal. *)
(*  The text drawing was a lot of digging around in the API.                           *)
(***************************************************************************************)

{ Shows off the pODListBox object.  Newly added is a second O/D listbox to the demo.    }
{ Several people had problems if they had more than one of these.  The problem is       }
{ explained below in the TTestWindow.wmDrawItem procedure.  Easy to work around once    }
{ you know what the problem is.                                                         }

program ODTest;

{$R ODTEST.RES}

uses OWindows, ODialogs, WinProcs, WinTypes, BWCC, ODList, DebugStr;

const
  id_ChangeOpts = 201;

  TBs:array[0..2] of integer = (60, 100, 160);  { Tab stops in DIALOG units }
  TB2s:array[0..2] of integer = (90, 120, 200); { Tab stops in DIALOG units }

type
  PTestWindow = ^TTestWindow;
  TTestWindow = object(TWindow)
    { Cool list boxes }
    LB,
    LB2: pODListBox;
    { normal list box }
    NLB: pListBox;
    { couple of bitmaps }
    Bmp1,
    Bmp2: hBitmap;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor  Done; virtual;
    procedure   SetupWindow; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var AWndClass: TWndClass); virtual;

    { Redirect these back at the listbox. }
    procedure   wmMeasureItem(var Msg: TMessage);  virtual wm_First + wm_MeasureItem;
    procedure   wmDrawItem(var Msg:TMessage);      virtual wm_First + wm_DrawItem;

    procedure   ChangeOpts(var Msg: TMessage);        virtual id_First + id_ChangeOpts;
    { Just so we can show a bitmap in its original form for testing purposes }
    procedure   Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
  end;


  { Application Object }
  TTestApp = object(TApplication)
    procedure InitMainWindow; virtual;
    procedure InitInstance; virtual;
  end;



constructor TTestWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var
  P : pWindowsObject;
begin
  inherited Init(AParent,ATitle);

  Attr.X := 50;
  Attr.Y := 40;
  Attr.W := 540;
  Attr.H := 401;

  { Our special listbox.  The mask RGB color can be found easily by double clicking on the color }
  { palette window in resource workshop when editing the bitmap.                                 }
  LB := New(pODListBox, Init(@Self, 101, 20, 20, 150, 300, 15, High(TBs)+1, @TBs,
            [Vertical,Horizontal,ClipToCell,LeftAlign], RGB(128, 0, 128)));
  LB^.Attr.Style := LB^.Attr.Style or LBS_USETABSTOPS or LBS_HASSTRINGS or WS_HSCROLL or WS_TABSTOP;
  LB^.Attr.Style := LB^.Attr.Style and (not LBS_SORT);

  { A second listbox because several people have asked how to get two to work. }
  LB2 := New(pODListBox, Init(@Self, 102, 190, 20, 150, 300, 15, High(TB2s)+1, @TB2s,
            [Vertical,Horizontal,ClipToCell,LeftAlign], RGB(128, 0, 128)));
  LB2^.Attr.Style := LB^.Attr.Style or LBS_USETABSTOPS or LBS_HASSTRINGS or WS_HSCROLL or WS_TABSTOP;
  LB2^.Attr.Style := LB^.Attr.Style and (not LBS_SORT);

  { A normal listbox for testing purposes }
  NLB := New(pListBox, Init(@Self, 103, 360, 20, 150, 300));
  NLB^.Attr.Style := NLB^.Attr.Style or LBS_USETABSTOPS or WS_HSCROLL or WS_TABSTOP;
  NLB^.Attr.Style := NLB^.Attr.Style and (not LBS_SORT);

  { Some bitmaps for displaying in the listbox }
  Bmp1 := LoadBitmap(hInstance, pChar(101));
  Bmp2 := LoadBitmap(hInstance, pChar(102));

  { A button to change listbox options on the fly }
  P := new(pbutton, Init(@Self, id_ChangeOpts, 'Change', 20, 320, 50, 15, FALSE));
end;

destructor TTestWindow.Done;
begin
  DeleteObject(Bmp1);
  DeleteObject(Bmp2);
  inherited Done;
end;

procedure TTestWindow.SetupWindow;
const
  Test1: pChar = #4'XXXXXDefault Align'#9'A 15 char string that will be cut off'#9#9'After blank cell';
  Test2: pChar = #1'Left Align'#9#4'XXXXXPretty'#9; { Two blank cells }
  Test3: pChar = #2'Center Align'#9#1'Left'#9#2'Center'#9#3'Right';
  Test4: pChar = #3'Right Align'#9'Some'#9'Filler'#9#4'XXXXXQuit playing with bitmaps!';
  Test5: pChar = #5'XXXXXXXXXXXPretty colors'#9#6'XXXXXXXXXXXAnd background';
var
  BmpStr: array[0..5] of char;
  ColorStr: array[0..11] of char;
  Color: TColorRef;
begin
  inherited SetupWindow;

{ Put Bmp handles into a char array and move that into our listbox strings }
  { First, change the handle into a char string }
  WVSPrintF(BmpStr, '%05u', Bmp1);
  { Then overwrite the placeholders ('XXXXX') in the string }
  Move(BmpStr, Test2[13], 5);
  Move(BmpStr, Test4[26], 5);
  { In the real world, you'll probably be constructing these on the fly with }
  { StrCat calls.                                                            }
  WVSPrintF(BmpStr, '%05u', Bmp2);
  Move(BmpStr, Test1[1], 5);
  { Make some pretty colors }
  Color := RGB(228,28,228);
  WVSPrintF(ColorStr, '%011li', Color);  { The string is %11 (as in eleven) li (as in LI - longint) not 3 1's }
  Move(ColorStr, Test5[1], 11);
  Color := RGB(59,139,100);
  WVSPrintF(ColorStr, '%011li', Color);
  Move(ColorStr, Test5[27], 11);

  { Tell the normal listbox where the tab stops are and a good guess at the horizontal extents }
  { Don't need to do this for our listbox since it does it for itself.                         }
  SendMessage(NLB^.hWindow, lb_SetTabStops, 5, LongInt(@TBs));
  SendMessage(NLB^.hWindow, lb_SetHorizontalExtent, 550, 0);

  { Put some strings in our box in various ways just to prove it can be done. }
  LB^.AddString(Test1);
  LB^.AddString(Test2);
  LB^.AddString(Test3);
  SendMessage(LB^.hWindow, lb_AddString, 0, LongInt(Test4));
  SendMessage(LB^.hWindow, lb_AddString, 0, LongInt(Test5));

  LB2^.AddString(Test1);
  LB2^.AddString(Test2);
  LB2^.AddString(Test3);
  SendMessage(LB2^.hWindow, lb_AddString, 0, LongInt(Test4));
  SendMessage(LB2^.hWindow, lb_AddString, 0, LongInt(Test5));

  { Put same strings in the normal box. }
  NLB^.AddString(Test1);
  NLB^.AddString(Test2);
  NLB^.AddString(Test3);
  SendMessage(NLB^.hWindow, lb_AddString, 0, LongInt(Test4));
  SendMessage(NLB^.hWindow, lb_AddString, 0, LongInt(Test5));

  SetFocus(LB^.hWindow);
end;

function TTestWindow.GetClassName: PChar;
begin
  GetClassName := 'Test Window';
end;

procedure TTestWindow.GetWindowClass(var AWndClass: TWndClass);
begin
  inherited GetWindowClass(AWndClass);
end;


procedure TTestWindow.wmMeasureItem(var Msg: TMessage);
begin
  { Redirect message back to the listbox... Strictly speaking, it's a Self-Drawn list box. <g> }
  case Msg.wParam of { Has the control ID in it. }
    101:
      LB^.wmMeasureItem(Msg);
    102:
      LB2^.wmMeasureItem(Msg);
  else
    outputdebugstring('Someone wants us to measure them, but I don''t know who'#13);
  end;
  { Could use SendMessage(LB^.hWindow, Msg.Message, Msg.wParam, Msg.lParam); if you needed to. }
end;

procedure TTestWindow.wmDrawItem(var Msg:TMessage);
begin
  { Redirect message back to the listbox... Strictly speaking, it's a Self-Drawn list box. <g> }

  { This is where folks who wanted more than one listbox were having troubles.  Either they weren't }
  { doing this at all, or they trusted the documentation and used Msg.wParam.  Now I know that the  }
  { API manuals and the on-line docs both say that Msg.wParam has the control's ID, but that just   }
  { ain't so.  It's supposed to be zero if sent from a menu, but it has been my experience that it  }
  { is ALWAYS zero.  Just check the CtlID item in the pDrawItemStuct in lParam.  It *does* have the }
  { control's ID.                                                                                   }
  if Msg.lParam = 0 then
    { WHAT????? !!!!!! }
    exit;
  case pDrawItemStruct(Msg.lParam)^.CtlID of
    101:
      LB^.wmDrawItem(Msg);
    102:
      LB2^.wmDrawItem(Msg);
  else
    outputdebugstring('Someone wants us to measure them, but I don''t know who'#13);
  end;
  { Could use SendMessage(LB^.hWindow, Msg.Message, Msg.wParam, Msg.lParam); if you needed to. }
end;

{ This is just to show one of the bitmaps in the lower right corner for testing purposes.      }
procedure TTestWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
  ADC: hDC;
  OldObj: tHandle;
  R: TRect;
begin
  ADC := CreateCompatibleDC(PaintDC);
  GetClientRect(hWindow, R);
  OldObj := SelectObject(ADC, Bmp2);
  TextOut(PaintDC, R.Right-52, R.Bottom-32, 'Bitmap:', 7);
  Rectangle(PaintDC, R.Right-55, R.Bottom-18, R.Right-1, R.Bottom-1);
  BitBlt(PaintDC, R.Right-43, R.Bottom-15, 29, 12, ADC, 0, 0, SRCCOPY);
  SelectObject(ADC, OldObj);
  DeleteDC(ADC);
end;


procedure TTestWindow.ChangeOpts(var Msg: TMessage);
const
  Toggle: boolean = FALSE;
begin
  if Toggle then
    LB^.ResetOptions([Vertical,Horizontal,ClipToCell,LeftAlign])
  else
    LB^.ResetOptions([Vertical,ClipToCell,RightAlign]);
  Toggle := not Toggle;
end;


{**************     Application Object     **************}

procedure TTestApp.InitMainWindow;
begin
  MainWindow := New(PTestWindow, Init(Nil, 'Test Window'));
end;

procedure TTestApp.InitInstance;
begin
  inherited InitInstance;
end;


var
  BWCCHandle: THandle;
  TestApp: TTestApp;

begin
  BWCCHandle := LoadLibrary('BWCC');
  BWCCGetVersion;
  TestApp.Init('Test App');
  TestApp.Run;
  TestApp.Done;
  FreeLibrary(BWCCHandle);
end.