(****************************************************)
(*   Turbo Vision Class for selecting and           *)
(*   capturing Netware spooled print queues.        *)
(*   (C) CSM Limited. All Rights Reserved.          *)
(*                                                  *)
(*   Written by                                     *)
(*          G.T. Swindell   June 1992               *)
(*                                                  *)
(*   Ammendments                                    *)
(*                                                  *)
(*   Sept. 1992  Fix bug where message sent when    *)
(*               cancelling the dialg box.          *)
(*                                                  *)
(*   Jan. 1993   DPMI Version created.              *)
(****************************************************)

Unit NvllPDlg;
Interface
Uses
  Objects, Drivers, Dialogs;

Const
  cmEndCapture = $FFFF;
  cmPrinters = 239;

Type
  TBannerStr = String[13];

  PPrinterDialog = ^TPrinterDialog;
  TPrinterDialog = object(TDialog)
    PrintBanner : TBannerStr;
    Constructor Init(R : TRect; ATitleStr : String; ABanner : TBannerStr);
    Procedure HandleEvent(var Event : TEvent); virtual;
  end;

Procedure SetPrinterQueue(ABannerText : TBannerStr);

Implementation
Uses
  Memory, Views, MsgBox, App, NvllVars, NvllDPMI, List, Strings;

Constructor TPrinterDialog.Init(R : TRect; ATitleStr : String; ABanner : TBannerStr);
begin
  TDialog.Init(R, ATitleStr);
  PrintBanner := ABanner;
end;

Procedure TPrinterDialog.HandleEvent(var Event : TEvent);
begin
  TDialog.HandleEvent(Event);
  If (Event.What=evCommand) AND (Event.Command=cmEndCapture) then
    EndModal(cmEndCapture);
end;

(*******************************************)
(*                                         *)
(*  Function to create the Printer list    *)
(*  Dialog                                 *)
(*******************************************)

FUNCTION MakeDialog(ABannerText : TBannerStr) : PPrinterDialog;
var
  Dlg : PPrinterDialog;
  R : TRect;
  Control, Labl, Histry : PView;
Begin
  R.Assign(14,1,59,21);
  New(Dlg, Init(R, 'Capture Network Printer', ABannerText));

  R.Assign(42,3,43,13);
  Control := New(PScrollbar, Init(R));
  Dlg^.Insert(Control);

  R.Assign(2,3,42,13);
  Control := New(PListBox, Init(R, 1, PScrollbar(Control)));
  Dlg^.Insert(Control);

    R.Assign(2,2,11,3);
    Labl := New(PLabel, Init(R, '~P~rinters', Control));
    Dlg^.Insert(Labl);

  R.Assign(2,16,12,18);
  Control := New(PButton, Init(R, 'Select', cmOK, bfDefault));
  Dlg^.Insert(Control);

  R.Assign(14,16,24,18);
  Control := New(PButton, Init(R, 'Cancel', cmCancel, bfNormal));
  Dlg^.Insert(Control);

  R.Assign(26,16,43,18);
  Control := New(PButton, Init(R, '~E~nd Capture', cmEndCapture, bfNormal));
  Dlg^.Insert(Control);

  R.Assign(12,14,32,15);
  Control := New(PCheckboxes, Init(R,
    NewSItem('~B~anner Enabled',Nil)));
  PCluster(Control)^.Value := 1;
  Dlg^.Insert(Control);

  Dlg^.SelectNext(False);
  MakeDialog := Dlg;
end;

var
  DataRec : record
    PrinterList : TListboxRec;  {Listbox}
    DialogFlags : Word; {Checkbox}
  end;

Procedure SetPrinterCollection(var P : PStringCollection);
Var
  NewPrinter : PPrinterQueue;
begin
  NewPrinter := FirstPrinter;
  If NewPrinter<>Nil then
  begin
    New(P, Init(50,5));
    While NewPrinter<>Nil do
    begin
      P^.Insert(NewStr(StrPas(NewPrinter^.Name)));
      NewPrinter := NewPrinter^.Next;
    end;
  end;
end;

(***************************************************)
(*  FUNCTION  : SetPrinterQueue                    *)
(*  PURPOSE   : Produces dialog containing printer *)
(*              queues form which the user may     *)
(*              select.                            *)
(*  INPUT     : A Text string for the banner       *)
(*  OUTPUT    : None                               *)
(***************************************************)

Procedure SetPrinterQueue(ABannerText : TBannerStr);
var
  D : PPrinterDialog;
  ExitCommand : Word;
  ChosenPrinter : Array[0..100] of Char;
  PrinterCollection : PStringCollection;

begin
  If FirstPrinter<>Nil then
  begin
    SetPrinterCollection(PrinterCollection);
    D := MakeDialog(ABannerText);
    DataRec.PrinterList.List := PrinterCollection;
    DataRec.PrinterList.Focused := 0;
    DataRec.DialogFlags := 1;
    D^.SetData(DataRec);
    If Application^.ValidView(D)<>Nil then
      ExitCommand := Desktop^.ExecView(D);
    Case ExitCommand of
      cmOk :
        begin
          D^.GetData(DataRec);
          StrPCopy(ChosenPrinter, PString(DataRec.PrinterList.List^.At(DataRec.PrinterList.Focused))^);
          CapturePrinter(ChosenPrinter, DataRec.DialogFlags, D^.PrintBanner);
          MessageBox(^C+'Printer Set to '+StrPas(ChosenPrinter), Nil, mfInformation+mfOkButton);
        end;
      cmEndCapture :
        begin
          EndCapture;
          MessageBox(^C+'Printer Set to Local Mode', Nil, mfInformation+mfOkButton);
        end;
    end;
    D^.Done;
  end
  else
  begin
    MessageBox(^C+'No Printers to select from.'+ #13 +
               ^C+'Printer set to Local Mode', Nil, mfInformation+mfOkButton);
    EndCapture;
  end;
end;

end.
