{***********************************************************************}
{ Turbo Pascal 6.0                                                      }
{ Program BaseOvr                                                       }
{ Copyright (c) B. Plagge, 1992                                         }
{ This program contains all routines for the TBase object which supports}
{ fixed length and variable length record handling.                     }
{ Modifications                                                         }
{ (Error, Correction, Initials, Date, What?                             }
{***********************************************************************}

unit BaseOvr;

{$S-,D-}

interface

Implementation

uses Overlay, Memory;

const
  OvrMaxSize = 25000;		
  
var
  ExitSave    : Pointer;
  SaveOvrRead : OvrReadFunc;
  UsingEMS    : Boolean;


{is called following a Halt statement or when an DosError or EmsError }
{occured and will abort the program}
procedure OvrExit; far;
begin
  ExitProc := ExitSave;
  if (ExitCode > 0) then
    WriteLn('Error occured: ', ExitCode);
end;


{function is called whenever the overlay manager needs to read an overlay}
function BaseOvrRead(OvrSeg: Word): Integer; far;
var
  E : Integer;
begin
  repeat
    E := SaveOvrRead(OvrSeg);
    if (E <> 0) then
      Halt(E)
  until E = 0;
  BaseOvrRead := 0;
end;
	   

{return value of 1 ensures that a pointer of NIL is returned whenever }
{a call to New or GetMem cannot be completed.                         }
function HeapNil(Size: Word): Integer; far;
begin
  HeapNil := 1;
end;




begin
  ExitSave := ExitProc;                {save the current ExitProc}
  ExitProc := @OvrExit;                {point to our ExitProc} 
  
  OvrInit('BASE.OVR');                 {initialise overlay manager}
  if (OvrResult <> OvrOk) then         {check result and call ExitProc}
    Halt(OvrResult);                   {in case of an error}

  SaveOvrRead := OvrReadBuf;           {save disk default}
  OvrReadBuf  := BaseOvrRead;          {install our read function} 
  UsingEMS    := false;
  OvrInitEMS;
  if (OvrResult = OvrOk) then
    begin
      SaveOvrRead := OvrReadBuf;       {save EMS default}
      OvrReadBuf  := BaseOvrRead;      {install our function}
      UsingEMS    := true;
      LowMemSize  := 2048;             {Safety pool = 2 kb!}
   end;                                {no abort if OvrInitEMS failed }
				       {because then normal disk i/o will occur}
  OvrSetBuf(OvrMaxSize);               {set max overlay buffer size}


  {install the heap error function}
  HeapError := @HeapNil;               {points to the HeapFunc above}
end.




