{ -------------------------------------------------------------------
  It's a good idea to move this stuff to dll
  ------------------------------------------------------------------- }
unit Strip;

interface

{ Strip dialog resource }
{$R STRIP.RES}

uses
    Winprocs,
    Wintypes,
    OWindows,
    ODialogs,
    Strings,
    Win31;

const
  BorderWidth = 1;

  wm_NewStrip = wm_User + 123;

  id_Title    = 101;
  id_Frame    = 102;

  Strip_Res   : pChar = 'STRIP';

type

PStripDialog = ^TStripDialog;
TStripDialog = object(TDialog)
  Title:  PChar;
  Total:  Longint;
  Factor: Integer;
  constructor Init(AParent: PWindowsObject; AName: PChar; ATitle: PChar; ATotal: Longint);
  destructor Done; virtual;
  procedure SetupWindow; virtual;
  procedure DrawNewStrip(Current: LongInt);
end;

procedure CenterDialog(hWndC, hWndP: HWnd; Top: Integer);

implementation

constructor TStripDialog.Init;
begin
  inherited Init(AParent, AName);
  Title := ATitle;
  Total := ATotal;
  if Total <= 100 then
  begin
    Factor := Total div 100;
    if Factor = 0 then Inc(Factor);
  end
  else
    if Total < 500 then
      Factor := Total div (Total div 10)
    else
      Factor := Total div 50;
end;

destructor TStripDialog.Done;
begin
  inherited Done;
end;

procedure TStripDialog.SetupWindow;
begin
  inherited SetupWindow;
  SetDlgItemText(HWindow, id_Title, Title);
  CenterDialog(HWindow, Parent^.HWindow, 0);
end;

procedure TStripDialog.DrawNewStrip(Current: LongInt);
var
  hFrame: HWnd;
begin
  { Just slight optimization,
    Profiler shows that 61% of time to fill listbox takes progress displaying,
    for small databases it's better to disable progress bar at all, i.e.
    do not override tListTable.Crate... DrawNew... and CloseStrip methods      }
  if (Current mod Factor) = 0 then
  begin
    hFrame := GetItemHandle(id_Frame);
    SendMessage(hFrame, wm_NewStrip, Current div 10, Total);
  end;
end;

procedure CenterDialog;
var
  P: TPoint;
  swp, RParent: TRect;
  Width, Height: Integer;
begin
  GetWindowRect(hWndC, swp);
  GetClientRect(hWndP, RParent);
  Width := swp.right - swp.left;
  Height := swp.bottom - swp.top;
  { find the center point and convert to screen coordinates }
  P.X := (RParent.right - RParent.left) div 2;
  P.Y := (RParent.bottom - RParent.top) div 2;
  ClientToScreen(hWndP, P);
  { calculate the new x, y starting point }
  P.X := P.X - (Width div 2);
  P.Y := P.Y - (Height div 2);
  { top will adjust the window position, up or down }
  if (Top <> 0) then
    P.Y := P.Y + Top;
  { move the window }
  MoveWindow(hWndC, P.X, P.Y, Width, Height, FALSE);
end;

function ProgBarWinFn(HWindow: HWnd; Message: Word; wParam: Word; lParam: Longint): Longint; export;
var
  PS: TPaintStruct;
  Frame, Rgn, TextRect: TRect;
  width, pcnt, CharWidth: Integer;
  PerCent: Real;
  DC: hDC;
  OldBrush, HiBrush: HBrush;
  Reg: HRgn;
  PStr: array [0..5] of Char;
  Metrics: TTextMetric;

procedure Paint(DC: HDC);
var
  BorderBrush, OldBrush: HBrush;
  Frame: TRect;
  Height, Width: Integer;
begin
  { Draw frame }
  GetClientRect(HWindow, Frame);
  Height := Frame.bottom - Frame.top;
  Width := Frame.right - Frame.left;
  OldBrush := SelectObject(DC, GetStockObject(Black_Brush));
  PatBlt(DC, Frame.left, Frame.top, Width, BorderWidth, PatCopy);
  PatBlt(DC, Frame.left, Frame.top, BorderWidth, Height, PatCopy);
  SelectObject(DC, GetStockObject(Black_Brush));
  PatBlt(DC, Frame.right-BorderWidth, Frame.top, BorderWidth, Height, PatCopy);
  PatBlt(DC, Frame.left, Frame.bottom-BorderWidth, Width, BorderWidth, PatCopy);
  SelectObject(DC, OldBrush);
end;

begin
  ProgBarWinFn := 0;
  case (Message) of

    wm_Paint:
      begin
        BeginPaint(HWindow, PS);
        Paint(PS.hDC);
        EndPaint(HWindow, PS);
      end;

    wm_NewStrip:
      begin
        GetClientRect(HWindow, Frame);
        Move(Frame, Rgn, SizeOf(TRect));
        Inc(Rgn.left, BorderWidth); Inc(Rgn.top, BorderWidth);
        Dec(Rgn.Right, BorderWidth); Dec(Rgn.bottom, BorderWidth);
        width := Rgn.right - Rgn.left;
        PerCent := wParam * 10 / lParam;
        pcnt := Trunc(PerCent * 100);
        PerCent := width * PerCent;
        Rgn.right := Rgn.left + Trunc(PerCent);
        DC := GetDC(HWindow);
        { Draw Strip }
        HiBrush :=  CreateSolidBrush(GetSysColor(COLOR_HIGHLIGHT));
        OldBrush := SelectObject(DC, HiBrush);
        Reg := CreateRectRgnIndirect(Rgn);
        PaintRgn(DC, Reg);
        SelectObject(DC, OldBrush);
        DeleteObject(HiBrush);
        { Write percentage }
        GetTextMetrics(DC, Metrics);
        CharWidth := Metrics.tmMaxCharWidth * 5;
        Move(Frame, TextRect, SizeOf(TRect));
        Inc(TextRect.top, BorderWidth); Dec(TextRect.bottom, BorderWidth);
        TextRect.left := Frame.left + width div 2 - CharWidth div 2;
        TextRect.right := TextRect.left + CharWidth;
        SetBkMode(DC, Opaque);
        SetTextAlign(DC, TA_TOP or TA_CENTER);
        wvsprintf(PStr, '%d%%', pcnt);
        with TextRect do
        begin
          SetBkColor(DC, GetSysColor(COLOR_HIGHLIGHT));
          SetTextColor(DC, GetSysColor(COLOR_HIGHLIGHTTEXT));
          SelectClipRgn(DC, Reg);
          ExtTextOut(DC, width div 2, 2, Eto_Clipped, @TextRect, PStr, strlen(PStr), nil);
          DeleteObject(Reg);
          SetBkColor(DC, GetSysColor(COLOR_WINDOW));
          SetTextColor(DC, GetSysColor(COLOR_HIGHLIGHT));
          Rgn.left := Rgn.right + 1;
          Rgn.right := Frame.right - BorderWidth;
          Reg := CreateRectRgnIndirect(Rgn);
          SelectClipRgn(DC, Reg);
          ExtTextOut(DC, width div 2, 2, Eto_Clipped, @TextRect, PStr, strlen(PStr), nil);
          DeleteObject(Reg);
        end;
        ReleaseDC(HWindow, DC);
      end;

  else
    ProgBarWinFn := DefWindowProc(HWindow, Message, wParam, lParam);
  end;

end;

var
  ProgBarClass: TWndClass;

begin
  { Progress bar class registration
    You can put it another way - wm_Paint }
  with ProgBarClass do
  begin
    lpszClassName := 'ProgressBar';
    hCursor       := LoadCursor(0, idc_Arrow);
    lpszMenuName  := nil;
    style         := cs_HRedraw or cs_VRedraw or cs_GlobalClass;
    lpfnWndProc   := TFarProc(@ProgBarWinFn);
    hInstance     := System.hInstance;
    hIcon         := 0;
    cbWndExtra    := 0;
    cbClsExtra    := 0;
    hbrBackground := 0;
  end;
  RegisterClass(ProgBarClass);
end.
