{Map Square Editor}

Uses
  Crt,Dos,Graph,Palette,Drivers,Fonts,Mouse,Convert,MouseRs2,Box;

Var
  Size,					{size of map squares}
  Color,				{current drawing color}
  x,y,					{cursor location}
  LookX,LookY,
  MaxRec,
  i:  INTEGER;
  LastMove,
  cmd:  CHAR;
  fp2:  FILE of AnyImage;
  filenm:  STRING;
  AltImage,
  MyImage:  ^AnyImage;

{ Table of mouse "buttons" on the screen.  Each entry contains the leftmost,
  rightmost, topmost, and bottommost pixels (respectively) of the button. }

Const
  mt: array[1..18,1..4] of INTEGER = (	{normal prompts}
  (340,380,25,249),			{select color}
  (51,211,21,181),			{draw pixel}
  (400,620,68,81),			{save}
  (400,620,82,95),			{read}
  (400,620,96,109),			{re-read}
  (400,620,110,123),			{palette functions}
  (400,620,124,137),			{clear}
  (400,620,138,151),			{view last images read}
  (400,620,152,165),			{look}
  (400,620,166,179),			{fill}
  (400,620,180,193),			{flip left to right}
  (400,620,194,207),			{flip top to bottom}
  (400,620,208,221),			{rotate}
  (400,620,222,235),			{shift right}
  (400,620,236,249),			{shift left}
  (400,620,250,265),			{shift up}
  (400,620,266,279),			{shift down}
  (400,620,280,293) );			{quit}

  mtp: array[1..5,1..4] of INTEGER = (	{palette prompts}
  (400,620,84,97),			{Save palette}
  (400,620,98,111),			{Load palette}
  (400,620,112,125),			{Change a color}
  (400,620,126,139),			{Rotate a color}
  (400,620,140,153) );			{Default palette}

  PalQues: array[1..5] of STRING = (	{palette questions}
  'Save','Load','Change','Rotate','Default');

  PutQues: array[1..5] of STRING = (	{PutImage questions}
  'Normal','XOR','OR','AND','NOT');

  ChangeQues: array[1..7] of STRING = (	{Change color questions}
  'r','g','b','R','G','B','Done');

procedure MouseOn;
{ turn on correct mouse cursor according to its current position }
begin
  case MouseLocate(Mx,My,18,@mt) of
    0:  MouseCursorOn(Mx,My,HAND);
    2:  MouseCursorOn(Mx,My,ARROW);
    else  MouseCursorOn(Mx,My,FINGER);
  end;
end;

procedure MouseColor;
{ set drawing color from mouse }
begin
  Color := (My - 25) div 14;
  GotoXY(52,2);
  TextColor(Color);
  if MyPal[Color,0] = 0 then
    TextColor(LightGray);
  if Color < 10 then
    Write('Color=',Color,' ')
  else
    Write('Color=',Chr(Color+55));
end;

procedure Prompts;
{ main menu prompts }
begin
  TextColor(Cyan);
  GotoXY(52,3); Write('Select color by number.   ');
  GotoXY(52,4); Write('Hit space to draw.        ');
  GotoXY(52,5); Write('Use arrows to move.       ');
  GotoXY(52,6); Write('S = Save file             ');
  GotoXY(52,7); Write('R = Read file             ');
  GotoXY(52,8); Write('W = Re-read               ');

  GotoXY(52,9); Write('P = Palette functions     ');
  GotoXY(52,10);Write('X = Clear drawing         ');
  GotoXY(52,11);Write('V = View last images read ');
  GotoXY(52,12);Write('L = Look at adjacent parts');
  GotoXY(52,13);Write('Z = Fill                  ');
  GotoXY(52,14);Write('< = Flip left to right    ');
  GotoXY(52,15);Write('> = Flip top to bottom    ');
  GotoXY(52,16);Write('@ = Rotate clock-wise     ');
  GotoXY(52,17);Write('- = Shift Right           ');
  GotoXY(52,18);Write('+ = Shift Left            ');
  GotoXY(52,19);Write('^ = Shift Up              ');
  GotoXY(52,20);Write('| = Shift Down           ');
  GotoXY(52,21);Write('Q = Quit                  ');
  TextColor(Green);
end;

procedure DefaultPalette;
{ load default palette }
begin
  for i := 0 to 15 do begin
    SetPalette(i,NormPal[i]);
    MyPal[i,0] := NormPal[i];
    MyPal[i,1] := $FF;
  end;
  GotoXY(50,24);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('Palette: DEFAULT');
end;

function RGBconvert(num:  STRING): INTEGER;
{ convert a string rgbRGB value to a number }
var
  i,j:  INTEGER;
begin
  j := 0;				{initialize new color}
  for i := 1 to 6 do begin		{check each bit in color selection}
    j := j * 2;
    if num[i] = '1' then j := j + 1;
  end;
  RGBconvert := j;
end;

procedure NewPalette;
{ load a new palette from disk }
var
  filenm:  STRING;
  fp2:  TEXT;
  j,i:  INTEGER;
begin
  filenm := '';
  filenm := MGetFile('*.pal','Select palette file name:');
  if filenm[0] = #255 then exit;	{abort if nothing entered}
  if Pos('.',filenm) = 0 then
    filenm := filenm + '.pal';
{I$-}
  Assign(fp2,filenm);
  Reset(fp2);
{I$+}
  if IOResult <> 0 then begin		{error in file}
    GotoXY(5,22);Write('I/O ERROR');
    Delay(1000);
    TextColor(Black);
    GotoXY(5,22);ClrEol;
    TextColor(Green);
  end
  else begin
    GotoXY(50,24);
    TextColor(Black);ClrEol;
    TextColor(Green);
    Write('Palette: ',filenm);
    for i := 0 to 15 do begin		{read in and set new palette}
      ReadLn(fp2,j);
      MyPal[i,0] := j;
      SetPalette(i,j);
      ReadLn(fp2,j);
      MyPal[i,1] := j;
    end;
    Close(fp2);
  end;
end; {NewPalette procedure}

procedure SavePalette;
{ save a palette to disk }
var
  filenm:  STRING;
  fp2:  TEXT;
  i:  INTEGER;
begin
  filenm := '';
  filenm := MGetFile('*.pal','Select palette file name:');
  if filenm[0] = #255 then exit;	{abort if nothing entered}
  if Pos('.',filenm) = 0 then
    filenm := filenm + '.pal';
  Assign(fp2,filenm);
  Rewrite(fp2);
  for i := 0 to 15 do begin		{write current palette}
    WriteLn(fp2,MyPal[i,0]);
    WriteLn(fp2,MyPal[i,1]);
  end;
  Close(fp2);
  GotoXY(50,24);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('Palette: ',filenm);
end; {NewPalette procedure}

procedure ChangeColor(ChColor,pal: INTEGER);
{ toggle bits within a palette color }
var
  Window: POINTER;
  Heading,
  temp: STRING;
  x1,x2,
  y1,y2,
  i,j: INTEGER;
  c: CHAR;
  mtq: array[1..7,1..4] of INTEGER;		{buttons for questions}
begin
  temp := '';
  j := MyPal[ChColor,pal];
  for i := 6 downto 1 do begin		{find current color}
    if j mod 2 = 1 then
      temp := '1' + temp
    else
      temp := '0' + temp;
    j := j div 2;
  end;
  MouseCursorOff(Mx,My);
  SetTextJustify(LeftText,BottomText);
  y1 := 160 - 10 * 7;				{establish window size}
  y2 := 190 + 10 * 7;				{  for 7 answer window}
  Heading := 'Select bit to toggle:';
  x1 := 104 - 4 * Length(Heading);
  x2 := 136 + 4 * Length(Heading);
  GetMem(Window,ImageSize(x1,y1,x2,y2));
  GetImage(x1,y1,x2,y2,Window^);
  OutlineBox(x1,y1,x2,y2,LightGray,Brown);
  SetColor(Magenta);
  OutTextXY(x1+16,y1+20,Heading);		{print the heading}
  SetColor(Blue);
  for i := 1 to 7 do begin			{print the answers}
    Circle(x1+17,y1+16+(i*20),7);
    if temp[i] = '1' then begin
      SetFillStyle(SolidFill,DarkGray);
      FloodFill(x1+17,y1+16+(i*20),Blue);
    end;
    OutTextXY(x1+32,y1+21+(i*20),ChangeQues[i]);
    mtq[i,1] := x1 + 5;				{mouse array position}
    mtq[i,2] := x1 + 20;			{  for this button}
    mtq[i,3] := y1 + 9 + (i * 20);
    mtq[i,4] := y1 + 23 + (i * 20);
  end;
  MouseCursorOn(Mx,My,HAND);
  repeat					{repeat until done...}
    i := 0;
    repeat					{use mouse until key hit...}
      MStatus(NewButton,NewX,NewY);		{get mouse status}
      if (NewX <> Mx) or (NewY <> My) then	{mouse cursor moved!}
        MouseCursor(NewX,NewY,Mx,My,FINGER);
      Mx := NewX; My := NewY;			{remember new location}
      if NewButton <> Button then begin		{if button changed...}
        if NewButton > 0 then			{if button now down...}
          i := MouseLocate(Mx,My,Size,@mtq);
        Button := NewButton;			{remember new button setting}
      end; {if button changed}
    until KeyPressed or (i > 0);
    if KeyPressed then begin
      c := ReadKey;
      case c of
        'r': begin i := 1; j := 32; end;
        'g': begin i := 2; j := 16; end;
        'b': begin i := 3; j := 8; end;
        'R': begin i := 4; j := 4; end;
        'G': begin i := 5; j := 2; end;
        'B': begin i := 6; j := 1; end;
        else Delay(1);
      end; {case}
    end {if KeyPressed}
    else begin
      c := #0;
      case i of
        1: begin i := 1; j := 32; end;
        2: begin i := 2; j := 16; end;
        3: begin i := 3; j := 8; end;
        4: begin i := 4; j := 4; end;
        5: begin i := 5; j := 2; end;
        6: begin i := 6; j := 1; end;
        7: c := #13;
        else Delay(1);
      end; {case}
    end;
    if c <> #13 then begin
      MouseCursorOff(Mx,My);
      if temp[i] = '1' then begin	{toggle digit in string}
        temp[i] := '0';
        SetFillStyle(SolidFill,LightGray);
        FloodFill(x1+17,y1+16+(i*20),Blue);
      end
      else begin
        temp[i] := '1';
	SetFillStyle(SolidFill,DarkGray);
        FloodFill(x1+17,y1+16+(i*20),Blue);
      end;
      MouseCursorOn(Mx,My,FINGER);
      MyPal[ChColor,pal] := MyPal[ChColor,pal] Xor j;
      if pal = 0 then begin
        MyPal[ChColor,1] := $FF;
        SetPalette(ChColor,MyPal[ChColor,0]);{do the actual change}
      end;
    end;
  until c = #13;
  MouseCursorOff(Mx,My);
  PutImage(x1,y1,Window^,NormalPut);
  MouseCursorOn(Mx,My,HAND);
  FreeMem(Window,ImageSize(x1,y1,x2,y2));
end;

procedure ChangePalette;
{ change a color in the palette }
var
  c:  CHAR;
  ChColor:  INTEGER;
begin
  c := MouseReadKey('Select color to change (0-9,A-F)');
  if (c = #27) or (c = #13) then exit;
  if c = #0 then
    ChColor := (My - 25) div 14
  else
    ChColor := Ord(UpCase(c)) - 48;
  if ChColor > 9 then ChColor := ChColor - 7;
  ChangeColor(ChColor,0);
  GotoXY(50,24);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('Palette: <none>');
end; {ChangePalette procedure}

procedure RotatePalette;
{ set up a color to rotate (palette switch) }
var
  c:  CHAR;
  RotColor:  INTEGER;
begin
  c := MouseReadKey('Select color to rotate (0-9,A-F)');
  if (c = #27) or (c = #13) then exit;
  if c = #0 then
    RotColor := (My - 25) div 14
  else
    RotColor := Ord(UpCase(c)) - 48;
  if RotColor > 9 then RotColor := RotColor - 7;
  MyPal[RotColor,1] := MyPal[RotColor,0];
  ChangeColor(RotColor,1);
  GotoXY(50,24);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('Palette: <none>');
end; {RotatePalette procedure}

procedure Look;
{ load adjacent parts of image to look at }
var
  temp:  STRING;
  c:  CHAR;
  code:  INTEGER;
  rec:  WORD;
  MyImage:  ^AnyImage;
begin
  SetFillStyle(SolidFill,Black);
  Bar(234,80,266,112);
  TextColor(Red);
  GotoXY(31,7);Write('1 2');
  GotoXY(31,8);Write('3 4');
  for i := 1 to 4 do begin
    filenm := MGetFile('*.pic','File '+ItoS(i)+' or Enter for drawing:');
    if filenm[0] = #255 then begin	{abort if ESC hit}
      exit;
    end;    
    if filenm = '' then begin			{if no name entered...}
      case i of					{this is where current goes}
        1: begin LookX := 234;LookY := 80;end;
        2: begin LookX := 250;LookY := 80;end;
        3: begin LookX := 234;LookY := 96;end;
        4: begin LookX := 250;LookY := 96;end;
      end; {case}
      GetMem(MyImage,Size);
      GetImage(21,21,36,36,MyImage^);
      PutImage(LookX,LookY,MyImage^,NormalPut);
      FreeMem(MyImage,Size);
    end
    else begin					{if name entered...}
      if Pos('.',filenm) = 0 then
        filenm := filenm + '.pic';
{$I-}
      Assign(fp2,filenm);			{open file}
      Reset(fp2);
{$I+}
      if IOResult <> 0 then begin
        GotoXY(5,22);Write('I/O ERROR');
        Delay(1000);
        TextColor(Black);
        GotoXY(5,22);ClrEol;
        TextColor(Red);
      end
      else begin
        TextColor(Black);
        GotoXY(5,22);ClrEol;
        TextColor(Red);
        if FileSize(fp2) > 1 then begin
          repeat
            GotoXY(5,22);Write('Record number (1-',FileSize(fp2),'): ');
            TextColor(Black);ClrEol;
            TextColor(Red);
            ReadLn(temp);
            Val(temp,rec,code);
          until (rec > 0) and (rec <= FileSize(fp2)) and (code = 0);
          Seek(fp2,rec-1);
        end;
        GetMem(MyImage,Size);				{reserve memory}
        Read(fp2,MyImage^);
        Close(fp2);
        case i of
          1: PutImage(234,80,MyImage^,Normalput);
          2: PutImage(250,80,MyImage^,Normalput);
          3: PutImage(234,96,MyImage^,Normalput);
          4: PutImage(250,96,MyImage^,Normalput);
        end; {case}
        FreeMem(MyImage,Size);				{free memory}
      end;
    end;
  end;
  TextColor(Black);
  GotoXY(5,22);ClrEol;
end; {Look procedure}

procedure PalFunc;
{ select palette function }
var
  func:  CHAR;
begin
  case MouseQuestion(5,'Select a palette function',@PalQues) of
    1:  SavePalette;
    2:  NewPalette;
    3:  ChangePalette;
    4:  RotatePalette;
    5:  DefaultPalette;
    else Delay(1);
  end; {case}
end;

procedure DrawCursor(color: INTEGER);
{ draw the cursor }
begin
  SetColor(color);
  Rectangle(51+x*10,21+y*10,61+x*10,31+y*10);
end;

procedure PutIt(x,y,color:  INTEGER);
{ draw a pixel at several places so we can see the drawing several times }
begin
  PutPixel(x+21,y+21,Color);
  PutPixel(x+234,y+21,Color);
  PutPixel(x+250,y+21,Color);
  PutPixel(x+266,y+21,Color);
  PutPixel(x+234,y+37,Color);
  PutPixel(x+250,y+37,Color);
  PutPixel(x+266,y+37,Color);
  PutPixel(x+234,y+53,Color);
  PutPixel(x+250,y+53,Color);
  PutPixel(x+266,y+53,Color);
  if LookX <> 0 then
    PutPixel(x+LookX,y+LookY,Color);
end;

procedure SaveIt;
{ save image to file }
var
  FileRec: WORD;
begin
  TextColor(Brown);
  GetMem(MyImage,Size);				{reserve memory}
  GetImage(21,21,36,36,MyImage^);		{get image}
  filenm := MGetFile('*.pic','Select picture file name:');
  if filenm[0] = #255 then exit;		{abort if nothing entered}
  if Pos('.',filenm) = 0 then
    filenm := filenm + '.pic';
  TextColor(Brown);
{$I-}
  Assign(fp2,filenm);
  Reset(fp2);
{$I+}
  if IOResult <> 0 then begin			{if new file...}
    GotoXY(5,22);Write('New File');
    Rewrite(fp2);				{create it}
    Write(fp2,MyImage^);			{write image to beginning}
    Close(fp2);
    FileRec := 1;
  end
  else begin					{if existing file...}
    GotoXY(5,22);Write('Record number (1-',FileSize(fp2)+1,'): ');
    ReadLn(FileRec);
    Seek(fp2,FileRec-1);			{seek desired record}
    Write(fp2,MyImage^);			{write image there}
    Close(fp2);
  end;
  TextColor(Black);
  GotoXY(5,22);ClrEol;
  GotoXY(50,23);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('  Image: ',filenm,' (',FileRec,')');
end;

procedure Clear;
{ clear drawing areas }
var
  i,j:  INTEGER;
begin
  SetFillStyle(SolidFill,Black);
  Bar(21,21,36,36);
  Bar(51,21,210,180);
  Bar(234,21,281,68);
  SetColor(DarkGray);
  for i := 0 to 16 do begin			{make grid in big box}
    Line(51+(i*10),21,51+(i*10),181);
    Line(51,21+(i*10),211,21+(i*10));
  end;
  DrawCursor(Yellow);				{initialize cursor}
  GotoXY(50,23);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('  Image: <none>');
end; {Clear procedure}

procedure Center;
{ move cursor to 7,7 }
begin
  DrawCursor(DarkGray);
  x := 7; y := 7;
  DrawCursor(Yellow);
end;

procedure Home;
{ move cursor to 0,0 }
begin
  DrawCursor(DarkGray);
  x := 0; y := 0;
  DrawCursor(Yellow);
end;

procedure GoEnd;
{ move cursor to 0,15 }
begin
  DrawCursor(DarkGray);
  x := 0; y := 15;
  DrawCursor(Yellow);
end;

procedure TopRight;
{ move cursor to 15,0 }
begin
  DrawCursor(DarkGray);
  x := 15; y := 0;
  DrawCursor(Yellow);
end;

procedure BottomRight;
{ move cursor to 15,15 }
begin
  DrawCursor(DarkGray);
  x := 15; y := 15;
  DrawCursor(Yellow);
end;

procedure FarLeft;
{ move cursor to 0,y }
begin
  DrawCursor(DarkGray);
  x := 0;
  DrawCursor(Yellow);
end;

procedure FarRight;
{ move cursor to 15,y }
begin
  DrawCursor(DarkGray);
  x := 15;
  DrawCursor(Yellow);
end;

procedure UpLeft;
{ move the cursor up and left }
begin
  DrawCursor(DarkGray);
  if y > 0 then
    y := y - 1;
  if x > 0 then
    x := x - 1;
  DrawCursor(Yellow);
end;

procedure DownLeft;
{ move the cursor down and left }
begin
  DrawCursor(DarkGray);
  if y < 15 then
    y := y + 1;
  if x > 0 then
    x := x - 1;
  DrawCursor(Yellow);
end;

procedure UpRight;
{ move the cursor up and right }
begin
  DrawCursor(DarkGray);
  if y > 0 then
    y := y - 1;
  if x < 15 then
    x := x + 1;
  DrawCursor(Yellow);
end;

procedure DownRight;
{ move the cursor down and right }
begin
  DrawCursor(DarkGray);
  if y < 15 then
    y := y + 1;
  if x < 15 then
    x := x + 1;
  DrawCursor(Yellow);
end;

procedure UpArrow;
{ move the cursor up }
begin
  if y > 0 then begin
    DrawCursor(DarkGray);
    y := y - 1;
    DrawCursor(Yellow);
  end;
end;

procedure DownArrow;
{ move the cursor up }
begin
  if y < 15 then begin
    DrawCursor(DarkGray);
    y := y + 1;
    DrawCursor(Yellow);
  end;
end;

procedure LeftArrow;
{ move the cursor up }
begin
  if x > 0 then begin
    DrawCursor(DarkGray);
    x := x - 1;
    DrawCursor(Yellow);
  end;
end;

procedure RightArrow;
{ move the cursor up }
begin
  if x < 15 then begin
    DrawCursor(DarkGray);
    x := x + 1;
    DrawCursor(Yellow);
  end;
end;

procedure JustDrawIt;
{ like DrawIt without the cursor movements }
begin
  PutIt(x,y,Color);
  SetFillStyle(SolidFill,Color);
  Bar(52+x*10,22+y*10,60+x*10,30+y*10);
end;

procedure MouseDrawIt;
{ draw a pixel from mouse }
var
  DrawX,DrawY:  INTEGER;
begin
  DrawX := x;				{save cursor location}
  DrawY := y;
  x := (Mx-52) div 10;			{set cursor to mouse position}
  y := (My-22) div 10;
  MouseCursorOff(Mx,My);
  JustDrawIt;				{draw pixel}
  MouseCursorOn(Mx,My,ARROW);
  x := DrawX;				{recall cursor location}
  y := DrawY;
end; {MouseDrawIt procedure}

procedure DrawIt;
{ draw a pixel at current location }
begin
  PutIt(x,y,Color);
  SetFillStyle(SolidFill,Color);
  Bar(52+x*10,22+y*10,60+x*10,30+y*10);
  case LastMove of
    #71:  UpLeft;
    #119: Home;
    #79:  DownLeft;
    #117: GoEnd;
    #73:  UpRight;
    #132: TopRight;
    #81:  DownRight;
    #118: BottomRight;
    #76:  Center;
    #72:  UpArrow;
    #80:  DownArrow;
    #75:  LeftArrow;
    #115: FarLeft;
    #77:  RightArrow;
    #116: FarRight;
    else Delay(1);
   end; {case}
end;

procedure Flip(FlipType:  INTEGER);
{ flip drawing }
var
  Savec,
  Savex,
  Savey:  INTEGER;
  MyImage:  ^AnyImage;
begin
  GetMem(MyImage,Size);
  GetImage(21,21,36,36,MyImage^);		{copy image outside normal}
  PutImage(21,51,MyImage^,NormalPut);		{  location}
  FreeMem(MyImage,Size);
  Savex := x;					{save cursor position}
  Savey := y;
  Savec := color;
  for x := 0 to 15 do begin			{redraw it}
    for y := 0 to 15 do begin
      case FlipType of
        1: color := GetPixel(36-x,51+y);	{left to right}
        2: color := GetPixel(21+x,66-y);	{top to bottom}
        3: color := GetPixel(21+y,66-x);	{rotate}
      end; {case}
      JustDrawIt;
    end;
  end;
  x := Savex;
  y := Savey;
  color := Savec;
end;

procedure Shift(ShiftType:  INTEGER);
{ shift drawing one pixel }
var
  Savec,
  Savex,
  Savey:  INTEGER;
  MyImage:  ^AnyImage;
begin
  GetMem(MyImage,Size);
  GetImage(21,21,36,36,MyImage^);		{copy image outside normal}
  PutImage(21,51,MyImage^,NormalPut);		{  location}
  FreeMem(MyImage,Size);
  Savex := x;					{save cursor position}
  Savey := y;
  Savec := color;
  for x := 0 to 15 do begin			{redraw it}
    for y := 0 to 15 do begin
      case ShiftType of
        1: color := GetPixel(20+x,51+y);	{shift right}
        2: color := GetPixel(22+x,51+y);	{shift left}
        3: color := GetPixel(21+x,52+y);	{shift up}
        4: color := GetPixel(21+x,50+y);	{shift down}
      end; {case}
      JustDrawIt;
    end;
  end;
  x := Savex;
  y := Savey;
  color := Savec;
end;

procedure Fill;
{ fill in an area }
var
  flag:  BOOLEAN;
  OldColor,
  savex,savey,
  xbegin,xend,
  fillx,filly:  INTEGER;
begin
  savex := x; savey := y;		{remember where cursor was}
  fillx := x; filly := y;
  OldColor := GetPixel(21+fillx,21+filly);
  repeat
    repeat				{find left edge of region}
      fillx := fillx - 1;
    until (fillx < 0) or (GetPixel(21+fillx,21+filly) <> OldColor);
    fillx := fillx + 1;
    xbegin := fillx;
    repeat				{fill from left to right edge}
      x := fillx; y := filly;
      JustDrawIt;
      fillx := fillx + 1;
    until (GetPixel(21+fillx,21+filly) <> OldColor) or (fillx > 15);
    filly := filly - 1;			{back up a line}
    flag := FALSE;
    for i := xbegin to fillx-1 do begin	{see if empty area on previous line}
      if GetPixel(21+i,21+filly) = OldColor then begin
        fillx := i;			{yes, remember where}
        flag := TRUE;
      end;
    end; {for i}
  until (flag = FALSE) or (filly < 0);
  x := savex; y := savey;		{restore cursor}
end; {Fill procedure}

procedure ViewAll;
{ view page 1 to see last group of images read in }
begin
  MouseCursorOff(Mx,My);
  SetActivePage(1);				{select alternate page}
  SetVisualPage(1);
  MouseCursorOn(Mx,My,FINGER);
  repeat
  until MouseYN(300,300,'Continue?');
  MouseCursorOff(Mx,My);
  SetActivePage(0);				{select normal page}
  SetVisualPage(0);
  MouseCursorOn(Mx,My,HAND);
end;

procedure ReadIt;
{ read image from file }
var
  temp:  STRING;
  SaveColor:  INTEGER;
  FileRec,
  PutType:  WORD;
begin
  SaveColor := Color;
  TextColor(Brown);
  GetMem(MyImage,Size);				{reserve memory}
  filenm := MGetFile('*.pic','Select picture file name:');
  if filenm[0] = #255 then exit;		{abort if nothing entered}
  if Pos('.',filenm) = 0 then
    filenm := filenm + '.pic';
{$I-}
  Assign(fp2,filenm);				{try to open file}
  Reset(fp2);
{$I+}
  if IOResult <> 0 then begin			{if no such file...}
    GotoXY(5,22);Write('I/O ERROR');
    Delay(1000);
    TextColor(Black);
    GotoXY(5,22);ClrEol;
    TextColor(Green);
  end
  else begin					{if file exists...}
    if FileSize(fp2) > 1 then begin
      SetColor(Yellow);
      MaxRec := FileSize(fp2);			{get # records in file}
      MouseCursorOff(Mx,My);
      SetActivePage(1);				{select alternate page}
      SetFillStyle(SolidFill,Black);
      Bar(0,0,639,349);				{clear it}
      GetMem(AltImage,Size);			{get memory for images}
      Reset(fp2);				{open file to beginning}
      for i := 0 to MaxRec-1 do begin		{now draw each image in file}
        Read(fp2,AltImage^);
        PutImage(32+(i mod 18)*32,28+(i div 18)*40,AltImage^,NormalPut);
        OutTextXY(32+(i mod 18)*32,54+(i div 18)*40,ItoS(i+1));
      end;
      OutlineBox(570,320,629,339,Red,Yellow);
      OutTextXY(581,334,'ABORT');
      SetVisualPage(1);
      MoveTo(40,310);
      SetColor(Yellow);
      OutText('Record number (1-'+ItoS(MaxRec)+'): ');
      MouseCursorOn(Mx,My,FINGER);
      FileRec := 0;
      repeat					{use mouse until key hit...}
        MStatus(NewButton,NewX,NewY);		{get mouse status}
          if (NewX <> Mx) or (NewY <> My) then	{mouse cursor moved!}
            MouseCursor(NewX,NewY,Mx,My,FINGER);
        Mx := NewX; My := NewY;			{remember new location}
        if NewButton <> Button then begin	{if button changed...}
          if NewButton > 0 then			{if button now down...}
            i := ((Mx-32) div 32) + 18 * ((My-28) div 40) + 1;
              if i <= MaxRec then FileRec := i;
	    if (Mx>570) and (My>320) then begin	{if abort...}
	      MouseCursorOff(Mx,My);
	      SetActivePage(0);
	      SetVisualPage(0);
	      MouseCursorOn(Mx,My,FINGER);
	      exit;				{just exit}
	    end;
	  Button := NewButton;			{remember new button setting}
        end; {if button changed}
      until KeyPressed or (FileRec > 0);
      MouseCursorOff(Mx,My);
      if KeyPressed then begin
        Input(temp);
        Val(temp,FileRec,i);
      end; {if KeyPressed}
      SetActivePage(0);
      SetVisualPage(0);
      MouseCursorOn(Mx,My,FINGER);
    end
    else FileRec := 1;
    PutType := MouseQuestion(5,'PutImage type:',@PutQues) - 1;
    TextColor(Brown);
    Seek(fp2,FileRec-1);
    Read(fp2,MyImage^);
    Close(fp2);
    PutImage(21,21,MyImage^,PutType);		{put image in small box}
    MouseCursorOff(Mx,My);
    DrawCursor(DarkGray);			{erase cursor}
    for x := 0 to 15 do begin			{now put it in big box}
      for y := 0 to 15 do begin
        Color := GetPixel(21+x,21+y);
        JustDrawIt;
      end;
    end;
    MouseOn;
    x := 0; y := 0;
    Color := SaveColor;				{restore drawing color}
    DrawCursor(Yellow);
    GotoXY(50,23);
    TextColor(Black);ClrEol;
    TextColor(Green);
    Write('  Image: ',filenm,'(',FileRec,')');
  end;
end;

procedure ReRead;
{ reread an image from the last file opened }
var
  tempstr:  STRING;
  temp:  POINTER;
  SaveColor,
  FileRec:  INTEGER;
begin
  SaveColor := color;
  MouseCursorOff(Mx,My);
  SetActivePage(1);				{select alternate page}
  SetVisualPage(1);

  SetColor(Yellow);
  MoveTo(40,310);			{prompt for desired image}
  OutText('Record number (1-'+ItoS(MaxRec)+'): ');
  SetFillStyle(SolidFill,Black);
  Bar(GetX,GetY,GetX+32,GetY-8);
  MouseCursorOn(Mx,My,FINGER);
  FileRec := 0;
  MStatus(NewButton,NewX,NewY);			{get mouse status}
  Button := NewButton;
  repeat					{use mouse until key hit...}
    MStatus(NewButton,NewX,NewY);		{get mouse status}
      if (NewX <> Mx) or (NewY <> My) then	{mouse cursor moved!}
        MouseCursor(NewX,NewY,Mx,My,FINGER);
    Mx := NewX; My := NewY;			{remember new location}
    if NewButton <> Button then begin		{if button changed...}
      if NewButton > 0 then begin		{if button now down...}
        i := ((Mx-32) div 32) + 18 * ((My-28) div 40) + 1;
        if i <= MaxRec then FileRec := i;
        if (Mx>570) and (My>320) then begin	{if abort...}
          MouseCursorOff(Mx,My);
          SetActivePage(0);
          SetVisualPage(0);
          MouseCursorOn(Mx,My,FINGER);
          exit;					{just exit}
        end; {if abort}
      end; {if button changed}
      Button := NewButton;			{remember new button setting}
    end; {if button changed}
  until KeyPressed or (FileRec > 0);
  MouseCursorOff(Mx,My);
  if KeyPressed then begin			{key was pressed, get image}
    Input(tempstr);				{number from keyboard}
    Val(tempstr,FileRec,i);
  end; {if KeyPressed}

  FileRec := FileRec - 1;
  GetMem(temp,ImageSize(0,0,15,15));		{get the desired image}
  GetImage(32+(FileRec mod 18)*32,28+(FileRec div 18)*40,
           47+(FileRec mod 18)*32,43+(FileRec div 18)*40,temp^);
  SetActivePage(0);
  SetVisualPage(0);

  PutImage(21,21,temp^,NormalPut);		{put image in small box}
  DrawCursor(DarkGray);				{erase cursor}
  for x := 0 to 15 do begin			{now put it in big box}
    for y := 0 to 15 do begin
      Color := GetPixel(21+x,21+y);
      JustDrawIt;
    end;
  end;
  x := 0; y := 0;
  Color := SaveColor;				{restore drawing color}
  DrawCursor(Yellow);
  GotoXY(50,23);
  TextColor(Black);ClrEol;
  TextColor(Green);
  Write('  Image: ',filenm,'(',FileRec+1,')');
  FreeMem(temp,ImageSize(0,0,15,15));

  MouseCursorOn(Mx,My,FINGER);
end; {ReRead procedure}

begin {Main routine}
  if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
    Abort('EGA/VGA');
  Initialize;					{initialize graphics}
  PalFlag := 1;
  GetIntVec($1C,Int1CSave);			{save interrupt vector}
  SetIntVec($1C,New1CInt);			{install timer interrupt}

  LookX := 0; LookY := 0;			{no look image now}
  DefaultPalette;				{set up normal palette}
  Size := ImageSize(0,0,15,15);			{size of images}
  x := 0; y := 0;				{initialize cursor}
  SetColor(LightGray);
  Rectangle(19,19,38,38);			{outline drawing areas}
  Rectangle(50,20,212,182);
  Rectangle(310,20,390,255);			{outline color chart}
  Rectangle(339,24,381,250);
  for i := 0 to 15 do begin
    SetFillStyle(SolidFill,i);
    Bar(340,25+(i*14),380,39+(i*14));
    GotoXY(41,3+i);
    if i < 10 then
      Write(i:1)
    else
      Write(Chr(i+55));
  end;
  Clear;
  Prompts;
  Color := 0;
  if MReset = -1 then begin			{see if mouse installed}
    MLimit(0,639-MW,0,349-MH);			{set mouse limits}
    MPut(0,0);					{reset mouse coordinates}
  end;
  Mx := 0; My := 0;				{reset mouse cursor}
  Button := 0;
  GetMem(MCurs,ImageSize(0,0,MW,MH));
  MouseCursorOn(0,0,HAND);
  repeat					{repeat until quit}
    GotoXY(52,2);
    TextColor(Color);
    if MyPal[Color,0] = 0 then
      TextColor(LightGray);
    if Color < 10 then
      Write('Color=',Color,' ')
    else
      Write('Color=',Chr(Color+55));
    repeat					{use mouse until key hit...}
      MStatus(NewButton,NewX,NewY);		{get mouse status}
      if (NewX <> Mx) or (NewY <> My) then	{mouse cursor moved!}
        case MouseLocate(NewX,NewY,18,@mt) of
          0:  MouseCursor(NewX,NewY,Mx,My,HAND);
          2:  MouseCursor(NewX,NewY,Mx,My,ARROW);
          else  MouseCursor(NewX,NewY,Mx,My,FINGER);
        end;
      Mx := NewX; My := NewY;			{remember new location}
      if NewButton <> Button then begin		{if button changed...}
        if NewButton > 0 then begin		{if button now down...}
          case MouseLocate(Mx,My,18,@mt) of	{do a command}
            1: MouseColor;			{set a color}
            2: MouseDrawIt;			{draw a pixel}
            3: SaveIt;
            4: ReadIt;
	    5: ReRead;
	    6: PalFunc;
	    7: if MouseYN(200,200,'Confirm clear?') then Clear;
	    8: ViewAll;
	    9: Look;
	    10: Fill;
	    11: begin MouseCursor(Mx,My,Mx,My,1);Flip(1);MouseCursor(Mx,My,Mx,My,2);end;
	    12: begin MouseCursor(Mx,My,Mx,My,1);Flip(2);MouseCursor(Mx,My,Mx,My,2);end;
	    13: begin MouseCursor(Mx,My,Mx,My,1);Flip(3);MouseCursor(Mx,My,Mx,My,2);end;
	    14: Shift(1);
	    15: Shift(2);
	    16: Shift(3);
	    17: Shift(4);
	    18: if MouseYN(200,200,'Confirm quit?') then Halt;
          else Delay(1);
          end; {case}
        end; {if button now down}
        Button := NewButton;			{remember new button setting}
      end; {if button changed}
    until KeyPressed;
    cmd := ReadKey;				{read a key}
    if cmd = #0 then begin
      cmd := ReadKey;				{2nd half of arrow key}
      LastMove := cmd;				{remember last move direction}
      case cmd of
        #71:  UpLeft;
        #119: Home;
        #79:  DownLeft;
        #117: GoEnd;
        #73:  UpRight;
        #132: TopRight;
        #81:  DownRight;
        #118: BottomRight;
        #76:  Center;
        #72:  UpArrow;
        #80:  DownArrow;
        #75:  LeftArrow;
        #115: FarLeft;
        #77:  RightArrow;
        #116: FarRight;
        else Begin Sound(440);Delay(250);NoSound;End;
       end; {case}
      cmd := #0;
    end
    else begin
      case UpCase(cmd) of
      '0': Color := 0;
      '1': Color := 1;
      '2': Color := 2;
      '3': Color := 3;
      '4': Color := 4;
      '5': Color := 5;
      '6': Color := 6;
      '7': Color := 7;
      '8': Color := 8;
      '9': Color := 9;
      'A': Color := 10;
      'B': Color := 11;
      'C': Color := 12;
      'D': Color := 13;
      'E': Color := 14;
      'F': Color := 15;
      'P': PalFunc;
      'L': Look;
      'S': SaveIt;
      'R': ReadIt;
      'V': ViewAll;
      'W': ReRead;
      'Q': if MouseYN(200,200,'Confirm quit <Y/N>?') then Halt;
      'X': if MouseYN(200,200,'Confirm clear?') then Clear;
      'Z': Fill;
      '-': Shift(1);				{shift right}
      '+': Shift(2);				{shift left}
      '^': Shift(3);				{shift up}
      '|': Shift(4);				{shift down}
      '<': Flip(1);
      '>': Flip(2);
      '@': Flip(3);
      ' ': DrawIt;
      else Begin Sound(440);Delay(250);NoSound;End;
      end; {case}
    end;
  until UpCase(Cmd) = 'Q';
end.
