COMMENT %
**
**  CompMem - A routine to compare to areas of memory for equality
**  by Richard S. Sadowsky [74017,1670]
**  version 1.0  5/11/88
**  released to the public domain
**  assembled with MASM 5.1
**
%
CODE      SEGMENT BYTE PUBLIC
          ASSUME CS:CODE

          PUBLIC CompMem

; function CompMem(var Block1,Block2; Size : Word) : Word
; return 0 if Block1 and Block2 are equal for Size bytes
; if not equal, return the position of first non matching byte
; the first byte is considered to be 1

CompMem          PROC FAR

       MOV       BX,SP           ; stack frame with BX
       MOV       DX,DS           ; preserve DS in DX
       XOR       AX,AX           ; zero out AX

       MOV       CX,SS:[BX+04h]  ; get Size
       JCXZ      Fini            ; if zero then exit

       LDS       SI,SS:[BX+0Ah]  ; address of block1 in DS:SI
       LES       DI,SS:[BX+06h]  ; address of block2 in ES:DI

       CLD                       ; forward string operations

       REPE      CMPSB           ; look for first non match or CX = 0
       JE        Fini            ; equal so exit (o in AX)

       MOV       AX,SS:[BX+04h]  ; get size again
       SUB       AX,CX           ; return position of first non match

Fini:  MOV       DS,DX           ; restore DS
       RET       0Ah             ; remove params from the stack

CompMem          ENDP

CODE   ENDS

       END
