(*****************************************************************************)
(*                                                                           *)
(*   Maximus CBCS v2.01wb Turbo Pascal USER.BBS/LASTUS??.BBS data structure  *)
(*                                                                           *)
(*                Converted to Turbo Pascal by David Drzyzga                 *)
(*                                                                           *)
(*                            Compliments of                             *)
(*                                                                           *)
(*                          =>> CUTTER JOHN'S <<=                            *)
(*                              (904)932-1849                                *)
(*                                                                           *)
(*                               23hrs/7days                                 *)
(*                          US Robotics HST 14.4k                            *)
(*                                                                           *)
(*                            FidoNet 1:3612/220                             *)
(*                                                                           *)
(*                Official Release Point for EPIC MegaGames                  *)
(*             Official APOGEE Software Distribution Site #155               *)
(*                    Distribution site for MVP Software                     *)
(*                                                                           *)
(*                           SDS/SDN/DDS/UTILNET                             *)
(*                                                                           *)
(*****************************************************************************)

const

{ Masks for usr.help, below }

  HELP_HOTFLASH         = $20;
  HELP_EXPERT           = $02;
  HELP_REGULAR          = $04;
  HELP_NOVICE           = $06;

{ Constants for usr.video, below }

  VIDEO_TTY             = $00;     { The current user's graphics setting...   }
  VIDEO_ANSI            = $01; 
  VIDEO_AVATAR          = $02;

{ Masks for usr.bits1, below }

  BITS_HOTKEYS          = $01;     { Hotkeys, independent of HOTFLASH level   }
  BITS_NOTAVAIL         = $02;     { If set, user is NOT available for chat.  }
  BITS_FSR              = $04;     { Full-screen reading in msg areas         }
  BITS_NERD             = $08;     { Yelling makes no noise on sysop console  }
  BITS_NOULIST          = $10;     { Don't display name in userlist           }
  BITS_TABS             = $20;     { Reserved                                 }
  BITS_BIT6             = $40;     { Reserved                                 }
  BITS_BIT7             = $80;     { Reserved                                 }


{ Masks for usr.bits2, below }

  BITS2_BADLOGON        = $0001;   { MAX: if user's last logon attempt was bad}
  BITS2_IBMCHARS        = $0002;   { MAX: if user can receive high-bit chars  }
  BITS2_RSVD1           = $0004;   { MAX: *obsolete* 1.02 avatar flag         }
  BITS2_BORED           = $0008;   { Use the line-oriented editor             }
  BITS2_MORE            = $0010;   { Wants the "MORE?" prompt                 }
  BITS2_RSVD2           = $0020;   { OPUS: set=wants Ansi                     }
  BITS2_CONFIGURED      = $0040;   { OPUS: set=used Maximus before            }
  BITS2_CLS             = $0080;   { OPUS: set=transmit ^L, clear=ignore ^L   }
  BITS2_BIT8            = $0100;   { used to be 'usr.keys'                    }
  BITS2_BIT9            = $0200;   { used to be 'usr.keys'                    }
  BITS2_BITA            = $0400;   { used to be 'usr.keys'                    }
  BITS2_BITB            = $0800;   { used to be 'usr.keys'                    }
  BITS2_BITC            = $1000;   { used to be 'usr.keys'                    }
  BITS2_BITD            = $2000;   { used to be 'usr.keys'                    }
  BITS2_BITE            = $4000;   { used to be 'usr.keys'                    }
  BITS2_BITF            = $8000;   { used to be 'usr.keys'                    }

{ Masks for usr.priv, below }

  TWIT                  = $FFFE;
  DISGRACE              = $0000;
  LIMITED               = $0001;
  NORMAL                = $0002;
  WORTHY                = $0003;
  PRIVIL                = $0004;
  FAVORED               = $0005;
  EXTRA                 = $0006;
  CLERK                 = $0007;
  ASSTSYSOP             = $0008;
  SYSOP                 = $000A;
  HIDDEN                = $000B;

{ Masks for usr.delflag, below }

  UFLAG_DEL             = $01;
  UFLAG_PERM            = $02;

{ Masks for usr.xp_flag, below }

  XP_DATE               = $01;     { Use the xp_date to control access        }
  XP_TIME               = $02;     { Use the xp_mins number to control access }
  XP_DEMOTE             = $04;     { Demote user to priv level in usr.xp_priv }
  XP_HANGUP             = $08;     { Just hang up on user                     }
  XP_NONE               = $00;
  XP_DATE_DEMOTE        = $05;
  XP_DATE_HANGUP        = $09;
  XP_TIME_DEMOTE        = $06;
  XP_TIME_HANGUP        = $0A;

{ Constants used for urs.xkeys, below }

  KEY1                  = $00000001;
  KEY2                  = $00000002;
  KEY3                  = $00000004;
  KEY4                  = $00000008;
  KEY5                  = $00000010;
  KEY6                  = $00000020;
  KEY7                  = $00000040;
  KEY8                  = $00000080;
  KEYA                  = $00000100;
  KEYB                  = $00000200;
  KEYC                  = $00000400;
  KEYD                  = $00000800;
  KEYE                  = $00001000;
  KEYF                  = $00002000;
  KEYG                  = $00004000;
  KEYH                  = $00008000;
  KEYI                  = $00010000;
  KEYJ                  = $00020000;
  KEYK                  = $00040000;
  KEYL                  = $00080000;
  KEYM                  = $00100000;
  KEYN                  = $00200000;
  KEYO                  = $00400000;
  KEYP                  = $00800000;
  KEYQ                  = $01000000;
  KEYR                  = $02000000;
  KEYS                  = $04000000;
  KEYT                  = $08000000;
  KEYU                  = $10000000;
  KEYV                  = $20000000;
  KEYW                  = $40000000;
  KEYX                  = $80000000;
  KEYALL                = $FFFFFFFF;

{ Constants for usr.lang, below }

  LANGUAGE_01           = $00;
  LANGUAGE_02           = $01;
  LANGUAGE_03           = $02;
  LANGUAGE_04           = $03;
  LANGUAGE_05           = $04;
  LANGUAGE_06           = $05;
  LANGUAGE_07           = $06;
  LANGUAGE_08           = $07;

{ Constants for usr.def_proto, below }

  DPROT_NONE            = $FF;
  DPROT_XMODEM          = $FE;
  DPROT_TELELINK        = $FD;
  DPROT_XMODEM1K        = $FC;
  DPROT_SEALINK         = $FB;
  DPROT_ZMODEM          = $FA;
  DPROT_XTERN01         = $00;
  DPROT_XTERN02         = $01;
  {etc..}

{ Constants for usr.compress, below }

  COMPRESS_NONE         = $00;
  COMPRESS_01           = $01;
  COMPRESS_02           = $02;
  COMPRESS_03           = $03;
  COMPRESS_04           = $04;
  COMPRESS_05           = $05;
  COMPRESS_06           = $06;
  COMPRESS_07           = $07;
  COMPRESS_08           = $08;
  COMPRESS_09           = $09;
  COMPRESS_10           = $0A;
  COMPRESS_11           = $0B;
  COMPRESS_12           = $0C;
  COMPRESS_13           = $0D;
  COMPRESS_14           = $0E;
  COMPRESS_15           = $0F;
  
type
  datetime = record
    date:word;
    time:word;
  end;

  usr = record
    name:array [0..35] of char;    { Caller's name                            }
    city:array [0..35] of char;    { Caller's location                        }
    alias:array [0..20] of char;   { MAX: user's alias (handle)               }
    phone:array [0..14] of char;   { MAX: user's phone number                 }
    lastread_ptr:word;             { MAX: a num which points to offset in     }
                                   { LASTREAD file -- Offset of lastread      }
                                   { pointer will be lastread_ptr*sizeof(int) }
    timeremaining:word;            { MAX: time left for current call          }
    pwd:array [0..15] of char;     { Password                                 }
    times:word;                    { Number of previous calls to this system  }
    help:byte;                     { Help level                               }
    rsvd1:array[0..1] of byte;     { Reserved by Maximus for future use       }
    video:byte;                    { user's video mode (see VIDEO_XXXX)       }
    nulls:byte;                    { Number of Nulls (delays) after <cr>      }
    bits:byte;                     { Bit flags for user (number 1)            }
    rsvd2:word;                    { Reserved by Maximus for future use       }
    bits2:word;                    { Bit flags for user (number 2)            }
    priv:word;                     { Access level                             }
    rsvd3:array [0..18] of char;   { Reserved by Maximus for future use       }
    struct_len:byte;               { len of struct, divided by 20.            }
    time:word;                     { Time on-line so far today                }
    delflag:word;                  { Used to hold delete/permanent status     }
    rsvd4:array [0..7] of byte;    { Reserved by Maximus for future use       }
    width:byte;                    { Width of the caller's screen             }
    len:byte;                      { Height of the caller's screen            }
    credit:word;                   { Matrix credit, in cents                  }
    debit:word;                    { Current matrix debit, in cents           }
    xp_priv:word;                  { Priv to demote to, when time runs out    }
    xp_date:datetime;              { Bit-mapped date of when user expires.    }
                                   { If zero, then no expiry date.            }
    xp_mins:longint;               { Minutes left before expiring.            }
    xp_flag:byte;                  { Flags for expiry.  See above XP_XXXXXX   }
    xp_rsvd:byte;                  { Reserved by Maximus for future use       }
    ludate:datetime;               { Bit-mapped date of user's last call      }
    xkeys:longint;                 { User's keys (all 32 of 'em)              }
    lang:byte;                     { The user's current language #            }
    def_proto:byte;                { Default file-transfer protocol           }
    up:longint;                    { K-bytes uploaded, all calls              }
    down:longint;                  { K-bytes downloaded, all calls            }
    downtoday:longint;             { K-bytes downloaded, today                }
    msg:array [0..9] of char;      { User's last msg area (string)            }
    files:array [0..9] of char;    { User's last file area (string)           }
    compress:byte;                 { Default compression program to use       }
    rsvd:array[0..4] of byte;      { Reserved by Maximus for future use       }
  end;
