Unit MATHLIB;

(* Bibliotheque mathematique pour type real *)
(* JD GAYRARD fev 94 *)
(* la bibliotheque est batie  partir des fonctions : *)
(* ARCTAN, COS, EXP, LN, SIN, SQRT *)
(* elle fournit les fonctions : *)
(* ARCCOS, ARCSIN, ARCTAN2, LOG, TAN *)
(* PUISSANCE, SIGNE, MAX, MIN, MODULO *)


interface

const pi_sur_2 = pi / 2.0;
      log10E = 0.434294481903;

function tan(x : real): real;
function arcsin(x : real): real;
function arccos(x : real): real;
function arctan2(x, y : real): real;
function log(x : real): real;
function puissance( x, n : real): real;
function modulo( x, m : real): real;
function signe(x, y : real): real;
function max(x, y : real): real;
function min(x, y : real): real;

implementation

function signe(x, y : real): real;
(* retourne x avec le signe de y *)
begin
if x > 0.0 then if y > 0.0 then signe := x
                           else signe := -x
           else if y < 0.0 then signe := x
                           else signe := -x
end;

function min(x, y : real): real;
(* retourne le plus petit *)
begin
if x > y then min := y
         else min := x
end;

function max(x, y : real): real;
(* retourne le plus grand *)
begin
if x < y then max := y
         else max := x
end;

function tan(x : real): real;
(* retourne la tangente de x (en radian) *)
var sinx, cosx :real;
begin
sinx := sin(x);
cosx := cos(x);
if cosx = 0.0
   then begin
        writeln('******* Fonction tan ********');
        writeln('********* OVERFLOW **********');
        halt
        end
   else tan := sinx / cosx
end;

function arcsin(x : real): real;
begin
if (x > 1.0) or (x < -1.0)
   then begin
        writeln('****** Fonction arcsin ******');
        writeln('********* OVERFLOW **********');
        halt
        end
   else if x = 0.0
           then arcsin := 0.0
           else if x = 1.0
                   then arcsin := pi_sur_2
                   else if x = -1.0
                           then arcsin := - pi_sur_2
                           else arcsin := arctan(x / sqrt( 1.0 - x * x))
end;

function arccos(x : real): real;
var y : real;
begin
if (x > 1.0) or (x < -1.0)
   then begin
        writeln('****** Fonction arccos ******');
        writeln('********* OVERFLOW **********');
        halt
        end
   else if x = 0.0
           then arccos := pi_sur_2
           else if x = 1.0
                then arccos := 0.0
                else if x = -1.0
                        then arccos := pi
                        else begin
                             y := arctan(sqrt( 1.0 - x * x) / x);
                             if x > 0.0
                                then arccos := y
                                else arccos := y + pi;
                             end
end;

function arctan2(x, y : real): real;
begin
if x = 0.0
   then arctan2 := signe(pi_sur_2, y)
   else if x > 0.0
        then arctan2 := arctan(y/x)
        else arctan2 := arctan(y/x) + signe(pi,y)
end;


function puissance( x, n : real): real;
begin
puissance := exp( n * ln(x))
end;

function modulo(x, m : real): real;
begin
while x < 0 do x := x + m;
while x > m do x := x - m;
modulo := x
end;

function log(x : real): real;
begin
log := log10E * ln(x)
end;

end.
