{ ******************************************************************** }
{ *                     TrigFun.bas   %INCLUDE FILE                  * }
{ *          Trigonometric functions For CBASIC-80 version 2.08      * }
{ *                   Copyright (c) 1982, Robert Lurie               * }
{ ******************************************************************** }


{ ******************************* constants ************************** }

CONST Pi     =  3.14159265358979;
      Sqrt2  =  1.41421356237310;

      LocT0  =  0.103851714551977E4;
      LocT1  = -0.178056467143863E2;
      LocT2  =  0.262478645943200E-1;
      LocT3  =  0.264456219512224E4;
      LocT4  = -0.181283283485401E3;

      LocT5  =  0.216062307897243E3;
      LocT6  =  0.322662070013251E3;
      LocT7  =  0.132702398163977E3;
      LocT8  =  0.128883830341573E2;
      LocT9  =  0.216062307897243E3;
      LocT10 =  0.394682839312283E3;
      LocT11 =  0.221050883028418E3;
      LocT12 =  0.385014865083512E2;

{ ****************************** functions *************************** }

FUNCTION TanHalf(x:REAL):REAL;
   VAR O, OSquare : REAL;
       Loop       : INTEGER;
   BEGIN O := ABS(x) / (pi + pi);
         O := 8.0 * (O - INT(O));
         Loop := 0;
         WHILE (O > 1.0) DO  BEGIN
            O := 0.5 * O;
            Loop := Loop + 1
         END;
         OSquare := Sqr(O);
         O := O*((LocT2*OSquare + LocT1)*OSquare + LocT0)
                     / ((OSquare + LocT4)*OSquare + LocT3);
         WHILE Loop > 0 DO  BEGIN
            O := (O + O) / (1.0 - Sqr(O));
            Loop := Loop - 1
         END;
         IF x < 0.0 THEN TanHalf := -O  ELSE TanHalf := O
   END;

FUNCTION Sine(x:REAL):REAL;
   BEGIN x := TanHalf(x);
         Sine := (x + x) / (1.0 + Sqr(x))
   END;

FUNCTION Cosine(x:REAL):REAL;
   BEGIN x := TanHalf(x);
         x := Sqr(x);
         Cosine := (1.0 - x) / (1.0 + x)
   END;

FUNCTION Tan(x:REAL):REAL;
   BEGIN x := TanHalf(x);
         Tan := (x + x) / (1.0 - Sqr(x))
   END;

FUNCTION ATan(x:REAL):REAL;
   VAR O, OSquare : REAL;
       Loop       : INTEGER;
   BEGIN O  := ABS(x);
         Loop := 0;
         IF (O > Sqrt2 + 1.0) THEN  BEGIN
              Loop := 2; O := -1.0 / O
         END;
         IF (O > Sqrt2 - 1.0) THEN  BEGIN
              Loop := 1; O := 1.0 - 2.0 / (1.0 + O)
         END;
         OSquare := Sqr(O);
         O := O * (((LocT8 * OSquare + LocT7)
                    * OSquare + LocT6) * OSquare + LocT5);
         OSquare := (((OSquare + LocT12) * OSquare + LocT11)
                    * OSquare + LocT10) * OSquare + LocT9;
         O := O / OSquare;
         IF Loop = 1 THEN O := O + 0.25 * pi;
         IF Loop = 2 THEN O := O + 0.50 * pi;
         IF x < 0.0 THEN ATan := -O ELSE ATan := O
   END;

FUNCTION ASin(x:REAL):REAL;
   VAR O, OSquare : REAL;
   BEGIN O := ABS(x);
        IF O > 1.0 THEN WRITE('Illegal arguement');
        IF O = 1.0 THEN BEGIN
             IF x < 0.0 THEN ASin :=  -0.5 * pi
                        ELSE ASin := 0.5 * pi
             END
        ELSE ASin := ATan(x / SQR(1.0 - Sqr(x)))
   END;

FUNCTION ACos(x:REAL):REAL;
   BEGIN ACos := (0.5 * pi) - ASin(x)
   END;

{ ************************** end of TrigFunc.bas ********************* }

