{$F+,O+}
UNIT File_Lib;
INTERFACE
  function File_Exist (File_Name : string) : boolean;

  function Find_File_Along_Path (File_Name : string) : string;

                            {* Assumes path ends with a '/'   *}
  procedure Check_Valid_Path (Path_To_Ck     : string;
                              VAR Ret_Status : integer);

  function Get_Unique_FileName : string;

  procedure Erase_File (File_Name  : string;
                        Var Status : byte);
  {* erase MANY files *}
  procedure Erase_Wild_Files (File_Name_Mask : string);

  function File_Error (Err : word) : string;
  function File_Error_This_File (File_Name : string) : string;

IMPLEMENTATION
USES
  Line_Collection,
  Str_Stf,
  DOS;

{***********************************************************************}
function File_Exist (File_Name : string) : boolean;
var
  DirInfo  : DOS.SearchRec;
begin
  DOS.FindFirst (File_Name, DOS.AnyFile, DirInfo);

  IF (DOS.DosError = 0)
    THEN File_Exist := TRUE
    ELSE File_Exist := FALSE;
end; {File_Exist}

{***********************************************************************}
function Find_File_Along_Path (File_Name : string) : string;
begin
  {*------------------------------------------------------------*}
  {* Ok, Must check for file along the current PATH             *}
  {* Starting with the current path                             *}
  {*------------------------------------------------------------*}
  Find_File_Along_Path := DOS.FSearch (File_Name, DOS.GetEnv('PATH'));
end; {Find_File_Along_Path}





{***********************************************************************}
{* Assumes path ends with a '/'   *}
procedure Check_Valid_Path (Path_To_Ck     : string;
                            VAR Ret_Status : integer);
var
  Curr_Path : string;
  Dir       : DOS.DirStr;
  Ext       : DOS.ExtStr;
  Name      : DOS.NameStr;
  Temp_Str  : string;
begin
  Ret_Status := 0;
  Temp_Str := TRIM (Path_To_Ck);
  IF (Temp_Str = '')
    THEN Ret_Status := -1
  ELSE
    BEGIN
      Temp_Str := DOS.FExpand (Temp_Str);
      DOS.FSplit (Temp_Str, Dir, Name, Ext);
      IF ((Name <> '') or (Ext <> ''))
        THEN Ret_Status := -2
      ELSE IF (POS (':', Dir) <> 2)
        THEN Ret_Status := -3
      ELSE IF ((POS ('\', Dir) <> 3))
        THEN Ret_Status := -4
      ELSE
        BEGIN {* Looks ok, check if directory exists *}
          GetDir (0, Curr_Path);
          DEC(Temp_Str[0]); {cut off last '\'}
          {$I-} ChDir (Temp_Str); {$I+}
          IF (IoResult <> 0)
            THEN Ret_Status := -5;
          ChDir (Curr_Path);
        END;
    END; {if}
end;  {Check_Valid_Path}


{***********************************************************************}
function Get_Unique_FileName : string;
var
  T_Hr, T_Min, T_Sec, T_100 : word;
begin
  DOS.GetTime (T_Hr, T_Min, T_Sec, T_100);
  Get_Unique_FileName := Int_To_Str(T_Hr)+Int_To_Str(T_Min)+
                         Int_To_Str(T_Sec)+Int_To_Str(T_100);
end; {get_unique_filename}

{***********************************************************************}
procedure Erase_File (File_Name  : string;
                      Var Status : byte);
VAR
  f : file;
begin
  Status := 0;
  Assign (F, File_Name);
  {$I-} Reset (F); {I+}
  IF (IOResult = 0) THEN
    BEGIN
      {$I-}
      Close (F);
      Erase (F);
      {$I+}
      IF (IOResult <> 0)
        THEN Status := 2;
    END
  ELSE Status := 1;
end; {erase_file}

{***********************************************************************}
function File_Error (Err : word) : string;
begin
  CASE Err OF
    0: File_Error := '';      {no error}
    2: File_Error := ' File Not Found';
    3: File_Error := ' Path Not Found';
    4: File_Error := ' Too many open files (Need more FILE=# in CONFIG.SYS)';
    5: File_Error := ' File Access Denied'
  ELSE
    File_Error := ' Some File error';
  END;
end; {file_error}

{***********************************************************************}
function File_Error_This_File (File_Name : string) : string;
var
  t     : file;
  Reply : word;
begin
  assign (T, File_Name);
  {$I-} ReSet(T);
  File_Error_This_File := File_Error (IOResult);
  Close (T);
  {$I+}
  Reply := IOResult;
end; {file_error_this_File}

{***********************************************************************}
procedure Erase_Wild_Files (File_Name_Mask : string);
var
  DirInfo              : DOS.SearchRec;
  File_Name            : string;
  File_Names           : PMany_Line_Sort_Collection;
  i                    : integer;
  Status               : byte;
begin
  File_Names := NEW (PMany_Line_Sort_Collection, INIT (30,5));

  DOS.FindFirst (File_Name_Mask, DOS.AnyFile, DirInfo);

  WHILE (DOS.DosError = 0) DO
  BEGIN
    File_Names^.Over_Write (New(PStrSort_Record,
                                           Init(DirInfo.Name,
                                                DirInfo.Name, '')));
    DOS.FindNext (DirInfo);
  END; {while}

  FOR i := 0 to (File_Names^.Count-1) DO
  BEGIN
    File_Name := PStrSort_Record(File_Names^.At(I))^.Lines[1]^;
    Erase_File (File_Name, Status);
  END; {for}

  Dispose (File_Names, DONE);

end; {Erase_Wild_Files}



end. {unit File_Lib}