{$F+,O+}
{$N+,E+}  (*  $N+ compiles for 80x87 which is used                 *)
          (*  automatically IF available.  E+ activates the        *)
          (*  80X87 emulator which will be used IF a coprocessor   *)
          (*  is not present.  I understand that these are program *)
          (*  wide options and cannot be used in a unit separately *)

(*  Written by Dan Glanz, Alexandria, Virginia (76672,2572), May, 1989. *)
(*  as a public service.                                                *)
(*  There are no restrictions on use and no gaurantees that it works.   *)
(*	All I ask is a smidgeon of credit.                              *)
(*  If you include this in a program, leave the credit line in.         *)
(*  If you modify the unit, add your own credit line.                   *)

(*  Modified by Doug Hood, New Brunswick, NJ   (70324,3336) 1992        *)
(*  as a public service.                                                *)
(*  There are no restrictions on use and no gaurantees that it works.   *)
(*	All I ask is a smidgeon of credit.                              *)
(*  If you include this in a program, leave the credit line in.         *)
(*  If you modify the unit, add your own credit line.                   *)

(*  Modified by Oscar Colpas, New Brunswick, NJ   August 1992           *)
(*  as a public service.                                                *)
(*  There are no restrictions on use and no gaurantees that it works.   *)
(*	All I ask is a smidgeon of credit.                              *)
(*  If you include this in a program, leave the credit line in.         *)
(*  If you modify the unit, add your own credit line.                   *)


(*	This is a Turbo Pascal 5.0 unit designed to allow reading and writing
	of Lotus 1-2-3,	Symphony, VP-Planner and other such files using the
	Lotus 1-2-3 file format.

              ************** update information  ***************

    This version is updated to allow reading and writing of range names and
    extents and column widths.  The structure of the "Lotus_Record_Type" has
    been modified to variant records for efficiency in data storage.

              **************************************************

	Lotus 1-2-3 uses 8 byte reals (TP's double's).  Any program using
	Lotus 1-2-3 data must either use a math coprocessor {$N+} or
	coprocessor emulation {$N+,E+}

	For demonstration purposes, a separate program called TEST123
    is included in the ARC file.

       It reads any Lotus format file and copies out label, integer, real
    column width, range identification and the current value of formula cells
    to a file in the same directory with the same name but with an extension
    of '.WK!'  It does not copy formulas and other such information.
       It is primarily designed to allow access to the DATA.  However, it
    does read column widths, and range names and extents.

    Take note that Lotus rows and columns are numbered starting with 0.
    that is Column A is 0 and Row 1 is 0.

    Lotus_Version is set up as a typed constant as if the file were
    a Lotus version 1.0 or 1a type file.  Change it if you need to.
    The program automatically writes a version record at the beginnning of
    the file when the file is opened for writing by calling
    Open_Lotus_Write_File.  It must do this or Lotus 1-2-3 will not
    allow use of the file.  IF you have used Open_Lotus_Read_File to open
    a file to be copied or accessed, THEN the version of that file is
    substituted for the default Lotus_Version.

    IF you want to use the unit to create a Lotus formatted file directly,
    you must provide the row and column of the data in Lotus_Cell.Row and
    Lotus_Cell.Column (starting with row 0 and column 0), define the format
    in Lotus_Cell.Format (default seems to be 255) set the value in either
    Lotus_Cell.Integer_Value, Lotus_Cell.Real_Value, Lotus_Cell.Column_Width, or
    Lotus_Cell.Range_Name, Range_Start Column, etc., or Lotus_Cell.Label_Value.
    then set Lotus_Cell.Cell_Type := to Integer_Type, Real_Type, Column_Width_Type,
    range_Type or Label_Type as the case may be	and call Write_Lotus_Record.

    Note: When you write your own labels in Label_Value, make sure you put
	  a ' or " or ^ as the first character of the string.  Also, you may be
	  able to include formulas in a worksheet you are creating by writing out
	  a label cell containing with the formula and then deleting
	  the ', ", or ^ in the spreadsheet itself, perhaps by using a macro.

	When you call Close_Lotus_Write_File, an end of file record is written
	and the file is automatically closed.

	Lotus 1-2-3 is a trademark of Lotus Corporation. *)

UNIT Unit123;
(*****************************************************************************)
                               INTERFACE
(*****************************************************************************)

USES
     DOS,
     Line_Collection;

  {*---------------------------------------*}
  {* CELL_PTR : PStrIntMixed_Record        *}
  {*  Line[ ]                              *}
  {*       0 = Which Cell Count 1,2..      *}
  {*       1 = Cell_Col                    *}
  {*       2 = Cell_Row                    *}
  {*       3 = Cell_Value                  *}
  {*           NOTE: Blanks are NIL        *}
  {*       4 = Store into Name             *}
  {*       5 = Cell_Addr (unit123 reserved)*}
  {*           NOTE: Blanks are NIL        *}
  {*  Ints[ ]                              *}
  {*       1 = Err_Code for cell           *}
  {*       2 = If cell found (123 internal)*}
  {*       3 = Used when writing to file   *}
  {*           contains file position of   *}
  {*           the beginning of cell       *}
  {*---------------------------------------*}

  {*--------------------------------------------------*}
  {*  Err_Code:                                       *}
  {*      -999 : Row+Col Not Found                    *}
  {*      -998 : Row+Col Not supported data type      *}
  {*       0   : everything ok!                       *}
  {*--------------------------------------------------*}

  Procedure Find_Lotus_Record (File_Name     : DOS.PathStr;
                               Cell_List     : PMany_Line_Sort_Collection;
                               Read_from_Cell: Boolean;
                               VAR Err_Code  : integer;
                               VAR Err_Msg   : String);

(*****************************************************************************)
                              IMPLEMENTATION
(*****************************************************************************)
USES
    File_Bufs,
    Dates, {for converting lotus Dates}
    RealStr,
    Str_Stf,
    {Arc_Utils, {to determine what type of value to put into a BLANK Cell}
    File_Lib; {for File_Error}

CONST
  Lotus_Version : integer = 1028;  {1028 for Lotus 1}
                                   {1029 for Symphony 1.0}
                                   {1030 for Lotus 2 & Symphony 1.1}

TYPE
  Lotus_Cell_Type = (Version_Type, END_Of_File_Type, Blank_Type,
                     Integer_Type, Real_Type, Label_Type,
                     Formula_Type, Unidentified, Range_Type,
                     Column_Width_Type);

  Lotus_Record_Type = Record
	    Cell_Type_Code	: Integer;
	    Cell_Length		: Integer;
	    Format		: Byte;
	    Column		: integer;
	    Row			: integer;
	    Cell_Type           : Lotus_Cell_Type;
            Alpha_Column        : String[8];
	    CASE integer OF
                 8:   (Column_Width       : Byte);
                 11:  (Range_Name         : string[16];
                       Range_Start_Column : integer;
                       Range_Start_Row    : integer;
                       Range_END_Column   : integer;
                       Range_END_Row      : integer;
                       Alpha_Range_Start  : string;
                       Alpha_Range_END    : String);
                 13:  (Integer_Value	  : integer);
                 14:  (Real_Value	  : double);
                 15:  (Label_Value        : string;
                        Zero		  : byte);
                 16:  (Formula_Value      : double;
                       Formula_Length     : integer;
                       Formula		  : array [0 .. 255] of byte);
                255:  (Unidentified       : array [0 .. 511] of byte);
	    END; {case/record}

  PLotus_Master_Struct_Type = ^Lotus_Master_Struct_Type;
  Lotus_Master_Struct_Type = record
    Lotus_Cell		    : Lotus_Record_Type;
    Lotus_File_Name         : PathStr;
    Lotus_Read_File         : file;

    GBL_Lotus_End_Of_File   : boolean;

    Lotus_Record_File_Pos   : LongInt;
    Lotus_Version_Name  : string;
  END; {record}

VAR
  GBL_Master_Struct : PLotus_Master_Struct_Type;

(*****************************************************************************)
FUNCTION Lotus_End_Of_File : boolean;
BEGIN
  Lotus_End_Of_File := GBL_Master_Struct^.GBL_Lotus_End_Of_File;
END; {lotus_End_of_File}

(*****************************************************************************)
(*
Procedure Set_Input_File_Name (File_Name : string);
{IF the extension is ommitted, it substitutes .WKS }

VAR
  Lotus_Read_File_ExtStr  : ExtStr;
  Lotus_Read_File_DirStr  : DirStr;
  Lotus_Read_File_NameStr : NameStr;
BEGIN
  Lotus_File_Name := File_Name;

  FSplit (Lotus_File_Name, Lotus_Read_File_DirStr,
                                Lotus_Read_File_NameStr,
                                Lotus_Read_File_ExtStr);

  IF  (Lotus_Read_File_ExtStr = '')
    THEN Lotus_Read_File_ExtStr := '.WKS';

  Lotus_File_Name := Lotus_Read_File_DirStr  +
                          Lotus_Read_File_NameStr +
                          Lotus_Read_File_ExtStr;
END; {set_input_file_name}
*)

(*****************************************************************************)
Procedure Read_Type_and_Length (Var Err_Msg: String);

{Could be changed to a single BlockRead since Cell_Type_Code}
{Cell_Length are adjacent in the record definition and on the file.}

{Since this procedure is called when a lotus record is about to be}
{read "Lotus_Record_File_Pos" remembers where the record begins.  }

VAR
  NumRead : Word;
  reply   : Word;
BEGIN
{$I+}
  Err_Msg := '';

  GBL_Master_Struct^.Lotus_Record_File_Pos :=
          FilePos(GBL_Master_Struct^.Lotus_Read_File);

  Reply := IOResult;
(*  IF (Lotus_Record_File_Pos > FileSize(Lotus_Read_File)) THEN
    Lotus_Record_File_Pos := FileSize(Lotus_Read_File)

  ELSE *)
  IF (reply <> 0)
   THEN Err_Msg := 'Error reading "'+GBL_Master_Struct^.Lotus_File_Name+'":'+File_Error(reply)

  ELSE
    WITH GBL_Master_Struct^ DO
    BEGIN
      BlockRead(Lotus_Read_File, Lotus_Cell.Cell_Type_Code, 2, NumRead);
      BlockRead(Lotus_Read_File, Lotus_Cell.Cell_Length,    2, NumRead);

      IF (NumRead = 0)
        THEN GBL_Lotus_End_Of_File := TRUE;
    END; {with}
{$I+}
END; {read_type_and_length}

(*****************************************************************************)
Procedure Get_Alpha_Column (VAR Alpha_Column_ID       : String;
                            Column_Number, Row_Number : integer);
VAR
   First_Char : char;
   Second_Char : char;
   Row_String  : string[6];

BEGIN
   First_Char  := char(64 + Column_Number div 26);
   Second_Char := char(65 + Column_Number -((byte(First_Char)-64) * 26));

   IF First_Char = #64
     THEN First_Char := #32;

   Str(Row_Number + 1, Row_String);
   Alpha_Column_ID := First_Char + Second_Char + Row_String;
END; {get_alpha_column}

(*****************************************************************************)
Procedure Read_Format_Info;

{Could be changed to a single BlockRead since format, column}
{and row are adjacent in the record definition and on the file.}

VAR
    Alpha_Column_ID : string;
    NumRead         : Word;
BEGIN
{$I-}
  WITH GBL_Master_Struct^ DO
  BEGIN
    BlockRead(Lotus_Read_File, Lotus_Cell.Format, 1, NumRead);
    BlockRead(Lotus_Read_File, Lotus_Cell.Column, 2, NumRead);
    BlockRead(Lotus_Read_File, Lotus_Cell.Row,    2, NumRead);

    Get_Alpha_Column(Alpha_Column_ID, Lotus_Cell.Column, Lotus_Cell.Row);
    Lotus_Cell.Alpha_Column := Alpha_Column_ID;
  END;
{$I+}
END; {read_format_info}

(*****************************************************************************)
Procedure Close_Lotus_Read_File;
Var
 reply : word;
BEGIN
{$I-}  Close (GBL_Master_Struct^.Lotus_Read_File); {$I+}
       reply := IOResult;
END;

(*****************************************************************************)
Procedure Get_Version_Name;
BEGIN
  WITH GBL_Master_Struct^
  DO Case Lotus_Version of
    1028: Lotus_Version_Name := 'Lotus 1-2-3 Version 1.0 or 1A';
    1029: Lotus_Version_Name := 'Symphony Version 1.0';
    1030: Lotus_Version_Name :=
              'Lotus 1-2-3 Version 2.0, 2.1 or Symphony Version 1.1';
    ELSE
       Lotus_Version_Name := 'Unidentified';
  END;
END; {get_version_name}

(*****************************************************************************)
Procedure Read_Lotus_Record (VAR Err_Msg: String);
VAR
  Alpha_Column_ID : string;

  NumRead  : Word;
  Jump_loc : LongInt;
BEGIN
  FillChar (GBL_Master_Struct^.Lotus_Cell,
                SizeOf (GBL_Master_Struct^.Lotus_Cell), #0);
{$I-}
  Read_Type_and_Length (Err_Msg);

  IF (Err_Msg = '') THEN
     WITH GBL_Master_Struct^ DO
     Case Lotus_Cell.Cell_Type_Code of
        0:  BEGIN {* Version Record There should be only one record of this *}
                  {* type and it will normally be read when you call        *}
                  {* Open_Lotus_Read_File.                                  *}

	      Lotus_Cell.Cell_Type := Version_Type;
	      BlockRead (Lotus_Read_File, Lotus_Version, 2, NumRead);
	      Get_Version_Name;
	    END;{0}

        1:  BEGIN                                        {End of File}
              Lotus_Cell.Cell_Type := End_Of_File_Type;
              GBL_Lotus_End_of_File := True;
	    END;{1}

        8:  BEGIN                                        {Column width type}
              Lotus_Cell.Cell_Type := Column_Width_Type;
	      BlockRead (Lotus_Read_File, Lotus_Cell.Column,       2, NumRead);
	      BlockRead (Lotus_Read_File, Lotus_Cell.Column_Width, 1, NumRead);

              Get_Alpha_Column(Alpha_Column_ID, Lotus_Cell.Column, 0);
              Lotus_Cell.Alpha_Column := Alpha_Column_ID;
            END;{8}

        11: BEGIN                                        {Range definition}
              Lotus_Cell.Cell_Type := Range_Type;
              BlockRead(Lotus_Read_File, Lotus_Cell.Range_Name[1],16, NumRead);
              Lotus_Cell.Range_Name[0] := Char(16);

              BlockRead (Lotus_Read_File, Lotus_Cell.Range_Start_Column, 2, NumRead);
              BlockRead (Lotus_Read_File, Lotus_Cell.Range_Start_Row,    2, NumRead);
              BlockRead (Lotus_Read_File, Lotus_Cell.Range_END_Column,   2, NumRead);
              BlockRead (Lotus_Read_File, Lotus_Cell.Range_END_Row,      2, NumRead);

              Get_Alpha_Column (Alpha_Column_ID, Lotus_Cell.Range_Start_Column,
                                Lotus_Cell.Range_Start_Row);
              Lotus_Cell.Alpha_Range_Start := Alpha_Column_ID;
              Get_Alpha_Column (Alpha_Column_ID, Lotus_Cell.Range_END_Column,
                                Lotus_Cell.Range_END_Row);
              Lotus_Cell.Alpha_Range_END := Alpha_Column_ID;
            END;{11}

	12: BEGIN                                        {Blank Record}
	      Lotus_Cell.Cell_Type := Blank_Type;
	      Read_Format_Info;
	    END;{12}

        13: BEGIN                                         {Integer}
	      Lotus_Cell.Cell_Type := Integer_Type;
	      Read_Format_Info;
	      BlockRead(Lotus_Read_File, Lotus_Cell.Integer_Value, 2, NumRead);
	    END;{13}

	14: BEGIN                                         {Real Value}
	      Lotus_Cell.Cell_Type := Real_Type;
	      Read_Format_Info;
	      BlockRead(Lotus_Read_File, Lotus_Cell.Real_Value, 8, NumRead);
	    END;{14}

	15: BEGIN                                         {Label}
	      Lotus_Cell.Cell_Type := Label_Type;
	      Read_Format_Info;
              IF (Lotus_Cell.Cell_Length > 261) THEN
                Err_Msg := 'Label at Row "'+Int_to_Str(Lotus_Cell.Row)+
                           '" Column "'+Int_to_Str(Lotus_Cell.Column)+
                           '" has length > 255';

              IF (Err_Msg = '') THEN
                BEGIN
	          BlockRead(Lotus_Read_File, Lotus_Cell.Formula, Lotus_Cell.Formula_Length,
                            NumRead);
	          BlockRead(Lotus_Read_File, Lotus_Cell.Label_Value[1],
                            Lotus_Cell.Cell_Length - 6, NumRead);
	          Lotus_Cell.Label_Value[0] := char(Lotus_Cell.Cell_Length - 6);
	          BlockRead(Lotus_Read_File, Lotus_Cell.Zero, 1, NumRead);
                END;
	    END;{15}

	16: BEGIN                                         {Formula}
	      Lotus_Cell.Cell_Type := Formula_Type;
	      Read_Format_Info;

	      BlockRead(Lotus_Read_File, Lotus_Cell.Formula_Value,  8, NumRead);
	      BlockRead(Lotus_Read_File, Lotus_Cell.Formula_Length, 2, NumRead);

              IF (Lotus_Cell.Formula_Length > 255) THEN
                Err_Msg := 'Formula Cell at Row "'+Int_to_Str(Lotus_Cell.Row)+
                           '" Column "'+Int_to_Str(Lotus_Cell.Column)+
                           '" has length > 255';

              IF  (Err_Msg = '') THEN
              	 BlockRead(Lotus_Read_File,
                           Lotus_Cell.Formula, Lotus_Cell.Formula_Length, NumRead);
	    END;{16}

	ELSE                                              {Unidentified}
	  BEGIN
	    Lotus_Cell.Cell_Type := Unidentified;

            {    Use the following line only IF you are sure that the length }
            {    of the Unidentified data type is less than 512 characters.  }
            {    IF the Unidentified data cell is more than 512 byte long,   }
            {    it could cream the program by overwriting code.             }
            {    The check on cell length protects against this. But,        }
            {    IF you don't know the maximum cell length, the safest       }
            {    approach is the approach I have taken, just skip the        }
            {    unknown data cell                                           }
            {                                                                }
            {    IF Lotus_Cell.Cell_Length > 512 THEN                             }
            {        BEGIN                                                   }
            {           Writeln('Big problem! Cell at row ', Lotus_Cell.Row,      }
            {           ' Column ', Lotus_Cell.Coulmn, ' has  length > 512');     }
            {           Halt;                                                }
            {        END;                                                    }
            {                                                                }
            {    BlockRead (Lotus_Read_File, Lotus_Cell.Unidentified ,            }
            {               Lotus_Cell.Cell_Length);                              }

            {    This is the safest way.}

            Jump_Loc := FilePos(Lotus_Read_File) + Lotus_Cell.Cell_Length;
            IF Jump_Loc < FileSize(Lotus_Read_File)
              THEN Seek (Lotus_Read_File, Jump_Loc)
              ELSE Seek (Lotus_Read_File, FileSize(Lotus_Read_File) );
          END;
    END; {case}
{$I+}
END; {read_lotus_record}

(*****************************************************************)
Procedure Write_Type_and_Length;
{Could be changed to a single BlockWrite since format, column}
{and row are adjacent in the record definition and on the file.}

VAR
  NumWritten: Word;
BEGIN
{$I-}
  WITH GBL_Master_Struct^ DO
  BEGIN
    BlockWrite (Lotus_Read_File, Lotus_Cell.Cell_Type_Code, 2, NumWritten);
    BlockWrite (Lotus_Read_File, Lotus_Cell.Cell_Length,    2, NumWritten);
  END;
{$I+}
END; {write_type_and_length}

(*****************************************************************)
Procedure Write_Format_Info;
{Could be changed to a single BlockWrite since format, column}
{and row are adjacent in the record definition and on the file.}

VAR
  NumWritten: Word;
BEGIN
{$I-}
  WITH GBL_Master_Struct^ DO
  BEGIN
    BlockWrite(Lotus_Read_File, Lotus_Cell.Format, 1, NumWritten);
    BlockWrite(Lotus_Read_File, Lotus_Cell.Column, 2, NumWritten);
    BlockWrite(Lotus_Read_File, Lotus_Cell.Row,    2, NumWritten);
  END;
{$I+}
END; {write_format_info}

(*****************************************************************)
Procedure Write_Lotus_Record;
VAR
  NumWritten: Word;
BEGIN
{$I-}
  WITH GBL_Master_Struct^ DO
  CASE Lotus_Cell.Cell_Type OF
    Column_Width_Type:
      BEGIN
(*        Lotus_Cell.Cell_Type_Code := 8;
        Lotus_Cell.Cell_Length    := 3;  *)

        Write_Type_and_Length;
        BlockWrite (Lotus_Read_File, Lotus_Cell.Column,       2, NumWritten);
        BlockWrite (Lotus_Read_File, Lotus_Cell.Column_Width, 1, NumWritten);
      END;{Column_Width_Type}

    Range_Type:
      BEGIN
(*        Lotus_Cell.Cell_Type_Code := 11;
        Lotus_Cell.Cell_Length    := 24; *)

        Write_Type_and_Length;
        BlockWrite (Lotus_Read_File, Lotus_Cell.Range_Name[1],      16, NumWritten);
        BlockWrite (Lotus_Read_File, Lotus_Cell.Range_Start_Column,  2, NumWritten);
        BlockWrite (Lotus_Read_File, Lotus_Cell.Range_Start_Row,     2, NumWritten);
        BlockWrite (Lotus_Read_File, Lotus_Cell.Range_END_Column,    2, NumWritten);
        BlockWrite (Lotus_Read_File, Lotus_Cell.Range_END_Row,       2, NumWritten);
      END;{Range_Type}

    Blank_Type:  BEGIN
                  { Write_Format_Info; }
                 END;{Blank_Type}

    Integer_Type:
      BEGIN
(*        Lotus_Cell.Cell_Type_Code := 13;
        Lotus_Cell.Cell_Length    := 7; *)

        Write_Type_and_Length;
        Write_Format_Info;
        BlockWrite (Lotus_Read_File, Lotus_Cell.Integer_Value, 2, NumWritten);
      END;{Integer_Type}

    Real_Type:
      BEGIN
(*        Lotus_Cell.Cell_Type_Code := 14;
        Lotus_Cell.Cell_Length    := 13; *)

        Write_Type_and_Length;
        Write_Format_Info;
        BlockWrite (Lotus_Read_File, Lotus_Cell.Real_Value, 8, NumWritten);
      END;{Real_Type}

    Label_Type:
      BEGIN
        Lotus_Cell.Cell_Type_Code := 15;
        Lotus_Cell.Cell_Length    := 6 + Length(Lotus_Cell.Label_Value);
        Lotus_Cell.Zero           := 0;

        Write_Type_and_Length;
        Write_Format_Info;
        BlockWrite (Lotus_Read_File,
                    Lotus_Cell.Label_Value[1], Length(Lotus_Cell.Label_Value), NumWritten);
        BlockWrite (Lotus_Read_File, Lotus_Cell.Zero, 1, NumWritten);
      END;{Label_Type}

    Formula_Type:    {NOTE: ONLY COPIES OUT THE CURRENT VALUE AS A REAL  }
                     { IF you want to copy the formula THEN also         }
                     { BlockWrite Lotus_Cell.formula.                         }
                     { See Read_Lotus_Record for how to interpret length }
                     { Also, you must change the Cell_Type_Code to 16    }
      BEGIN
(*        Lotus_Cell.Cell_Type_Code := 14;
        Lotus_Cell.Cell_Length    := 13;  *)

        Write_Type_and_Length;
        Write_Format_Info;
        BlockWrite (Lotus_Read_File, Lotus_Cell.Formula_Value, 8, NumWritten);
      END;{Formula_Type}

  END; {case}
{$I+}
END; {write_lotus_record}

(****************************************************************)
Procedure Open_Lotus_Read_File (File_Name        : string;
                                Read_From_Cell   : boolean;
                                VAR Old_FileMode : byte;
                                VAR Err_Code     : integer;
                                VAR Err_Msg      : String );
VAR
  Reply : word;
  Lotus_Read_File_ExtStr  : ExtStr;
  Lotus_Read_File_DirStr  : DirStr;
  Lotus_Read_File_NameStr : NameStr;

BEGIN
  Err_Code := 0;

  GBL_Master_Struct^.Lotus_File_Name := File_Name;

  FSplit (GBL_Master_Struct^.Lotus_File_Name, Lotus_Read_File_DirStr,
                           Lotus_Read_File_NameStr,
                           Lotus_Read_File_ExtStr);

  IF (Lotus_Read_File_ExtStr = '')
    THEN Lotus_Read_File_ExtStr := '.WKS';

  GBL_Master_Struct^.Lotus_File_Name := Lotus_Read_File_DirStr  +
                          Lotus_Read_File_NameStr +
                          Lotus_Read_File_ExtStr;

  Assign (GBL_Master_Struct^.Lotus_Read_File,
          GBL_Master_Struct^.Lotus_File_Name);

  IF (NOT Read_From_Cell) THEN  {* Writing *}
    BEGIN
      {*-----------------------------------------------------------*}
      {* Must override SYSTEM.FILEMODE option to allow READ+WRITE  *}
      {* in case the SYSTEM.FILEMODE has been overridden already   *}
      {* and Deny_Write is new 'default'                           *}
      {* Otherwise RT-Error 5 will occur                           *}
      {*-----------------------------------------------------------*}
      Old_FileMode := SYSTEM.FileMode;
      SYSTEM.FileMode := $2;      {READ+WRITE (normal 'default')}
    END; {if}

{$I-} Reset (GBL_Master_Struct^.Lotus_Read_File,1); {$I+}

    Reply := IOResult;
    IF (Reply <> 0) THEN
      BEGIN
        Err_Code := -1;
        Err_Msg  := 'Error in file "'+GBL_Master_Struct^.Lotus_File_Name+'" '+
                    FILE_LIB.File_Error (Reply);
      END;

    IF (Err_Code = 0) THEN
      BEGIN
       {Read the first record IF the first record is not a Version_Type }
       {record THEN this is not a Lotus File}
       Read_Lotus_Record (Err_Msg);

       IF ((Err_Msg = '') and
           (GBL_Master_Struct^.Lotus_Cell.Cell_Type <> Version_Type)) THEN
         BEGIN
           Err_Code := -1;
           Err_Msg  := 'File "'+GBL_Master_Struct^.Lotus_File_Name+
                       '" not "LOTUS"tm WK1/WKS file format.';
           {$I-} CLOSE (GBL_Master_Struct^.Lotus_Read_File); {$I+}
           Reply := IOResult;
          END;

        GBL_Master_Struct^.GBL_Lotus_End_Of_File := FALSE;
      END;{if}

END; {open_lotus_read_file}

(***************************************************************************)
  {*---------------------------------------*}
  {* CELL_PTR : PStrIntMixed_Record        *}
  {*  Line[ ]                              *}
  {*       0 = Which Cell Count 1,2..      *}
  {*       1 = Cell_Col                    *}
  {*       2 = Cell_Row                    *}
  {*       3 = Cell_Value                  *}
  {*           NOTE: Blanks are NIL        *}
  {*       4 = Store into Name             *}
  {*       5 = Cell_Addr (unit123 reserved)*}
  {*  Ints[ ]                              *}
  {*       1 = Err_Code for cell           *}
  {*       2 = IF cell found (123 internal)*}
  {*---------------------------------------*}

(***************************************************************************)
(***************************************************************************)
PROCEDURE Find_All_Records_File_Position
              (Cell_List    : PMany_Line_Sort_Collection;
               Last_Row_Num : longInt;
               Read_Again   : Boolean;
               Read_From_Cell : boolean; {OLC}
               VAR Err_Code : integer;
               VAR Err_Msg  : String);
VAR
  i: integer;

  Found_All : Boolean;
  Found     : Boolean;
  Cell_Ptr  : PStrIntMixed_Record;

  Long_Int  : LongInt;

  Temp_Str  : String;
BEGIN
  Found_All := FALSE;
  If (Read_Again)
    THEN FOR i := 0 to (Cell_List^.Count-1) DO
      BEGIN
        Cell_Ptr          := PStrIntMixed_Record(Cell_List^.At (i));
        Cell_Ptr^.Ints[1] := -999; {no errors}
        Cell_Ptr^.Ints[2] := 0;    {not found}
        Cell_Ptr^.Ints[3] := 0;    {dont know its file position yet}
    END; {if/for}

  Seek (GBL_Master_Struct^.Lotus_Read_File, 0);  { Go to beginning of file. }

  REPEAT
    Read_Lotus_Record (Err_Msg);
    Temp_Str := TRIM (GBL_Master_Struct^.Lotus_Cell.Alpha_Column);

    IF ((Temp_Str <> '') and
        (Err_Msg = '') and
        (GBL_Master_Struct^.Lotus_Cell.Cell_Type <> Column_Width_Type))
          THEN {have a cell and no read error}
      BEGIN
        Found := FALSE;
        i     := 0;
        While NOT Found and (i < Cell_List^.Count) DO
          BEGIN
            Cell_Ptr := PStrIntMixed_Record(Cell_List^.At (i));

            IF ((Not Found) and (Cell_Ptr^.Ints[2] = 0) and
                (Cell_Ptr^.Lines[5]^ = Temp_Str) ) THEN
               WITH GBL_Master_Struct^ DO
                IF ((Lotus_Cell.Cell_Type = Real_Type) or
                    (Lotus_Cell.Cell_Type = Integer_Type) or
                    (Lotus_Cell.Cell_Type = Label_Type) or
                    (Lotus_Cell.Cell_Type = Formula_Type) or
                    (Lotus_Cell.Cell_Type = Blank_Type)) THEN  {supported cell type}
                  BEGIN
                    Found             := TRUE;
                    Cell_Ptr^.Ints[1] := 0; {no error in finding cell}
                    Cell_Ptr^.Ints[2] := 1; {flag as found}
                    IF (NOT Read_From_Cell)
                       {***** store its position in file      *****}
                       {***** Lotus_Record_File_Pos is set in *****}
                       {***** Read_Type_And_Length            *****}
                      THEN Cell_Ptr^.Ints[3] :=
                                Lotus_Record_File_Pos

                    ELSE
                      BEGIN
                        CASE Lotus_Cell.Cell_type OF
                          Blank_Type: Temp_Str := '';

                          Integer_Type:
                               Temp_Str := Int_To_Str (Lotus_Cell.Integer_Value);

                          Real_Type:
                          BEGIN
                            Temp_Str := Real_To_Str (12, Lotus_Cell.Real_Value);
                            {*----------------------------------------------*}
                            {* Catch IF DATE, and convert into NORMAL format*}
                            {*----------------------------------------------*}
                            IF ((Lotus_Cell.Format = 249) or (Lotus_Cell.Format = 250) or
                               ((Lotus_Cell.Format >= 242) and
                                    (Lotus_Cell.Format <= 244))) THEN
                              BEGIN
                                {DATE format, the num days since 12/31/1899}
                                {* cant convert REAL -> Long, so trick it *}
                                VAL (Temp_Str, Long_Int, Err_Code);
                                Err_Code := 0;
                                Temp_Str := DATES.Lotus_Date_Str (Long_Int);
                              END; {IF date}
                          END;{real_type}

                          Label_Type: Temp_Str := Lotus_Cell.Label_Value;

                          Formula_Type:
                             Temp_Str :=
                                  TRIM(Real_To_Str (12, Lotus_Cell.Formula_Value));
                        END; {case}

                       IF (Cell_Ptr^.Ints[1] <> -998) {save the value}
                         THEN Cell_Ptr^.Set_Data (3, Temp_Str);
                      END

                  END {if supported type of cell}

                ELSE
                  Cell_Ptr^.Ints[1] := -998;  {unsupported data type}

            INC(i);
          END;{while}

        IF Found THEN {* check if that was the last one looked for *}
          BEGIN
            Found_All := TRUE;
            i := 0;
            While ((Found_All) and (i < Cell_List^.Count)) DO
              BEGIN
                IF (Found_All) THEN
                  BEGIN
                    Cell_Ptr := PStrIntMixed_Record(Cell_List^.At (i));
                    IF (Cell_Ptr^.Ints[2] <> 1)
                      THEN Found_All := FALSE;
                  END;
                INC(i);
              END;{while}
          END;{if}
      END;{if have cell}
  UNTIL ((GBL_Master_Struct^.Lotus_Cell.Row = Last_Row_Num) OR
         (Found_All) OR (Lotus_End_Of_File))
         OR (Err_Msg <> ''); {error in reading record}

  GBL_Master_Struct^.GBL_Lotus_End_Of_File := FALSE;  {since we are not really finished}
END;{Find_All_Records_File_Position}

(***************************************************************************)
(***************************************************************************)
PROCEDURE Grow_Lotus_File_For_Changed_Cell
                                    (Write_Value  : String;
                                     Rec_Loc      : LongInt;
                                     VAR Err_Code : Integer;
                                     VAR Err_Msg  : String);   {OLC}

{ Assumes Lotus file is open on entering procedure }

VAR
 Temp_File_Name : String;
 Temp_File      : file;
 status         : byte;

 NumRead,
 NumWritten   : Word;
 Need_to_Move : Boolean;
BEGIN
  {$I-}        {*** We do A LOT of file operations ***}
                         {~~~~~}
   Seek (GBL_Master_Struct^.Lotus_Read_File, Rec_Loc);
                                                {find record we are writing to}
   Read_Lotus_Record (Err_Msg);       {and Fill Lotus Structure     }

   IF (Err_Msg = '') THEN
     BEGIN
       Need_to_Move := (FilePos(GBL_Master_Struct^.Lotus_Read_File) <
                        FileSize(GBL_Master_Struct^.Lotus_Read_File));

       IF (Need_to_Move) THEN
         BEGIN
       {open temp file}
           Temp_File_Name := FILE_LIB.Get_Unique_FileName;
           Assign (Temp_File, Temp_File_Name);
           ReWrite (Temp_File, 1);

      { Read from the current position of the lotus file to the end.}
      { Placing everything read into temp file. }
           REPEAT
             BlockRead(GBL_Master_Struct^.Lotus_Read_File, FILE_BUFS.buf,
                                       SizeOf(FILE_BUFS.buf), NumRead);
             BlockWrite(Temp_File, FILE_BUFS.buf, NumRead, NumWritten);
           UNTIL (NumRead = 0) or (NumWritten <> NumRead);

      {close temp file}
           Close(Temp_File);
         END;{if information exist after cell writing to}

   {find record we are writing to... lotus structure already filled in}
       Seek (GBL_Master_Struct^.Lotus_Read_File, Rec_Loc);

   {Prepare to write}
       IF (GBL_Master_Struct^.Lotus_Cell.Cell_Type = BLANK_TYPE) THEN
                                               {case where inserting into}
         BEGIN                                 {a blank cell             }
           GBL_Master_Struct^.Lotus_Cell.Cell_Type := LABEL_TYPE;
           GBL_Master_Struct^.Lotus_Cell.Format    := 255; {default, see comments up top}
         END;

       Write_Value := STR_STF.TRIM (Write_Value);
       GBL_Master_Struct^.Lotus_Cell.Label_Value := Write_Value;

  {Finally, write value!!!}
       Write_Lotus_Record;

       IF (Need_to_Move) THEN
         BEGIN
      { Read from the beginning of the temp file to the end.}
      { Placing everything read into lotus file. }
           Assign (Temp_File, Temp_File_Name);
           Reset (Temp_File, 1);

           REPEAT
             BlockRead(Temp_File, FILE_BUFS.buf, SizeOf(FILE_BUFS.buf), NumRead);
             BlockWrite(GBL_Master_Struct^.Lotus_Read_File,
                            FILE_BUFS.buf, NumRead, NumWritten);
           UNTIL (NumRead = 0) or (NumWritten <> NumRead);

      {close temp file}
           Close(Temp_File);

     {Clean up}
           FILE_LIB.Erase_File (Temp_File_Name, status);
         END;{if information exist after cell writing to}
     END;{if no read error}

{$I+}   {*** Done with file manipulations ***}
   IF (Err_Msg <> '')
     THEN Err_Code := -1;


END;{Grow_Lotus_File_For_Changed_Cell}

(***************************************************************************)
(***************************************************************************)
Procedure Write_Cell_Prep
                     (Cell_List     : PMany_Line_Sort_Collection;
                      Cell_Index    : Integer;
                      Last_Row_Num  : LongInt;
                      VAR Err_Code  : integer;
                      VAR Err_Msg   : String); {OLC}

VAR
 Cell_Ptr: PStrIntMixed_Record;
 Grow_Flag   : Boolean;
 Write_Value : string;
 Rec_Loc     : LongInt;

 Long_Int     : Longint;
 Double_value : Double;
 err          : Integer;

 Var_Type     : word;

BEGIN
  Grow_Flag := FALSE;
  Cell_Ptr  := PStrIntMixed_Record (Cell_List^.At (Cell_index));

  IF ((Cell_Ptr^.Ints[1] <> 0) or   {error in finding cell}
      (Cell_Ptr^.Ints[2] <> 1))     {found flag}
    THEN Exit;

  Rec_Loc := Cell_Ptr^.Ints[3];    {beginning of record}
  Seek (GBL_Master_Struct^.Lotus_Read_File, Rec_Loc); {find record we are writing to}
  Read_Lotus_Record (Err_Msg);     {Fill lotus structure}

  Seek (GBL_Master_Struct^.Lotus_Read_File, Rec_Loc);    {reposition after read!,prepare to write}
  Write_Value := Cell_Ptr^.Lines[3]^; {value to write}

  WITH GBL_Master_Struct^ DO
  CASE Lotus_Cell.Cell_type OF
    Blank_Type: BEGIN
                  {Exit;}
                  IF (Write_Value <> '') THEN
                    BEGIN
                      Grow_Flag := TRUE;
                      IF (Write_Value[1] <> '''')
                        THEN Write_Value :=  '''' + Write_Value;
                    END; {if}
                END; {blank}


    Integer_Type:
      BEGIN
        VAL(Write_Value, Long_Int, Err);
        IF (Err = 0)
          THEN Lotus_Cell.Integer_Value := Long_Int
        ELSE
          BEGIN
            Err_Code := -1;
            Err_Msg  := 'Attempting to store a non-numeric value'+
                          ' in a INTEGER field at "'+Cell_Ptr^.Lines[1]^+
                          Cell_Ptr^.Lines[2]^+'"';
          END; {if}
      END;{integer_type}


    Real_Type,
    Formula_Type:
      BEGIN
        {*----------------------------------------------*}
        {* Catch IF DATE, and convert into Lotus format *}
        {*----------------------------------------------*}
        IF ((Lotus_Cell.Format = 249) or (Lotus_Cell.Format = 250) or
           ((Lotus_Cell.Format >= 242) and (Lotus_Cell.Format <= 244)) ) THEN
          BEGIN
            Long_Int := Str_Date_to_Lotus_Date_Format(Write_Value, Err_Msg);
            IF (Long_Int = -1)
              THEN Err_Code := -1
              ELSE Lotus_Cell.Real_Value := Long_Int;
          END {If date}

        ELSE
          BEGIN
            VAL (Write_Value, Double_Value, Err);
            IF (Err <> 0) THEN
              BEGIN
                Err_Code := -1;
                Err_Msg  := 'Attempting to store a non-numeric value'+
                            ' in a REAL or FORMULA field at "'+
                            Cell_Ptr^.Lines[1]^+Cell_Ptr^.Lines[2]^+'"';
              END

            ELSE IF (Lotus_Cell.Cell_type = Real_Type)
              THEN Lotus_Cell.Real_Value := Double_value

            ELSE Lotus_Cell.Formula_Value := Double_value;
          END;
      END;{real_type,formula_type}


    Label_Type:
      BEGIN
        {*------------------------------------------------*}
        {* First assure that NO leading "'" for compares! *}
        {*------------------------------------------------*}
        IF ((Write_Value <> '') and (Write_Value[1] = ''''))
          THEN Write_Value := COPY (Write_Value, 2, LENGTH(Write_Value));

                                  {***  minus one for tick ' ***}
        IF (LENGTH(Write_Value) > (LENGTH(Lotus_Cell.Label_Value) - 1))
          THEN Grow_Flag := TRUE;

        Write_Value :=  '''' + Write_Value;

        IF (NOT Grow_Flag)
          THEN Lotus_Cell.Label_Value := Left_Justify_Str
                                         (Write_Value,
                                          LENGTH(Lotus_Cell.Label_Value))
      END;{Label_Type}

  END; {case}

  IF (Err_Code = 0) THEN
    BEGIN
      IF (NOT Grow_Flag)
        THEN Write_Lotus_Record
      ELSE
        BEGIN
          Grow_Lotus_File_for_Changed_Cell
                               (Write_Value, Rec_Loc,
                                 Err_Code, Err_Msg);
          {*-------------------------------------------------------------*}
          {* (RE)Locate the new positions of each CELL in the lotus File *}
          {*-------------------------------------------------------------*}
          Find_All_Records_File_Position
                    (Cell_List, Last_Row_Num, TRUE, FALSE, Err_Code, Err_Msg);
          Grow_Flag := FALSE;
        END; {if}
    END; {if}

END;{Write_Cell_Prep}

(***************************************************************************)
(*        Main Routine                                                     *)
(***************************************************************************)
Procedure Find_Lotus_Record (File_Name     : DOS.PathStr;
                             Cell_List     : PMany_Line_Sort_Collection;
                             Read_from_Cell: Boolean;
                             VAR Err_Code  : integer;
                             VAR Err_Msg   : String);
VAR
  Cell_Ptr       : PStrIntMixed_Record;
  Last_Row_Num   : longInt;     {searched for}
  Temp_Str       : string;
  i              : integer;
  Long_Int       : LongInt;
  Old_FileMode   : byte;
BEGIN
  Last_Row_Num := -9999;
  Err_Code     :=     0;
  Err_Msg      :=    '';

  GBL_Master_Struct := NEW (PLotus_Master_Struct_Type);

  {Open a WKS, WK1 file and read version}
  Open_Lotus_Read_File (File_Name, Read_From_Cell, Old_FileMode, Err_Code, Err_Msg);

  IF ((Err_Code = 0) and
      (GBL_Master_Struct^.Lotus_Version_Name = 'Unidentified')) THEN
    BEGIN
      Err_Code := -1;
      Err_Msg  := 'File "'+File_Name+
             '" unknown "LOTUS"tm Version, Ck that is WK1/WKS format.';
      Close_Lotus_Read_File;
    END;

  IF (Err_Code <> 0) THEN
    BEGIN
      IF (NOT Read_From_Cell)
        THEN System.FileMode := Old_FileMode;
      DISPOSE (GBL_Master_Struct);
      Exit;
    END; {if}

  {*---------------------------------------------*}
  {* Initialize all the CellSets                 *}
  {*---------------------------------------------*}
  FOR i := 0 to (Cell_List^.Count-1) DO
    BEGIN
      Cell_Ptr          := PStrIntMixed_Record(Cell_List^.At (i));
      Cell_Ptr^.Ints[1] := -999; {not found}
      Temp_Str          := Trim(Cell_Ptr^.Lines[2]^);  {row}
      VAL (Temp_Str, Long_Int, Err_Code);

      IF (Long_Int > Last_Row_Num)
        THEN Last_Row_Num := Long_Int;        {col}

      Temp_Str := Change_Case(Trim(Cell_Ptr^.Lines[1]^)) + Temp_Str;
      Cell_Ptr^.Set_Data(5, Temp_Str);  {cell_Addr=Col+Row}
    END; {for}

{ Locate the position of each CELL in the lotus File}
  Find_All_Records_File_Position (Cell_List, Last_Row_Num, FALSE,
                                  Read_From_Cell, Err_Code, Err_Msg);

  IF ((Err_Code = 0) and (NOT Read_From_Cell))
    THEN FOR i := 0 to (Cell_List^.Count-1)
          DO IF (Err_Code = 0)
               THEN Write_Cell_Prep (Cell_List, i, Last_Row_Num,
                                     Err_Code, Err_Msg);

  Close_Lotus_Read_File;
  IF (NOT Read_From_Cell)
    THEN System.FileMode := Old_FileMode;

 DISPOSE (GBL_Master_Struct);
END; {Find_Lotus_Record}
(***************************************************************************)

END. {unit123}
