{*************************************************}
{                                                 }
{  Lookup List Box Object Unit                    }
{  Copyright (c) 1994 Timothy J. Wollin           }
{                                                 }
{  Rev 1.0                                        }
{                                                 }
{  Description: Contains TLookUpListBox Object-   }
{   A ListBox that can search for a string entered}
{   via keyboard and captured via WM_Char for the }
{   closest match. Moves the Caret to the closest }
{   match. Allows quick scaning of a listboxes'   }
{   contents. Has a Type Ahead Buffer of Size 80. }
{                                                 }
{  Objects:                                       }
{                                                 }
{  TLookUpListBox: The Lookup ListBox Object      }
{                                                 }
{*************************************************}


unit LookUpLB;

interface

uses WinTypes, WinProcs, Objects, OWindows, ODialogs;

type
     PLookUpListBox = ^TLookUpListBox;
     TLookUpListBox = object(TListBox)
      constructor Init(AParent: PWindowsObject; AnId: Integer; X,Y,W,H: Integer);
      constructor InitResource(AParent:PWindowsObject; ResourceID: integer);
      procedure   InitDefs; virtual;
      procedure   WMChar(var Msg: TMessage); virtual wm_First + wm_Char;
     private
      OldSel: Longint;          {The Old Selection of the List Box}
      CharCount: Boolean;       {Have We Recursed throught WMChar Already?}
      Buffer: array[0..79] of char;   {Type Ahead Buffer}
     end;

implementation

uses Strings;

constructor TLookUpListBox.Init(AParent: PWindowsObject; AnId: Integer; X,Y,W,H: Integer);
begin
     inherited Init(AParent, AnId, X,Y,W,H);
     InitDefs  {Set the Defaults}
end;

constructor TLookUpListBox.InitResource(AParent:PWindowsObject; ResourceID: integer);
begin
     inherited InitResource(AParent, ResourceID);
     InitDefs; {Set the Defaults}
end;

procedure TLookUpListBox.InitDefs;
begin
     OldSel := LB_ERR;           {Set OldSel to LB_ERR = -1}
     CharCount := False;         {Have not Recursed throught WMChar yet}
end;

procedure TLookUpListBox.WMChar(var Msg: TMessage);
var Result: Longint; {SendMessage() Result}
begin
     if UpCase(Char(Msg.wParam)) > #31 then
      {Check if Char is an Alpha Character}
     begin
       {Get the Current ListBox Selection}
       Result := SendMessage(HWindow, LB_GetCurSel, 0, 0);
       if Result <> LB_ERR then      {Check to See if an Item in LB Selected}
        if OldSel <> Result then     {Is it a Different Selection than Old}
        begin
          Buffer[0] := #0;           {If So then Reset Buffer}
          OldSel := Result;          {UpDate OldSel to the New Selection}
          StrCat(Buffer, PChar(@Char(Msg.wParam))) {Store New Char in Buffer}
        end
        else {if Same Selection...}
        begin
          if StrLen(Buffer) < 80 then  {Add Char to Buffer End if Buffer}
            StrCat(Buffer, PChar(@Char(Msg.wParam))) {is not Full Else}
          else
            Buffer[0] := #0;                         {Reset Buffer}
        end;
     end;

     {Tell ListBox to Find the Closest Match to Buffer.}
     {Start at List Begining}
     Result := SendMessage(HWindow, LB_FindString, Word(LB_ERR), Longint(@Buffer));
     if Result <> LB_ERR then {If Match then Set Current Selection to Match}
     begin
       Result := SendMessage(HWindow, LB_SetCurSel, Word(Result), 0);
       OldSel := Result;              {UpDate OldSel to New Selection}
       CharCount := False;            {Set Recursive indicator to False}
     end
     else  {No Match Found So...}
     begin
      OldSel := Result;  {Set OldSel to New Selection; ie LB_ERR}
      if not CharCount then {Have We been Here Before???}
      begin
        CharCount := True;  {No, So set Recursive Indicator to True and}
        SendMessage(HWindow, WM_Char, Msg.wParam, 0); {Call Self w/ Char}
      end
      else
        CharCount := False; {Have Been Here Before So Reset Process}
     end;
end;

end.