{$A-,B-,D-,E-,F+,I+,L-,N-,O-,R-,S+,V-}

unit ADDMACRO;

{----------------------------------------------------------------------}
{------  Turbo Pascal  ADDMACRO unit written by Douglas Webb   --------}
{------  Copywrite (c) 1989-1991.  All rights reserved.        --------}
{------  Last undated 09/08/91                                 --------}
{----------------------------------------------------------------------}
{------  This sofware is freeware.  It may not be              --------}
{------   redistibuted in any altered format nor may this      --------}
{------   notice be removed.                                   --------}
{----------------------------------------------------------------------}
{------  DISCLAIMER:  There shall be no guarantee of the       --------}
{------   suitability of this software for any purpose.  The   --------}
{------   author shall not be liable for any damages arrising  --------}
{------   from the use of this software.                       --------}
{----------------------------------------------------------------------}



{  This unit implements a more or less complete macro management system.
  It can be invoked by typing <ALT-M> when the system is in 80 column
  text mode,(calling up the macro menu in graphics mode will cause the
  macro manager to beep but do nothing else), <Alt-M> will cause the macro
  managment menu to popup allowing one of 5 actions (described below)
  to be taken.  Recorded macros can, of course, be played back regardless
  of the video mode.

  There are then 5 options when <ALT-M> is pressed:
    Create a macro - You will be asked to select a macro hotkey which can
      be any combination of ALT or CTRL or SHIFT and any Function Key (F11
      and F12, are not supported).  You then type in the macro (up to 255
      characters), the macro recorder clicks as you go as a reminder.  Typing
      <ALT-M> again will terminate macro recording.
    Delete a macro - You will be asked to select a hotkey whose macro you
      want to delete.
    View the macros - Will display a list of all defined macros in a
      scrollable list.
    Save the current macros - Will save the macros to a file of the same name
      as the file currently being run, but with the '.MAC' extension.
    Toggle the macros On/Off - By default any macros which have been recorded
      are available at the touch of a key.  If for some reason you which to
      turn off the ability to use the macros for some reason this option
      toggles the mode between active/inactive.


  IMPORTANT NOTES:
    1) This unit intercepts interrupts $09 and $16.
    2) This unit cooperates poorly with TP's built-in debugger because of
      the way it steals the keyboard interrupts.  This unit should be added
      to a program only after it has been debugged, otherwise this unit may
      cause your system to freeze up if the debugger is used.
    3)  When a program using this unit is run, if a file with the same name
      as the program being run, but with an extension '.MAC' is in the same
      directory it will be assumed to be a macro list and will be loaded in
      automatically as the program initialises.
    4)  When a program using this unit ends, if the macros have been changed
      but not saved then the user will be queried as to whether he wants to
      save the changes or not.
    5) Care must be taken not to use Standard Input/OutPut or dynamic memory
      allocation in an ISR because these routines are not reentrant. Neither,
      of course is DOS, so if you tinker with this unit keep this in mind.
    6) If you don't need 255 keystrokes/macro you can change the Constant
      'Maxkey' to a smaller number and save some heap space. (You'll also
      have to trim down the constant 'Key_holder'.)

}


interface


{ The following routines can be used to temporarily disable the keyboard
  interceptors installed by this unit.  They are DUMB and assume that
  nobody is messing with either of the keyboard interrupts while the
  handlers are disabled.

  P.S.  This function has an exit function which automatically calls
    ResetIntVecs.
}

Procedure ResetIntVecs;   { Unhook the keyboard interrupt handlers }
Procedure SetIntVecs;     { reinstall the keyboard handlers }

implementation

uses DOS,CRT;
CONST
  MaxKey = 255;          { How many keystrokes are allowed per macro. }
  UP     = #200;
  PGUP   = #201;
  Down   = #208;
  PGDN   = #209;
  ROM_Data = $0040;      { Memory location for manipulation of the keyboard }
  Head     = $001A;      {  buffer. }
  Tail     = $001C;
  KeyBuf   = $001E;
  BufEnd   = $003E;
  VBiosOfs = $0049;
  BIOS_I9 = $9;
  Presskey = 'Press any key to continue.';
  M3 = '(Macro files have the .MAC extension)';



TYPE
  String50 = String[50];
  KeyCode_Ptr_Type = ^KeyCode;
  KeyCode  = WORD;
  KeyCode_Array = Array[0..MaxKey] OF WORD;
  Key_List_Ptr = ^Key_List_Type;
  Key_List_Type = RECORD
                    HotKey : KeyCode;
                    Macro_Name : String50;
                    Insert_Data : KeyCode_Array;
                  END;
  Macro_Array = Array[1..30] OF Key_List_Ptr;
  Macro_Modes = (DoNothing,RecordKeys,Active);
  WinBufPtr = ^Window_Buffer_Type;
  Window_Buffer_Type = Array[1..1320] OF BYTE;    { 60*11*2 }

  { Record for storing the current state of the BIOS video system info. }
  VideoRecs = RECORD
                VideoMode                     : BYTE;
                NumbCol,Screensize,MemoryOfs  : WORD;
                CursorArea     : ARRAY[0..7] OF WORD;
                CursorMode                    : WORD;
                CurrentPage                   : BYTE;
                VideoBoardAddr                : WORD;
                CurrentMode,CurrentColor      : BYTE;
              END;




CONST
  Key_Holder : KeyCode_Array = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  Key_H_Pos  : WORD = 1;
  Insert_ON  : BOOLEAN = FALSE;
  New_Macro  : BOOLEAN = FALSE;
  Popped_UP  : BOOLEAN = FALSE;
  Dice_Popped: BOOLEAN = FALSE;
  INT9_Mode  : Macro_Modes = DoNothing;
  Macro_Base : Macro_Array = (NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,
                              NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,
                              NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL,NIL);

  Activate_Record_Key = $3200;    { CTRL-M  for Macro }
  Activate_Dice_Key   = $2000;




VAR
  BIOS_INT9 : Pointer;           { BIOS HardWare KeyBoard Interrupt Vector }
  Exit_Vec  : Pointer;

  KeyBoard_Queue_Head : WORD Absolute $0040:$001A;
  KeyBoard_Queue_Tail : WORD Absolute $0040:$001C;
  KBDFlag     : BYTE Absolute $0040:$0017;      {Hardware KBD status byte}
  KeyCode_Ptr : KeyCode_Ptr_Type;

  WinBuf : WinBufPtr;
  X,OldWindMin,OldWindMax,OXC,OYC : WORD;
  Ch,Ch2 : CHAR;
  Regs   : Registers;



CONST    { Offsets to items contained in Procedure Int16_ISR. }
  Unsafe = 0;
  Flg = 1;
  InsNumb = 14;
  Bios16 = $10;
  Our16 = Bios16 + 12;     InsChr = Our16+138-8;


PROCEDURE Int16_ISR;  { Data storage and intercept routines. }
Interrupt;
BEGIN
  INLINE(
   {*** Storage for interrupt vectors.                                    }
       {Bios16: }    >0/>0/          { BIOS buffered keybd. intr. vector. }

   {*** OurIntr16 ***** Intercept routine for buffered keyboard input. ** }
   {   0} $58/   {JmpBios16: POP  AX          ; Restore AX, DS, and       }
   {   1} $1F/             { POP  DS          ; FLAGS registers then      }
   {   2} $9D/             { POPF             ; exit to orig. BIOS        }
   {   3} $2E/             { CS:              ; intr. 16H routine         }
   {   4} $FF/$2E/>Bios16/ { JMP [Bios16]     ;                           }

   {   8} $9C/   {OurIntr16: PUSHF            ; Preserve flags            }
   {   9} $FB/             { STI              ; Enable interrupts         }
   {  10} $1E/             { PUSH DS          ; Preserve DS and AX        }
   {  11} $50/             { PUSH AX          ; registers.                }
   {  12} $0E/             { PUSH CS          ; DS := CS;                 }
   {  13} $1F/             { POP  DS          ;                           }
   {  14} $F6/$C4/$EF/     { TEST AH,EFh      ; Jmp if not read character }
   {  17} $75/<38-19/      { JNZ  C3          ; request.                  }

                           {**** Intercept loop for read Key service. *** }
   {  19} $F6/$06/>Flg/16/{C2:TEST [Flg],10h  ; Jmp if insert flag set    }
   {  24} $75/<38-26/      { JNZ  C3          ;                           }
   {  26} $FE/$C4/         { INC  AH          ; Use orig. BIOS            }
   {  28} $9C/             { PUSHF            ; service check for char.   }
   {  29} $FA/             { CLI              ; ready. Disable interrupts.}
   {  30} $FF/$1E/>Bios16/ { CALL FAR [Bios16];                           }
   {  34} $58/             { POP  AX          ; Restore AX and save       }
   {  35} $50/             { PUSH AX          ; it again.                 }
   {  36} $74/<19-38/      { JZ   CL          ; Loop until chr. ready     }

   {  38} $F6/$06/>Flg/17/{C3:TEST [Flg],11h  ; Exit if neither bit       }
   {  43} $74/<-45/        { JZ   JmpBios16   ;  of flg is set.           }

   {  45} $F6/$06/>Flg/$10/{C4:TEST [Flg],10h ; Exit unless have          }
   {  50} $74/<-52/        { JZ   JmpBios16   ;  characters to insert.    }
   {  52} $F6/$C4/$EE/     { TEST AH,0EEh     ; If request is not a char. }
   {  55} $75/<-57/        { JNZ  JmpBios16   ;  request, exit.           }

   {  57} $53/             { PUSH BX          ; Save BX                   }
   {  58} $1E/             { PUSH DS          ; Save DS                   }
   {  59} $B8/>ROM_Data/   { MOV  AX,ROM_Data ;                           }
   {  62} $8E/$D8/         { MOV  DS,AX       ; Point to ROM Data Segment }
   {  64} $8B/$1E/>Tail/   { MOV  BX,[>Tail]  ;                           }
   {  68} $A1/>Head/       { MOV  AX,[>Head]  ; Are the head & tail of    }
   {  71} $33/$C3/         { XOR  AX,BX       ; the keyboard queue equal, }
   {  73} $74/<78-74/      { JE   Insert      ;  ie., no characters in    }
   {  75} $1F/             { POP  DS          ;  queue. If so put a       }
   {  76} $5B/             { POP  BX          ;  keystroke in the keyboard}
   {  77} $EB/<-79/        { JMP  JmpBios16   ;  buffer.                  }

                           { *** Insert a character.                      }
   {  79} $8C/$DA/  {Insert: MOV  DX,DS       ; Store DS in to ROM area   }
   {  81} $1F/             { POP  DS          ; Restore original DS but   }
   {  82} $1E/             { PUSH DS          ; Keep it on the stack      }
   {  83} $06/             { PUSH ES          ; Save ES                   }
   {  84} $53/             { PUSH BX          ; Save tail address         }
   {  85} $C4/$1E/>InsChr/ { LES  BX,[InsChr] ; PTR(ES,BX) := InsChr;     }
   {  89} $26/$8B/$07/     { MOV  AX,ES:[BX]  ; AX := InsChr^;            }
   {  92} $FE/$06/>InsChr/ { INC  [InsChr]    ; Inc[InsChr]               }
   {  96} $FE/$06/>InsChr/ { INC  [InsChr]    ; Inc[InsChr]               }
   { 100} $FF/$0E/>InsNumb/{ DEC  [InsNum]    ; Dec[InsNum]               }

   { 104} $75/<111-106/    { JNZ  SkipReset   ; If InsNumb = 0 THEN       }
   { 106} $80/$26/>Flg/$EF/{ AND  [Flg],0EFh  ;  clear insert char flag   }

   { 111} $5B/   {SkipReset: POP  BX          ; Restore tail pointer      }
   { 112} $8E/$DA/         { MOV  DS,DX       ; Restore DS to ROM area    }
   { 114} $89/$07/         { MOV  [BX],AX     ; Put key in buffer         }
   { 116} $81/$C3/$02/$00/ { ADD  BX,+$02     ; Advance tail pointer      }
   { 120} $81/$FB/>Bufend/ { CMP  BX,>Bufend  ; IF tail at end of buffer  }
   { 124} $7C/$03/         { JL   BufOK       ;                           }
   { 126} $BB/>KeyBuf/     { MOV  BX,>Keybuf  ;   set it to the beginning }
   { 129} $89/$1E/>Tail/{BufOK: MOV  [>Tail],BX  ; Restore tail.          }
   { 133} $07/             { POP  ES                                      }
   { 134} $1F/             { POP  DS                                      }
   { 135} $5B/             { POP  BX                                      }
   { 136} $EB/<77-138);    { Jmp  JmpBios16                               }
END;   { Int16_ISR. }
{ END corresponds to 12 bytes of code used for storage     }






PROCEDURE EnableInterrupts; INLINE($FB);
PROCEDURE DisableInterrupts; INLINE($FA);


PROCEDURE CallInterrupt(oldvector : Pointer); { stack image     }
   INLINE($55/          { PUSH    BP                 } {  ip   \ return  }
          $89/$E5/      { MOV     BP,SP              } {  cs     to here }
          $9C/          { PUSHF create an IRET return} {  flags/         }
          $36/          { SS:                        } {  bp  <--sp      }
          $FF/$5E/$02/  { CALLfar [BP+02]            } {  cs \           }
          $5D/          { POP     BP                 } {  ip /old vector }
          $83/$C4/$04); { ADD     SP,+04             } {                 }
   {END CallInterrupt}



{$L FASTWIN}

procedure WriteStr(X, Y: Byte; S: String; Attr: Byte); far; external {FASTWIN};
procedure GetText(VAR Memory); far; external {FASTWIN};
  { This procedure is analogous to that available in Turbo C.  It grabs
     currently defined (as per CRT unit) Window, and save it contents,
     attributes and all in a memory area defined by Memory.
    NOTE: to determine how much memory to allocate for the screen save
     call the function 'Winsize' below.  }


procedure PutText(VAR Memory); far; external {FASTWIN};
  { This procedure is analogous to that available in Turbo C. It puts the
     saved screen info. in the variable Memory into the current (CRT unit
     defined) window.  Better make sure the sizes match.
  }


function WinSize: Word; far; external {FASTWIN};
  { Returns the amount of memory needed to store the current (CRT defined
     window). Useful for calls to GetText. }


Procedure CursorON;
{
  This procedure uses video BIOS interrupt call to turn off the cursor.

   Programmer : DPW
   Last Updated : 09/08/91
   Supporting Functions: None.
}
BEGIN
  Inline($B4/$03/          { MOV   AH,03h   }
         $CD/$10/          { INT   10h      }
         $80/$E5/$5F/      { AND   CH,5Fh   ;Turn Cursor On }
         $B4/$01/          { MOV   AH,01h   }
         $CD/$10)          { INT   10h      }
END;



Procedure CursorOFF;
{
  This procedure uses video BIOS interrupt call to turn on the cursor.

   Programmer : DPW
   Last Updated : 09/08/91
   Supporting Functions: None.
}
BEGIN
  Inline($B4/$03/          { MOV   AH,03h   }
         $CD/$10/          { INT   10h      }
         $80/$CD/$20/      { OR    CH,20h   ;Turn Cursor Off }
         $B4/$01/          { MOV   AH,01h   }
         $CD/$10)          { INT   10h      }
END;

Function GetKey:Char;
  {
    This is a good alternative to Readkey, which allows ready access
     to function keys and other extended keys in a single char value.
     If a function key is pressed then 128 is added to the auxilliary
     scan code (the non-zero code), this allows any key to be handled
     with one character. Values returned for function keys are listed
     as constants above.

   }
VAR
  CH : CHAR;
BEGIN
  While Not Keypressed DO  { Loop until a key is pressed. }
    INLINE($CD/$28); { Call the DOS idle interrupt - allows DOS multitasking. }
  CH := Readkey;
  IF Ch = #0  THEN
    BEGIN
      Ch := ReadKey;
      IF CH < #128 THEN CH := CHR(ORD(CH) + 128);
    END;
  GetKey := CH;
END;



Procedure Store_Video_State(VAR VideoRec : VideoRecs);
BEGIN
  Move(Ptr(ROM_Data,VBiosOfs)^,VideoRec,          { Get video Bios info.       }
                      SizeOF(VideoRec));
END;


Procedure Restore_Video_State(VideoRec : VideoRecs);
BEGIN
  IF Mem[ROM_Data:VBiosOfs] <> VideoRec.VideoMode THEN
    BEGIN
      Regs.AX := VideoRec.VideoMode;             { Restore video Mode.     }
      Intr($10,Regs);
    END;
  Regs.AH := 1; Regs.CX := VideoRec.CursorMode;  { Restore cursor size.    }
  Intr($10,Regs);
  Regs.AH := 5; Regs.AL := VideoRec.CurrentPage; { Restore active page.    }
  Intr($10,Regs);
  Regs.AH := 2; Regs.BH := VideoRec.CurrentPage; { Restore cursor position.}
  Intr($10,Regs);
  Regs.DX := VideoRec.CursorArea[VideoRec.CurrentPage];
  Intr($10,Regs);                                { Restore screen Image.   }
END;






PROCEDURE Draw_Box(TopLX,TopLY,                { Top left corner of box.}
                   BotRX,BotRY :Integer);      { Bottom right box corner}


VAR
  Temp       : Integer;
  Ch1        : Char;

CONST
  Boxchar : Array[1..6] of char =
     ('','','','','','');       { ASCII chars for double line box }
BEGIN
    WriteStr(TopLX,TopLY,BoxChar[1],TextAttr); { Display upper left corner of box}
    Temp := SUCC(TopLX);
    Ch1 := BoxCHar[5];
    Repeat
      WriteStr(Temp,TopLY,Ch1,7);
      WriteStr(Temp,BotRY,Ch1,7);
      Inc(Temp);                         { Keep going to you hit the right }
    Until Temp > PRED(BOTRX);            { side of the box.                }
    WriteStr(Temp,TopLY,BoxChar[2],7);   { Now display top right box corner}
    WriteStr(Temp,BotRY,BoxChar[4],7);   { right corner of the box.         }
    Ch1 := BoxChar[6];
    INC(TopLY);
    While TopLY < BotRY do               { and then start printing the vert}
      Begin                              { lines.                          }
        WriteStr(TopLX,TopLY,Ch1,7);   { 1st display the left side of box}
        WriteStr(Temp,TopLY,Ch1,7);    { then show the right side, until }
        Inc(TopLY);                      { you reach the bottom of the box.}
      END;
    WriteStr(TopLX,BotRY,BoxChar[3],7);  { Display left corner of box.      }
END; {Draw Box}




Procedure MakePopWin(XC,YC,XD,YD : WORD; S : String50; VAR WinBuf: Pointer; VAR VRec : VideoRecs);
BEGIN
  Store_Video_State(VRec);
  OldWindMin := WindMin;
  OldWindMax := WindMax;
  Window(XC,YC,XC+Pred(XD),YC+PRED(YD));     { Save old screen contents }
  GetText(WinBuf^);
  Window(1,1,80,25);
  Draw_Box(XC,YC,XC+Pred(XD),YC+PRED(YD));
  WriteStr(XC + 11,YC,S,15);
  Window(SUCC(XC),SUCC(YC),XC+XD-2,YC+YD-2);
  Popped_Up := TRUE;
  CursorON;
END;



Procedure RemovePopWin(XC,YC,XD,YD : WORD;VAR WinBuf: Pointer; VRec : VideoRecs);
BEGIN
  Window(XC,YC,XC+Pred(XD),YC+PRED(YD));{ Restore screen contents }
  PutText(WinBuf^);
  WindMin := OldWindMin;
  WindMax := OldWindMax;
  Popped_Up := FALSE;
  Restore_Video_State(VRec);
END;






Function PutPopMess(M1,M2,M3,Response_Message:String50): Char;

 {This procedure puts up to a three line message on the screen, and either
   waits for acknowledgement or returns control to the calling routine,
   depending on whether or not the 'Response_Message' string is empty.
   In the latter case the calling routine must remove the window created
   for the message. }

VAR
  OldWindMin,OldWindMax : WORD;
  Errcode : Integer;
  Ch : CHAR;
  Local : BOOLEAN;
  VRec : VideoRecs;

BEGIN
  Local := True;
  IF NOT Popped_UP THEN
    BEGIN
      ResetIntVecs;
      MakePopWin(11,5,60,10,'',Pointer(WinBuf),VRec);
    END
  ELSE  Local := False;
  Clrscr;
  WriteStr(30-Length(M1) DIV 2,2,M1,7);
  WriteStr(30-Length(M2) DIV 2,3,M2,7);
  WriteStr(30-Length(M3) DIV 2,4,M3,7);
  IF Response_Message <> '' THEN
    BEGIN
      WriteStr((30-Length(Response_Message) DIV 2),6,Response_Message,7);
      PutPopMess := Readkey;
      IF Local THEN
        BEGIN
          RemovePopWin(11,5,60,10,Pointer(WinBuf),VRec);
          SetIntVecs;
        END;
    END;
END;






Procedure Save_Macros;
VAR
  OutFile : FILE OF Key_List_Type;
  File_Name : PathStr;
  D : DirStr;
  N : NameStr;
  E : ExtStr;
  Written : Boolean;


BEGIN
  Written := FALSE;
  File_Name := ParamStr(0);
  FSplit(File_Name,D,N,E);
  File_Name := D + N + '.MAC';
{$I-}
  Assign(OutFile,File_Name);
  Rewrite(OutFile);
  While IOResult <> 0 Do
    BEGIN
      Ch := PutPopMess('Cannot save macros to target file:',File_Name,
                        '','Abort or Retry ? (A/R)');
      IF UPCASE(CH) = 'A' THEN EXIT;
      Rewrite(OutFile);
    END;
  X := 1;
  While Macro_Base[X]^.HotKey <> 0 DO
    BEGIN
      Write(OutFile,Macro_Base[X]^);
      If IOResult <> 0 THEN
        Ch := PutPopMess('Error saving Macro file.','',M3,Presskey);
      INC(X);
    END;
  Close(OutFile);
{$I+}
  New_Macro := False;
END;





Procedure Load_Macros(VAR Macro_Base : Macro_Array);


VAR
  InFile : FILE OF Key_List_Type;
  File_Name : PathStr;
  D : DirStr;
  N : NameStr;
  E : ExtStr;


BEGIN
  File_Name := ParamStr(0);
  FSplit(File_Name,D,N,E);
  File_Name := D + N + '.MAC';
  {$I-}
  Assign(InFile,File_Name);
  Reset(InFile);
  IF IOResult <> 0 THEN Exit
  ELSE
    BEGIN
      X := 1;
      While Not Eof(InFile) DO
        BEGIN
          Read(InFile,Macro_Base[X]^);
          IF IOREsult <> 0 THEN
            BEGIN
              Ch := PutPopMess('Error loading macro file',
                      'Bad or damaged macro file',M3,Presskey);
              Macro_Base[1]^.Hotkey := 0;
              Exit;
            END;
          INC(X);
        END;
      Close(InFile);
      Int9_Mode := Active;
    END;
  {$I+}
END;






Procedure Beep;
BEGIN
  Sound(250);
  Delay(300);
  NoSound;
END;

Procedure Click;
BEGIN
  Sound(100);
  Delay(25);
  NoSound;
END;




Procedure MacPopUp(Var Items;                { Array of pointers to display}
                    Count : WORD;            { How many options in menu.   }
                    Max   : WORD);           { Total items to passed in.   }


VAR
    List : Array[1..1] of Pointer absolute Items;
    J    : Byte;
    First,X1,Y1,Errcode : Integer;
    Str : String;
    WinMax,WinMin : WORD;

    PROCEDURE Show_Popup_List;
    VAR
      I,Num: Integer;
    Begin
      ClrScr;
      Gotoxy(1,1);
      For I := First to First+PRED(Count) do       { Draw the entries }
	WriteStr(2,I-Pred(First),String(List[I]^),7);
    end;

Begin
     WinMax := WindMax;
     WinMin := WindMin;
     Window(12,6,68,12);
     First := 1;
     Show_Popup_List;
     Repeat
       Ch := GetKey;
       Case Ch of
         Up:
            If First > 1 THEN DEC(First);
         Down:
            If (First+Count <= Max) THEN INC(First);
         PgDn:
            IF Count > Max THEN
              First := 1
            ELSE IF First+Count < SUCC(MAX)-Count THEN
              inc(First,Count)
            ELSE  First:=SUCC(Max)-Count;
         PgUp :
            IF First-Count > 1 THEN DEC(First,Count)
            ELSE First := 1;
       END;
       Show_PopUp_List;
     Until CH = #27;
  ClrScr;
  WindMax := WinMax;
  WindMin := WinMin;
end; {MacPopup}




Procedure Macro_Main;

TYPE
  String60 = String[60];

CONST
         { Shift/Ctrl/Alt + Function Key }
  Allowed_Keys : SET of BYTE = [ $54..$5D,$5E..$67,$68..$71];

VAR
  Errcode : Integer;
  NameArray : Array[1..30] of String60;
  Temp: String;
  Pointers : Array[1..30] of Pointer;
  Count,X2 : BYTE;
  Num : Integer;
  Rows : BOOLEAN;
  VRec : VideoRecs;


BEGIN
  ResetIntVecs;
  MakePopWin(11,5,60,10,' Macro Builder ',Pointer(WinBuf),VRec);
  MemW[$0040:Tail] := MemW[$0040:Head];   { Empty buffer }
  REPEAT
    ClrScr;
    WriteStr(5,2,'A - Add a Macro',7);
    WriteStr(5,3,'D - Delete a Macro',7);
    WriteStr(5,4,'V - View Existing Macros',7);
    WriteStr(5,5,'S - Save Macros to Disk',7);
    WriteStr(5,6,'T - Toggle macros On/Off',7);
    WriteStr(5,8,'Q - Quit Macro Builder',7);
    Ch := Readkey;
    CASE Ch OF
      'A','a':
         BEGIN
           Clrscr;
           Writestr(5,3,'Select the key for this macro.',7);
           WriteStr(5,7,'Only ALT/SHIFT/CTRL and <F1>-<F10>',7);
           WriteStr(5,8,'will be accepted as valid.',7);
           Ch := Readkey;
           IF CH = #27 THEN  BEGIN END  { <ESC> DO Nothing }
           ELSE IF CH <> #0 THEN Beep        { Just a regular key code. }
           ELSE
             BEGIN
               Ch2 := ReadKey;               { Illegal extended key code. }
               IF NOT (BYTE(ORD(Ch2)) IN Allowed_Keys) THEN Beep
               ELSE
                 BEGIN
                   X := 1;
                   While (Macro_Base[X]^.HotKey <> (WORD(ORD(Ch2)) SHL 8))
                     AND (Macro_Base[X]^.HotKey <> 0) DO
                     INC(X);
                   IF Macro_Base[X]^.HotKey <> 0 THEN
                     BEGIN
                       Beep;
                       CH := PutPopMess('This key already in use by',Macro_Base[X]^.Macro_Name,
                           'Do you want to replace it ?','(Y/N)');
                       IF BYTE(Ch) OR 32 = BYTE('y') THEN
                         BEGIN
                           WHILE Macro_Base[SUCC(X)]^.HotKey <> 0 DO
                             BEGIN
                               Macro_Base[X]^ := Macro_Base[Succ(X)]^;
                               INC(X);
                             END;
                           Macro_Base[X]^.HotKey := 0;
                         END;
                     END;
                   IF Macro_Base[X]^.HotKey = 0 THEN     { Add Macro to the end of }
                     BEGIN                               {  the existing list.     }
                       Macro_Base[X]^.HotKey := WORD(ORD(Ch2)) SHL 8;
                       Clrscr;
                       Macro_Base[x]^.Macro_Name := '';
                       WriteStr(5,3,'What do you want to call this macro ?',7);
                       X2 := 5;
                       While CH <> #13 DO
                         BEGIN
                           GotoXY(X2,5);
                           CH := Readkey;
                           IF CH = #8 THEN
                             BEGIN
                               Macro_Base[X]^.Macro_Name[0] := PRED(Macro_Base[X]^.Macro_Name[0]);
                               DEC(X2);
                               WriteStr(X2,5,' ',7);
                             END
                           ELSE
                             BEGIN
                               Macro_Base[X]^.Macro_Name := Macro_Base[X]^.Macro_Name + CH;
                               WriteStr(X2,5,Ch,7);
                               INC(X2);
                             END;
                         END;
                       DEC(Macro_Base[X]^.Macro_Name[0]);
                       Int9_Mode := RecordKeys;    { Turn on key recording. }
                       Key_H_Pos := 0;
                       Key_Holder[0] := 0;
                       Ch := 'q';                  { Get out of this loop.  }
                     END;
                 END;
             END;
         END;
      'D','d':
        BEGIN
          CH := PutPopMess('','Press the hotkey associated with the',
                            'macro you want to delete.',' ');
          IF Ch <> #0 THEN
            CH := PutPopMess('','That is not a valid hotkey','',Presskey)
          ELSE
            BEGIN
              Ch:= Readkey;
              IF NOT (BYTE(ORD(Ch)) IN Allowed_Keys) THEN Beep
              ELSE
                BEGIN
                  X := 1;
                  While (Macro_Base[X]^.HotKey <> 0) AND (Macro_Base[X]^.HotKey <> ORD(CH) SHL 8) DO
                    INC(X);
                  IF Macro_Base[X]^.HotKey = 0 THEN
                    CH := PutPopMess('','There is no macro associated with that hotkey',
                                      '',PressKey)
                  ELSE
                    BEGIN
                      WHILE (Macro_Base[SUCC(X)]^.HotKey <> 0) AND (X <> 30) DO
                        BEGIN
                          Macro_Base[X]^ := Macro_Base[Succ(X)]^;
                          INC(X);
                        END;
                      Macro_Base[X]^.HotKey := 0;
                      New_Macro := TRUE;
                    END;
                END;
            END;
        END;
      'V','v':
        BEGIN
          IF Macro_Base[1]^.HotKey = 0 THEN
            Ch := PutPopMess('','There are no Macros.','',Presskey)
          ELSE
            BEGIN
              X := 1;
              While Macro_Base[X]^.HotKey <> 0 DO
                BEGIN
                  Num := Macro_Base[X]^.HotKey SHR 8;
                  Case NUM OF
                   $54..$5D:     { Shift + Func }
                     BEGIN
                       NameArray[X] := '<SHIFT>-F';
                       DEC(Num,$53);
                     END;
                   $5E..$67:     { Ctrl + Func  }
                     BEGIN
                       NameArray[X] := '<CTRL>-F';
                       DEC(Num,$5D);
                     END;
                   $68..$71:     { Alt + Func   }
                     BEGIN
                       NameArray[X] := '<ALT>-F';
                       DEC(Num,$67);
                     END;
                   END;      { Case }
                  Str(Num,Temp);
                  NameArray[X] := NameArray[X] + Temp +   ' : ' + Macro_Base[X]^.Macro_Name;
                  INC(X);
                END;
              For Num := 1 to PRED(X) Do
                Pointers[Num] := @NameArray[Num];
              Num := Pred(X);
              ClrScr;
              WriteStr(17,9,'Press <ESC> when finished',7);
              IF X > 6 THEN Count := 5       { Show 5 macros on screen at a time. }
              ELSE Count := PRED(X);
              IF Num > Count THEN
                WriteStr(5,8,'Use arrow keys to scroll list, <ESC> when finished',7)
              Else WriteStr(16,8,'Press <ESC> when finished',7);
              MacPopup(Pointers,Count,Num);
            END;
        END;
      'S','s':  Save_Macros;
      'T','t':
        BEGIN
          IF Int9_Mode = DoNothing THEN
            BEGIN
              Int9_Mode := Active;
              CH := PutPopMess('','Macros are now active.','',Presskey);
            END
          ELSE
            BEGIN
              Int9_Mode := DoNothing;
              CH := PutPopMess('','Macros are now inactive.','',Presskey);
            END;
        END;
    END;
  UNTIL BYTE(Ch) OR 32 = BYTE('q');
  RemovePopWin(11,5,60,10,Pointer(WinBuf),VRec);
  SetIntVecs;
END;




{}
{                     KEYBOARD       Interrupt 9 service routine     }
{}
{$S-}
PROCEDURE HKEYBOARD_ISR(flags, CS, Ip, Ax, Bx, Cx, Dx, Si, Di, DS, ES, Bp : Word);
  interrupt;

  { Hardware KeyBoard _ I S R }
CONST
  KR :Boolean = FALSE;      { Key Released Flag }

VAR
  X,KeyTemp : WORD;


BEGIN                          {KeyBoard_ISR}
   INLINE(       { Check if it's a key press or key release }
     $9C/             { PUSHF                  ; Save Flags             }
     $E4/$60/         { IN    AL,$60           ; Read the keyboard port }
     $A8/$80/         { TEST  Al,$80           ; Is the high bit set ?  }
     $74/$05/         { JZ    Press            ; If not skip to 'Press' }
     $C6/$06/>KR/$01/ { MOV   BYTE PTR [>KR], $01 ; If so make KR TRUE  }
     $1E/             { PUSH  DS               ; Save the Turbo Dseg    }
     $B8/>ROM_Data/   { MOV   AX,ROM_Data      ;                        }
     $8E/$D8/         { MOV   DS,AX            ; Set DS to Kbd ROM Seg  }
     $A1/>Tail/       { MOV   AX,[Tail]        ; Get Tail address       }
     $89/$86/KeyTemp/ { MOV   [BP+KeyTemp],AX  ; Put it where it's useful }
     $1F/             { POP   DS               ;  Restore Turbo DSEG    }
     $9D);      {Press: POPF                   ; Restore the flags.     }

   CallInterrupt(BIOS_INT9);       { Do the usual interrupt      }
   IF KR OR (KeyBoard_Queue_Tail = KeyBoard_Queue_Head) THEN
     BEGIN
       KR := FALSE;                { Action only on key presses, }
       EnableInterrupts;           { otherwise allow interrupts  }
       EXIT;                       { and exit.                   }
     END;
   KeyCode_Ptr := PTR($0040,KeyTemp);
   EnableInterrupts;          { allow interrupts           }
   CASE Int9_Mode OF
     DoNothing :              { This ISR not currently in use. }
       BEGIN                  { Check for hotkey.              }
         IF KeyCode_Ptr^ <> Activate_Record_Key THEN EXIT
         ELSE IF NOT (Mem[$40:$49] IN [2,3,7]) THEN Beep   { In graphics mode can't popup.}
         ELSE Macro_Main;
       END;
     RecordKeys :              { Recording Keys for a Macro  }
       BEGIN
         IF (KeyCode_Ptr^ <> Activate_Record_Key) THEN
           BEGIN
             Click;
             INC(Key_H_Pos);
             Key_Holder[Key_H_Pos] := WORD(KeyCode_Ptr^);
           END;
         IF (KeyCode_Ptr^ = Activate_Record_Key) OR (Key_H_Pos = MaxKey) THEN
           BEGIN
             MemW[$0040:Tail] := MemW[$0040:Head];   { Empty keyboard buffer }
             ResetIntVecs;
             CH := PutPopMess('S - Save this Macro','','A - Abort/Don''t save this macro',' ');
             SetIntVecs;
             X := 1;
             While Macro_Base[X]^.HotKey <> 0 DO     { New macro will be last }
               INC(X);                               {  the macro List.       }
             DEC(X);
             IF NOT(BYTE(Ch) OR 32 = Byte('a')) THEN            { Save it.  }
               BEGIN
                 New_Macro := TRUE;
                 Key_Holder[0] := Key_H_Pos;
                 Macro_Base[X]^.Insert_Data := Key_Holder;
               END
             ELSE
               Macro_Base[X]^.Hotkey := 0;           { Abort it. }
             Int9_Mode := Active;
           END;
       END;
     Active:
       BEGIN
         X := 1;
         While ((Macro_Base[X]^.HotKey) <> KeyCode_Ptr^) AND
               (Macro_Base[X]^.HotKey <> 0) DO
           INC(X);
         IF Macro_Base[X]^.HotKey <> 0 THEN
           BEGIN
             MemW[$0040:Tail] := MemW[$0040:Head];   { Empty buffer }
             MemW[CSeg:InsNumb] := Macro_Base[X]^.Insert_Data[0];{ How many characters.   }
             IF MemW[CSeg:InsNumb] > 0 THEN
               BEGIN                                  { Have charcters to insert. }
                 MemL[CSeg:InsChr] :=
                     LongInt(@Macro_Base[X]^.Insert_Data[1]);
                 Mem[CSeg:Flg] := Mem[CSeg:Flg] OR $10;
                 INLINE(             { Call to set up macro. }
                    $B8/$00/$01/     { MOV  AX,$0100 test for next char }
                    $CD/$16);        { CALL INT16            }
              END;
           END
         ELSE IF NOT (Mem[$40:$49] IN [2,3,7]) THEN Beep   { In graphics mode can't popup.}
         ELSE IF KeyCode_Ptr^ = Activate_Record_Key THEN Macro_Main;
       END;
   END;                        { CASE }
   {$S+}
END;                           { INT9 }



Procedure ResetIntVecs;
VAR
  TempPtr : Pointer;
BEGIN
  DisableInterrupts;
  SetIntVec(BIOS_I9, BIOS_INT9);   { Restore Hardware KeyBoard Interrupt. }
  SetIntVec($16,POINTER(MemL[CSeg:Bios16]));
  EnableInterrupts;
END;


Procedure SetIntVecs;
BEGIN
  DisableInterrupts;
  SetIntVec(BIOS_I9,@HKeyBoard_ISR);
  SetIntVec($16,Ptr(CSeg,Our16));
  EnableInterrupts;
END;


PROCEDURE Macro_Unit_Exit_Proc;
BEGIN
    IF New_Macro THEN
      BEGIN
        Ch := PutPopMess('Macro(s) have been changed since','they were last saved, would',
                          'you like to save the current macros ?','(Y/N)');
        IF UPCASE(Ch) = 'Y' THEN Save_Macros;
      END;
    ExitProc := Exit_Vec;       {restore previous ExitProc}
    ResetIntVecs;
END {Critical_Exit} ;



BEGIN
  IF Ofs(Int16_ISR) <> 0 THEN HALT;               { Offset of 'Int16_ISR' must be 0.  }
{
****** Save intercepted interrupt vectors  $16,$09.
}
  DisableInterrupts;
  GetIntVec($16, POINTER(MemL[CSeg:Bios16]));
  GetIntVec(BIOS_I9,BIOS_INT9);
{
***** Intercept original interrupt vectors;
}
  SetIntVec(BIOS_I9,@HKeyBoard_ISR);
  SetIntVec($16,Ptr(CSeg,Our16));
  EnableInterrupts;

  MemW[CSeg:UnSafe] := 0;                     { Allow TSR to function.    }

  FOR X := 1 to 30 DO
    BEGIN
      NEW(Macro_Base[X]);
      Macro_Base[X]^.HotKey := 0;
    END;
  New(WinBuf);

  Exit_Vec := ExitProc;                 { Chain into ExitProc     }
  ExitProc := @Macro_Unit_Exit_Proc;    { install additional exit }

  Load_Macros(Macro_Base);
END.