program logtime;
uses logunit;
var base:word;
    chk,bns,ns,bfs,fs,i,adj:longint;
    log2,log10:real;
    sysclk:longint absolute $40:$6c;

procedure Nop;  {dummy statement}
  inline($90);

begin
  base := 2;      {<-- use 1,2, or 10 for log base}
  log2 := ln(2);
  log10 := ln(10);
  chk := 1;
  writeln;
  writeln('** Integer logarithm verses real logarithm computation time **');
  writeln('-> Using base ',base);
  write('Computing loop overhead for 1,000,000 passes...');

  while sysclk = sysclk do nop;  {sync to the system clock}
  bfs := sysclk;                   {for consistant results}
  for i := 1 to 1000000 do
    case chk of
      1: if true = false then nop;  {dummy for timing check}
      2: if true = false then nop;  {dummy for timing check}
    end;
  fs := sysclk;
  adj := rwdiv((fs-bfs)*55,1000);  {save for later use}
  writeln(' ',(fs-bfs)*55,' milliseconds');
  writeln('Average rate: ',rwdiv((fs-bfs)*55,1000),' microseconds per log');

    write('Computing 5,000 logarithms the long way...');
    while sysclk = sysclk do nop;  {sync to the system clock}
    bns := sysclk;                   {for consistant results}
    for i := 1 to 5000 do
      case base of
        1: if ln(i) = 0 then nop;
        2: if ln(i)/log2 = 0 then nop;
        10: if ln(i)/log10 = 0 then nop;
      end;
    ns := sysclk;
    writeln(' ',((ns-bns)*55)-(adj*5),' milliseconds');
    writeln('Average rate: ',
              rwdiv(((ns-bns)*55)-(adj*5),5),' microseconds per log');

    write('Now computing 200,000 logarithms the fast way...');
    while sysclk = sysclk do nop;  {sync to the system clock}
    bfs := sysclk;                   {for consistant results}
    for i := 1 to 200000 do
      case base of
        1: if ilog(i) = 0 then nop;
        2: if ilog2(i) = 0 then nop;
        10: if ilog10(i) = 0 then nop;
      end;
    fs := sysclk;
    writeln(' ',((fs-bfs)*55)-(adj*200),' milliseconds');
    writeln('Average rate: ',
              rwdiv(((fs-bfs)*55)-(adj*200),200),' microseconds per log');

    writeln('Speed ratio = ',
              rwdiv(rwdiv(((ns-bns)*55),5)-(adj*5),
              rwdiv(((fs-bfs)*55)-(adj*200),200)),':1');

  writeln;
  write('Press any key to continue...');
  readln;
end.
